/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import com.sun.java.util.collections.ArrayList;
import java.util.Vector;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetListener;
import oracle.jbo.RowSetManagementEvent;
import oracle.jbo.RowSetManagementListener;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.Variable;
import oracle.jbo.VariableValueManager;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.PropertiesHelper;

public abstract class RowSetHelper
extends PropertiesHelper {
    protected String mName;
    protected ArrayList listeners;
    protected ArrayList mMgmtListeners;

    private /* synthetic */ void $init$() {
        this.listeners = null;
        this.mMgmtListeners = null;
    }

    public RowSetHelper() {
        this.$init$();
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    protected ArrayList getListenersList() {
        return this.listeners;
    }

    protected Vector getListeners() {
        return JboEnvUtil.convertArrayListToVector(this.listeners);
    }

    protected final boolean hasListeners() {
        return this.listeners != null;
    }

    protected ArrayList getManagementListenersList() {
        return this.mMgmtListeners;
    }

    protected final boolean hasManagementListeners() {
        return this.mMgmtListeners != null;
    }

    public synchronized void addListener(Object object) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(object)) {
            this.listeners.add(object);
        }
    }

    public synchronized void removeListener(Object object) {
        if (this.listeners != null && this.listeners.contains(object)) {
            this.listeners.remove(object);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public synchronized void addManagementListener(RowSetManagementListener rowSetManagementListener) {
        if (this.mMgmtListeners == null) {
            this.mMgmtListeners = new ArrayList();
        }
        if (!this.mMgmtListeners.contains((Object)rowSetManagementListener)) {
            this.mMgmtListeners.add((Object)rowSetManagementListener);
        }
    }

    public synchronized void removeManagementListener(RowSetManagementListener rowSetManagementListener) {
        if (this.mMgmtListeners != null && this.mMgmtListeners.contains((Object)rowSetManagementListener)) {
            this.mMgmtListeners.remove((Object)rowSetManagementListener);
            if (this.mMgmtListeners.size() == 0) {
                this.mMgmtListeners = null;
            }
        }
    }

    public void fireRangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetListener rowSetListener = (RowSetListener)arrayList.get(n);
            rowSetListener.rangeRefreshed(rangeRefreshEvent);
            ++n;
        }
    }

    public void fireRangeScrolled(ScrollEvent scrollEvent) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetListener rowSetListener = (RowSetListener)arrayList.get(n);
            rowSetListener.rangeScrolled(scrollEvent);
            ++n;
        }
    }

    public void fireRowInserted(InsertEvent insertEvent) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetListener rowSetListener = (RowSetListener)arrayList.get(n);
            rowSetListener.rowInserted(insertEvent);
            ++n;
        }
    }

    public void fireRowDeleted(DeleteEvent deleteEvent) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetListener rowSetListener = (RowSetListener)arrayList.get(n);
            rowSetListener.rowDeleted(deleteEvent);
            ++n;
        }
    }

    public void fireRowUpdated(UpdateEvent updateEvent) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetListener rowSetListener = (RowSetListener)arrayList.get(n);
            rowSetListener.rowUpdated(updateEvent);
            ++n;
        }
    }

    public void fireNavigationEvent(NavigationEvent navigationEvent) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetListener rowSetListener = (RowSetListener)arrayList.get(n);
            rowSetListener.navigated(navigationEvent);
            ++n;
        }
    }

    public void fireMgmtIteratorReset(RowSetManagementEvent rowSetManagementEvent) {
        if (this.mMgmtListeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mMgmtListeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetManagementListener rowSetManagementListener = (RowSetManagementListener)arrayList.get(n);
            rowSetManagementListener.iteratorReset(rowSetManagementEvent);
            ++n;
        }
    }

    public void fireMgmtIteratorClosed(RowSetManagementEvent rowSetManagementEvent) {
        if (this.mMgmtListeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mMgmtListeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetManagementListener rowSetManagementListener = (RowSetManagementListener)arrayList.get(n);
            rowSetManagementListener.iteratorClosed(rowSetManagementEvent);
            ++n;
        }
    }

    public abstract Class getMessageBundleClass();

    public static void updateNamedWhereParamValues(RowSet rowSet, VariableValueManager variableValueManager, boolean bl) {
        boolean bl2 = false;
        VariableValueManager variableValueManager2 = rowSet.ensureVariableManager();
        Variable[] variableArray = variableValueManager2.getVariablesOfKind("where");
        if (variableArray != null) {
            Variable[] variableArray2 = variableValueManager.getVariables();
            int n = 0;
            while (n < variableArray.length) {
                String string = variableArray[n].getName();
                Object object = variableValueManager2.getVariableValue(string);
                variableValueManager2.setVariableValue(string, variableValueManager.getVariableValue(string));
                rowSet.setNamedWhereClauseParam(string, variableValueManager.getVariableValue(string));
                Object object2 = variableValueManager2.getVariableValue(string);
                if (!(object == object2 || object != null && object.equals(object2))) {
                    bl2 = true;
                }
                ++n;
            }
        }
        if (bl && bl2) {
            rowSet.executeQuery();
        }
    }
}

