/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.http;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import oracle.adf.share.ADFContext;
import oracle.adf.share.el.ADFContextVariableResolverImpl;

public class HttpADFContextVariableResolverImpl
implements VariableResolver {
    static final String HTTP_REQUEST_SCOPE = "__http_request_scope__";
    static final String PORTLET_REQUEST_SCOPE = "__portlet_request_scope__";
    static final String HTTP_SESSION_SCOPE = "__http_session_scope__";
    static final String PORTLET_SESSION_SCOPE = "__portlet_session_scope__";
    static final String HTTP_APPLICATION_SCOPE = "__http_application_scope__";
    static final String PORTLET_APPLICATION_SCOPE = "__portlet_application_scope__";
    static final String HTTP_PARAM_MAP = "__http_param_map__";
    static final String HTTP_PARAM_VALUES_MAP = "__http_param_values_map__";
    static final String HTTP_HEADER_MAP = "__http_header_map__";
    static final String HTTP_HEADER_VALUES_MAP = "__http_header_values_map__";
    static final String HTTP_INIT_PARAM_MAP = "__http_init_param_map__";
    static final String HTTP_COOKIE_MAP = "__http_cookie_map__";
    private final Hashtable mMapCache;
    private final VariableResolver mParentResolver;
    private boolean mResolveImplicit;

    private /* synthetic */ void $init$() {
        this.mMapCache = new Hashtable(10);
        this.mResolveImplicit = true;
    }

    public HttpADFContextVariableResolverImpl(VariableResolver variableResolver) {
        this.$init$();
        if (variableResolver == null) {
            variableResolver = new ADFContextVariableResolverImpl();
        }
        this.mParentResolver = variableResolver;
    }

    public Object resolveVariable(String string) throws ELException {
        Object object;
        ADFContext aDFContext = ADFContext.getCurrent();
        if (this.isResolveImplicit()) {
            if ("requestScope".equals(string)) {
                Object object2 = aDFContext.getEnvironment().getRequest();
                if (object2 instanceof HttpServletRequest) {
                    return this.getHttpRequestScope((HttpServletRequest)object2);
                }
                return null;
            }
            if ("sessionScope".equals(string)) {
                Object object3 = aDFContext.getEnvironment().getRequest();
                if (object3 instanceof HttpServletRequest) {
                    return this.getHttpSessionScope(((HttpServletRequest)object3).getSession(true));
                }
                return null;
            }
            if ("applicationScope".equals(string)) {
                Object object4 = aDFContext.getEnvironment().getContext();
                if (object4 instanceof ServletContext) {
                    return this.getHttpApplicationScope((ServletContext)object4);
                }
                return null;
            }
            if ("param".equals(string)) {
                Object object5 = aDFContext.getEnvironment().getRequest();
                if (object5 instanceof HttpServletRequest) {
                    return this.getHttpParamMap((HttpServletRequest)object5);
                }
                return null;
            }
            if ("paramValues".equals(string)) {
                Object object6 = aDFContext.getEnvironment().getRequest();
                if (object6 instanceof HttpServletRequest) {
                    return this.getHttpParamValuesMap((HttpServletRequest)object6);
                }
                return null;
            }
            if ("header".equals(string)) {
                Object object7 = aDFContext.getEnvironment().getRequest();
                if (object7 instanceof HttpServletRequest) {
                    return this.getHttpHeaderMap((HttpServletRequest)object7);
                }
                return null;
            }
            if ("initParam".equals(string)) {
                Object object8 = aDFContext.getEnvironment().getContext();
                if (object8 instanceof ServletContext) {
                    return this.getHttpInitParamMap((ServletContext)object8);
                }
                return null;
            }
            if ("cookie".equals(string)) {
                Object object9 = aDFContext.getEnvironment().getRequest();
                if (object9 instanceof HttpServletRequest) {
                    return this.getHttpCookieMap((HttpServletRequest)object9);
                }
                return null;
            }
        }
        if ((object = this.mParentResolver.resolveVariable(string)) != null) {
            return object;
        }
        if (this.isResolveImplicit()) {
            Object object10;
            Object object11 = aDFContext.getEnvironment().getRequest();
            if (object11 instanceof HttpServletRequest) {
                object = ((HttpServletRequest)object11).getAttribute(string);
                if (object != null) {
                    return object;
                }
                HttpSession httpSession = ((HttpServletRequest)object11).getSession(false);
                object = httpSession.getAttribute(string);
                if (object != null) {
                    return object;
                }
            }
            if ((object10 = aDFContext.getEnvironment().getContext()) instanceof ServletContext && (object = ((ServletContext)object10).getAttribute(string)) != null) {
                return object;
            }
        }
        return null;
    }

    public void setResolveImplicit(boolean bl) {
        this.mResolveImplicit = bl;
    }

    public boolean isResolveImplicit() {
        return this.mResolveImplicit;
    }

    private Object getHttpRequestScope(HttpServletRequest httpServletRequest) {
        Map map = (Map)this.mMapCache.get(HTTP_REQUEST_SCOPE);
        if (map == null) {
            map = new 7(this, this, httpServletRequest);
            this.mMapCache.put(HTTP_REQUEST_SCOPE, map);
        }
        return map;
    }

    private Object getHttpSessionScope(HttpSession httpSession) {
        Map map = (Map)this.mMapCache.get(HTTP_SESSION_SCOPE);
        if (map == null) {
            map = new 6(this, this, httpSession);
            this.mMapCache.put(HTTP_SESSION_SCOPE, map);
        }
        return map;
    }

    private Object getHttpApplicationScope(ServletContext servletContext) {
        Map map = (Map)this.mMapCache.get(HTTP_APPLICATION_SCOPE);
        if (map == null) {
            map = new 5(this, this, servletContext);
            this.mMapCache.put(HTTP_APPLICATION_SCOPE, map);
        }
        return map;
    }

    private Object getHttpParamMap(HttpServletRequest httpServletRequest) {
        Map map = (Map)this.mMapCache.get(HTTP_PARAM_MAP);
        if (map == null) {
            map = new 4(this, this, httpServletRequest);
            this.mMapCache.put(HTTP_PARAM_MAP, map);
        }
        return map;
    }

    private Object getHttpParamValuesMap(HttpServletRequest httpServletRequest) {
        Map map = (Map)this.mMapCache.get(HTTP_PARAM_VALUES_MAP);
        if (map == null) {
            map = new 3(this, this, httpServletRequest);
            this.mMapCache.put(HTTP_PARAM_VALUES_MAP, map);
        }
        return map;
    }

    private Object getHttpHeaderMap(HttpServletRequest httpServletRequest) {
        Map map = (Map)this.mMapCache.get(HTTP_HEADER_MAP);
        if (map == null) {
            map = new 2(this, this, httpServletRequest);
            this.mMapCache.put(HTTP_HEADER_MAP, map);
        }
        return map;
    }

    private Object getHttpInitParamMap(ServletContext servletContext) {
        Map map = (Map)this.mMapCache.get(HTTP_INIT_PARAM_MAP);
        if (map == null) {
            map = new 1(this, this, servletContext);
            this.mMapCache.put(HTTP_INIT_PARAM_MAP, map);
        }
        return map;
    }

    private Object getHttpCookieMap(HttpServletRequest httpServletRequest) {
        HashMap<String, Cookie> hashMap = (HashMap<String, Cookie>)this.mMapCache.get(HTTP_COOKIE_MAP);
        if (hashMap == null) {
            Cookie[] cookieArray = httpServletRequest.getCookies();
            hashMap = new HashMap<String, Cookie>(cookieArray.length);
            int n = 0;
            while (n < cookieArray.length) {
                hashMap.put(cookieArray[n].getName(), cookieArray[n]);
                ++n;
            }
            this.mMapCache.put(HTTP_COOKIE_MAP, hashMap);
        }
        return hashMap;
    }

    public final class 7
    extends ImplicitObjectMapAdapter {
        private final /* synthetic */ HttpServletRequest v$request;
        final /* synthetic */ HttpADFContextVariableResolverImpl this$0;

        public Object get(Object object) {
            if (object instanceof String) {
                return this.v$request.getAttribute((String)object);
            }
            return null;
        }

        public /* synthetic */ 7(HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl, HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl2, HttpServletRequest httpServletRequest) {
            this.v$request = httpServletRequest;
            this.this$0 = httpADFContextVariableResolverImpl;
        }
    }

    public final class 6
    extends ImplicitObjectMapAdapter {
        private final /* synthetic */ HttpSession v$session;
        final /* synthetic */ HttpADFContextVariableResolverImpl this$0;

        public Object get(Object object) {
            if (object instanceof String) {
                return this.v$session.getAttribute((String)object);
            }
            return null;
        }

        public /* synthetic */ 6(HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl, HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl2, HttpSession httpSession) {
            this.v$session = httpSession;
            this.this$0 = httpADFContextVariableResolverImpl;
        }
    }

    public final class 5
    extends ImplicitObjectMapAdapter {
        private final /* synthetic */ ServletContext v$context;
        final /* synthetic */ HttpADFContextVariableResolverImpl this$0;

        public Object get(Object object) {
            if (object instanceof String) {
                return this.v$context.getAttribute((String)object);
            }
            return null;
        }

        public /* synthetic */ 5(HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl, HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl2, ServletContext servletContext) {
            this.v$context = servletContext;
            this.this$0 = httpADFContextVariableResolverImpl;
        }
    }

    public final class 4
    extends ImplicitObjectMapAdapter {
        private final /* synthetic */ HttpServletRequest v$request;
        final /* synthetic */ HttpADFContextVariableResolverImpl this$0;

        public Object get(Object object) {
            if (object instanceof String) {
                return this.v$request.getParameter((String)object);
            }
            return null;
        }

        public /* synthetic */ 4(HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl, HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl2, HttpServletRequest httpServletRequest) {
            this.v$request = httpServletRequest;
            this.this$0 = httpADFContextVariableResolverImpl;
        }
    }

    public final class 3
    extends ImplicitObjectMapAdapter {
        private final /* synthetic */ HttpServletRequest v$request;
        final /* synthetic */ HttpADFContextVariableResolverImpl this$0;

        public Object get(Object object) {
            if (object instanceof String) {
                return this.v$request.getParameterValues((String)object);
            }
            return null;
        }

        public /* synthetic */ 3(HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl, HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl2, HttpServletRequest httpServletRequest) {
            this.v$request = httpServletRequest;
            this.this$0 = httpADFContextVariableResolverImpl;
        }
    }

    public final class 2
    extends ImplicitObjectMapAdapter {
        private final /* synthetic */ HttpServletRequest v$request;
        final /* synthetic */ HttpADFContextVariableResolverImpl this$0;

        public Object get(Object object) {
            if (object instanceof String) {
                return this.v$request.getHeader((String)object);
            }
            return null;
        }

        public /* synthetic */ 2(HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl, HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl2, HttpServletRequest httpServletRequest) {
            this.v$request = httpServletRequest;
            this.this$0 = httpADFContextVariableResolverImpl;
        }
    }

    public final class 1
    extends ImplicitObjectMapAdapter {
        private final /* synthetic */ ServletContext v$context;
        final /* synthetic */ HttpADFContextVariableResolverImpl this$0;

        public Object get(Object object) {
            if (object instanceof String) {
                return this.v$context.getInitParameter((String)object);
            }
            return null;
        }

        public /* synthetic */ 1(HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl, HttpADFContextVariableResolverImpl httpADFContextVariableResolverImpl2, ServletContext servletContext) {
            this.v$context = servletContext;
            this.this$0 = httpADFContextVariableResolverImpl;
        }
    }

    public abstract class ImplicitObjectMapAdapter
    implements Map {
        public int size() {
            return -1;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean containsKey(Object object) {
            return false;
        }

        public boolean containsValue(Object object) {
            return false;
        }

        public abstract Object get(Object var1);

        public Object put(Object object, Object object2) {
            return null;
        }

        public Object remove(Object object) {
            return null;
        }

        public void putAll(Map map) {
        }

        public void clear() {
        }

        public Set keySet() {
            return null;
        }

        public Collection values() {
            return null;
        }

        public Set entrySet() {
            return null;
        }

        ImplicitObjectMapAdapter() {
        }
    }
}

