/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter.dataformat;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import oracle.adf.model.adapter.AdapterContext;
import oracle.adf.model.adapter.AdapterException;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adf.model.adapter.dataformat.FormatDataEvent;
import oracle.adf.model.adapter.dataformat.FormatDataEventListener;
import oracle.adf.model.adapter.dataformat.FormatDataHandler;
import oracle.adf.model.adapter.dataformat.FormatStructureHandler;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adf.model.adapter.dataformat.csv.CSVParser;
import oracle.adf.model.adapter.dataformat.csv.ConditionDefinition;
import oracle.adf.model.adapter.utils.Utility;
import oracle.adf.model.utils.SimpleStringBuffer;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.perf.Timer;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.DefinitionContext;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.StructureDefinition;

public class CSVHandler
implements FormatStructureHandler,
FormatDataHandler {
    public static final String FILTERING_COLTYPE_MAP = "ColTypeMap";
    public static final String FILTERING_COLFORMAT_MAP = "ColFormatMap";
    public static final String EV_EOD = "__ev_eod__";
    private InputStream mDataStream;
    private boolean mIsFirstRowNames;
    private String mEncStyle;
    private String mDelimiter;
    private String mQuoteChar;
    private ParameterDefinition[] mParams;
    private boolean mIsAll;
    private String[] mConditions;
    private Vector mValidConditions;
    private Map mColTypeMap;
    private Map mColFormatMap;
    private List mColNames;
    private FormatDataEventListener mEventListener;
    private ADFLogger mLogger;
    private static Timer sGetStructureTimer = Timer.createTimer((Level)Level.FINER, (String)"/oracle/adf/model/adapter/dataformat/CSVHandler", (String)"getStructure", (String)"Creating the structure definition from csv data");
    private static Timer sGetResultTimer = Timer.createTimer((Level)Level.FINER, (String)"/oracle/adf/model/adapter/dataformat/CSVHandler", (String)"getResult", (String)"Creating the collection iterators for csv data");

    private /* synthetic */ void $init$() {
        this.mIsFirstRowNames = false;
        this.mIsAll = true;
        this.mConditions = null;
        this.mValidConditions = new Vector();
        this.mColTypeMap = null;
        this.mColFormatMap = null;
        this.mColNames = null;
        this.mEventListener = null;
        this.mLogger = AdapterContext.getDefaultContext().getLogger();
    }

    public CSVHandler(InputStream inputStream, boolean bl, String string, String string2, String string3) {
        this.$init$();
        this.mDataStream = inputStream;
        this.mIsFirstRowNames = bl;
        this.mEncStyle = string;
        this.mDelimiter = string2;
        this.mQuoteChar = string3;
    }

    public void setDataEventListener(FormatDataEventListener formatDataEventListener) {
        this.mEventListener = formatDataEventListener;
    }

    public void setParameters(ParameterDefinition[] parameterDefinitionArray) {
        this.mParams = parameterDefinitionArray;
    }

    public void setFilterConditions(boolean bl, String[] stringArray) {
        this.mIsAll = bl;
        this.mConditions = stringArray;
    }

    public void setColTypeMap(Map map) {
        this.mColTypeMap = map;
    }

    public void setColFormatMap(Map map) {
        this.mColFormatMap = map;
    }

    /*
     * Unable to fully structure code
     */
    public StructureDefinition getStructure(String var1_1, DefinitionContext var2_2) {
        var3_3 = null;
        try {
            try {
                block10: {
                    this.mLogger.finer("Creating the structure definitions from the CSV source.");
                    CSVHandler.sGetStructureTimer.start();
                    var4_4 = this.mEncStyle == null ? new CSVParser(this.mDataStream) : new CSVParser(this.mDataStream, this.mEncStyle);
                    var4_4.setSeparators(this.mDelimiter.toCharArray());
                    if (this.mQuoteChar != null && this.mQuoteChar.length() != 0) {
                        var4_4.setQuoteChar(this.mQuoteChar.charAt(0));
                    }
                    var5_5 = this.getColNames(var4_4).iterator();
                    var3_3 = new StructureDef(var1_1);
                    if (this.mIsFirstRowNames) {
                        var4_4.nextLine();
                    }
                    this.mLogger.finer("Attributes Added: ");
                    var6_6 = var4_4.getLineValues();
                    if (var6_6 == null) ** GOTO lbl32
                    var7_7 = 0;
                    while (var5_5.hasNext()) {
                        var8_8 = "java.lang.String";
                        if (var7_7 < var6_6.length) {
                            var8_8 = this.checkType(var6_6[var7_7]);
                            ++var7_7;
                        }
                        var9_9 = new AttributeDef((String)var5_5.next(), var3_3, var8_8);
                        var3_3.addAttribute((AttributeDefinition)var9_9);
                        this.mLogger.finer(var9_9.getName());
                    }
                    break block10;
lbl-1000:
                    // 1 sources

                    {
                        var10_10 = new AttributeDef((String)var5_5.next(), var3_3, "java.lang.String");
                        var3_3.addAttribute((AttributeDefinition)var10_10);
                        this.mLogger.finer(var10_10.getName());
lbl32:
                        // 2 sources

                        ** while (var5_5.hasNext())
                    }
                }
                CSVHandler.sGetStructureTimer.stop();
            }
            catch (Exception var11_13) {
                throw new AdapterException(var11_13);
            }
            var13_11 = null;
        }
        catch (Throwable var12_14) {
            var13_12 = null;
            CSVHandler.sGetStructureTimer.cleanup();
            throw var12_14;
        }
        CSVHandler.sGetStructureTimer.cleanup();
        return var3_3;
    }

    public Object getResult(Map map, String string) {
        return this.getResult(map);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator getResult(Map map) {
        1 var8_6;
        try {
            try {
                this.mLogger.finer("Creating result from the CSV source.");
                sGetResultTimer.start();
                if (this.mColTypeMap == null) {
                    this.mColTypeMap = (Map)map.get(FILTERING_COLTYPE_MAP);
                }
                if (this.mColFormatMap == null) {
                    this.mColFormatMap = (Map)map.get(FILTERING_COLFORMAT_MAP);
                }
                this.checkConditions();
                CSVParser cSVParser = this.mEncStyle == null ? new CSVParser(this.mDataStream) : new CSVParser(this.mDataStream, this.mEncStyle);
                cSVParser.setSeparators(this.mDelimiter.toCharArray());
                if (this.mQuoteChar != null && this.mQuoteChar.length() != 0) {
                    cSVParser.setQuoteChar(this.mQuoteChar.charAt(0));
                }
                List list = this.getColNames(cSVParser);
                boolean bl = this.mIsFirstRowNames ? cSVParser.nextLine() ^ true : false;
                this.mLogger.finer("Creating data iterator.");
                1 var5_5 = new 1(this, cSVParser, list, bl);
                sGetResultTimer.stop();
                var8_6 = var5_5;
                Object var10_7 = null;
            }
            catch (AdapterException adapterException) {
                throw adapterException;
            }
            catch (Exception exception) {
                throw new AdapterException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            sGetResultTimer.cleanup();
            throw throwable;
        }
        sGetResultTimer.cleanup();
        return var8_6;
    }

    private String checkType(String string) {
        try {
            if (string != null) {
                try {
                    long l = Long.parseLong(string);
                    String string2 = "java.lang.Long";
                    return string2;
                }
                catch (NumberFormatException numberFormatException) {
                    float f = Float.parseFloat(string);
                    String string3 = "java.lang.Float";
                    return string3;
                }
            }
            String string4 = "java.lang.String";
            return string4;
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = "java.lang.String";
            return string5;
        }
    }

    private List getColNames(CSVParser cSVParser) {
        try {
            if (this.mColNames == null) {
                if (!cSVParser.nextLine()) {
                    new Exception("No data");
                }
                this.mColNames = new ArrayList(10);
                String[] stringArray = cSVParser.getLineValues();
                if (this.mIsFirstRowNames) {
                    this.makeValidColumnNames(stringArray);
                    int n = 0;
                    while (n < stringArray.length) {
                        this.mColNames.add(stringArray[n]);
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < stringArray.length) {
                        String string = new SimpleStringBuffer(20).append("Column").append(n).toString();
                        this.mColNames.add(string);
                        ++n;
                    }
                }
            }
            List list = this.mColNames;
            return list;
        }
        catch (Exception exception) {
            throw new AdapterException(exception);
        }
    }

    private boolean isValidForConditions(Map map) {
        boolean bl = true;
        if (this.mValidConditions != null && this.mValidConditions.size() > 0) {
            if (!this.mIsAll) {
                int n = 0;
                while (n < this.mValidConditions.size()) {
                    ConditionDefinition conditionDefinition = (ConditionDefinition)this.mValidConditions.elementAt(n);
                    String string = conditionDefinition.getColumn();
                    String string2 = (String)map.get(string);
                    String string3 = conditionDefinition.getOperator();
                    String string4 = conditionDefinition.getValue();
                    String string5 = (String)this.mColTypeMap.get(string);
                    String string6 = (String)this.mColFormatMap.get(string);
                    if (string3.equalsIgnoreCase("startsWith")) {
                        if (string2.startsWith(string4)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                    }
                    if (string3.equalsIgnoreCase("endsWith")) {
                        if (string2.endsWith(string4)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                    }
                    if (string3.equalsIgnoreCase("contains")) {
                        if (string2.indexOf(string4) != -1) {
                            bl = true;
                            break;
                        }
                        bl = false;
                    }
                    if (string3.equalsIgnoreCase("notContains")) {
                        if (string2.indexOf(string4) == -1) {
                            bl = true;
                            break;
                        }
                        bl = false;
                    }
                    if ((string3.equals(">") || string3.equals("<") || string3.equals(">=") || string3.equals("<=") || string3.equals("!=") || string3.equals("=")) && string2.length() > 0) {
                        try {
                            if (string5.compareToIgnoreCase("java.util.Date") == 0) {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string6);
                                Date date = simpleDateFormat.parse(string2);
                                Date date2 = simpleDateFormat.parse(string4);
                                if (string3.equals(">")) {
                                    if (date.after(date2)) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                                if (string3.equals("<")) {
                                    if (date.before(date2)) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                                if (string3.equals("<=")) {
                                    if (date.before(date2) || date.equals(date2)) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                                if (string3.equals(">=")) {
                                    if (date.after(date2) || date.equals(date2)) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                                if (string3.equals("!=")) {
                                    if (!date.equals(date2)) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                                if (string3.equals("=")) {
                                    if (date.equals(date2)) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                            } else {
                                DecimalFormat decimalFormat = new DecimalFormat(string6);
                                Number number = decimalFormat.parse(string2);
                                Number number2 = decimalFormat.parse(string4);
                                if (string3.equals(">")) {
                                    if (number.doubleValue() > number2.doubleValue()) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                                if (string3.equals("<")) {
                                    if (number.doubleValue() < number2.doubleValue()) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                                if (string3.equals("<=")) {
                                    if (number.doubleValue() <= number2.doubleValue()) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                                if (string3.equals(">=")) {
                                    if (number.doubleValue() >= number2.doubleValue()) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                                if (string3.equals("!=")) {
                                    if (number.doubleValue() != number2.doubleValue()) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                                if (string3.equals("=")) {
                                    if (number.doubleValue() == number2.doubleValue()) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                }
                            }
                        }
                        catch (Exception exception) {
                            bl = false;
                        }
                    }
                    ++n;
                }
            }
            if (this.mIsAll) {
                int n = 0;
                while (n < this.mValidConditions.size()) {
                    ConditionDefinition conditionDefinition = (ConditionDefinition)this.mValidConditions.elementAt(n);
                    String string = conditionDefinition.getColumn();
                    String string7 = (String)map.get(string);
                    String string8 = conditionDefinition.getOperator();
                    String string9 = conditionDefinition.getValue();
                    String string10 = (String)this.mColTypeMap.get(string);
                    String string11 = (String)this.mColFormatMap.get(string);
                    if (string8.equalsIgnoreCase("startsWith") && !string7.startsWith(string9)) {
                        bl = false;
                        break;
                    }
                    if (string8.equalsIgnoreCase("endsWith") && !string7.endsWith(string9)) {
                        bl = false;
                        break;
                    }
                    if (string8.equalsIgnoreCase("contains") && string7.indexOf(string9) == -1) {
                        bl = false;
                        break;
                    }
                    if (string8.equalsIgnoreCase("notContains") && string7.indexOf(string9) != -1) {
                        bl = false;
                        break;
                    }
                    if ((string8.equals(">") || string8.equals("<") || string8.equals(">=") || string8.equals("<=") || string8.equals("!=") || string8.equals("=")) && string7.length() > 0) {
                        try {
                            if (string10.compareToIgnoreCase("java.util.Date") == 0) {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string11);
                                Date date = simpleDateFormat.parse(string7);
                                Date date3 = simpleDateFormat.parse(string9);
                                if (string8.equals(">") && !date.after(date3)) {
                                    bl = false;
                                    break;
                                }
                                if (string8.equals("<") && !date.before(date3)) {
                                    bl = false;
                                    break;
                                }
                                if (string8.equals("<=") && date.after(date3)) {
                                    bl = false;
                                    break;
                                }
                                if (string8.equals(">=") && date.before(date3)) {
                                    bl = false;
                                    break;
                                }
                                if (string8.equals("!=") && date.equals(date3)) {
                                    bl = false;
                                    break;
                                }
                                if (string8.equals("=") && !date.equals(date3)) {
                                    bl = false;
                                    break;
                                }
                            } else {
                                DecimalFormat decimalFormat = new DecimalFormat(string11);
                                Number number = decimalFormat.parse(string7);
                                Number number3 = decimalFormat.parse(string9);
                                if (string8.equals(">") && number.doubleValue() <= number3.doubleValue()) {
                                    bl = false;
                                    break;
                                }
                                if (string8.equals("<") && number.doubleValue() >= number3.doubleValue()) {
                                    bl = false;
                                    break;
                                }
                                if (string8.equals("<=") && number.doubleValue() > number3.doubleValue()) {
                                    bl = false;
                                    break;
                                }
                                if (string8.equals(">=") && number.doubleValue() < number3.doubleValue()) {
                                    bl = false;
                                    break;
                                }
                                if (string8.equals("!=") && number.doubleValue() == number3.doubleValue()) {
                                    bl = false;
                                    break;
                                }
                                if (string8.equals("=") && number.doubleValue() != number3.doubleValue()) {
                                    bl = false;
                                    break;
                                }
                            }
                        }
                        catch (Exception exception) {
                            bl = false;
                        }
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    private void checkConditions() {
        if (this.mConditions != null && this.mConditions.length > 0) {
            int n = 0;
            while (n < this.mConditions.length) {
                String string = this.mConditions[n];
                if (string.indexOf("=") != -1 || string.indexOf("<") != -1 || string.indexOf(">") != -1 || string.indexOf("!=") != -1 || string.indexOf("<=") != -1 || string.indexOf(">=") != -1) {
                    String string2;
                    int n2 = 0;
                    String string3 = null;
                    if (string.indexOf("=") != -1) {
                        n2 = string.indexOf("=");
                        string3 = "=";
                    }
                    if (string.indexOf(">") != -1) {
                        n2 = string.indexOf(">");
                        string3 = ">";
                    }
                    if (string.indexOf("<") != -1) {
                        n2 = string.indexOf("<");
                        string3 = "<";
                    }
                    if (string.indexOf("!=") != -1) {
                        n2 = string.indexOf("!=");
                        string3 = "!=";
                    }
                    if (string.indexOf(">=") != -1) {
                        n2 = string.indexOf(">=");
                        string3 = ">=";
                    }
                    if (string.indexOf("<=") != -1) {
                        n2 = string.indexOf("<=");
                        string3 = "<=";
                    }
                    if (this.mColTypeMap.containsKey(string2 = string.substring(0, n2).trim())) {
                        String string4 = (String)this.mColTypeMap.get(string2);
                        String string5 = (String)this.mColFormatMap.get(string2);
                        String string6 = string.substring(n2 + string3.length()).trim();
                        if (!string4.equals("java.lang.String") && !string4.equals("java.util.Date")) {
                            try {
                                DecimalFormat decimalFormat = new DecimalFormat(string5);
                                Number number = decimalFormat.parse(string6);
                                ConditionDefinition conditionDefinition = new ConditionDefinition(string2, string3, string6);
                                this.mValidConditions.add(conditionDefinition);
                            }
                            catch (Exception exception) {}
                        } else if (!string4.equals("java.lang.String") && string4.equals("java.util.Date")) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string5);
                                Date date = simpleDateFormat.parse(string6);
                                ConditionDefinition conditionDefinition = new ConditionDefinition(string2, string3, string6);
                                this.mValidConditions.add(conditionDefinition);
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else if (string.indexOf("startsWith") != -1 || string.indexOf("contains") != -1 || string.indexOf("endsWith") != -1 || string.indexOf("notContains") != -1) {
                    String string7;
                    int n3 = 0;
                    String string8 = null;
                    if (string.indexOf("startsWith") != -1) {
                        n3 = string.indexOf("startsWith");
                        string8 = "startsWith";
                    } else if (string.indexOf("contains") != -1) {
                        n3 = string.indexOf("contains");
                        string8 = "contains";
                    } else if (string.indexOf("endsWith") != -1) {
                        n3 = string.indexOf("endsWith");
                        string8 = "endsWith";
                    } else {
                        n3 = string.indexOf("notContains");
                        string8 = "notContains";
                    }
                    String string9 = string.substring(0, n3).trim();
                    if (this.mColTypeMap.containsKey(string9) && (string7 = (String)this.mColTypeMap.get(string9)).equals("java.lang.String")) {
                        String string10 = string.substring(n3 + string8.length()).trim();
                        ConditionDefinition conditionDefinition = new ConditionDefinition(string9, string8, string10);
                        this.mValidConditions.add(conditionDefinition);
                    }
                }
                ++n;
            }
        }
    }

    private String[] makeValidColumnNames(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && stringArray[n].length() > 0) {
                stringArray[n] = stringArray[n].trim();
            }
            if (stringArray[n] == null || stringArray[n].length() == 0) {
                stringArray[n] = new SimpleStringBuffer("column").append(n + 1).toString();
            } else {
                try {
                    stringArray[n] = Utility.normalizeString(stringArray[n]);
                }
                catch (Exception exception) {
                    stringArray[n] = new SimpleStringBuffer("column").append(n + 1).toString();
                }
            }
            ++n;
        }
        return stringArray;
    }

    public final class 1
    implements Iterator {
        CSVParser _parser;
        List _names;
        boolean _eof;
        Object nextValue;
        final /* synthetic */ CSVHandler this$0;
        private final /* synthetic */ CSVParser v$parser;
        private final /* synthetic */ List v$cols;
        private final /* synthetic */ boolean v$bEndOfData;

        private /* synthetic */ void $init$() {
            this._parser = this.v$parser;
            this._names = this.v$cols;
            this._eof = this.v$bEndOfData;
            this.nextValue = this.nextValidValue();
        }

        public void remove() {
        }

        public boolean hasNext() {
            return this.nextValue != null;
        }

        public Object next() {
            Object object = this.nextValue;
            this.nextValue = this.nextValidValue();
            return object;
        }

        private Object nextValidValue() {
            try {
                if (this._eof) {
                    Object var8_1 = null;
                    return var8_1;
                }
                this.this$0.mLogger.finer("Row fetched.");
                Iterator iterator = this._names.iterator();
                HashMap hashMap = new HashMap(5);
                String[] stringArray = this._parser.getLineValues();
                this._eof = this._parser.nextLine() ^ true;
                if (this._eof && this.this$0.mEventListener != null) {
                    CSVDataEvent cSVDataEvent = this.this$0.new CSVDataEvent(CSVHandler.EV_EOD);
                    cSVDataEvent.sendEvent(this.this$0.mEventListener);
                }
                if (stringArray == null) {
                    Object object = this.nextValidValue();
                    return object;
                }
                int n = 0;
                while (iterator.hasNext()) {
                    String string = null;
                    if (n < stringArray.length) {
                        string = stringArray[n];
                    }
                    hashMap.put(iterator.next(), string);
                    ++n;
                }
                if (this.this$0.isValidForConditions(hashMap)) {
                    HashMap hashMap2 = hashMap;
                    return hashMap2;
                }
                this.this$0.mLogger.finer("Skiping row, doesn't match the filter criteria.");
                Object object = this.nextValidValue();
                return object;
            }
            catch (Exception exception) {
                this.this$0.mLogger.warning("Exception fetching CSV data. Cause: " + exception.toString());
                throw new AdapterException(exception);
            }
        }

        public /* synthetic */ 1(CSVHandler cSVHandler, CSVParser cSVParser, List list, boolean bl) {
            this.v$bEndOfData = bl;
            this.v$cols = list;
            this.v$parser = cSVParser;
            this.this$0 = cSVHandler;
            this.$init$();
        }
    }

    public class CSVDataEvent
    extends FormatDataEvent {
        public CSVDataEvent(String string) {
            super(string, null);
        }
    }
}

