/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import oracle.xml.xsql.XSQLConnection;
import oracle.xml.xsql.XSQLConnectionManager;
import oracle.xml.xsql.XSQLConnectionManagerFactory;
import oracle.xml.xsql.XSQLNoSuchConnectionException;
import oracle.xml.xsql.XSQLPageRequest;

public class XSQLDatasourceConnectionManager
implements XSQLConnectionManager,
XSQLConnectionManagerFactory {
    private XSQLConnectionManager singleton = null;

    public XSQLConnection getConnection(String string, XSQLPageRequest xSQLPageRequest) throws SQLException {
        DataSource dataSource = null;
        try {
            InitialContext initialContext = new InitialContext();
            dataSource = (DataSource)initialContext.lookup(string);
        }
        catch (NamingException namingException) {
            xSQLPageRequest.signalError(25004, new String[]{string}, null);
            throw new XSQLNoSuchConnectionException();
        }
        return this.wrapConnection(dataSource.getConnection(), string);
    }

    protected XSQLConnection wrapConnection(Connection connection, String string) {
        return new XSQLConnection(connection, string);
    }

    public void releaseConnection(XSQLConnection xSQLConnection, XSQLPageRequest xSQLPageRequest) {
        try {
            Connection connection = xSQLConnection.getJDBCConnection();
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public XSQLConnectionManager create() {
        if (this.singleton == null) {
            this.singleton = new XSQLDatasourceConnectionManager();
        }
        return this.singleton;
    }
}

