/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.processes;

import java.io.Closeable;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.pipeline.controller.Util;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLProcessor;
import oracle.xml.xslt.XSLStylesheet;

public class XSLStylesheetProcess
extends Process {
    private XSLProcessor xslproc = null;
    private XSLStylesheet xslstyle = null;

    public void initialize() {
        Input input = this.getInput("xsl");
        input.supportType(0);
        input.supportType(2);
        input.supportType(8);
    }

    public void execute() throws PipelineException {
        block16: {
            Object object;
            Source source = this.getInputSource("xsl");
            String string = (String)this.getInParamValue("baseURL");
            String string2 = (String)this.getInParamValue("outputEncoding");
            String string3 = (String)this.getInParamValue("showWarnings");
            this.xslproc = new XSLProcessor();
            if (string != null && string.length() != 0) {
                try {
                    object = Util.createURL(string);
                    this.xslproc.setBaseURL((URL)object);
                }
                catch (MalformedURLException malformedURLException) {
                    this.error(30004, 17);
                }
            }
            if (string2 != null && string2.length() != 0) {
                this.xslproc.setOutputEncoding(string2);
            }
            if (string3 != null) {
                object = Boolean.valueOf(string3);
                this.xslproc.showWarnings(((Boolean)object).booleanValue());
            }
            if (source instanceof StreamSource) {
                object = (StreamSource)source;
                try {
                    Closeable closeable = ((StreamSource)object).getInputStream();
                    if (closeable != null) {
                        this.xslstyle = this.xslproc.newXSLStylesheet(closeable);
                        break block16;
                    }
                    closeable = ((StreamSource)object).getReader();
                    if (closeable != null) {
                        this.xslstyle = this.xslproc.newXSLStylesheet((Reader)closeable);
                        break block16;
                    }
                    this.error(30005, 17, new String[]{"xsl"});
                }
                catch (XSLException xSLException) {
                    this.processError((Exception)((Object)xSLException));
                }
            } else if (source instanceof DOMSource) {
                try {
                    object = (DOMSource)source;
                    if (!(((DOMSource)object).getNode() instanceof XMLDocument)) {
                        throw new PipelineException("Input is not an XMLDocument type");
                    }
                    this.xslstyle = this.xslproc.newXSLStylesheet((XMLDocument)((DOMSource)object).getNode());
                }
                catch (Exception exception) {
                    this.processError(exception);
                }
            } else {
                this.error(30002, 17, new String[]{"StreamSource and DOMSource"});
            }
        }
        this.setOutParam("stylesheet", this.xslstyle);
    }

    void processError(Exception exception) throws PipelineException {
        if (!this.ignoreError("stylesheet")) {
            this.error(30001, 17, exception);
        }
        try {
            this.info(30000, new String[]{"XSLStylesheetProcess", exception.getMessage()});
            XMLDocument xMLDocument = this.getErrorDocument("stylesheet", true);
            this.xslstyle = this.xslproc.newXSLStylesheet(xMLDocument);
        }
        catch (Exception exception2) {
            this.error(30006, 17, exception2);
        }
    }
}

