/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester.properties;

import com.sun.java.util.collections.ArrayList;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.properties.Res;

public class PropertyPanel
extends JPanel {
    public static final String[] columNames = new String[]{Res.getString(0), Res.getString(1)};
    final Object[] args;
    myButton button;
    JComboBox comboBox;
    BeanInfo mBI;
    Object mEditObject;
    Frame mFrame;
    myProperty[] mProps;
    final Object[] setArgs;
    JScrollPane tablePanel;
    JTable tableView;
    JTextField textBox;
    private static /* synthetic */ Class class$java$lang$String;

    public static void comboRemoveAllItems(JComboBox jComboBox) {
        int n = jComboBox.getItemCount();
        if (n > 0) {
            jComboBox.removeAllItems();
        }
    }

    private /* synthetic */ void $init$() {
        this.args = new Object[0];
        this.button = new myButton();
        this.comboBox = new JComboBox();
        this.setArgs = new Object[1];
        this.textBox = new JTextField();
    }

    public PropertyPanel(Frame frame, Object object, BeanInfo beanInfo) {
        this.$init$();
        try {
            this.mFrame = frame;
            this.mEditObject = object;
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n].getReadMethod() != null) {
                    arrayList.add((Object)propertyDescriptorArray[n]);
                }
                ++n;
            }
            this.mProps = new myProperty[arrayList.size()];
            n = 0;
            while (n < arrayList.size()) {
                this.mProps[n] = new myProperty((PropertyDescriptor)arrayList.get(n));
                ++n;
            }
            this.tablePanel = this.getPane();
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.displayError(this.mFrame, exception);
        }
    }

    public void cancel() {
        this.close();
        int n = 0;
        while (n < this.mProps.length) {
            if (this.mProps[n].isSet) {
                this.mProps[n].set(this.mProps[n].oldValue);
            }
            ++n;
        }
    }

    public void close() {
        if (this.tableView.isEditing()) {
            this.tableView.getCellEditor().stopCellEditing();
        }
    }

    public JScrollPane getPane() throws Exception {
        Object[][] objectArray = new Object[this.mProps.length][columNames.length];
        boolean[] blArray = new boolean[this.mProps.length];
        int n = 0;
        while (n < this.mProps.length) {
            try {
                String string = this.mProps[n].pd.getDisplayName();
                if (this.mProps[n].userProperty) {
                    string = string.substring(string.indexOf(46) + 1);
                    this.setArgs[0] = string;
                    this.mProps[n].pd.getWriteMethod().invoke(this.mEditObject, this.setArgs);
                }
                objectArray[n][0] = string;
                objectArray[n][1] = this.mProps[n].pd.getReadMethod().invoke(this.mEditObject, this.args);
                blArray[n] = this.mProps[n].readonly ^ true;
            }
            catch (InvocationTargetException invocationTargetException) {
                objectArray[n][1] = null;
            }
            ++n;
        }
        PropertyPanel propertyPanel = this;
        1 var7_7 = new 1(this, objectArray, blArray, propertyPanel);
        this.tableView = new JTable(var7_7);
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = PropertyPanel.class$("java.lang.String");
        }
        this.tableView.setDefaultRenderer(clazz, new PropertyTableCellRenderer());
        TableColumn tableColumn = this.tableView.getColumn(Res.getString(1));
        tableColumn.setCellEditor(new myCellEditor());
        JScrollPane jScrollPane = new JScrollPane(this.tableView);
        jScrollPane.setBorder(BorderFactory.createBevelBorder(1));
        return jScrollPane;
    }

    public void jbInit() throws Exception {
        this.setLayout(new GridLayout());
        this.add((Component)this.tablePanel, null);
    }

    private void storeCellValue(Object object, int n) {
        try {
            if (this.mProps[n].pe != null) {
                PropertyEditor propertyEditor = this.mProps[n].pe;
                if (propertyEditor.supportsCustomEditor()) {
                    if (!propertyEditor.isPaintable()) {
                        propertyEditor.setValue(this.button.value);
                    }
                } else if (propertyEditor.getTags() != null) {
                    propertyEditor.setAsText((String)this.comboBox.getSelectedItem());
                } else {
                    propertyEditor.setAsText(this.textBox.getText());
                }
                object = propertyEditor.getValue();
            }
            this.mProps[n].set(object);
        }
        catch (Exception exception) {
            ErrorHandler.displayError(this.mFrame, exception);
        }
    }

    void dump() {
        int n = 0;
        while (n < this.mProps.length) {
            if (this.mProps[n].value != null) {
                // empty if block
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class myButton
    extends JButton {
        PropertyEditor pe;
        Object value;

        private myButton() {
        }
    }

    private class myCellEditor
    extends DefaultCellEditor {
        public myCellEditor() {
            super(new JTextField());
            PropertyPanel.this.textBox = (JTextField)this.getComponent();
        }

        public Object getCellEditorValue() {
            if (this.editorComponent instanceof JComboBox) {
                return ((JComboBox)this.editorComponent).getSelectedItem();
            }
            if (this.editorComponent instanceof myButton) {
                return PropertyPanel.this.button.value;
            }
            return super.getCellEditorValue();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl && n2 == 1 && PropertyPanel.this.mProps[n].pe != null) {
                PropertyEditor propertyEditor = PropertyPanel.this.mProps[n].pe;
                if (propertyEditor.supportsCustomEditor()) {
                    try {
                        Method method = PropertyPanel.this.mProps[n].pd.getReadMethod();
                        object = method.invoke(PropertyPanel.this.mEditObject, PropertyPanel.this.args);
                        propertyEditor.setValue(object);
                        if (propertyEditor.getCustomEditor() != null && propertyEditor.isPaintable()) {
                            this.editorComponent = (JComponent)propertyEditor.getCustomEditor();
                        } else {
                            PropertyPanel.this.button.pe = propertyEditor;
                            PropertyPanel.this.button.setText(PropertyPanel.this.mProps[n].pd.getDisplayName());
                            this.editorComponent = PropertyPanel.this.button;
                        }
                        JComponent jComponent = this.editorComponent;
                        return jComponent;
                    }
                    catch (Exception exception) {}
                } else if (propertyEditor.getTags() != null) {
                    PropertyPanel.comboRemoveAllItems(PropertyPanel.this.comboBox);
                    String[] stringArray = propertyEditor.getTags();
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        PropertyPanel.this.comboBox.addItem(stringArray[n3]);
                        ++n3;
                    }
                    this.editorComponent = PropertyPanel.this.comboBox;
                    return this.editorComponent;
                }
            }
            this.editorComponent = PropertyPanel.this.textBox;
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            component.setEnabled(PropertyPanel.this.mProps[n].readonly ^ true);
            return component;
        }
    }

    private class myProperty {
        boolean isSet;
        Object oldValue;
        PropertyDescriptor pd;
        PropertyEditor pe;
        boolean readonly;
        boolean userProperty;
        Object value;

        private /* synthetic */ void $init$() {
            this.isSet = false;
            this.oldValue = null;
            this.value = null;
        }

        myProperty(PropertyDescriptor propertyDescriptor) {
            this.$init$();
            this.pd = propertyDescriptor;
            this.userProperty = this.pd.getDisplayName().startsWith("Prop.");
            this.readonly = this.userProperty || this.pd.getWriteMethod() == null;
            Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
            if (clazz != null) {
                try {
                    this.pe = (PropertyEditor)clazz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.pe == null) {
                this.pe = PropertyEditorManager.findEditor(this.pd.getPropertyType());
            }
        }

        public void set(Object object) {
            try {
                if (!this.isSet) {
                    this.oldValue = this.pd.getReadMethod().invoke(PropertyPanel.this.mEditObject, PropertyPanel.this.args);
                    this.isSet = true;
                }
                this.value = object;
                PropertyPanel.this.setArgs[0] = object;
                this.pd.getWriteMethod().invoke(PropertyPanel.this.mEditObject, PropertyPanel.this.setArgs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class PropertyTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl) {
                if (n2 == 1 && PropertyPanel.this.mProps[n].readonly) {
                    this.setBackground(UIManager.getColor("Label.background"));
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            return this;
        }

        private PropertyTableCellRenderer() {
        }
    }

    public final class 1
    extends AbstractTableModel {
        private final /* synthetic */ Object[][] v$data;
        private final /* synthetic */ boolean[] v$canedit;
        private final /* synthetic */ PropertyPanel v$myPanel;
        final /* synthetic */ PropertyPanel this$0;
        private static /* synthetic */ Class class$java$lang$String;

        public Class getColumnClass(int n) {
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = 1.class$("java.lang.String");
            }
            return clazz;
        }

        public int getColumnCount() {
            return columNames.length;
        }

        public String getColumnName(int n) {
            return columNames[n];
        }

        public int getRowCount() {
            return this.v$data.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.v$data[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 > 0 && this.v$canedit[n];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.v$data[n][n2] = object;
            this.v$myPanel.storeCellValue(object, n);
        }

        public /* synthetic */ 1(PropertyPanel propertyPanel, Object[][] objectArray, boolean[] blArray, PropertyPanel propertyPanel2) {
            this.v$myPanel = propertyPanel2;
            this.v$canedit = blArray;
            this.v$data = objectArray;
            this.this$0 = propertyPanel;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

