/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester.properties;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JComboBox;

public abstract class BaseEnumEditor
extends PropertyEditorSupport {
    private ActualEnumEditor editor;

    public String getJavaInitializationString() {
        return this.getEnumName() + "." + this.getAsText().toUpperCase();
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new ActualEnumEditor(this);
        }
        return this.editor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public boolean isPaintable() {
        return this.editor != null;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        this.editor.paint(graphics);
    }

    public void setValue(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            if (n > -1 && n < this.getTags().length) {
                super.setValue(object);
            }
        } else {
            this.setAsText(object.toString());
        }
    }

    public void setAsText(String string) {
        String[] stringArray = this.getTags();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                super.setValue(new Integer(n));
                return;
            }
            ++n;
        }
    }

    public String getAsText() {
        Object object = this.getValue();
        if (object instanceof Integer) {
            return object.toString();
        }
        return null;
    }

    public abstract String[] getTags();

    protected abstract String getEnumName();

    public class ActualEnumEditor
    extends JComboBox
    implements ItemListener {
        BaseEnumEditor host;

        ActualEnumEditor(BaseEnumEditor baseEnumEditor2) {
            this.host = baseEnumEditor2;
            String[] stringArray = baseEnumEditor2.getTags();
            int n = 0;
            while (n < stringArray.length) {
                this.addItem(stringArray[n]);
                ++n;
            }
            super.setSelectedIndex(new Integer(baseEnumEditor2.getAsText()));
            super.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.host.firePropertyChange();
                this.host.setValue(this.getSelectedItem());
            }
        }
    }
}

