/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester.load;

import com.sun.java.util.collections.ArrayList;
import oracle.jbo.jbotester.load.TimeSeriesModelListener;

public class TimeSeriesModel {
    private static int DEFAULT_MAX_SAMPLE_SIZE = 200;
    private static double ERROR_TOLERANCE = 0.05;
    private static double RESPONSE_TIME_FACTOR = 0.95;
    private int mMaxSampleSize;
    private int mSampleSize;
    private Object mSyncLock;
    double[] mData;
    double[] mTimeIntervals;
    private int mSampleSizeDelta;
    private long mLastUpdateTime;
    private long mFirstUpdateTime;
    private int mPos;
    private double mTotalTime;
    private double mDataMax;
    private double mDataMin;
    private double mDataTotal;
    private double mXScale;
    private double mYScale;
    private ArrayList mModelListeners;

    private /* synthetic */ void $init$() {
        this.mMaxSampleSize = DEFAULT_MAX_SAMPLE_SIZE;
        this.mSampleSize = 0;
        this.mSyncLock = new Object();
        this.mData = new double[this.mMaxSampleSize];
        this.mTimeIntervals = new double[this.mMaxSampleSize];
        this.mSampleSizeDelta = 0;
        this.mLastUpdateTime = 0L;
        this.mFirstUpdateTime = 0L;
        this.mPos = -1;
        this.mTotalTime = 0.0;
        this.mDataMax = 0.0;
        this.mDataMin = 0.0;
        this.mDataTotal = 0.0;
        this.mXScale = 1.0;
        this.mYScale = 1.0;
        this.mModelListeners = new ArrayList();
    }

    public TimeSeriesModel() {
        this.$init$();
        this.init();
    }

    private void init() {
    }

    public void addModelListener(TimeSeriesModelListener timeSeriesModelListener) {
        this.mModelListeners.add((Object)timeSeriesModelListener);
    }

    public void removeModelListener(TimeSeriesModelListener timeSeriesModelListener) {
        this.mModelListeners.remove((Object)timeSeriesModelListener);
    }

    public void reset() {
        this.mMaxSampleSize = DEFAULT_MAX_SAMPLE_SIZE;
        this.mSampleSize = 0;
        this.mData = new double[this.mMaxSampleSize];
        this.mTimeIntervals = new double[this.mMaxSampleSize];
        this.mSampleSizeDelta = 0;
        this.mFirstUpdateTime = 0L;
        this.mLastUpdateTime = 0L;
        this.mPos = -1;
        this.mTotalTime = 0.0;
        this.mDataTotal = 0.0;
        this.mDataMin = 0.0;
        this.mDataMax = 0.0;
        this.mXScale = 1.0;
        this.mYScale = 1.0;
        this.fireModelChanged();
    }

    private void fireModelChanged() {
        int n = 0;
        while (n < this.mModelListeners.size()) {
            ((TimeSeriesModelListener)this.mModelListeners.get(n)).modelChanged();
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataPoint(double d) {
        Object object = this.mSyncLock;
        synchronized (object) {
            if (this.mSampleSizeDelta < this.mMaxSampleSize - 1) {
                ++this.mSampleSizeDelta;
            }
            long l = System.currentTimeMillis();
            long l2 = 0L;
            if (this.mLastUpdateTime > 0L) {
                l2 = l - this.mLastUpdateTime;
            }
            this.mLastUpdateTime = l;
            if (this.mFirstUpdateTime == 0L) {
                this.mFirstUpdateTime = this.mLastUpdateTime;
            }
            ++this.mPos;
            if (this.mPos == this.mMaxSampleSize) {
                this.mPos = 0;
                this.mDataMin = d;
            }
            if (this.mSampleSize < this.mMaxSampleSize) {
                ++this.mSampleSize;
            }
            this.mTotalTime -= this.mTimeIntervals[this.mPos] / this.mXScale;
            this.mDataTotal -= this.mData[this.mPos] / this.mYScale;
            double d2 = (double)l2 * this.mXScale;
            this.mTotalTime += (double)l2;
            double d3 = d * this.mYScale;
            this.mDataMax = Math.max(this.mDataMax, d);
            this.mDataMin = Math.min(this.mDataMin, d);
            this.mDataTotal += d;
            this.mData[this.mPos] = d3;
            this.mTimeIntervals[this.mPos] = d2;
        }
        this.fireModelChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDataMax() {
        Object object = this.mSyncLock;
        synchronized (object) {
            double d = this.mDataMax;
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDataMin() {
        Object object = this.mSyncLock;
        synchronized (object) {
            double d = this.mDataMin;
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDataAvg() {
        Object object = this.mSyncLock;
        synchronized (object) {
            double d = this.mDataTotal / (double)this.mSampleSize;
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSampleSize() {
        Object object = this.mSyncLock;
        synchronized (object) {
            int n = this.mMaxSampleSize;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSampleSize() {
        Object object = this.mSyncLock;
        synchronized (object) {
            int n = this.mSampleSize;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalTime() {
        Object object = this.mSyncLock;
        synchronized (object) {
            long l = (long)this.mTotalTime;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastUpdateTime() {
        Object object = this.mSyncLock;
        synchronized (object) {
            long l = this.mLastUpdateTime;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstUpdateTime() {
        Object object = this.mSyncLock;
        synchronized (object) {
            long l = this.mFirstUpdateTime;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescale(double[] dArray, double d, double d2) {
        Object object = this.mSyncLock;
        synchronized (object) {
            if (this.mPos == -1) {
                return;
            }
            int n = this.mPos;
            int n2 = this.mMaxSampleSize - 1;
            while (n2 > 0) {
                dArray[n] = dArray[n] / d * d2;
                if (--n < 0) {
                    n = this.mMaxSampleSize - 1;
                }
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSampleSizeDelta() {
        Object object = this.mSyncLock;
        synchronized (object) {
            int n = this.mSampleSizeDelta;
            return n;
        }
    }

    Object getSyncLock() {
        return this.mSyncLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int translate(int[] nArray, int[] nArray2, double d, double d2) {
        Object object = this.mSyncLock;
        synchronized (object) {
            double d3;
            double d4;
            double d5;
            this.mSampleSizeDelta = 0;
            if (this.mPos == -1) {
                int n = 0;
                return n;
            }
            int n = this.mPos;
            double d6 = 0.0;
            if (this.mTotalTime > 0.0 && (d5 = Math.abs((this.mXScale - (d6 = d / (d4 = this.mTotalTime / (double)this.mSampleSize * (double)this.mMaxSampleSize))) / this.mXScale)) > ERROR_TOLERANCE) {
                this.rescale(this.mTimeIntervals, this.mXScale, d6);
                this.mXScale = d6;
            }
            double d7 = 0.0;
            if (this.mDataMax > 0.0 && (d3 = Math.abs((this.mYScale - (d7 = d2 / this.mDataMax)) / this.mYScale)) > ERROR_TOLERANCE) {
                this.rescale(this.mData, this.mYScale, d7);
                this.mYScale = d7;
            }
            int n2 = 0;
            double d8 = d;
            int n3 = this.mMaxSampleSize - 1;
            while (n3 > 0) {
                if (n2 == this.mSampleSize) break;
                nArray[n3] = (int)d8;
                nArray2[n3] = (int)(d2 - this.mData[n] * RESPONSE_TIME_FACTOR);
                ++n2;
                if ((d8 -= (double)Math.round(this.mTimeIntervals[n])) <= 0.0) break;
                if (--n < 0) {
                    n = this.mMaxSampleSize - 1;
                }
                --n3;
            }
            int n4 = n2;
            return n4;
        }
    }
}

