/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester.load;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.jbo.jbotester.load.SimpleDateFormatter;
import oracle.jbo.jbotester.load.TimeSeriesModel;
import oracle.jbo.jbotester.load.TimeSeriesModelListener;

public class TimeSeriesGraph
extends JPanel
implements TimeSeriesModelListener {
    SimpleDateFormatter mDateFormatter;
    SimpleDateFormatter mLongDateFormatter;
    private static int TIME_SEGMENT_LENGTH = 5;
    private static Color GRID_LINE_COLOR = new Color(27, 96, 6);
    private TimeSeriesModel mModel;
    private final StripGraph mStripGraph;
    private JLabel mMinValueLabel;
    private JLabel mMaxValueLabel;
    private JLabel mAvgValueLabel;
    private JLabel mNewestTimeLabel;
    private JLabel mOldestTimeLabel;

    private /* synthetic */ void $init$() {
        this.mDateFormatter = new SimpleDateFormatter("mm:ss");
        this.mLongDateFormatter = new SimpleDateFormatter("HH:mm:ss");
        this.mStripGraph = new StripGraph();
        this.mMinValueLabel = new JLabel("0.0");
        this.mMaxValueLabel = new JLabel("0.0");
        this.mAvgValueLabel = new JLabel("0.0");
        this.mNewestTimeLabel = new JLabel("00:00");
        this.mOldestTimeLabel = new JLabel(" ");
    }

    public TimeSeriesGraph() {
        this(new TimeSeriesModel());
    }

    public TimeSeriesGraph(TimeSeriesModel timeSeriesModel) {
        this.$init$();
        this.setModel(timeSeriesModel);
        this.init();
    }

    void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createTitledBorder("Data History"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        JPanel jPanel = new JPanel(new CardLayout());
        jPanel.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.add("StripGraph", this.mStripGraph);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mOldestTimeLabel.setHorizontalAlignment(2);
        this.add((Component)this.mOldestTimeLabel, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mNewestTimeLabel.setHorizontalAlignment(4);
        this.add((Component)this.mNewestTimeLabel, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 0, 5);
        jPanel = this.buildSummaryStatisticsPanel();
        this.add((Component)jPanel, gridBagConstraints);
    }

    private JPanel buildSummaryStatisticsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        Dimension dimension = jPanel.getPreferredSize();
        dimension.setSize(dimension.getWidth(), 25.0);
        jPanel.setPreferredSize(dimension);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.buildSummaryStatisticPanel(new JLabel("Max:"), this.mMaxValueLabel), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.buildSummaryStatisticPanel(new JLabel("Min:"), this.mMinValueLabel), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.buildSummaryStatisticPanel(new JLabel("Avg:"), this.mAvgValueLabel), gridBagConstraints);
        return jPanel;
    }

    private JPanel buildSummaryStatisticPanel(JLabel jLabel, JLabel jLabel2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jLabel.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setPreferredSize(new Dimension(50, (int)jLabel2.getPreferredSize().getHeight()));
        jLabel2.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        return jPanel;
    }

    public TimeSeriesModel getModel() {
        return this.mModel;
    }

    private void setModelInternal(TimeSeriesModel timeSeriesModel) {
        this.mStripGraph.setModel(timeSeriesModel);
        if (this.mModel != null) {
            this.mModel.removeModelListener(this);
        }
        timeSeriesModel.addModelListener(this);
        this.mModel = timeSeriesModel;
        this.repaint();
    }

    public void setModel(TimeSeriesModel timeSeriesModel) {
        this.setModel(timeSeriesModel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(TimeSeriesModel timeSeriesModel, String string) {
        if (this.mModel != null) {
            Object object = this.mModel.getSyncLock();
            synchronized (object) {
                if (string != null) {
                    this.setTitle(string);
                }
                this.setModelInternal(timeSeriesModel);
            }
        } else {
            this.setModelInternal(timeSeriesModel);
        }
    }

    public void setTitle(String string) {
        this.setBorder(BorderFactory.createTitledBorder(string));
    }

    public void reset() {
        if (this.mModel != null) {
            this.mModel.reset();
            this.mStripGraph.repaint();
        }
    }

    public void modelChanged() {
        if (this.mModel != null && this.mModel.getSampleSizeDelta() > 2) {
            float f = (float)Math.round(this.mModel.getDataMax() * 10.0) / 10.0f;
            float f2 = (float)Math.round(this.mModel.getDataMin() * 10.0) / 10.0f;
            float f3 = (float)Math.round(this.mModel.getDataAvg() * 10.0) / 10.0f;
            this.mMaxValueLabel.setText(new Float(f).toString());
            this.mMinValueLabel.setText(new Float(f2).toString());
            this.mAvgValueLabel.setText(new Float(f3).toString());
            long l = this.mModel.getLastUpdateTime();
            long l2 = this.mModel.getFirstUpdateTime();
            long l3 = l - l2;
            SimpleDateFormatter simpleDateFormatter = l3 > 3600000L ? this.mLongDateFormatter : this.mDateFormatter;
            Date date = new Date(l - l2);
            this.mNewestTimeLabel.setText(simpleDateFormatter.format(date));
            if (this.mModel.getSampleSize() == this.mModel.getMaxSampleSize()) {
                long l4 = l3 - this.mModel.getTotalTime();
                simpleDateFormatter = l4 > 3600000L ? this.mLongDateFormatter : this.mDateFormatter;
                date = new Date(l4);
                this.mOldestTimeLabel.setText(simpleDateFormatter.format(date));
            } else {
                this.mOldestTimeLabel.setText(" ");
            }
            this.mStripGraph.repaint();
        }
    }

    public class StripGraph
    extends JPanel {
        private int[] mXCoordinates;
        private int[] mYCoordinates;

        public StripGraph() {
            this.init();
        }

        void setModel(TimeSeriesModel timeSeriesModel) {
            int n = timeSeriesModel.getMaxSampleSize();
            this.mXCoordinates = new int[n];
            this.mYCoordinates = new int[n];
        }

        private void init() {
            this.setDoubleBuffered(true);
            this.setBackground(Color.BLACK);
        }

        private void drawGrid(Graphics graphics, int n) {
            graphics.setColor(GRID_LINE_COLOR);
            Rectangle rectangle = graphics.getClipBounds();
            double d = rectangle.getWidth();
            double d2 = rectangle.getHeight();
            int n2 = TIME_SEGMENT_LENGTH - n % TIME_SEGMENT_LENGTH;
            while ((double)n2 < d) {
                graphics.drawLine(n2, 0, n2, (int)d2);
                n2 += TIME_SEGMENT_LENGTH;
            }
            int n3 = 0;
            while ((double)n3 < d2) {
                graphics.drawLine(0, n3, (int)d, n3);
                n3 += TIME_SEGMENT_LENGTH;
            }
        }

        private void drawSeriesLine(Graphics graphics, int[] nArray, int[] nArray2, int n) {
            graphics.setColor(Color.GREEN);
            int n2 = nArray.length - n;
            while (n2 < nArray.length - 1) {
                graphics.drawLine(nArray[n2], nArray2[n2], nArray[n2 + 1], nArray2[n2 + 1]);
                ++n2;
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            Object object = TimeSeriesGraph.this.mModel.getSyncLock();
            synchronized (object) {
                super.paint(graphics);
                Rectangle rectangle = graphics.getClipBounds();
                double d = rectangle.getWidth();
                double d2 = rectangle.getHeight();
                int n = TimeSeriesGraph.this.mModel.getSampleSizeDelta();
                int n2 = TimeSeriesGraph.this.mModel.translate(this.mXCoordinates, this.mYCoordinates, d, d2);
                int n3 = this.mXCoordinates[this.mXCoordinates.length - 1] - this.mXCoordinates[this.mXCoordinates.length - 1 - n];
                this.drawGrid(graphics, n3);
                this.drawSeriesLine(graphics, this.mXCoordinates, this.mYCoordinates, n2);
            }
        }
    }
}

