/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester.load;

import com.sun.java.util.collections.ArrayList;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.load.Controller;
import oracle.jbo.jbotester.load.UIHelper;

public class SimulationParametersPanel
extends JPanel {
    private NumericSpinBox mNumOfSessionsSpin;
    private NumericSpinBox mNumOfIterationsSpin;
    private NumericSpinBox mTestDurationSpin;
    private NumericSpinBox mThinkTimeSpin;
    private JTextField mTaskClassNameText;
    private final JButton mResetButton;
    private final JButton mApplyButton;
    private Controller mController;

    private /* synthetic */ void $init$() {
        this.mNumOfSessionsSpin = new NumericSpinBox(0, 1000);
        this.mNumOfIterationsSpin = new NumericSpinBox(-1, 1000);
        this.mTestDurationSpin = new NumericSpinBox(0, 86400);
        this.mThinkTimeSpin = new NumericSpinBox(0, 300);
        this.mTaskClassNameText = new JTextField();
        this.mResetButton = new JButton("Reset");
        this.mApplyButton = new JButton("Apply");
        this.mController = null;
    }

    public SimulationParametersPanel(Controller controller) {
        this.$init$();
        this.mController = controller;
        this.init();
    }

    private final void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel("Number of sessions:  ");
        UIHelper.buildSpinBoxRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfSessionsSpin);
        JLabel jLabel2 = new JLabel("Number of iterations per session:  ");
        UIHelper.buildSpinBoxRow(this, gridBagConstraints, gridBagLayout, jLabel2, this.mNumOfIterationsSpin);
        JLabel jLabel3 = new JLabel("Duration of simulation(s):  ");
        UIHelper.buildSpinBoxRow(this, gridBagConstraints, gridBagLayout, jLabel3, this.mTestDurationSpin);
        JLabel jLabel4 = new JLabel("Think time per iteration(s):  ");
        UIHelper.buildSpinBoxRow(this, gridBagConstraints, gridBagLayout, jLabel4, this.mThinkTimeSpin);
        JLabel jLabel5 = new JLabel("Task class name:  ");
        gridBagConstraints.gridwidth = 2;
        UIHelper.buildRow(this, gridBagConstraints, gridBagLayout, jLabel5, this.mTaskClassNameText);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = this.buildButtonsBar();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.updatePanelUI();
    }

    private JPanel buildButtonsBar() {
        int n = 0;
        ArrayList arrayList = new ArrayList();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        arrayList.add((Object)this.mResetButton);
        n = Math.max(n, this.mResetButton.getMinimumSize().width);
        this.mResetButton.addActionListener(new 2());
        String string = "Reset";
        this.mResetButton.setText(JboTesterUtil.stripMnemonic(string));
        int n2 = JboTesterUtil.getMnemonicKeyCode(string);
        if (n2 != 0) {
            this.mResetButton.setMnemonic(n2);
        }
        arrayList.add((Object)this.mApplyButton);
        n = Math.max(n, this.mApplyButton.getMinimumSize().width);
        this.mApplyButton.setEnabled(true);
        this.mApplyButton.setDefaultCapable(true);
        this.mApplyButton.addActionListener(new 1());
        Dimension dimension = new Dimension(n, this.mApplyButton.getMinimumSize().height);
        Dimension dimension2 = new Dimension(8, 0);
        int n3 = 0;
        while (n3 < arrayList.size()) {
            JButton jButton = (JButton)arrayList.get(n3);
            jButton.setPreferredSize(dimension);
            if (n3 == 0) {
                jPanel.add(Box.createHorizontalGlue());
                jPanel.add(jButton);
                jPanel.add(Box.createRigidArea(dimension2));
            } else {
                jPanel.add(jButton);
                jPanel.add(Box.createRigidArea(dimension2));
            }
            ++n3;
        }
        return jPanel;
    }

    private void apply() {
        this.mController.setNumOfSessions(this.mNumOfSessionsSpin.getIntValue());
        this.mController.setNumOfIterations(this.mNumOfIterationsSpin.getIntValue());
        this.mController.setDuration(this.mTestDurationSpin.getIntValue() * 1000);
        this.mController.setThinkTime(this.mThinkTimeSpin.getIntValue() * 1000);
        this.mController.setTaskClassName(this.mTaskClassNameText.getText());
    }

    private void reset() {
        this.mController.resetParameters();
        this.resetPanelUI();
    }

    final void resetPanelUI() {
        this.mNumOfSessionsSpin.setIntValue(this.mController.getNumOfSessions());
        this.mNumOfIterationsSpin.setIntValue(this.mController.getNumOfIterations());
        this.mTestDurationSpin.setIntValue(this.mController.getDuration() / 1000);
        this.mThinkTimeSpin.setIntValue(this.mController.getThinkTime() / 1000);
        this.mTaskClassNameText.setText(this.mController.getTaskClassName());
    }

    final void updatePanelUI() {
        this.resetPanelUI();
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SimulationParametersPanel.this.reset();
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SimulationParametersPanel.this.apply();
        }
    }
}

