/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ComponentObject;
import oracle.jbo.ViewObject;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MDForm;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.ObjTreeNode;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.ResultWindow;
import oracle.jbo.jbotester.SimpleForm;
import oracle.jbo.jbotester.properties.ViewObjectBean;

public final class VOTreeNode
extends ObjTreeNode {
    private ApplicationModule am;
    private String name;
    private ViewObject vo;
    private static ImageIcon icon;

    public VOTreeNode(ViewObject viewObject) {
        this(viewObject.getApplicationModule(), viewObject);
    }

    public VOTreeNode(ApplicationModule applicationModule, ViewObject viewObject) {
        this(applicationModule, viewObject.getName());
        this.vo = viewObject;
    }

    public VOTreeNode(ApplicationModule applicationModule, String string) {
        super(string);
        this.name = string;
        this.am = applicationModule;
        if (icon == null) {
            icon = JboTesterUtil.getIcon("NodeVOU.gif");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.vo != null) {
            return this.vo.getFullName();
        }
        return this.am.getFullName() + "." + this.name;
    }

    public int getType() {
        return 1;
    }

    public Object getData() {
        return this.getViewObject();
    }

    protected ViewObject getViewObject() {
        if (this.vo == null) {
            this.vo = this.am.findViewObject(this.name);
        }
        return this.vo;
    }

    public void setData(Object object) {
        this.vo = (ViewObject)object;
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public void showForm() {
        String string = this.getFullName();
        ResultWindow resultWindow = ResultWindow.getResultWindow();
        if (resultWindow.getTab(string) == null) {
            MainFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            try {
                resultWindow.addTab(new SimpleForm(MainFrame.getInstance(), this, this.getViewObject()), string);
            }
            catch (Throwable throwable) {
                ErrorHandler.displayError((Frame)MainFrame.getInstance(), throwable);
            }
            MainFrame.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        } else {
            resultWindow.showTab(string);
        }
    }

    public String getStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Res.getString(194));
        if (this.vo != null) {
            stringBuffer.append(this.vo.getFullName());
            stringBuffer.append(Res.getString(195));
            stringBuffer.append(this.vo.getDefFullName());
        } else {
            stringBuffer.append(this.name);
        }
        return stringBuffer.toString();
    }

    public void handleEvent(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(JboTesterUtil.stripMnemonic(Res.getString(197)))) {
            JboTesterUtil.createViewCriteria(MainFrame.getInstance(), this.vo);
        } else if (actionEvent.getActionCommand().equals(JboTesterUtil.stripMnemonic(Res.getString(198)))) {
            this.vo.executeQuery();
        } else if (JboTesterUtil.stripMnemonic(Res.getString(204)).equals(actionEvent.getActionCommand())) {
            JboTesterUtil.editBindParameters(MainFrame.getInstance(), this.vo);
        }
    }

    public JPopupMenu getMenu() {
        return this.createVOVLMenu((ComponentObject)this.vo);
    }

    public void remove() {
        if (this.vo == null) {
            this.getViewObject();
        }
        if (this.vo != null) {
            JPanel jPanel = ResultWindow.getResultWindow().removeTab(this.getFullName());
            if (jPanel != null) {
                ((SimpleForm)jPanel).setIterator(null);
                if (jPanel instanceof MDForm) {
                    ((MDForm)jPanel).setDetailRowSetIterator(null);
                }
            }
            this.vo.remove();
            this.vo = null;
        }
        super.remove();
    }

    public void showProperties() {
        this.getData();
        ViewObjectBean viewObjectBean = new ViewObjectBean(this.vo, this.isFormDisplayed((ComponentObject)this.vo));
        this.showPropertyDialog(viewObjectBean, viewObjectBean.getBeanInfo(), 190);
    }

    protected boolean isBindParameterActionEnabled(ComponentObject componentObject) {
        return JboTesterUtil.hasBindParameters(componentObject != null ? (ViewObject)componentObject : this.getViewObject());
    }
}

