/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.ComponentObject;
import oracle.jbo.ViewLink;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MDForm;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.ObjTreeNode;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.ResultWindow;
import oracle.jbo.jbotester.SimpleForm;
import oracle.jbo.jbotester.TreeForm;
import oracle.jbo.jbotester.properties.ViewLinkBean;

public final class VLTreeNode
extends ObjTreeNode {
    private ApplicationModule am;
    private String name;
    private ViewLink vl;
    private static ImageIcon icon;

    public VLTreeNode(ViewLink viewLink) {
        this(viewLink.getSource().getApplicationModule(), viewLink);
    }

    public VLTreeNode(ApplicationModule applicationModule, ViewLink viewLink) {
        this(applicationModule, viewLink.getName());
        this.vl = viewLink;
    }

    public VLTreeNode(ApplicationModule applicationModule, String string) {
        super(string);
        this.name = string;
        this.am = applicationModule;
        if (icon == null) {
            icon = JboTesterUtil.getIcon("NodeVLU.gif");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.vl != null) {
            return this.vl.getFullName();
        }
        return this.am.getFullName() + "." + this.name;
    }

    public int getType() {
        return 2;
    }

    public Object getData() {
        if (this.vl == null) {
            this.vl = this.am.findViewLink(this.name);
        }
        return this.vl;
    }

    public void setData(Object object) {
        this.vl = (ViewLink)object;
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public void showForm() {
        String string = this.getFullName();
        ResultWindow resultWindow = ResultWindow.getResultWindow();
        if (resultWindow.getTab(string) == null) {
            MainFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            try {
                AttributeDef attributeDef;
                this.getData();
                boolean bl = false;
                if (this.vl.getSource().getDefName().equals(this.vl.getDestination().getDefName()) && (attributeDef = this.vl.getSource().findViewLinkAccessor(this.vl)) != null && attributeDef.getAttributeKind() == 6) {
                    bl = true;
                }
                SimpleForm simpleForm = bl ? new TreeForm(MainFrame.getInstance(), (ObjTreeNode)this, this.vl) : new MDForm(MainFrame.getInstance(), this, this.vl.getSource(), this.vl.getDestination());
                resultWindow.addTab(simpleForm, string);
                MainFrame.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (Throwable throwable) {
                ErrorHandler.displayError((Frame)MainFrame.getInstance(), throwable);
            }
        } else {
            resultWindow.showTab(string);
        }
    }

    public String getStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Res.getString(194));
        if (this.vl != null) {
            stringBuffer.append(this.vl.getFullName());
            stringBuffer.append(Res.getString(195));
            stringBuffer.append(this.vl.getDefFullName());
        } else {
            stringBuffer.append(this.name);
        }
        return stringBuffer.toString();
    }

    public void handleEvent(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(JboTesterUtil.stripMnemonic(Res.getString(197)))) {
            JboTesterUtil.createViewCriteria(MainFrame.getInstance(), this.vl.getSource());
        } else if (actionEvent.getActionCommand().equals(JboTesterUtil.stripMnemonic(Res.getString(198)))) {
            this.vl.getSource().executeQuery();
            this.vl.getDestination().executeQuery();
        }
    }

    public JPopupMenu getMenu() {
        return this.createVOVLMenu((ComponentObject)this.vl);
    }

    public void remove() {
        if (this.vl == null) {
            this.vl = this.am.findViewLink(this.name);
        }
        if (this.vl != null) {
            JPanel jPanel = ResultWindow.getResultWindow().removeTab(this.getFullName());
            if (jPanel != null) {
                ((SimpleForm)jPanel).setIterator(null);
                if (jPanel instanceof MDForm) {
                    ((MDForm)jPanel).setDetailRowSetIterator(null);
                }
            }
            this.vl.remove();
            this.vl = null;
        }
        super.remove();
    }

    public void showProperties() {
        ViewLinkBean viewLinkBean = new ViewLinkBean(this.vl);
        this.showPropertyDialog(viewLinkBean, viewLinkBean.getBeanInfo(), 191);
    }
}

