/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import com.sun.java.util.collections.ArrayList;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import oracle.jbo.AttributeDef;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewCriteriaRow;
import oracle.jbo.ViewObject;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.JTDialog;
import oracle.jbo.jbotester.JTScrollPane;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.Res;

public class VCDialog
extends JTDialog {
    private JButton addButt;
    AttributeDef[] attribs;
    private JPanel buttonPanel;
    private JButton cancelButt;
    private JButton createButt;
    private JButton helpButt;
    private boolean isVCExecuted;
    private ArrayList mColumnNames;
    private ArrayList mFields;
    private String mMnemonics;
    private ViewCriteria mOriginalVC;
    private String mReservedMnemonics;
    private ViewCriteria mViewCriteria;
    private ViewObject mViewObject;
    private JButton removeAllButt;
    private JButton removeButt;
    private JTabbedPane tabPane;
    private int vcRowCounter;
    private static String titleFirstTab = Res.getString(236);
    private final KeyListener keyListener;

    private static JButton createButton(int n) {
        String string = Res.getString(n);
        return new JButton(JboTesterUtil.stripMnemonic(string));
    }

    private /* synthetic */ void $init$() {
        this.addButt = VCDialog.createButton(233);
        this.attribs = null;
        this.buttonPanel = new JPanel();
        this.cancelButt = VCDialog.createButton(60);
        this.createButt = VCDialog.createButton(232);
        this.helpButt = VCDialog.createButton(62);
        this.isVCExecuted = true;
        this.mColumnNames = null;
        this.mFields = null;
        this.mMnemonics = "";
        this.mOriginalVC = null;
        this.mReservedMnemonics = "";
        this.mViewCriteria = null;
        this.mViewObject = null;
        this.removeAllButt = VCDialog.createButton(235);
        this.removeButt = VCDialog.createButton(234);
        this.tabPane = new JTabbedPane();
        this.vcRowCounter = 0;
        this.keyListener = new 5();
    }

    public VCDialog(MainFrame mainFrame, ViewObject viewObject) {
        super((Frame)mainFrame, 231);
        this.$init$();
        this.mViewObject = viewObject;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.displayError(this.parent, exception);
        }
    }

    private void addViewCriteriaRows() {
        ViewCriteriaRow viewCriteriaRow = null;
        this.mViewCriteria.removeAllElements();
        int n = this.tabPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            ArrayList arrayList = (ArrayList)this.mColumnNames.get(n2);
            ArrayList arrayList2 = (ArrayList)this.mFields.get(n2);
            int n3 = 0;
            while (n3 < arrayList2.size()) {
                String string = ((JTextField)arrayList2.get(n3)).getText();
                if (string != null && string.length() > 0) {
                    if (viewCriteriaRow == null) {
                        viewCriteriaRow = this.mViewCriteria.createViewCriteriaRow();
                    }
                    viewCriteriaRow.setAttribute((String)arrayList.get(n3), (Object)string);
                }
                ++n3;
            }
            if (viewCriteriaRow != null) {
                this.mViewCriteria.addElement(viewCriteriaRow);
                viewCriteriaRow = null;
            }
            ++n2;
        }
    }

    protected void cancel() {
        if (!this.isVCExecuted) {
            try {
                this.mViewObject.applyViewCriteria(this.mOriginalVC);
                this.mViewObject.executeQuery();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createViewCriteria() {
        try {
            this.addViewCriteriaRows();
            this.mViewObject.applyViewCriteria(this.mViewCriteria);
            this.mViewObject.executeQuery();
            ((MainFrame)this.parent).showTab(this.mViewObject.getFullName());
            this.close();
        }
        catch (Exception exception) {
            ErrorHandler.displayError(this.parent, exception);
            this.isVCExecuted = false;
        }
    }

    private void createViewCriteriaRow(boolean bl) {
        if (bl) {
            this.tabPane.removeAll();
            this.mColumnNames = new ArrayList();
            this.mFields = new ArrayList();
            this.vcRowCounter = 0;
            this.setEnabledRemoveButtons(false);
        }
        this.mMnemonics = this.mReservedMnemonics;
        String string = this.vcRowCounter++ == 0 ? titleFirstTab : Res.getString(237);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        int n = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.mColumnNames.add((Object)arrayList);
        this.mFields.add((Object)arrayList2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        JLabel jLabel = new JLabel(Res.getString(238));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        int n2 = 0;
        while (n2 < this.attribs.length) {
            jLabel = new JLabel(this.attribs[n2].getName() + ":");
            JTextField jTextField = new JTextField();
            jTextField.addKeyListener(this.keyListener);
            arrayList.add((Object)this.attribs[n2].getName());
            arrayList2.add((Object)jTextField);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jTextField, gridBagConstraints);
            jPanel.add(jTextField);
            this.setMnemonic(jLabel, jTextField);
            ++n2;
        }
        JTScrollPane jTScrollPane = new JTScrollPane(jPanel);
        this.tabPane.add(string, jTScrollPane);
        this.tabPane.setSelectedComponent(jTScrollPane);
    }

    private char getMnemonic(String string) {
        int n = 0;
        while (n < string.length()) {
            char c;
            String string2 = string.substring(n, n + 1).toUpperCase();
            if (this.mMnemonics.indexOf(string2) < 0 && (c = string.charAt(n)) >= 'A' && c <= 'z') {
                this.mMnemonics = this.mMnemonics + string2;
                return c;
            }
            ++n;
        }
        return ' ';
    }

    private void initButton(JButton jButton, ActionListener actionListener) {
        this.buttonPanel.add(jButton);
        jButton.addActionListener(actionListener);
        this.setMnemonic(jButton);
    }

    private void initViewCriteria() {
        this.mViewCriteria = this.mViewObject.getViewCriteria();
        this.mOriginalVC = this.mViewCriteria != null ? (ViewCriteria)this.mViewCriteria.clone() : (ViewCriteria)this.mViewObject.createViewCriteria().clone();
        ViewObject viewObject = this.mViewObject.getViewObject();
        AttributeDef[] attributeDefArray = viewObject.getAttributeDefs();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < attributeDefArray.length) {
            if (attributeDefArray[n].isQueriable()) {
                arrayList.add((Object)attributeDefArray[n]);
            }
            ++n;
        }
        this.attribs = (AttributeDef[])arrayList.toArray((Object[])new AttributeDef[arrayList.size()]);
        if (this.mViewCriteria == null || this.mViewCriteria.size() == 0) {
            this.createViewCriteriaRow(true);
            this.mViewCriteria = this.mViewObject.createViewCriteria();
            return;
        }
        ViewCriteriaRow viewCriteriaRow = null;
        Enumeration enumeration = this.mViewCriteria.elements();
        boolean bl = true;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        while (enumeration.hasMoreElements()) {
            this.createViewCriteriaRow(bl);
            if (bl) {
                bl = false;
            }
            int n2 = this.tabPane.getSelectedIndex();
            arrayList3 = (ArrayList)this.mColumnNames.get(n2);
            arrayList2 = (ArrayList)this.mFields.get(n2);
            viewCriteriaRow = (ViewCriteriaRow)enumeration.nextElement();
            int n3 = 0;
            while (n3 < arrayList3.size()) {
                ((JTextField)arrayList2.get(n3)).setText((String)viewCriteriaRow.getAttribute((String)arrayList3.get(n3)));
                ++n3;
            }
        }
        this.setEnabledRemoveButtons(bl ^ true);
        this.mViewCriteria = this.mViewObject.createViewCriteria();
    }

    private void jbInit() throws Exception {
        this.initButton(this.createButt, new 4());
        this.initButton(this.addButt, new 3());
        this.initButton(this.removeButt, new 2());
        this.initButton(this.removeAllButt, new 1());
        this.initButton(this.cancelButt, this.cancelAction);
        this.setHelpLocation("f1_bcbctviewcriteria_html");
        this.initButton(this.helpButt, this.helpAction);
        this.getContentPane().add((Component)this.tabPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.mReservedMnemonics = this.mMnemonics;
        this.initViewCriteria();
    }

    private void removeCurrentVCRow() {
        if (this.tabPane.getTabCount() <= 1) {
            this.createViewCriteriaRow(true);
        } else {
            int n = this.tabPane.getSelectedIndex();
            this.tabPane.removeTabAt(n);
            if (this.mColumnNames != null) {
                this.mColumnNames.remove(n);
            }
            if (this.mFields != null) {
                this.mFields.remove(n);
            }
            this.tabPane.setTitleAt(0, titleFirstTab);
        }
    }

    private void setEnabledRemoveButtons(boolean bl) {
        this.removeButt.setEnabled(bl);
        this.removeAllButt.setEnabled(bl && this.tabPane.getTabCount() > 1);
    }

    private void setMnemonic(JButton jButton) {
        jButton.setMnemonic(this.getMnemonic(jButton.getText()));
    }

    private void setMnemonic(JLabel jLabel, JTextField jTextField) {
        jLabel.setDisplayedMnemonic(this.getMnemonic(jLabel.getText()));
        jLabel.setLabelFor(jTextField);
    }

    public final class 5
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getSource() instanceof JTextField && ((JTextField)keyEvent.getSource()).getText() != null) {
                VCDialog.this.setEnabledRemoveButtons(true);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            VCDialog.this.createViewCriteria();
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            VCDialog.this.createViewCriteriaRow(false);
            VCDialog.this.setEnabledRemoveButtons(true);
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            VCDialog.this.removeCurrentVCRow();
            VCDialog.this.removeAllButt.setEnabled(VCDialog.this.tabPane.getTabCount() > 1);
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            VCDialog.this.createViewCriteriaRow(true);
        }
    }
}

