/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.jbo.RowSetIterator;
import oracle.jbo.jbotester.MDForm;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.ResultFrame;
import oracle.jbo.jbotester.SimpleForm;

public final class ResultWindow
implements ChangeListener {
    private static ResultWindow resultWindow = null;
    private final JTabbedPane tabPane;
    private final Hashtable mWins;
    private String selectedTabName;
    private transient ChangeEvent changeEvent;
    private EventListenerList listenerList;
    private boolean isDocking;
    private static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    private /* synthetic */ void $init$() {
        this.mWins = new Hashtable(20);
        this.listenerList = new EventListenerList();
        this.isDocking = false;
    }

    public boolean isDocking() {
        return this.isDocking;
    }

    public ResultWindow() {
        this.$init$();
        this.tabPane = new JTabbedPane();
        this.tabPane.addChangeListener(this);
    }

    public void addChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = ResultWindow.class$("javax.swing.event.ChangeListener");
        }
        this.listenerList.add(clazz, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = ResultWindow.class$("javax.swing.event.ChangeListener");
        }
        this.listenerList.remove(clazz, changeListener);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabPane;
    }

    public void addTab(JPanel jPanel, String string) {
        int n = this.tabPane.indexOfTab(string);
        if (n == -1) {
            this.tabPane.addTab(string, jPanel);
        }
        this.showTab(string);
    }

    public void addToWindow(JPanel jPanel, JPanel jPanel2) {
        int n = this.tabPane.indexOfComponent(jPanel2);
        if (n == -1) {
            return;
        }
        String string = this.tabPane.getTitleAt(n);
        this.tabPane.removeTabAt(n);
        ResultFrame resultFrame = new ResultFrame(this, jPanel2, string);
        this.mWins.put(string, resultFrame);
        resultFrame.getContentPane().add(jPanel.getComponent(0), "North");
        resultFrame.getContentPane().add(jPanel2.getComponent(0), "Center");
        resultFrame.setLocation(jPanel.getRootPane().getParent().getLocationOnScreen());
        resultFrame.pack();
        resultFrame.setVisible(true);
        jPanel.getRootPane().getParent().setVisible(false);
    }

    public void displayInWindow(JPanel jPanel) {
        int n = this.tabPane.indexOfComponent(jPanel);
        if (n == -1) {
            return;
        }
        String string = this.tabPane.getTitleAt(n);
        this.tabPane.removeTabAt(n);
        ResultFrame resultFrame = new ResultFrame(this, jPanel, string);
        this.mWins.put(string, resultFrame);
        resultFrame.getContentPane().add(jPanel.getComponent(0), "North");
        resultFrame.getContentPane().add(jPanel.getComponent(0), "Center");
        resultFrame.setLocationRelativeTo(MainFrame.getInstance());
        resultFrame.pack();
        resultFrame.setVisible(true);
    }

    public static ResultWindow getResultWindow() {
        return resultWindow;
    }

    public static ResultWindow createResultWindow() {
        if (resultWindow == null) {
            resultWindow = new ResultWindow();
        }
        return resultWindow;
    }

    public JPanel getTab(String string) {
        JPanel jPanel = null;
        if (string == null) {
            return null;
        }
        int n = this.tabPane.indexOfTab(string);
        if (n == -1) {
            ResultFrame resultFrame = (ResultFrame)this.mWins.get(string);
            if (resultFrame != null) {
                jPanel = resultFrame.mPanel;
            }
        } else {
            jPanel = (JPanel)this.tabPane.getComponentAt(n);
        }
        return jPanel;
    }

    public JPanel getSelectedTab() {
        return this.getTab(this.selectedTabName);
    }

    public void showTab(String string) {
        int n = this.tabPane.indexOfTab(string);
        if (n != -1) {
            this.tabPane.setSelectedIndex(n);
        } else {
            JDialog jDialog = (JDialog)this.mWins.get(string);
            if (jDialog != null) {
                jDialog.toFront();
            }
        }
    }

    public JPanel removeTab(String string) {
        JPanel jPanel = null;
        int n = this.tabPane.indexOfTab(string);
        if (n != -1) {
            jPanel = (JPanel)this.tabPane.getComponentAt(n);
            this.tabPane.removeTabAt(n);
        } else {
            ResultFrame resultFrame = (ResultFrame)this.mWins.get(string);
            if (resultFrame != null) {
                jPanel = resultFrame.mPanel;
                resultFrame.dispose();
                this.mWins.remove(string);
            }
        }
        return jPanel;
    }

    public void replaceTab(ResultFrame resultFrame) {
        JPanel jPanel = resultFrame.mPanel;
        jPanel.add(resultFrame.getContentPane().getComponent(0), "North");
        jPanel.add(resultFrame.getContentPane().getComponent(0), "Center");
        this.addTab(jPanel, resultFrame.getTitle());
        this.mWins.remove(resultFrame.getTitle());
        this.isDocking = true;
        this.fireStateChange();
        this.isDocking = false;
    }

    public void removeAllTabs() {
        this.mWins.clear();
        this.tabPane.removeAll();
    }

    public void refreshAfterActivate() {
        int n = this.tabPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            this.refreshFormAfterActivate((SimpleForm)this.tabPane.getComponentAt(n2));
            ++n2;
        }
        Enumeration enumeration = this.mWins.elements();
        while (enumeration.hasMoreElements()) {
            ResultFrame resultFrame = (ResultFrame)enumeration.nextElement();
            if (resultFrame == null) continue;
            this.refreshFormAfterActivate((SimpleForm)resultFrame.mPanel);
        }
    }

    void refreshFormAfterActivate(SimpleForm simpleForm) {
        RowSetIterator rowSetIterator = simpleForm instanceof MDForm ? ((MDForm)simpleForm).getDetailRowSetIterator() : simpleForm.getIterator();
        rowSetIterator.getCurrentRow();
    }

    public void refreshAll(boolean bl) {
        int n = this.tabPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            this.refreshForm(this.tabPane.getComponentAt(n2), bl);
            ++n2;
        }
        Enumeration enumeration = this.mWins.elements();
        while (enumeration.hasMoreElements()) {
            ResultFrame resultFrame = (ResultFrame)enumeration.nextElement();
            if (resultFrame == null) continue;
            this.refreshForm(resultFrame.mPanel, bl);
        }
    }

    private void refreshForm(Component component, boolean bl) {
        RowSetIterator rowSetIterator = null;
        if (component == null) {
            return;
        }
        if (bl) {
            if (component instanceof MDForm && (rowSetIterator = ((MDForm)component).getDetailRowSetIterator()) != null) {
                rowSetIterator.first();
            }
            if ((rowSetIterator = ((SimpleForm)component).getIterator()) != null) {
                rowSetIterator.first();
            }
        } else {
            SimpleForm simpleForm = (SimpleForm)component;
            simpleForm.refreshAll();
        }
    }

    private void fireStateChange() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = ResultWindow.class$("javax.swing.event.ChangeListener");
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    void tabIsSelected(String string) {
        this.selectedTabName = string;
        this.fireStateChange();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane;
        int n;
        if (changeEvent.getSource() instanceof JTabbedPane && (n = (jTabbedPane = (JTabbedPane)changeEvent.getSource()).getSelectedIndex()) != -1) {
            this.tabIsSelected(jTabbedPane.getTitleAt(n));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

