/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import com.sun.java.util.collections.ArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.load.Controller;

public class PoolParameterPanel
extends JPanel {
    private static final int MAX_POOL_SIZE = 5000;
    private static final int MIN_POOL_SIZE = 0;
    private Hashtable mParams;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private final NumericSpinBox poolInitSizeSpin;
    private final NumericSpinBox poolMaxSizeSpin;
    private final NumericSpinBox poolRefSizeSpin;
    private final NumericSpinBox poolMinAvailSizeSpin;
    private final NumericSpinBox poolMaxAvailSizeSpin;
    private final NumericSpinBox poolMaxInactiveAgeSpin;
    private final NumericSpinBox poolMonitorSleepIntervalSpin;
    private final NumericSpinBox connPoolInitSizeSpin;
    private final NumericSpinBox connPoolMaxSizeSpin;
    private final NumericSpinBox connPoolMinAvailSizeSpin;
    private final NumericSpinBox connPoolMaxAvailSizeSpin;
    private final NumericSpinBox connPoolMaxInactiveAgeSpin;
    private final NumericSpinBox connPoolMonitorSleepIntervalSpin;
    private final NumericSpinBox[] connCapacitySpins;
    private final JCheckBox poolDoFailoverCheck;
    private final JCheckBox poolDoConnectionPoolingCheck;
    private final JCheckBox poolDynamicJdbcCredentialsCheck;
    private final JCheckBox poolResetNonTxnStateCheck;
    private final JCheckBox poolDoAMPoolingCheck;
    private final JCheckBox poolIsUseExclusiveCheck;
    private final JButton mResetButton;
    private final JButton mApplyButton;
    static PropertyMetadata[] POOL_PARAMETER_METADATA = new PropertyMetadata[]{PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE, PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE, PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD, PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE, PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE, PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE, PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL, PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE, PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE, PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE, PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE, PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE, PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL, PropertyMetadata.ENV_DO_FAILOVER, PropertyMetadata.ENV_DO_CONNECTION_POOLING, PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS, PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE, PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING, PropertyMetadata.ENV_AMPOOL_COOKIE_FACTORY_CLASS_NAME};
    private final Frame mParentFrame;
    private Controller mController;
    private boolean mIsStandalone;

    private /* synthetic */ void $init$() {
        this.poolInitSizeSpin = new NumericSpinBox(0, 5000);
        this.poolMaxSizeSpin = new NumericSpinBox(0, 5000);
        this.poolRefSizeSpin = new NumericSpinBox(0, 5000);
        this.poolMinAvailSizeSpin = new NumericSpinBox(0, 5000);
        this.poolMaxAvailSizeSpin = new NumericSpinBox(0, 5000);
        this.poolMaxInactiveAgeSpin = new NumericSpinBox(0, 86400);
        this.poolMonitorSleepIntervalSpin = new NumericSpinBox(0, 86400);
        this.connPoolInitSizeSpin = new NumericSpinBox(0, 5000);
        this.connPoolMaxSizeSpin = new NumericSpinBox(0, 5000);
        this.connPoolMinAvailSizeSpin = new NumericSpinBox(0, 5000);
        this.connPoolMaxAvailSizeSpin = new NumericSpinBox(0, 5000);
        this.connPoolMaxInactiveAgeSpin = new NumericSpinBox(0, 86400);
        this.connPoolMonitorSleepIntervalSpin = new NumericSpinBox(0, 86400);
        this.connCapacitySpins = new NumericSpinBox[]{this.connPoolInitSizeSpin, this.connPoolMaxSizeSpin, this.connPoolMinAvailSizeSpin, this.connPoolMaxAvailSizeSpin, this.connPoolMaxInactiveAgeSpin, this.connPoolMonitorSleepIntervalSpin};
        this.poolDoFailoverCheck = JboTesterUtil.createCheckBox(111);
        this.poolDoConnectionPoolingCheck = JboTesterUtil.createCheckBox(112);
        this.poolDynamicJdbcCredentialsCheck = JboTesterUtil.createCheckBox(113);
        this.poolResetNonTxnStateCheck = JboTesterUtil.createCheckBox(114);
        this.poolDoAMPoolingCheck = JboTesterUtil.createCheckBox(115);
        this.poolIsUseExclusiveCheck = JboTesterUtil.createCheckBox(116);
        this.mResetButton = JboTesterUtil.createButton(58);
        this.mApplyButton = JboTesterUtil.createButton(57);
        this.mController = null;
        this.mIsStandalone = false;
    }

    public PoolParameterPanel(Frame frame, Controller controller) {
        this.$init$();
        this.mParentFrame = frame;
        this.mController = controller;
        this.mParams = (Hashtable)this.mController.getApplicationPool(true).getEnvironment().clone();
        this.mIsStandalone = true;
        this.init();
    }

    public PoolParameterPanel(Frame frame, Hashtable hashtable) {
        this.$init$();
        this.mParentFrame = frame;
        this.mParams = hashtable;
        this.init();
    }

    void setPoolParameters(Hashtable hashtable) {
        this.mParams = hashtable;
        this.updatePanelUI();
    }

    private final void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JPanel jPanel = this.buildCapacityPanel();
        String string = Res.getString(87);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(5, 5, 0, 5)));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        jPanel = this.buildConnCapacityPanel();
        string = Res.getString(86);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(5, 5, 0, 5)));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        JPanel jPanel2 = this.buildFailoverPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel3 = this.buildButtonsBar();
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.add(jPanel3);
        this.updatePanelUI();
    }

    private JPanel buildButtonsBar() {
        int n = 0;
        ArrayList arrayList = new ArrayList();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        arrayList.add((Object)this.mResetButton);
        n = Math.max(n, this.mResetButton.getMinimumSize().width);
        this.mResetButton.addActionListener(new 4());
        if (this.mIsStandalone) {
            arrayList.add((Object)this.mApplyButton);
            n = Math.max(n, this.mApplyButton.getMinimumSize().width);
            this.mApplyButton.setEnabled(true);
            this.mApplyButton.setDefaultCapable(true);
            this.mApplyButton.addActionListener(new 3());
        }
        Dimension dimension = new Dimension(n, this.mApplyButton.getMinimumSize().height);
        Dimension dimension2 = new Dimension(8, 0);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            JButton jButton = (JButton)arrayList.get(n2);
            jButton.setPreferredSize(dimension);
            if (n2 == 0) {
                jPanel.add(Box.createHorizontalGlue());
                jPanel.add(jButton);
                jPanel.add(Box.createRigidArea(dimension2));
            } else {
                jPanel.add(jButton);
                jPanel.add(Box.createRigidArea(dimension2));
            }
            ++n2;
        }
        return jPanel;
    }

    private void apply() {
        if (this.validateAndUpdateScalabilityParams(true)) {
            Hashtable hashtable = this.mController.getApplicationPool(true).getEnvironment();
            int n = 0;
            while (n < POOL_PARAMETER_METADATA.length) {
                String string = POOL_PARAMETER_METADATA[n].getName();
                Object v = this.mParams.get(string);
                if (v != null) {
                    hashtable.put(string, v);
                } else {
                    hashtable.remove(string);
                }
                ++n;
            }
        }
    }

    final void resetPanelUI() {
        int n = Integer.valueOf(PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE.getDefault());
        n = n < 0 ? 0 : n;
        this.poolInitSizeSpin.setIntValue(n < 5000 ? n : 5000);
        int n2 = Integer.valueOf(PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE.getDefault());
        n2 = n2 < 0 ? 0 : n2;
        this.poolMaxSizeSpin.setIntValue(n2 < 5000 ? n2 : 5000);
        int n3 = Integer.valueOf(PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD.getDefault());
        n3 = n3 < 0 ? 0 : n3;
        this.poolRefSizeSpin.setIntValue(n3 < 5000 ? n3 : 5000);
        int n4 = Integer.valueOf(PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE.getDefault());
        n4 = n4 < 0 ? 0 : n4;
        this.poolMinAvailSizeSpin.setIntValue(n4 < 5000 ? n4 : 5000);
        int n5 = Integer.valueOf(PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE.getDefault());
        n5 = n5 < 0 ? 0 : n5;
        this.poolMaxAvailSizeSpin.setIntValue(n5 < 5000 ? n5 : 5000);
        int n6 = Integer.parseInt(PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE.getDefault()) / 1000;
        n6 = n6 < 0 ? 0 : n6;
        this.poolMaxInactiveAgeSpin.setIntValue(n6 < 5000 ? n6 : 5000);
        int n7 = Integer.parseInt(PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL.getDefault()) / 1000;
        n7 = n7 < 0 ? 0 : n7;
        this.poolMonitorSleepIntervalSpin.setIntValue(n7 < 5000 ? n7 : 5000);
        int n8 = Integer.valueOf(PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE.getDefault());
        n8 = n8 < 0 ? 0 : n8;
        this.connPoolInitSizeSpin.setIntValue(n8 < 5000 ? n8 : 5000);
        int n9 = Integer.valueOf(PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE.getDefault());
        n9 = n9 < 0 ? 0 : n9;
        this.connPoolMaxSizeSpin.setIntValue(n9 < 5000 ? n9 : 5000);
        int n10 = Integer.valueOf(PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE.getDefault());
        n10 = n10 < 0 ? 0 : n10;
        this.connPoolMinAvailSizeSpin.setIntValue(n10 < 5000 ? n10 : 5000);
        int n11 = Integer.valueOf(PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE.getDefault());
        n11 = n11 < 0 ? 0 : n11;
        this.connPoolMaxAvailSizeSpin.setIntValue(n11 < 5000 ? n11 : 5000);
        n6 = Integer.parseInt(PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE.getDefault()) / 1000;
        n6 = n6 < 0 ? 0 : n6;
        this.connPoolMaxInactiveAgeSpin.setIntValue(n6 < 5000 ? n6 : 5000);
        n7 = Integer.parseInt(PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL.getDefault()) / 1000;
        n7 = n7 < 0 ? 0 : n7;
        this.connPoolMonitorSleepIntervalSpin.setIntValue(n7 < 5000 ? n7 : 5000);
        this.poolDoFailoverCheck.setSelected(TRUE.equals(PropertyMetadata.ENV_DO_FAILOVER.getDefault()));
        this.poolDoConnectionPoolingCheck.setSelected(TRUE.equals(PropertyMetadata.ENV_DO_CONNECTION_POOLING.getDefault()));
        this.poolDynamicJdbcCredentialsCheck.setSelected(TRUE.equals(PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS.getDefault()));
        this.poolResetNonTxnStateCheck.setSelected(TRUE.equals(PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE.getDefault()));
        this.poolDoAMPoolingCheck.setSelected(TRUE.equals(PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING.getDefault()));
        this.setAMPoolingEnabled(this.poolDoAMPoolingCheck.getModel().isSelected());
        this.poolIsUseExclusiveCheck.setSelected(TRUE.equals(PropertyMetadata.ENV_AMPOOL_IS_USE_EXCLUSIVE.getDefault()));
        this.setUseExclusive(this.poolIsUseExclusiveCheck.getModel().isSelected());
    }

    private final JPanel buildFailoverPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.poolDoFailoverCheck.setToolTipText(Res.getString(123) + " " + PropertyMetadata.ENV_DO_FAILOVER.getName());
        gridBagLayout.setConstraints(this.poolDoFailoverCheck, gridBagConstraints);
        jPanel.add(this.poolDoFailoverCheck);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.poolDoConnectionPoolingCheck.setToolTipText(Res.getString(123) + " " + PropertyMetadata.ENV_DO_CONNECTION_POOLING.getName());
        gridBagLayout.setConstraints(this.poolDoConnectionPoolingCheck, gridBagConstraints);
        jPanel.add(this.poolDoConnectionPoolingCheck);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.poolDynamicJdbcCredentialsCheck.setToolTipText(Res.getString(123) + " " + PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS.getName());
        gridBagLayout.setConstraints(this.poolDynamicJdbcCredentialsCheck, gridBagConstraints);
        jPanel.add(this.poolDynamicJdbcCredentialsCheck);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.poolResetNonTxnStateCheck.setToolTipText(Res.getString(123) + " " + PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE.getName());
        gridBagLayout.setConstraints(this.poolResetNonTxnStateCheck, gridBagConstraints);
        jPanel.add(this.poolResetNonTxnStateCheck);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.poolIsUseExclusiveCheck.setToolTipText(Res.getString(123) + " " + PropertyMetadata.ENV_AMPOOL_IS_USE_EXCLUSIVE.getName());
        this.poolIsUseExclusiveCheck.addActionListener(new 2());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.poolDoAMPoolingCheck.setToolTipText(Res.getString(123) + " " + PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING.getName());
        this.poolDoAMPoolingCheck.addActionListener(new 1());
        gridBagLayout.setConstraints(this.poolDoAMPoolingCheck, gridBagConstraints);
        jPanel.add(this.poolDoAMPoolingCheck);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        return jPanel;
    }

    final void setAMPoolingEnabled(boolean bl) {
        if (!bl) {
            this.poolIsUseExclusiveCheck.setSelected(true);
        }
        this.poolIsUseExclusiveCheck.setEnabled(bl);
    }

    final void setUseExclusive(boolean bl) {
        if (!bl) {
            this.poolDoFailoverCheck.setSelected(false);
            this.poolDoConnectionPoolingCheck.setSelected(false);
            this.poolDynamicJdbcCredentialsCheck.setSelected(false);
            this.poolResetNonTxnStateCheck.setSelected(false);
        }
        this.poolDoFailoverCheck.setEnabled(bl);
        this.poolDoConnectionPoolingCheck.setEnabled(bl);
        this.poolDynamicJdbcCredentialsCheck.setEnabled(bl);
        this.poolResetNonTxnStateCheck.setEnabled(bl);
    }

    final void setConnCapacitiesEditable(boolean bl) {
        int n = 0;
        while (n < this.connCapacitySpins.length) {
            this.connCapacitySpins[n].setEnabled(bl);
            ++n;
        }
    }

    private final void buildCapacityRow(JPanel jPanel, GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout, int n, PropertyMetadata propertyMetadata, NumericSpinBox numericSpinBox) {
        JLabel jLabel = JboTesterUtil.createLabel(n, (Component)numericSpinBox);
        jLabel.setToolTipText(Res.getString(123) + " " + propertyMetadata.getName());
        jPanel.setAlignmentY(0.0f);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.anchor = 18;
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        SpinBuddy spinBuddy = numericSpinBox.getSpinBuddy();
        if (spinBuddy instanceof JTextField) {
            ((JTextField)spinBuddy).setHorizontalAlignment(4);
        }
        gridBagLayout.setConstraints((Component)numericSpinBox, gridBagConstraints);
        jPanel.add((Component)numericSpinBox);
        ++gridBagConstraints.gridy;
    }

    private final JPanel buildCapacityPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 104, PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE, this.poolInitSizeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 105, PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE, this.poolMaxSizeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 106, PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD, this.poolRefSizeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 107, PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE, this.poolMinAvailSizeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 108, PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE, this.poolMaxAvailSizeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 109, PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE, this.poolMaxInactiveAgeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 110, PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL, this.poolMonitorSleepIntervalSpin);
        return jPanel;
    }

    private final JPanel buildConnCapacityPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 104, PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE, this.connPoolInitSizeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 105, PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE, this.connPoolMaxSizeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 107, PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE, this.connPoolMinAvailSizeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 108, PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE, this.connPoolMaxAvailSizeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 109, PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE, this.connPoolMaxInactiveAgeSpin);
        this.buildCapacityRow(jPanel, gridBagConstraints, gridBagLayout, 110, PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL, this.connPoolMonitorSleepIntervalSpin);
        JLabel jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        return jPanel;
    }

    final boolean validateAndUpdateScalabilityParams(boolean bl) {
        return this.validateAndUpdateScalabilityParams(this.mParams, bl);
    }

    final boolean validateAndUpdateScalabilityParams(Hashtable hashtable, boolean bl) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = this.poolInitSizeSpin.getIntValue();
            if (n8 == 5000) {
                n8 = Integer.MAX_VALUE;
            }
            if ((n7 = this.poolMaxSizeSpin.getIntValue()) == 5000) {
                n7 = Integer.MAX_VALUE;
            }
            if ((n6 = this.poolRefSizeSpin.getIntValue()) == 5000) {
                n6 = Integer.MAX_VALUE;
            }
            if ((n5 = this.poolMinAvailSizeSpin.getIntValue()) == 5000) {
                n5 = Integer.MAX_VALUE;
            }
            if ((n4 = this.poolMaxAvailSizeSpin.getIntValue()) == 5000) {
                n4 = Integer.MAX_VALUE;
            }
            String string = null;
            int n9 = this.poolMaxInactiveAgeSpin.getIntValue();
            string = n9 > 2147483 ? String.valueOf(Integer.MAX_VALUE) : String.valueOf(n9 * 1000);
            String string2 = null;
            int n10 = this.poolMonitorSleepIntervalSpin.getIntValue();
            string2 = n10 > 2147483 ? String.valueOf(Integer.MAX_VALUE) : String.valueOf(n10 * 1000);
            int n11 = this.connPoolInitSizeSpin.getIntValue();
            if (n11 == 5000) {
                n11 = Integer.MAX_VALUE;
            }
            if ((n3 = this.connPoolMaxSizeSpin.getIntValue()) == 5000) {
                n3 = Integer.MAX_VALUE;
            }
            if ((n2 = this.connPoolMinAvailSizeSpin.getIntValue()) == 5000) {
                n2 = Integer.MAX_VALUE;
            }
            if ((n = this.connPoolMaxAvailSizeSpin.getIntValue()) == 5000) {
                n = Integer.MAX_VALUE;
            }
            String string3 = null;
            n9 = this.connPoolMaxInactiveAgeSpin.getIntValue();
            string3 = n9 > 2147483 ? String.valueOf(Integer.MAX_VALUE) : String.valueOf(n9 * 1000);
            String string4 = null;
            n10 = this.connPoolMonitorSleepIntervalSpin.getIntValue();
            string4 = n10 > 2147483 ? String.valueOf(Integer.MAX_VALUE) : String.valueOf(n10 * 1000);
            String string5 = this.poolDoFailoverCheck.isSelected() ? TRUE : FALSE;
            String string6 = this.poolDoConnectionPoolingCheck.isSelected() ? TRUE : FALSE;
            String string7 = this.poolDynamicJdbcCredentialsCheck.isSelected() ? TRUE : FALSE;
            String string8 = this.poolResetNonTxnStateCheck.isSelected() ? TRUE : FALSE;
            String string9 = this.poolDoAMPoolingCheck.isSelected() ? TRUE : FALSE;
            String string10 = this.poolIsUseExclusiveCheck.isSelected() ? TRUE : FALSE;
            this.updateScalabilityParam(PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE.getName(), String.valueOf(n8), PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE.getName(), String.valueOf(n7), PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD.getName(), String.valueOf(n6), PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE.getName(), String.valueOf(n5), PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE.getName(), String.valueOf(n4), PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE.getName(), string, PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL.getName(), string2, PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE.getName(), String.valueOf(n11), PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE.getName(), String.valueOf(n3), PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE.getName(), String.valueOf(n2), PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE.getName(), String.valueOf(n), PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE.getName(), string3, PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL.getName(), string4, PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_DO_FAILOVER.getName(), string5, PropertyMetadata.ENV_DO_FAILOVER.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_DO_CONNECTION_POOLING.getName(), string6, PropertyMetadata.ENV_DO_CONNECTION_POOLING.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS.getName(), string7, PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE.getName(), string8, PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING.getName(), string9, PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING.getDefault(), hashtable);
            this.updateScalabilityParam(PropertyMetadata.ENV_AMPOOL_IS_USE_EXCLUSIVE.getName(), string10, PropertyMetadata.ENV_AMPOOL_IS_USE_EXCLUSIVE.getDefault(), hashtable);
        }
        catch (Exception exception) {
            if (bl) {
                ErrorHandler.displayError(this.mParentFrame, exception);
            }
            boolean bl2 = false;
            return bl2;
        }
        return true;
    }

    private void updateScalabilityParam(String string, String string2, String string3, Hashtable hashtable) {
        if (!string3.equals(string2)) {
            hashtable.put(string, string2);
        } else {
            hashtable.remove(string);
        }
    }

    final void updatePanelUI() {
        String string = (String)this.mParams.get(PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE.getName());
        String string2 = (String)this.mParams.get(PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE.getName());
        String string3 = (String)this.mParams.get(PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD.getName());
        String string4 = (String)this.mParams.get(PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE.getName());
        String string5 = (String)this.mParams.get(PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE.getName());
        String string6 = (String)this.mParams.get(PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE.getName());
        String string7 = (String)this.mParams.get(PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL.getName());
        String string8 = (String)this.mParams.get(PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE.getName());
        String string9 = (String)this.mParams.get(PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE.getName());
        String string10 = (String)this.mParams.get(PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE.getName());
        String string11 = (String)this.mParams.get(PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE.getName());
        String string12 = (String)this.mParams.get(PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE.getName());
        String string13 = (String)this.mParams.get(PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL.getName());
        String string14 = (String)this.mParams.get(PropertyMetadata.ENV_DO_FAILOVER.getName());
        String string15 = (String)this.mParams.get(PropertyMetadata.ENV_DO_CONNECTION_POOLING.getName());
        String string16 = (String)this.mParams.get(PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS.getName());
        String string17 = (String)this.mParams.get(PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE.getName());
        String string18 = (String)this.mParams.get(PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING.getName());
        String string19 = (String)this.mParams.get(PropertyMetadata.ENV_AMPOOL_IS_USE_EXCLUSIVE.getName());
        int n = string == null ? Integer.valueOf(PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE.getDefault()).intValue() : Integer.valueOf(string).intValue();
        this.poolInitSizeSpin.setIntValue(n < 5000 ? n : 5000);
        int n2 = string2 == null ? Integer.valueOf(PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE.getDefault()).intValue() : Integer.valueOf(string2).intValue();
        this.poolMaxSizeSpin.setIntValue(n2 < 5000 ? n2 : 5000);
        int n3 = string3 == null ? Integer.valueOf(PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD.getDefault()).intValue() : Integer.valueOf(string3).intValue();
        this.poolRefSizeSpin.setIntValue(n3 < 5000 ? n3 : 5000);
        int n4 = string4 == null ? Integer.valueOf(PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE.getDefault()).intValue() : Integer.valueOf(string4).intValue();
        this.poolMinAvailSizeSpin.setIntValue(n4 < 5000 ? n4 : 5000);
        int n5 = string5 == null ? Integer.valueOf(PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE.getDefault()).intValue() : Integer.valueOf(string5).intValue();
        this.poolMaxAvailSizeSpin.setIntValue(n5 < 5000 ? n5 : 5000);
        int n6 = Integer.parseInt(string6 == null ? PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE.getDefault() : string6);
        this.poolMaxInactiveAgeSpin.setIntValue(n6 / 1000);
        int n7 = Integer.parseInt(string7 == null ? PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL.getDefault() : string7);
        this.poolMonitorSleepIntervalSpin.setIntValue(n7 / 1000);
        int n8 = string8 == null ? Integer.valueOf(PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE.getDefault()).intValue() : Integer.valueOf(string8).intValue();
        this.connPoolInitSizeSpin.setIntValue(n8 < 5000 ? n8 : 5000);
        int n9 = string9 == null ? Integer.valueOf(PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE.getDefault()).intValue() : Integer.valueOf(string9).intValue();
        this.connPoolMaxSizeSpin.setIntValue(n9 < 5000 ? n9 : 5000);
        int n10 = string10 == null ? Integer.valueOf(PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE.getDefault()).intValue() : Integer.valueOf(string10).intValue();
        this.connPoolMinAvailSizeSpin.setIntValue(n10 < 5000 ? n10 : 5000);
        int n11 = string11 == null ? Integer.valueOf(PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE.getDefault()).intValue() : Integer.valueOf(string11).intValue();
        this.connPoolMaxAvailSizeSpin.setIntValue(n11 < 5000 ? n11 : 5000);
        int n12 = Integer.parseInt(string12 == null ? PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE.getDefault() : string12);
        this.connPoolMaxInactiveAgeSpin.setIntValue(n12 / 1000);
        int n13 = Integer.parseInt(string13 == null ? PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL.getDefault() : string13);
        this.connPoolMonitorSleepIntervalSpin.setIntValue(n13 / 1000);
        this.poolDoFailoverCheck.setSelected(string14 == null ? TRUE.equals(PropertyMetadata.ENV_DO_FAILOVER.getDefault()) : TRUE.equals(string14));
        this.poolDoConnectionPoolingCheck.setSelected(string15 == null ? TRUE.equals(PropertyMetadata.ENV_DO_CONNECTION_POOLING.getDefault()) : TRUE.equals(string15));
        this.poolDynamicJdbcCredentialsCheck.setSelected(string16 == null ? TRUE.equals(PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS.getDefault()) : TRUE.equals(string16));
        this.poolResetNonTxnStateCheck.setSelected(string17 == null ? TRUE.equals(PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE.getDefault()) : TRUE.equals(string17));
        this.poolDoAMPoolingCheck.setSelected(string18 == null ? TRUE.equals(PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING.getDefault()) : TRUE.equals(string18));
        this.setAMPoolingEnabled(this.poolDoAMPoolingCheck.getModel().isSelected());
        this.poolIsUseExclusiveCheck.setSelected(string19 == null ? TRUE.equals(PropertyMetadata.ENV_AMPOOL_IS_USE_EXCLUSIVE.getDefault()) : TRUE.equals(string19));
        this.setUseExclusive(this.poolIsUseExclusiveCheck.getModel().isSelected());
        this.setConnCapacitiesEditable(this.useDataSource() ^ true);
    }

    private final boolean useDataSource() {
        return this.mParams.get("JDBCDataSource") != null;
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PoolParameterPanel.this.resetPanelUI();
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PoolParameterPanel.this.apply();
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PoolParameterPanel.this.setUseExclusive(((JCheckBox)actionEvent.getSource()).getModel().isSelected());
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PoolParameterPanel.this.setAMPoolingEnabled(((JCheckBox)actionEvent.getSource()).getModel().isSelected());
        }
    }
}

