/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.ViewObject;
import oracle.jbo.jbotester.AbstractJboAction;
import oracle.jbo.jbotester.JBOControl;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MDForm;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.ObjTreeNode;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.ResultWindow;
import oracle.jbo.jbotester.SimpleForm;

public final class NavBar
extends JToolBar
implements ChangeListener,
JBOControl {
    public static final int BIND_PARAMETERS = 13;
    public static final Border buttonBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final int CLOSE = 15;
    public static final int COMMIT = 8;
    public static final int CONNECT = 10;
    public static final int DELETE = 5;
    public static final int DISCONNECT = 11;
    public static final int FIND = 12;
    public static final int FIRST = 0;
    public static final Border focusBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK);
    public static final String[][] images = new String[][]{{"firstrec.gif", "firstrecd.gif"}, {"prevrec.gif", "prevrecd.gif"}, {"nextrec.gif", "nextrecd.gif"}, {"lastrec.gif", "lastrecd.gif"}, {"addnew.gif", "addnewd.gif"}, {"deleterec.gif", "deleterecd.gif"}, {"nextpage.gif", "nextpaged.gif"}, {"prevpage.gif", "prevpaged.gif"}, {"save.gif", "saved.gif"}, {"rollback.gif", "rollbackd.gif"}, {"gologin.gif", "gologind.gif"}, {"gologout.gif", "gologoutd.gif"}, {"query.gif", "queryd.gif"}, {"bindvar.gif", "bindvard.gif"}, {"sepwin.gif", "sepwin.gif"}, {"close.gif", "close.gif"}, {"validaterow.gif", "validaterowd.gif"}};
    public static final int INSERT = 4;
    public static final int LAST = 3;
    public static final int NEXT = 2;
    public static final int NEXT_PAGE = 6;
    public static final int NUM_BUTTONS = 17;
    public static final int PREV_PAGE = 7;
    public static final int PREVIOUS = 1;
    public static final int ROLLBACK = 9;
    public static final int SEPARATE_WIN = 14;
    public static final int VALIDATE = 16;
    private static final FocusListener focusListener = new 1();
    private RowSetIterator iter;
    private Action[] mActions;
    private final MainFrame mainFrame;
    private JPanel mParent;
    private ResultWindow window;
    private boolean windowButtonRemoved;

    public static void initButton(JButton jButton, char c, int n) {
        jButton.setText("");
        jButton.setMnemonic(c);
        jButton.setBorderPainted(true);
        jButton.setBorder(buttonBorder);
        jButton.setDisabledIcon(JboTesterUtil.getIcon(images[n][1]));
        jButton.addFocusListener(focusListener);
    }

    private /* synthetic */ void $init$() {
        this.mActions = new Action[18];
        this.windowButtonRemoved = false;
    }

    public NavBar(MainFrame mainFrame) {
        this(mainFrame, false, 0);
    }

    public NavBar(MainFrame mainFrame, boolean bl) {
        this(mainFrame, bl, 0);
    }

    public NavBar(MainFrame mainFrame, boolean bl, int n) {
        super(mainFrame.getTitle(), n);
        this.$init$();
        this.mainFrame = mainFrame;
        this.add(new rsFirst(), 32, 0);
        this.add(new rsPrevPage(), 34, 7);
        this.add(new rsPrev(), 36, 1);
        this.add(new rsNext(), 38, 2);
        this.add(new rsNextPage(), 40, 6);
        this.add(new rsLast(), 42, 3);
        this.addSeparator();
        this.add(new rsInsert(), 44, 4);
        this.add(new rsDelete(), 46, 5);
        this.addSeparator();
        this.add(new rsFind(), 48, 12);
        this.add(new rsBindParameters(), 50, 13);
        this.add(new rsValidate(), 56, 16);
        if (!bl) {
            this.addWindowButtons();
        }
    }

    public RowSetIterator getIterator() {
        return this.iter;
    }

    public JPanel getMyParent() {
        if (this.mParent == null) {
            return (JPanel)this.getParent();
        }
        return this.mParent;
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.resetButtons();
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        RangeRefreshHandler rangeRefreshHandler = new RangeRefreshHandler();
        rangeRefreshHandler.event = rangeRefreshEvent;
        rangeRefreshHandler.navBar = this;
        SwingUtilities.invokeLater(rangeRefreshHandler);
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
        this.resetButtons();
    }

    public void rowInserted(InsertEvent insertEvent) {
        this.resetButtons();
    }

    public void rowUpdated(UpdateEvent updateEvent) {
    }

    public synchronized void setIterator(RowSetIterator rowSetIterator) {
        if (this.iter == rowSetIterator) {
            return;
        }
        if (this.iter != null) {
            this.iter.removeListener((Object)this);
        }
        this.iter = rowSetIterator;
        if (this.iter != null) {
            this.iter.addListener((Object)this);
            ViewObject viewObject = this.iter.getRowSet().getViewObject();
            if (viewObject.isReadOnly()) {
                this.mActions[4].setEnabled(false);
                this.mActions[5].setEnabled(false);
            }
            this.mActions[13].setEnabled(JboTesterUtil.hasBindParameters(viewObject));
            this.resetButtons();
        }
    }

    public void setMyParent(JPanel jPanel) {
        this.mParent = jPanel;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.windowButtonRemoved && this.window.isDocking() && ((ResultWindow)changeEvent.getSource()).getSelectedTab() == this.getParent()) {
            this.window.removeChangeListener(this);
            this.window = null;
            this.windowButtonRemoved = false;
            this.addWindowButton();
        }
    }

    private void addWindowButton() {
        int n = this.getComponentCount() - 1;
        while (n > 0) {
            Component component = this.getComponent(n);
            if (component instanceof JButton && ((JButton)component).getAction() == this.mActions[16]) break;
            this.remove(component);
            --n;
        }
        this.addWindowButtons();
    }

    private void addWindowButtons() {
        this.addSeparator();
        this.add(new rsWin(this), 52, 14);
        this.add(new rsClose(this), 54, 15);
        this.addSeparator();
    }

    private void removeWindowButton(ResultWindow resultWindow) {
        int n = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            if (component instanceof JButton && ((JButton)component).getAction() == this.mActions[14]) {
                this.remove(component);
                break;
            }
            ++n;
        }
        this.windowButtonRemoved = true;
        this.window = resultWindow;
        resultWindow.addChangeListener(this);
    }

    void add(Action action, int n, int n2) {
        JButton jButton = super.add(action);
        NavBar.initButton(jButton, Res.getString(n).charAt(0), n2);
        this.mActions[n2] = action;
    }

    void cancelCellEditing() {
        TableCellEditor tableCellEditor;
        if (this.mParent instanceof MDForm && (tableCellEditor = ((MDForm)this.mParent).detailTable.getCellEditor()) != null) {
            tableCellEditor.cancelCellEditing();
        }
    }

    void resetButtons() {
        if (this.iter == null) {
            return;
        }
        boolean bl = this.iter.hasNext();
        this.mActions[2].setEnabled(bl);
        this.mActions[6].setEnabled(bl);
        this.mActions[3].setEnabled(bl);
        bl = this.iter.hasPrevious();
        this.mActions[1].setEnabled(bl);
        this.mActions[7].setEnabled(bl);
        this.mActions[0].setEnabled(bl);
        bl = !this.iter.getRowSet().getViewObject().isReadOnly() && this.iter.getCurrentRowSlot() == 0;
        this.mActions[5].setEnabled(bl);
        this.mActions[16].setEnabled(bl);
    }

    boolean stopCellEditing() {
        TableCellEditor tableCellEditor;
        if (this.mParent instanceof MDForm && (tableCellEditor = ((MDForm)this.mParent).detailTable.getCellEditor()) != null) {
            return tableCellEditor.stopCellEditing();
        }
        return true;
    }

    private final class RangeRefreshHandler
    implements Runnable {
        RangeRefreshEvent event;
        NavBar navBar;

        public void run() {
            if (this.navBar.iter.getCurrentRowSlot() != 0 && this.event.getRowCountInRange() > 0) {
                this.navBar.iter.first();
            } else {
                this.navBar.resetButtons();
            }
        }

        private RangeRefreshHandler() {
        }
    }

    private final class rsBindParameters
    extends AbstractNavAction {
        public rsBindParameters() {
            super("bindParameters", 13, 49);
        }

        protected void doAction(ActionEvent actionEvent) {
            NavBar.this.cancelCellEditing();
            JboTesterUtil.editBindParameters(NavBar.this.mainFrame, NavBar.this.iter.getRowSet().getViewObject());
        }
    }

    private final class rsClose
    extends AbstractNavAction {
        private NavBar navBar;

        public rsClose(NavBar navBar2) {
            super("close", 15, 53);
            this.navBar = navBar2;
        }

        protected void doAction(ActionEvent actionEvent) {
            SimpleForm simpleForm = (SimpleForm)NavBar.this.getMyParent();
            ObjTreeNode objTreeNode = simpleForm.getTreeNode();
            if (objTreeNode != null) {
                ResultWindow.getResultWindow().removeTab(objTreeNode.getFullName());
            }
            if (!this.navBar.getParent().equals(simpleForm)) {
                this.navBar.getRootPane().getParent().setVisible(false);
            }
        }
    }

    private final class rsDelete
    extends AbstractNavAction {
        public rsDelete() {
            super("delete", 5, 45);
        }

        protected void doAction(ActionEvent actionEvent) {
            NavBar.this.cancelCellEditing();
            NavBar.this.iter.removeCurrentRow();
        }
    }

    private final class rsFind
    extends AbstractNavAction {
        public rsFind() {
            super("find", 12, 47);
        }

        protected void doAction(ActionEvent actionEvent) {
            NavBar.this.cancelCellEditing();
            JboTesterUtil.createViewCriteria(NavBar.this.mainFrame, NavBar.this.iter.getRowSet().getViewObject());
        }
    }

    private final class rsFirst
    extends AbstractNavAction {
        public rsFirst() {
            super("first", 0, 31);
        }

        protected void doAction(ActionEvent actionEvent) {
            if (NavBar.this.stopCellEditing()) {
                NavBar.this.iter.first();
            }
        }
    }

    private final class rsInsert
    extends AbstractNavAction {
        public rsInsert() {
            super("insert", 4, 43);
        }

        protected void doAction(ActionEvent actionEvent) {
            Row row;
            if (NavBar.this.stopCellEditing() && (row = NavBar.this.iter.createRow()) != null) {
                NavBar.this.iter.insertRow(row);
            }
        }
    }

    private final class rsLast
    extends AbstractNavAction {
        public rsLast() {
            super("last", 3, 41);
        }

        protected void doAction(ActionEvent actionEvent) {
            if (NavBar.this.stopCellEditing()) {
                NavBar.this.iter.last();
            }
        }
    }

    private final class rsNext
    extends AbstractNavAction {
        public rsNext() {
            super("next", 2, 37);
        }

        protected void doAction(ActionEvent actionEvent) {
            if (NavBar.this.stopCellEditing()) {
                NavBar.this.iter.next();
            }
        }
    }

    private final class rsNextPage
    extends AbstractNavAction {
        public rsNextPage() {
            super("nextpage", 6, 39);
        }

        protected void doAction(ActionEvent actionEvent) {
            int n = NavBar.this.iter.scrollRange(NavBar.this.iter.getRangeSize());
            if (n > 0 && NavBar.this.stopCellEditing()) {
                NavBar.this.iter.setCurrentRowAtRangeIndex(0);
            }
        }
    }

    private final class rsPrev
    extends AbstractNavAction {
        public rsPrev() {
            super("prev", 1, 35);
        }

        protected void doAction(ActionEvent actionEvent) {
            if (NavBar.this.stopCellEditing()) {
                NavBar.this.iter.previous();
            }
        }
    }

    private final class rsPrevPage
    extends AbstractNavAction {
        public rsPrevPage() {
            super("prevpage", 7, 33);
        }

        protected void doAction(ActionEvent actionEvent) {
            int n = NavBar.this.iter.scrollRange(-NavBar.this.iter.getRangeSize());
            if (n < 0 && NavBar.this.stopCellEditing()) {
                NavBar.this.iter.setCurrentRowAtRangeIndex(0);
            }
        }
    }

    private final class rsValidate
    extends AbstractNavAction {
        public rsValidate() {
            super("validate", 16, 55);
        }

        protected void doAction(ActionEvent actionEvent) {
            if (NavBar.this.stopCellEditing()) {
                NavBar.this.iter.getCurrentRow().validate();
            }
        }
    }

    private final class rsWin
    extends AbstractNavAction {
        private NavBar navBar;

        public rsWin(NavBar navBar2) {
            super("window", 14, 51);
            this.navBar = navBar2;
        }

        protected void doAction(ActionEvent actionEvent) {
            ResultWindow resultWindow = ResultWindow.getResultWindow();
            JPanel jPanel = (JPanel)((JButton)actionEvent.getSource()).getParent().getParent();
            JPanel jPanel2 = this.navBar.getMyParent();
            if (jPanel instanceof SimpleForm) {
                resultWindow.displayInWindow(jPanel2);
            } else {
                resultWindow.addToWindow(jPanel, jPanel2);
            }
            this.navBar.removeWindowButton(resultWindow);
        }
    }

    public abstract class AbstractNavAction
    extends AbstractJboAction {
        public AbstractNavAction(String string) {
            super(string);
        }

        public AbstractNavAction(String string, int n, int n2) {
            super(string, n, n2);
        }

        protected MainFrame getMainFrame() {
            return NavBar.this.mainFrame;
        }
    }

    public static final class 1
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            JButton jButton = (JButton)focusEvent.getSource();
            jButton.setBorder(focusBorder);
        }

        public void focusLost(FocusEvent focusEvent) {
            JButton jButton = (JButton)focusEvent.getSource();
            jButton.setBorder(buttonBorder);
        }
    }
}

