/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.Session;
import oracle.jbo.Version;
import oracle.jbo.ViewObject;
import oracle.jbo.client.Configuration;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.jbotester.AbstractJboAction;
import oracle.jbo.jbotester.BaseTree;
import oracle.jbo.jbotester.ConnectionInfo;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.GenericDialog;
import oracle.jbo.jbotester.HelpManager;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MainFrame_AboutBoxPanel1;
import oracle.jbo.jbotester.NavBar;
import oracle.jbo.jbotester.ObjTreeNode;
import oracle.jbo.jbotester.OutputDialog;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.ResultWindow;
import oracle.jbo.jbotester.SimpleForm;

public final class MainFrame
extends JFrame {
    private static MainFrame frame;
    private static ByteArrayOutputStream sysOut;
    private static String helpUrlStr;
    private static HelpManager helpMan;
    private static boolean AMenabled;
    private static boolean VOenabled;
    private static boolean VLenabled;
    private static boolean createMenuInitialized;
    private boolean noConnectionDialog;
    private JMenuItem menuViewOutput;
    private JMenuItem menuViewDataXML;
    private JMenuItem menuCreateAM;
    private JMenuItem menuCreateVO;
    private JMenuItem menuCreateVL;
    private JComponent statusBar;
    private JLabel statusLine;
    private JToolBar mToolBar;
    private final JSplitPane mSplitPane;
    private BaseTree mObjectTree;
    private ResultWindow mResultPanel;
    private Window mPopup;
    private final Action connectAction;
    private final Action disconnectAction;
    private final Action commitAction;
    private final Action rollbackAction;
    private final Action exitAction;
    private final Action saveAmAction;
    private final Action loadAmAction;
    private final Action helpContentAction;
    private Hashtable mConnectionParams;
    private Configuration mConfiguration;
    private String mConfigurationName;
    private static /* synthetic */ Class class$java$awt$Frame;
    private static /* synthetic */ Class class$java$util$Hashtable;
    private static /* synthetic */ Class class$javax$swing$JFrame;

    static {
        AMenabled = false;
        VOenabled = false;
        VLenabled = false;
        createMenuInitialized = false;
        try {
            if (UIManager.getSystemLookAndFeelClassName().toLowerCase().indexOf(".windows.") > 0) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            Diagnostic.println((String)"Cannot set windows look and feel");
        }
    }

    private /* synthetic */ void $init$() {
        this.mSplitPane = new JSplitPane();
        this.connectAction = new FileConnectAction();
        this.disconnectAction = new FileDisconnectAction();
        this.commitAction = new CommitAction();
        this.rollbackAction = new RollbackAction();
        this.exitAction = new FileExitAction();
        this.saveAmAction = new FileSaveAction();
        this.loadAmAction = new FileLoadAction();
        this.helpContentAction = new HelpContentAction();
    }

    public MainFrame(Hashtable hashtable) {
        this();
        this.setConnectionParams(hashtable);
    }

    public MainFrame() {
        this.$init$();
        MainFrame.enableUnitTest(this);
    }

    public static MainFrame getInstance() {
        return frame;
    }

    public BaseTree getBaseTree() {
        return this.mObjectTree;
    }

    public Dimension getPreferredSize() {
        return new Dimension(640, 480);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exit() {
        try {
            try {
                ConnectionInfo.releaseApplicationModule();
            }
            catch (Exception exception) {
                Diagnostic.println((String)"Fail during disconnect.");
                Object var3_2 = null;
                System.out.println("BC4J Tester exit code(0)");
                System.exit(0);
                return;
            }
            Object var3_1 = null;
            System.out.println("BC4J Tester exit code(0)");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            System.out.println("BC4J Tester exit code(0)");
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    public void setConnectionParams(Hashtable hashtable) {
        this.mConnectionParams = hashtable;
        try {
            this.noConnectionDialog = hashtable.get(PropertyMetadata.DEPLOY_PLATFORM.getName()) != null;
            this.mResultPanel = ResultWindow.createResultWindow();
            this.mObjectTree = new BaseTree();
            this.addWindowListener(new 7());
            this.setDefaultCloseOperation(0);
            this.getRootPane().registerKeyboardAction(this.helpContentAction, KeyStroke.getKeyStroke(112, 0), 2);
            this.setJMenuBar(this.createMainMenuBar());
            this.getContentPane().add((Component)this.createMainToolBar(), "North");
            this.getContentPane().add(this.createStatusBar(), "South");
            this.getContentPane().add((Component)this.mSplitPane, "Center");
            this.mSplitPane.setLeftComponent(this.mObjectTree);
            this.mSplitPane.setRightComponent(this.mResultPanel.getTabbedPane());
            this.disconnected();
        }
        catch (Throwable throwable) {
            ErrorHandler.displayError((Frame)this, throwable);
            this.exitAction.actionPerformed(null);
        }
    }

    public Hashtable getConnectionParams() {
        return this.mConnectionParams;
    }

    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public void setConfiguration(Configuration configuration) {
        this.mConfiguration = configuration;
    }

    public String getConfigurationName() {
        return this.mConfigurationName;
    }

    public void setConfigurationName(String string) {
        this.mConfigurationName = string;
    }

    private static void enableUnitTest(MainFrame mainFrame) {
        try {
            Class<?> clazz = Class.forName("oracle.jbo.jbotester.test.Server");
            Class[] classArray = new Class[1];
            Class clazz2 = class$javax$swing$JFrame;
            if (clazz2 == null) {
                clazz2 = class$javax$swing$JFrame = MainFrame.class$("javax.swing.JFrame");
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("run", classArray);
            method.invoke(clazz, mainFrame);
            System.out.println("unittest mode; internal unit testing enabled");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object var3_4 = null;
        }
        catch (Exception exception) {
            Diagnostic.printStackTrace();
        }
    }

    void helpAbout_ActionPerformed(ActionEvent actionEvent) {
        GenericDialog genericDialog = new GenericDialog((Frame)this, Res.format(1, Res.format(0, "")), new MainFrame_AboutBoxPanel1(), 3);
        genericDialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(112, 0), "none");
        genericDialog.show();
    }

    private void viewDataXML_ActionPerformed(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this, Res.getString(5), Res.getString(6), 0, 3);
        if (n == 0) {
            ViewObject viewObject = (ViewObject)this.mObjectTree.getSelectedObject();
            OutputDialog outputDialog = new OutputDialog(this, Res.getString(3), true);
            outputDialog.setText(JboTesterUtil.getDataAsXML(viewObject));
            outputDialog.setLocationRelativeTo(frame);
            outputDialog.setFileName(viewObject.getName().concat(".xml"));
            outputDialog.setFileFilter(new 6());
            outputDialog.pack();
            outputDialog.setVisible(true);
        }
    }

    public void launchConnectDialog() {
        String string;
        String[] stringArray = new String[]{"oracle.jbo.jbotester.jdev.ConnectionDialog", "oracle.jbo.jbotester.jdevx.ConnectionDialog"};
        Class<?> clazz = null;
        if (Version.isUsing32IDE()) {
            string = stringArray[0];
            Diagnostic.println((String)"Loading 3.2 connection dialog");
        } else {
            string = stringArray[1];
            Diagnostic.println((String)"Loading 5.0 connection dialog");
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorHandler.displayError((Frame)this, classNotFoundException);
        }
        try {
            Class clazz2;
            Class[] classArray = new Class[2];
            Class clazz3 = class$java$awt$Frame;
            if (clazz3 == null) {
                clazz3 = classArray[0] = (class$java$awt$Frame = MainFrame.class$("java.awt.Frame"));
            }
            if ((clazz2 = class$java$util$Hashtable) == null) {
                clazz2 = class$java$util$Hashtable = MainFrame.class$("java.util.Hashtable");
            }
            classArray[1] = clazz2;
            Method method = clazz.getMethod("launchConnectDialog", classArray);
            Object[] objectArray = new Object[]{frame, this.getConnectionParams()};
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            ErrorHandler.displayError((Frame)this, exception);
        }
        if (ConnectionInfo.isConnected()) {
            frame.connected();
        }
    }

    public void showTab(String string) {
        this.mResultPanel.showTab(string);
    }

    public static void StartClient(String string, String string2) {
        frame = new MainFrame();
        Configuration configuration = new Configuration();
        Hashtable hashtable = null;
        try {
            configuration.loadFromClassPath(Configuration.buildConfigurationFileNameFromClassPath((String)string));
            hashtable = configuration.getConfiguration(string2);
        }
        catch (Exception exception) {
            ErrorHandler.displayError((Frame)frame, exception);
            System.exit(0);
        }
        frame.setConfiguration(configuration);
        frame.setConfigurationName(string2);
        frame.setConnectionParams(hashtable);
        frame.init();
    }

    public static void main(String[] stringArray) {
        frame = new MainFrame();
        Hashtable hashtable = frame.processArgs(stringArray);
        frame.setConnectionParams(hashtable);
        frame.init();
    }

    private void init() {
        if (this.noConnectionDialog) {
            try {
                if (!this.isAllowedConfiguration4Tester()) {
                    this.exitAction.actionPerformed(null);
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (!ConnectionInfo.useApplicationModule(this, this.getConfiguration(), this.getConfigurationName())) {
                    this.exitAction.actionPerformed(null);
                }
            }
            catch (Throwable throwable) {
                ErrorHandler.displayError((Frame)frame, throwable);
                this.exitAction.actionPerformed(null);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (ConnectionInfo.isConnected()) {
                this.connected();
            }
        } else {
            this.launchConnectDialog();
        }
        this.mSplitPane.resetToPreferredSizes();
        Dimension dimension = this.mSplitPane.getLeftComponent().getPreferredSize();
        this.mSplitPane.setDividerLocation(dimension.width + this.mSplitPane.getDividerSize() / 2 + 1);
        this.pack();
        JboTesterUtil.centerWindow(this);
        this.setVisible(true);
    }

    private boolean isAllowedConfiguration4Tester() {
        Hashtable hashtable = this.getConnectionParams();
        if ("LOCAL".equals((String)hashtable.get("DeployPlatform")) && hashtable.get("JDBCDataSource") != null) {
            ErrorHandler.displayError((Frame)frame, Res.getString(278));
            return false;
        }
        return true;
    }

    private void initializeCreateMenu() {
        Session session = ((ApplicationModule)this.mObjectTree.getSelectedObject()).getSession();
        String[] stringArray = session.getAllApplicationModuleDefNames();
        AMenabled = stringArray != null && stringArray.length > 0;
        String[] stringArray2 = session.getAllViewDefNames();
        VOenabled = stringArray2 != null && stringArray2.length > 0;
        VLenabled = stringArray2 != null && stringArray2.length > 1;
        createMenuInitialized = true;
    }

    public void connected() {
        if (!this.noConnectionDialog) {
            this.connectAction.setEnabled(false);
            this.disconnectAction.setEnabled(true);
        }
        this.saveAmAction.setEnabled(true);
        this.loadAmAction.setEnabled(true);
        this.commitAction.setEnabled(true);
        this.rollbackAction.setEnabled(true);
        this.mObjectTree.setAppModule(ConnectionInfo.getRootAppModule());
        this.updateTitle();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void disconnected() {
        if (!this.noConnectionDialog) {
            this.connectAction.setEnabled(true);
            this.disconnectAction.setEnabled(false);
        }
        this.commitAction.setEnabled(false);
        this.rollbackAction.setEnabled(false);
        this.menuCreateAM.setEnabled(false);
        this.menuCreateVO.setEnabled(false);
        this.menuCreateVL.setEnabled(false);
        this.mObjectTree.clearAll();
        this.updateTitle();
    }

    public void viewMenu_Selected(MenuEvent menuEvent) {
        boolean bl = this.mObjectTree.getSelectedObject() instanceof ViewObject;
        this.menuViewDataXML.setEnabled(bl);
    }

    public void createMenu_Selected(MenuEvent menuEvent) {
        boolean bl = this.mObjectTree.getSelectedObject() instanceof ApplicationModule;
        if (bl && !createMenuInitialized) {
            this.initializeCreateMenu();
        }
        this.menuCreateAM.setEnabled(bl && AMenabled);
        this.menuCreateVO.setEnabled(bl && VOenabled);
        this.menuCreateVL.setEnabled(bl && VLenabled);
    }

    private Hashtable processArgs(String[] stringArray) {
        Hashtable hashtable = new Hashtable(20);
        int n = 0;
        String string = null;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-X")) {
                if ((string = stringArray[++n]) != null) {
                    Configuration configuration = new Configuration();
                    configuration.loadFromClassPath("tester.xcfg");
                    hashtable = configuration.getConfiguration(string);
                    this.setConfiguration(configuration);
                    this.setConfigurationName(string);
                }
            } else if (stringArray[n].equalsIgnoreCase("-H")) {
                if ((string = stringArray[++n]) != null) {
                    helpUrlStr = string;
                }
            } else if (stringArray[n].equalsIgnoreCase("-O")) {
                sysOut = new ByteArrayOutputStream();
                System.setOut(new PrintStream(sysOut));
            }
            ++n;
        }
        return hashtable;
    }

    public static JMenuItem addMenuItem(JMenu jMenu, int n) {
        String string = Res.getString(n);
        JMenuItem jMenuItem = jMenu.add(JboTesterUtil.stripMnemonic(string));
        int n2 = JboTesterUtil.getMnemonicKeyCode(string);
        if (n2 != 0) {
            jMenuItem.setMnemonic(n2);
        }
        return jMenuItem;
    }

    public static JMenu createMenu(int n) {
        String string = Res.getString(n);
        JMenu jMenu = new JMenu(JboTesterUtil.stripMnemonic(string));
        int n2 = JboTesterUtil.getMnemonicKeyCode(string);
        if (n2 != 0) {
            jMenu.setMnemonic(n2);
        }
        return jMenu;
    }

    private JMenuBar createMainMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = MainFrame.createMenu(7);
        JMenu jMenu2 = MainFrame.createMenu(8);
        JMenu jMenu3 = MainFrame.createMenu(9);
        JMenu jMenu4 = MainFrame.createMenu(10);
        JMenu jMenu5 = MainFrame.createMenu(11);
        if (!this.noConnectionDialog) {
            jMenu.add(this.connectAction);
            jMenu.add(this.disconnectAction);
            jMenu.addSeparator();
        }
        jMenu.add(this.saveAmAction);
        this.saveAmAction.setEnabled(false);
        jMenu.add(this.loadAmAction);
        this.loadAmAction.setEnabled(false);
        JMenuItem jMenuItem = jMenu.add(this.exitAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        if (!this.noConnectionDialog && sysOut != null) {
            this.menuViewOutput = jMenu2.add(new JMenuItem(Res.getString(12)));
            this.menuViewOutput.addActionListener(new 5());
        }
        this.menuViewDataXML = MainFrame.addMenuItem(jMenu2, 13);
        this.menuViewDataXML.addActionListener(new 4());
        jMenuItem = jMenu3.add(this.commitAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)Res.getString(28).charAt(0), 8));
        jMenuItem = jMenu3.add(this.rollbackAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)Res.getString(30).charAt(0), 8));
        jMenu4.add(this.helpContentAction);
        jMenuItem = MainFrame.addMenuItem(jMenu4, 15);
        jMenuItem.addActionListener(new 3());
        this.menuCreateAM = jMenu5.add(ObjTreeNode.createAMAction);
        this.menuCreateVO = jMenu5.add(ObjTreeNode.createVOAction);
        this.menuCreateVL = jMenu5.add(ObjTreeNode.createVLAction);
        jMenu2.addMenuListener(new 2());
        jMenu5.addMenuListener(new 1());
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu5);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        return jMenuBar;
    }

    private JToolBar createMainToolBar() {
        this.mToolBar = new JToolBar();
        if (!this.noConnectionDialog) {
            this.addToolbarButton(this.mToolBar, this.connectAction, 24, 10);
            this.addToolbarButton(this.mToolBar, this.disconnectAction, 26, 11);
            this.mToolBar.addSeparator();
        }
        this.addToolbarButton(this.mToolBar, this.commitAction, 28, 8);
        this.addToolbarButton(this.mToolBar, this.rollbackAction, 30, 9);
        return this.mToolBar;
    }

    private JButton addToolbarButton(JToolBar jToolBar, Action action, int n, int n2) {
        JButton jButton = jToolBar.add(action);
        NavBar.initButton(jButton, Res.getString(n).charAt(0), n2);
        return jButton;
    }

    public void updateTitle() {
        this.setTitle(Res.format(0, Res.format(2, ConnectionInfo.getConnectionTitle())));
        this.mToolBar.setName(this.getTitle());
    }

    private Component createStatusBar() {
        this.statusBar = new StatusBar();
        this.statusLine = new JLabel("", 2);
        this.statusBar.add(this.statusLine);
        return this.statusBar;
    }

    final JLabel getStatusLine() {
        return this.statusLine;
    }

    boolean isHelpAvailable() {
        return helpUrlStr != null;
    }

    public void helpMe(String string) {
        if (helpMan == null) {
            helpMan = new HelpManager(helpUrlStr);
        }
        helpMan.helpMe(string);
    }

    private final boolean applyEditsAndValidate() {
        JPanel jPanel;
        boolean bl = true;
        if (this.mResultPanel != null && (jPanel = this.mResultPanel.getSelectedTab()) instanceof SimpleForm) {
            bl = ((SimpleForm)jPanel).applyEditsAndValidate();
        }
        return bl;
    }

    public void setPopup(Window window) {
        this.mPopup = window;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 7
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            MainFrame.this.exit();
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (MainFrame.this.mPopup != null) {
                MainFrame.this.mPopup.setVisible(false);
            }
        }
    }

    public final class 6
    extends FileFilter {
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
        }

        public String getDescription() {
            return Res.getString(277);
        }
    }

    public final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            OutputDialog outputDialog = new OutputDialog(MainFrame.this, Res.getString(4), true);
            outputDialog.setText(sysOut.toString());
            outputDialog.setLocationRelativeTo(frame);
            outputDialog.pack();
            outputDialog.setVisible(true);
        }
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.viewDataXML_ActionPerformed(actionEvent);
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.helpAbout_ActionPerformed(actionEvent);
        }
    }

    public final class 2
    implements MenuListener {
        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            MainFrame.this.viewMenu_Selected(menuEvent);
        }
    }

    public final class 1
    implements MenuListener {
        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            MainFrame.this.createMenu_Selected(menuEvent);
        }
    }

    private final class StatusBar
    extends JComponent {
        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    public abstract class AbstractMainAction
    extends AbstractJboAction {
        public AbstractMainAction(String string) {
            super(string);
        }

        public AbstractMainAction(String string, int n, int n2) {
            super(string, n, n2);
        }

        protected MainFrame getMainFrame() {
            return MainFrame.this;
        }
    }

    private final class FileConnectAction
    extends AbstractMainAction {
        public FileConnectAction() {
            super(Res.getString(16), 10, 23);
        }

        protected void doAction(ActionEvent actionEvent) {
            MainFrame.this.launchConnectDialog();
        }
    }

    private final class FileDisconnectAction
    extends AbstractMainAction {
        public FileDisconnectAction() {
            super(Res.getString(17), 11, 25);
        }

        protected void doAction(ActionEvent actionEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ApplicationModule applicationModule = ConnectionInfo.getRootAppModule();
            if (applicationModule != null) {
                ConnectionInfo.releaseApplicationModule();
                MainFrame.this.mResultPanel.removeAllTabs();
                MainFrame.this.disconnected();
            }
        }
    }

    private final class CommitAction
    extends AbstractMainAction {
        public CommitAction() {
            super(Res.getString(18), 8, 27);
        }

        protected void doAction(ActionEvent actionEvent) {
            ApplicationModule applicationModule;
            boolean bl = MainFrame.this.applyEditsAndValidate();
            if (bl && (applicationModule = ConnectionInfo.getRootAppModule()) != null) {
                applicationModule.getTransaction().commit();
                MainFrame.this.mResultPanel.refreshAll(false);
            }
        }
    }

    private final class RollbackAction
    extends AbstractMainAction {
        public RollbackAction() {
            super(Res.getString(19), 9, 29);
            this.setDelayedValidation();
        }

        protected void doAction(ActionEvent actionEvent) {
            ApplicationModule applicationModule = ConnectionInfo.getRootAppModule();
            if (applicationModule != null) {
                applicationModule.getTransaction().rollback();
                MainFrame.this.mResultPanel.refreshAll(true);
                MainFrame.this.commitAction.setEnabled(true);
            }
        }
    }

    private final class FileExitAction
    extends AbstractMainAction {
        public FileExitAction() {
            super(Res.getString(20));
        }

        protected void doAction(ActionEvent actionEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.exit();
        }
    }

    private final class FileSaveAction
    extends AbstractMainAction {
        public FileSaveAction() {
            super(Res.getString(21));
        }

        protected void doAction(ActionEvent actionEvent) {
            boolean bl = MainFrame.this.applyEditsAndValidate();
            if (bl) {
                int n = ConnectionInfo.getRootAppModule().passivateState(new byte[0], 0);
                JOptionPane.showMessageDialog(MainFrame.this, Res.getString(242) + n, Res.getString(243), 1);
                MainFrame.this.commitAction.setEnabled(false);
            }
        }
    }

    private final class FileLoadAction
    extends AbstractMainAction {
        public FileLoadAction() {
            super(Res.getString(22));
        }

        protected void doAction(ActionEvent actionEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = JOptionPane.showInputDialog(Res.getString(242));
                if (string == null || string.trim().length() == 0) {
                    return;
                }
                ConnectionInfo.getRootAppModule().activateState(Integer.valueOf(string).intValue(), null, 2);
                MainFrame.this.mResultPanel.refreshAfterActivate();
                MainFrame.this.mResultPanel.refreshAll(false);
                JOptionPane.showMessageDialog(MainFrame.this, Res.getString(242) + string, Res.getString(244), 1);
                MainFrame.this.commitAction.setEnabled(true);
            }
            catch (JboException jboException) {
                if (jboException.getErrorCode().equals("28039")) {
                    ErrorHandler.displayError((Frame)MainFrame.this, Res.getString(240));
                } else {
                    ErrorHandler.displayError((Frame)MainFrame.this, jboException);
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorHandler.displayError((Frame)MainFrame.this, Res.getString(241) + numberFormatException.getMessage());
            }
            catch (Exception exception) {
                ErrorHandler.displayError((Frame)MainFrame.this, exception);
            }
        }
    }

    private final class HelpContentAction
    extends AbstractMainAction {
        public HelpContentAction() {
            super(Res.getString(14));
        }

        protected void doAction(ActionEvent actionEvent) {
            MainFrame.this.helpMe("f1_bcbctbrowser_html");
        }
    }
}

