/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import com.sun.java.util.collections.HashMap;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.jbo.AttributeDef;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.LocaleContext;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.jbotester.AttDefDialog;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.JBOControl;
import oracle.jbo.jbotester.JBOControlMouseAdapter;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MainFrame;

final class JBOTableModel
extends AbstractTableModel
implements ChangeListener,
ListSelectionListener,
JBOControl {
    private RowSetIterator iter;
    private final JTable table;
    private final JScrollPane scrollPane;
    private Row[] view;
    private AttributeDef[] attrDefs;
    private LocaleContext locale;
    private int scrollUnit;
    private int rowCount;
    private int oldSBvalue;
    private boolean fromStateChange;
    private boolean selInProg;
    private final MainFrame mainFrame;
    private static /* synthetic */ Class class$java$lang$String;
    private static /* synthetic */ Class class$java$util$Date;
    private static /* synthetic */ Class class$java$lang$Number;

    private /* synthetic */ void $init$() {
        this.selInProg = false;
    }

    JBOTableModel(MainFrame mainFrame, JTable jTable, JScrollPane jScrollPane, RowSetIterator rowSetIterator) {
        this.$init$();
        this.table = jTable;
        this.scrollPane = jScrollPane;
        this.mainFrame = mainFrame;
        this.setIterator(rowSetIterator);
        this.table.addMouseListener(new TableMouseAdapter());
        this.table.setModel(this);
        Class clazz = class$java$util$Date;
        if (clazz == null) {
            clazz = class$java$util$Date = JBOTableModel.class$("java.util.Date");
        }
        this.table.setDefaultRenderer(clazz, new DefaultTableCellRenderer());
        Class clazz2 = class$java$lang$Number;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Number = JBOTableModel.class$("java.lang.Number");
        }
        this.table.setDefaultRenderer(clazz2, new DefaultTableCellRenderer());
        Class clazz3 = class$java$util$Date;
        if (clazz3 == null) {
            clazz3 = class$java$util$Date = JBOTableModel.class$("java.util.Date");
        }
        this.table.setDefaultEditor(clazz3, new DefaultCellEditor(new JTextField()));
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(this);
        this.scrollPane.getViewport().addChangeListener(this);
        this.scrollPane.getVerticalScrollBar().getModel().addChangeListener(new sbListener());
        this.scrollUnit = this.table.getScrollableUnitIncrement(this.table.getVisibleRect(), 1, 0);
        this.stateChanged(null);
    }

    public RowSetIterator getIterator() {
        return this.iter;
    }

    public synchronized void setIterator(RowSetIterator rowSetIterator) {
        if (this.iter == rowSetIterator) {
            return;
        }
        if (this.iter != null) {
            this.iter.removeListener((Object)this);
        }
        this.iter = rowSetIterator;
        if (this.iter != null) {
            this.locale = this.iter.getRowSet().getApplicationModule().getSession().getLocaleContext();
            this.iter.addListener((Object)this);
            this.attrDefs = JboTesterUtil.getDisplayableAttributes(this.iter.getRowSet());
        } else {
            this.attrDefs = null;
            this.locale = null;
        }
    }

    public int getColumnCount() {
        if (this.attrDefs == null) {
            return 0;
        }
        return this.attrDefs.length;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String getColumnName(int n) {
        return this.attrDefs[n].getUIHelper().getLabel(this.locale);
    }

    public Class getColumnClass(int n) {
        if (this.attrDefs[n].getUIHelper().hasFormatInformation(this.locale)) {
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = JBOTableModel.class$("java.lang.String");
            }
            return clazz;
        }
        return this.attrDefs[n].getJavaType();
    }

    public Object getValueAt(int n, int n2) {
        int n3 = n - this.iter.getRangeStart();
        if (n3 >= 0 && n3 < this.view.length) {
            try {
                Object object = JboTesterUtil.getData(this.view[n3], this.attrDefs[n2], this.locale);
                return object;
            }
            catch (Exception exception) {
                ErrorHandler.displayError(this.mainFrame, exception, (ViewObject)this.iter);
                Object var6_6 = null;
                return var6_6;
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        int n3 = n - this.iter.getRangeStart();
        if (n3 >= 0 && n3 < this.view.length) {
            return this.view[n3].isAttributeUpdateable(this.attrDefs[n2].getIndex());
        }
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            int n3 = this.attrDefs[n2].getIndex();
            int n4 = n - this.iter.getRangeStart();
            if (n4 >= 0 && n4 < this.view.length) {
                String string;
                Row row = this.view[n4];
                Object object2 = row.getAttribute(n3);
                String string2 = string = object == null ? "" : object.toString();
                if (object2 == null ? string.length() == 0 : object2.toString().equals(string)) {
                    return;
                }
                JboTesterUtil.setData(row, this.attrDefs[n2], this.locale, object);
            }
        }
        catch (Exception exception) {
            ErrorHandler.displayError(this.mainFrame, exception, (ViewObject)this.iter);
            SwingUtilities.invokeLater(new DelayedEditCell(object, n, n2));
        }
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        Diagnostic.println((String)("JBOTableModel: Recvd Event=" + rangeRefreshEvent));
        int n = rangeRefreshEvent.getRowCountInRange();
        if (this.view != null) {
            int n2 = this.view.length;
            if (n2 > n) {
                this.fireTableRowsDeleted(n2, n - 1);
            } else if (n2 < n) {
                this.fireTableRowsInserted(n2, n - 1);
            }
        }
        this.view = rangeRefreshEvent.getAllRowsInRange();
        this.scrollPane.getVerticalScrollBar().setValue(0);
        this.rowCount = (int)this.iter.getRowSet().getEstimatedRowCount();
        this.refresh();
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
        this.view = this.iter.getAllRowsInRange();
        if (!this.fromStateChange) {
            this.scrollPane.getVerticalScrollBar().setValue(this.iter.getRangeStart() * this.scrollUnit);
            SwingUtilities.invokeLater(new 2());
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        if (this.table.isEditing()) {
            this.table.removeEditor();
        }
        if (this.rowCount == 0) {
            ++this.rowCount;
        }
        this.selectRangeRow(navigationEvent.getRowIndex());
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.view = this.iter.getAllRowsInRange();
        SwingUtilities.invokeLater(new 1());
        this.refresh();
    }

    public void rowInserted(InsertEvent insertEvent) {
        RowSetIterator rowSetIterator = (RowSetIterator)insertEvent.getSource();
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.view = rowSetIterator.getAllRowsInRange();
        this.refresh();
    }

    public void rowUpdated(UpdateEvent updateEvent) {
        int[] nArray;
        Row row = updateEvent.getRow();
        int n = updateEvent.getRowIndex();
        int n2 = n + this.iter.getRangeStart();
        if (this.view != null && n < this.view.length) {
            this.view[n] = row;
        }
        if ((nArray = updateEvent.getChangedAttrIndices()) == null) {
            this.fireTableRowsUpdated(n2, n2);
        } else {
            int n3 = 0;
            while (n3 < nArray.length) {
                int n4 = 0;
                while (n4 < this.attrDefs.length) {
                    if (this.attrDefs[n4].getIndex() == nArray[n3]) {
                        this.fireTableCellUpdated(n2, n4);
                        break;
                    }
                    ++n4;
                }
                ++n3;
            }
        }
    }

    private void refresh() {
        this.fireTableDataChanged();
        this.rowCount = (int)this.iter.getRowSet().getEstimatedRowCount();
        this.selInProg = true;
        try {
            this.selectRangeRow(this.iter.getCurrentRowIndex());
            Object var2_1 = null;
            this.selInProg = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.selInProg = false;
            throw throwable;
        }
    }

    private void selectRangeRow(int n) {
        int n2;
        if (n >= 0 && (n2 = n + this.iter.getRangeStart()) < this.rowCount) {
            this.table.setRowSelectionInterval(n2, n2);
        } else {
            this.table.clearSelection();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (this.selInProg || listSelectionModel.getValueIsAdjusting()) {
            return;
        }
        if (!listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionModel.getMinSelectionIndex();
            try {
                this.iter.setCurrentRowAtRangeIndex(n - this.iter.getRangeStart());
            }
            catch (Exception exception) {
                ErrorHandler.displayError((Frame)this.mainFrame, exception);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        int n2 = this.scrollPane.getViewport().getHeight();
        int n3 = n2 / (n = this.table.getRowHeight() + this.table.getIntercellSpacing().height) + 1;
        if (n3 != this.iter.getRangeSize()) {
            this.iter.setRangeSize(n3);
            this.view = this.iter.getAllRowsInRange();
            this.refresh();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            JBOTableModel.this.fireTableDataChanged();
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            try {
                if (JBOTableModel.this.iter.getCurrentRowSlot() == 1) {
                    if (JBOTableModel.this.iter.hasNext()) {
                        JBOTableModel.this.iter.next();
                    } else {
                        JBOTableModel.this.iter.previous();
                    }
                }
            }
            catch (Exception exception) {
                ErrorHandler.displayError((Frame)JBOTableModel.this.mainFrame, exception);
            }
        }
    }

    final class sbListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
            int n = boundedRangeModel.getValue();
            int n2 = n - JBOTableModel.this.oldSBvalue;
            int n3 = boundedRangeModel.getExtent();
            if (n2 == 0) {
                return;
            }
            int n4 = JBOTableModel.this.iter.getRangeStart();
            int n5 = JBOTableModel.this.iter.getRangeSize();
            if (n2 > 0) {
                int n6 = n + n3 - (n4 + n5) * JBOTableModel.this.scrollUnit;
                if (n6 > 0) {
                    n6 = n6 / JBOTableModel.this.scrollUnit + 1;
                    JBOTableModel.this.fromStateChange = true;
                    JBOTableModel.this.iter.scrollRange(n6);
                    JBOTableModel.this.fromStateChange = false;
                }
            } else {
                int n7 = n - n4 * JBOTableModel.this.scrollUnit;
                if (n7 < 0) {
                    n7 = n7 / JBOTableModel.this.scrollUnit - 1;
                    JBOTableModel.this.fromStateChange = true;
                    JBOTableModel.this.iter.scrollRange(n7);
                    JBOTableModel.this.fromStateChange = false;
                }
            }
            JBOTableModel.this.oldSBvalue = n;
        }

        sbListener() {
        }
    }

    final class TableMouseAdapter
    extends JBOControlMouseAdapter {
        private HashMap mDlgs;

        TableMouseAdapter() {
            super(JBOTableModel.this.mainFrame);
            this.mDlgs = new HashMap();
        }

        public AttributeDef getAttributeDef(MouseEvent mouseEvent) {
            return JBOTableModel.this.attrDefs[JBOTableModel.this.table.columnAtPoint(mouseEvent.getPoint())];
        }

        public AttDefDialog getAttrDefDialog(AttributeDef attributeDef, MainFrame mainFrame) {
            AttDefDialog attDefDialog = (AttDefDialog)this.mDlgs.get((Object)attributeDef.getName());
            if (attDefDialog == null) {
                attDefDialog = new AttDefDialog(attributeDef, mainFrame);
                this.mDlgs.put((Object)attributeDef.getName(), (Object)attDefDialog);
            }
            return attDefDialog;
        }
    }

    class DelayedEditCell
    implements Runnable {
        Object invalidValue;
        int row;
        int col;

        public DelayedEditCell(Object object, int n, int n2) {
            this.invalidValue = object;
            this.row = n;
            this.col = n2;
        }

        public void run() {
            JBOTableModel.this.selInProg = true;
            try {
                JBOTableModel.this.table.setRowSelectionInterval(this.row, this.row);
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                JBOTableModel.this.selInProg = false;
                throw throwable;
            }
            JBOTableModel.this.selInProg = false;
            JBOTableModel.this.table.setColumnSelectionInterval(this.col, this.col);
            JBOTableModel.this.table.editCellAt(this.row, this.col);
            Component component = ((DefaultCellEditor)JBOTableModel.this.table.getCellEditor()).getComponent();
            if (component instanceof JTextField) {
                ((JTextField)component).setText(this.invalidValue.toString());
            }
            component.requestFocus();
        }
    }
}

