/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.jbo.AttributeDef;
import oracle.jbo.LocaleContext;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ViewObject;
import oracle.jbo.jbotester.AbstractJboAction;
import oracle.jbo.jbotester.DelayedFocus;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.JBOField;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.RowSetPanel;

public class JBOFieldHelper
implements JBOField {
    private final AttributeDef attrDef;
    private final JBOField controlField;
    protected Row row;
    protected RowSetIterator rowIter;
    protected boolean inRefresh;
    public static final ActionListener UpdateActionListener = new 2();
    public static final Action CancelAction = new 1();

    public JBOFieldHelper(AttributeDef attributeDef, JBOField jBOField) {
        this.attrDef = attributeDef;
        this.controlField = jBOField;
    }

    protected void init() {
        this.getJComponent().addFocusListener(new DefaultJBOFocusListener());
    }

    public void setRow(Row row, RowSetIterator rowSetIterator) {
        this.row = row;
        this.rowIter = rowSetIterator;
        this.getJComponent().setEnabled(this.row != null && !this.row.isDead() && this.row.isAttributeUpdateable(this.attrDef.getIndex()));
        this.refresh();
    }

    public AttributeDef getAttributeDef() {
        return this.attrDef;
    }

    public Object getDataValue() {
        try {
            if (this.row != null) {
                Object object = JboTesterUtil.getData(this.row, this.attrDef, this.getLocaleContext());
                return object;
            }
        }
        catch (Exception exception) {
            ErrorHandler.displayError(JBOFieldHelper.getRowSetPanel((JComponent)this.getJComponent()).mainFrame, exception, this.rowIter.getRowSet().getViewObject());
        }
        return null;
    }

    public boolean setDataValue(Object object) {
        try {
            if (this.row != null) {
                JboTesterUtil.setData(this.row, this.attrDef, this.getLocaleContext(), object);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            SwingUtilities.invokeLater(new DelayedError(exception, this.rowIter.getRowSet().getViewObject()));
        }
        return false;
    }

    public static RowSetPanel getRowSetPanel(JComponent jComponent) {
        JComponent jComponent2 = (JComponent)jComponent.getParent();
        if (jComponent2 == null) {
            return null;
        }
        if (jComponent2 instanceof RowSetPanel) {
            return (RowSetPanel)jComponent2;
        }
        return JBOFieldHelper.getRowSetPanel(jComponent2);
    }

    public Object getControlValue() {
        return this.controlField.getControlValue();
    }

    public void setControlValue(Object object) {
        this.controlField.setControlValue(object);
    }

    public JComponent getJComponent() {
        return this.controlField.getJComponent();
    }

    public LocaleContext getLocaleContext() {
        return this.controlField.getLocaleContext();
    }

    public boolean applyEdit() {
        if (!this.inRefresh && this.row != null) {
            return this.setDataValue(this.getControlValue());
        }
        return true;
    }

    public boolean applyEditAndValidate() {
        Object object;
        if (this.inRefresh) {
            return true;
        }
        Object object2 = this.getControlValue();
        if (object2 == (object = this.getDataValue())) {
            return true;
        }
        String string = object2 == null ? "" : object2.toString();
        String string2 = object == null ? "" : object.toString();
        boolean bl = true;
        if (string.compareTo(string2) != 0 && !(bl = this.applyEdit())) {
            SwingUtilities.invokeLater(new DelayedFocus(this.getJComponent()));
        }
        return bl;
    }

    public void refresh() {
        this.inRefresh = true;
        this.setControlValue(this.getDataValue());
        this.inRefresh = false;
    }

    public static final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JBOField) {
                JBOField jBOField = (JBOField)object;
                jBOField.applyEdit();
            }
        }
    }

    public static final class 1
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JBOField) {
                JBOField jBOField = (JBOField)object;
                jBOField.refresh();
            }
        }
    }

    public class DefaultJBOFocusListener
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                // empty if block
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (JBOFieldHelper.this.inRefresh || focusEvent.isTemporary()) {
                return;
            }
            Component component = focusEvent.getOppositeComponent();
            if (component != null && component instanceof JButton) {
                JButton jButton = (JButton)component;
                Container container = jButton.getParent();
                while (container != null && !(container instanceof JDialog)) {
                    container = container.getParent();
                }
                if (container != null && container instanceof ErrorHandler) {
                    return;
                }
                Action action = jButton.getAction();
                if (action != null && action instanceof AbstractJboAction && ((AbstractJboAction)action).isDelayedValidation()) {
                    return;
                }
            }
            JBOFieldHelper.this.applyEditAndValidate();
        }

        DefaultJBOFocusListener() {
        }
    }

    public class DelayedError
    implements Runnable {
        Exception ex;
        ViewObject vo;

        public DelayedError(Exception exception, ViewObject viewObject) {
            this.ex = exception;
            this.vo = viewObject;
        }

        public void run() {
            if (this.ex != null) {
                ErrorHandler.displayError(JOptionPane.getFrameForComponent(JBOFieldHelper.this.getJComponent()), this.ex, this.vo);
            }
        }
    }
}

