/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.jbo.JboException;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.jbotester.Res;

public final class ErrorHandler
extends JDialog {
    private static boolean isUp;
    private final JPanel bPanel;
    private final JButton okButton;
    private final JButton detailsButton;
    private final JButton copyButton;
    private final JTextArea mTextArea;
    private final JScrollPane scrollPane;
    private JboException jboex;
    private boolean mShowStackTraces;

    private /* synthetic */ void $init$() {
        this.bPanel = new JPanel();
        this.okButton = new JButton(Res.getString(59));
        this.detailsButton = new JButton(Res.getString(219));
        this.copyButton = new JButton(Res.getString(220));
        this.mTextArea = new JTextArea(5, 80);
        this.scrollPane = new JScrollPane(this.mTextArea);
    }

    public ErrorHandler(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.$init$();
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            Diagnostic.printStackTrace((Throwable)exception);
        }
    }

    private void jbInit() throws Exception {
        this.mTextArea.setRequestFocusEnabled(false);
        this.bPanel.add(this.okButton);
        this.bPanel.add(this.detailsButton);
        this.bPanel.add(this.copyButton);
        this.mTextArea.setEnabled(true);
        this.mTextArea.setEditable(false);
        this.mTextArea.setWrapStyleWord(true);
        this.mTextArea.setLineWrap(true);
        this.mTextArea.setBackground(this.getBackground());
        this.okButton.addActionListener(new 3());
        this.detailsButton.addActionListener(new 2());
        this.copyButton.addActionListener(new 1());
        this.okButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.requestFocusInWindow();
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.bPanel, "South");
    }

    public ErrorHandler() {
        this((Frame)null, Res.format(217, ""), false);
    }

    private void formErrorMessage(int n, int n2, StringBuffer stringBuffer, Throwable throwable) {
        Object[] objectArray;
        String string = "";
        int n3 = 1;
        while (n3 < n2) {
            string = string + Res.getString(250);
            ++n3;
        }
        if (n2 > 0) {
            stringBuffer.append(string).append(Res.getString(251)).append(Res.getString(253)).append(n2).append(Res.getString(254)).append(n).append(Res.getString(252)).append("\n");
        }
        if (this.mShowStackTraces) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringWriter.flush();
            stringBuffer.append(string).append(stringWriter.toString()).append("\n");
        } else {
            stringBuffer.append(string).append("(").append(throwable.getClass().getName()).append(") ").append(throwable.getMessage()).append("\n");
        }
        if (throwable instanceof JboException && (objectArray = ((JboException)throwable).getDetails()) != null) {
            int n4 = 0;
            while (n4 < objectArray.length) {
                this.formErrorMessage(n4, n2 + 1, stringBuffer, (Throwable)objectArray[n4]);
                ++n4;
            }
        }
    }

    protected String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        this.formErrorMessage(0, 0, stringBuffer, this.jboex);
        return stringBuffer.toString();
    }

    public static void displayError(Frame frame, String string) {
        ErrorHandler.startInitialize(frame);
        ErrorHandler errorHandler = new ErrorHandler(frame, Res.format(217, Res.getString(218)), true);
        errorHandler.finishInitialize(frame, string, false);
    }

    public static void displayError(Frame frame, Throwable throwable) {
        ErrorHandler.displayError(frame, throwable, null);
    }

    public static void displayError(Frame frame, Throwable throwable, ViewObject viewObject) {
        ErrorHandler.startInitialize(frame);
        ErrorHandler errorHandler = new ErrorHandler(frame, Res.format(217, throwable.getClass().getName()), true);
        Diagnostic.printStackTrace((Throwable)throwable);
        boolean bl = false;
        if (throwable instanceof JboException) {
            errorHandler.jboex = (JboException)throwable;
            if (viewObject != null) {
                errorHandler.jboex.doEntityToVOMapping(viewObject.getApplicationModule(), new ViewObject[]{viewObject});
            }
            bl = true;
        }
        errorHandler.finishInitialize(frame, bl ? errorHandler.getErrorMessage() : throwable.getMessage(), bl);
    }

    public static boolean isUp() {
        return isUp;
    }

    private void finishInitialize(Frame frame, String string, boolean bl) {
        this.mTextArea.setText(string);
        this.detailsButton.setEnabled(bl);
        this.setLocationRelativeTo(frame);
        this.okButton.requestFocus();
        this.setVisible(true);
        isUp = false;
    }

    private static void startInitialize(Frame frame) {
        isUp = true;
        frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ErrorHandler.this.setVisible(false);
            ErrorHandler.this.dispose();
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ErrorHandler.this.mShowStackTraces = true;
            ErrorHandler.this.mTextArea.setText(ErrorHandler.this.getErrorMessage());
            ErrorHandler.this.detailsButton.setEnabled(false);
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ErrorHandler.this.mTextArea.selectAll();
            ErrorHandler.this.mTextArea.copy();
        }
    }
}

