/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.jbo.client.Configuration;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.jbotester.ConfigMode;
import oracle.jbo.jbotester.ConfigPropertyPanel;
import oracle.jbo.jbotester.ConnectionInfo;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.GenericDialog;
import oracle.jbo.jbotester.IASPanel;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.PlatformPanel;
import oracle.jbo.jbotester.PoolParameterPanel;
import oracle.jbo.jbotester.Property;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.VBPanel;
import oracle.jbo.jbotester.WLPanel;

public abstract class ConnectionDialogBase
extends GenericDialog
implements ChangeListener {
    public static final int CONNECT = 2;
    public static final int IS_EJB_PACKAGE = 4;
    public static final int SHOW_NAME = 1;
    public static final String[] tabNames = new String[]{"AppModule", "Pooling", "Property"};
    private static final int APPMODULE_STR = 1;
    private static final Hashtable defaultConParam = new Hashtable(10);
    private static final int IAS = 2;
    private static final int JDBC_DS_PANEL = 1;
    private static final int JDBC_URL_PANEL = 0;
    private static final String[] jdbcPanelNames = new String[]{"jdbcUrlPanel", "jdbcDsPanel"};
    private static final int LOCAL = 0;
    private static final HashMap notInPropertyParam = new HashMap(20);
    private static final int PACKAGE_STR = 0;
    private static final String[] platforms = new String[]{"LOCAL", "VB", "EjbIas", "EjbWls"};
    private static final int VB = 1;
    private static final int WL = 3;
    private JPanel appConTypePanel;
    private final JComboBox appTypeCombo;
    private final JComboBox bc4jConNameCombo;
    private final JTextField bc4jConNameField;
    private CardLayout cardLayout;
    private final Hashtable cmdParams;
    private final Configuration configMgr;
    private final TitledBorder connBorder;
    private final boolean connectWhenDone;
    private final JCheckBox connRequiredCheck;
    private Hashtable currentParams;
    private int currentTabIndex;
    private final JComboBox dbConnTypeCombo;
    private JTextField dsNameField;
    private IASPanel iasPanel;
    private final boolean isEJBPackage;
    private JPanel jdbcConnPanel;
    private final ConfigMode mode;
    private PoolParameterPanel mPoolParameterPanel;
    private int mPropertiesTabIndex;
    private String oldConName;
    private final JComboBox orbTypeCombo;
    private final Hashtable origCmdParams;
    private final JTextField packageField;
    private ConfigPropertyPanel propConfPanel;
    private final boolean showNamedConnections;
    private String[] uniqueNames;
    private WLPanel wlPanel;
    protected final JComboBox connTypeCombo;
    protected JPanel mainConnPanel;
    protected final JTextArea urlField;
    protected final JLabel userNameField;

    static {
        defaultConParam.put("BC4JConfigName", "Configuration1");
        defaultConParam.put(PropertyMetadata.DEPLOY_PLATFORM.getName(), PropertyMetadata.DEPLOY_PLATFORM.getDefault());
        defaultConParam.put("ApplicationName", "package1.Package1Module");
        notInPropertyParam.put((Object)"BC4JConfigName", (Object)"BC4JConfigName");
        notInPropertyParam.put((Object)"ApplicationName", (Object)"ApplicationName");
        notInPropertyParam.put((Object)"ApplicationType", (Object)"ApplicationType");
        notInPropertyParam.put((Object)"JDBCName", (Object)"JDBCName");
        notInPropertyParam.put((Object)"JDBCDataSource", (Object)"JDBCDataSource");
        notInPropertyParam.put((Object)PropertyMetadata.DEPLOY_PLATFORM.getName(), (Object)PropertyMetadata.DEPLOY_PLATFORM.getName());
        notInPropertyParam.put((Object)PropertyMetadata.HOST_NAME.getName(), (Object)PropertyMetadata.HOST_NAME.getName());
        notInPropertyParam.put((Object)PropertyMetadata.APPLICATION_PATH.getName(), (Object)PropertyMetadata.APPLICATION_PATH.getName());
        notInPropertyParam.put((Object)PropertyMetadata.CONNECTION_MODE.getName(), (Object)PropertyMetadata.CONNECTION_MODE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.CONNECTION_PORT.getName(), (Object)PropertyMetadata.CONNECTION_PORT.getName());
        notInPropertyParam.put((Object)"EjbClientJars", (Object)"EjbClientJars");
        notInPropertyParam.put((Object)PropertyMetadata.DEPLOY_PLATFORM.getName(), (Object)PropertyMetadata.DEPLOY_PLATFORM.getName());
        notInPropertyParam.put((Object)"AppServerConnectionName", (Object)"AppServerConnectionName");
        notInPropertyParam.put((Object)"jbo.internal.embedded", (Object)"jbo.internal.embedded");
        notInPropertyParam.put((Object)"jbo.configname", (Object)"jbo.configname");
        notInPropertyParam.put((Object)PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE.getName(), (Object)PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE.getName(), (Object)PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD.getName(), (Object)PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE.getName(), (Object)PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE.getName(), (Object)PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE, (Object)PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL.getName(), (Object)PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE.getName(), (Object)PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE.getName(), (Object)PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE.getName(), (Object)PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE.getName(), (Object)PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE, (Object)PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL.getName(), (Object)PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_DO_FAILOVER.getName(), (Object)PropertyMetadata.ENV_DO_FAILOVER.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_DO_CONNECTION_POOLING.getName(), (Object)PropertyMetadata.ENV_DO_CONNECTION_POOLING.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS.getName(), (Object)PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE.getName(), (Object)PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE.getName());
        notInPropertyParam.put((Object)PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING.getName(), (Object)PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING.getName());
    }

    private /* synthetic */ void $init$() {
        this.appTypeCombo = new JComboBox<String>(new String[]{Res.getString(89), Res.getString(90)});
        this.bc4jConNameCombo = new JComboBox();
        this.bc4jConNameField = new JTextField();
        this.connBorder = BorderFactory.createTitledBorder("");
        this.connRequiredCheck = new JCheckBox(Res.getString(126));
        this.dbConnTypeCombo = new JComboBox<String>(new String[]{Res.getString(124), Res.getString(125)});
        this.dsNameField = new JTextField();
        this.jdbcConnPanel = new JPanel();
        this.mPoolParameterPanel = null;
        this.mPropertiesTabIndex = 1;
        this.oldConName = "";
        this.orbTypeCombo = new JComboBox();
        this.packageField = new JTextField();
        this.uniqueNames = null;
        this.connTypeCombo = new JComboBox();
        this.mainConnPanel = new JPanel();
        this.urlField = new JTextArea();
        this.userNameField = new JLabel();
    }

    public ConnectionDialogBase(Frame frame, Hashtable hashtable, Configuration configuration, ConfigMode configMode, ActionListener actionListener, int n) {
        super(frame, configMode != ConfigMode.RUN ? Res.getString(77) : Res.format(0, Res.getString(76)), new JPanel(new GridBagLayout()), 2, configMode != ConfigMode.RUN ? null : Res.getString(94));
        this.$init$();
        if (hashtable.get("BC4JConfigNames") != null) {
            this.uniqueNames = (String[])hashtable.get("BC4JConfigNames");
            hashtable.remove("BC4JConfigNames");
        }
        this.cmdParams = hashtable;
        this.origCmdParams = (Hashtable)hashtable.clone();
        this.configMgr = configuration;
        this.oldConName = (String)hashtable.get("BC4JConfigName");
        this.connectWhenDone = (n & 2) > 0;
        this.showNamedConnections = (n & 1) > 0;
        this.isEJBPackage = (n & 4) > 0;
        this.mode = configMode;
        if (this.isEditing()) {
            this.mPropertiesTabIndex = 2;
        }
        this.setHelpActionListener(actionListener);
        this.propConfPanel = new ConfigPropertyPanel(this.parent, new Property[0]);
        if (hashtable != null) {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (notInPropertyParam.get((Object)string) != null) continue;
                PropertyMetadata propertyMetadata = PropertyMetadata.findProperty((String)string);
                Property property = new Property(string, (String)hashtable.get(string), propertyMetadata != null ? propertyMetadata.getDescription() : string, false, false, true, propertyMetadata == null);
                arrayList.add((Object)property);
            }
            this.setProperties((Property[])arrayList.toArray((Object[])new Property[arrayList.size()]));
        }
        try {
            this.jbInit();
            this.initConfigName();
            this.initAppInfo(hashtable);
            if (!this.isEditing() && this.bc4jConNameCombo.getItemCount() > 1) {
                this.bc4jConNameCombo.setSelectedIndex(1);
            }
        }
        catch (Exception exception) {
            ErrorHandler.displayError(this.parent, exception);
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            this.exitCmd = string;
            this.connectAction();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public final void doHelp() {
        if (this.getHelpActionListener() != null) {
            String string = null;
            string = this.currentTabIndex == 0 || this.isEditing() ? tabNames[this.currentTabIndex] : tabNames[2];
            this.getHelpActionListener().actionPerformed(new ActionEvent(this, 1001, string));
        } else {
            super.doHelp();
        }
    }

    public final Hashtable getParams() {
        return this.cmdParams;
    }

    public void setDeployPlatform(String string) {
        int n = 0;
        while (n < platforms.length) {
            if (platforms[n].equals(string)) {
                this.orbTypeCombo.setSelectedIndex(n);
                break;
            }
            ++n;
        }
    }

    public final void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            this.currentTabIndex = jTabbedPane.getSelectedIndex();
            if (this.currentTabIndex == this.mPropertiesTabIndex) {
                this.populatePropertiesTable();
            }
            if (this.mPoolParameterPanel != null) {
                this.mPoolParameterPanel.setConnCapacitiesEditable(this.useDataSource() ^ true);
            }
        }
    }

    private final void addToPanel(JPanel jPanel, JComponent jComponent, JPanel jPanel2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setAlignmentY(0.0f);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
    }

    private final void bc4jConNameCombo_actionPerformed(ActionEvent actionEvent) {
        try {
            String string = (String)this.bc4jConNameCombo.getSelectedItem();
            Hashtable hashtable = defaultConParam;
            if (string != null && string.length() > 0) {
                if (string.equals(Res.getString(93))) {
                    hashtable = this.cmdParams;
                } else if (this.configMgr != null) {
                    hashtable = this.configMgr.getConfiguration(string);
                    hashtable.remove(PropertyMetadata.INITIAL_CONTEXT_FACTORY.getName());
                    hashtable.remove("DBconnection");
                    hashtable.remove("user");
                    hashtable.remove("password");
                    this.setProperties(new Property[0]);
                }
            }
            this.initAppInfo(hashtable);
            this.populatePropertiesTable();
        }
        catch (Exception exception) {
            Diagnostic.printStackTrace((Throwable)exception);
        }
    }

    private final JPanel buildAppTypePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = JboTesterUtil.createLabel(91, this.packageField);
        jPanel.setAlignmentY(0.0f);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.packageField, gridBagConstraints);
        jPanel.add(this.packageField);
        return jPanel;
    }

    private final JPanel buildConnPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(JboTesterUtil.stripMnemonic(96));
        JLabel jLabel2 = new JLabel(Res.getString(99));
        JLabel jLabel3 = JboTesterUtil.createLabel(102, this.connTypeCombo);
        jPanel.setAlignmentY(0.0f);
        this.urlField.setEditable(false);
        this.urlField.setRows(2);
        this.urlField.setEnabled(false);
        this.urlField.setLineWrap(true);
        this.urlField.setFont(jLabel2.getFont());
        this.urlField.setMinimumSize(new Dimension(250, 50));
        this.urlField.setBackground(jLabel2.getBackground());
        this.urlField.setForeground(jLabel2.getForeground());
        this.urlField.setToolTipText(this.urlField.getText());
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.connTypeCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.userNameField, gridBagConstraints);
        jPanel.add(this.userNameField);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.urlField, gridBagConstraints);
        jPanel.add(this.urlField);
        return jPanel;
    }

    private final JPanel buildDataSourcePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = JboTesterUtil.createLabel(98, this.dsNameField);
        jPanel.setAlignmentY(0.0f);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.dsNameField, gridBagConstraints);
        JboTesterUtil.addSpacerPanel(jPanel, 0, 1);
        return jPanel;
    }

    private final void buildJdbcConnectionPanel() {
        JPanel jPanel = new JPanel();
        jPanel = this.buildConnPanel();
        JPanel jPanel2 = this.buildDataSourcePanel();
        this.jdbcConnPanel.setLayout(new CardLayout());
        this.jdbcConnPanel.add((Component)jPanel, jdbcPanelNames[0]);
        this.jdbcConnPanel.add((Component)jPanel2, jdbcPanelNames[1]);
        this.dbConnTypeCombo.addActionListener(new 5());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mainConnPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mainConnPanel.setAlignmentY(0.0f);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 3, 10, 0);
        gridBagConstraints.anchor = 18;
        if (this.isEJBPackage && this.isEditing()) {
            gridBagLayout.setConstraints(this.connRequiredCheck, gridBagConstraints);
            this.mainConnPanel.add(this.connRequiredCheck);
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.dbConnTypeCombo, gridBagConstraints);
        this.mainConnPanel.add(this.dbConnTypeCombo);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.jdbcConnPanel, gridBagConstraints);
        this.mainConnPanel.add(this.jdbcConnPanel);
    }

    private final JPanel buildNamePanel() {
        JComponent jComponent;
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setMinimumSize(new Dimension(400, 40));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.isEditing()) {
            jComponent = this.bc4jConNameField;
            JboTesterUtil.removeKeyBindingCompatibility(this.bc4jConNameField);
            this.bc4jConNameCombo.setVisible(false);
        } else {
            jComponent = this.bc4jConNameCombo;
            this.bc4jConNameField.setVisible(false);
        }
        JLabel jLabel = JboTesterUtil.createLabel(92, jComponent);
        jPanel.setAlignmentY(0.0f);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        return jPanel;
    }

    private final void connectAction() {
        if (!this.propConfPanel.canExit()) {
            return;
        }
        this.cmdParams.clear();
        String string = this.getConfigName();
        boolean bl = Res.getString(93).equals(string);
        if (string != null && string.length() > 0 && !bl && this.configMgr != null) {
            if (!this.mode.equals(ConfigMode.NEW)) {
                if (this.isEditing()) {
                    if (string.equals(this.oldConName)) {
                        this.configMgr.getConfiguration(string, this.cmdParams, false);
                    } else {
                        this.configMgr.getConfiguration(this.oldConName, this.cmdParams, false);
                        this.cmdParams.put("BC4JConfigName", string);
                    }
                } else {
                    this.configMgr.getConfiguration(string, this.cmdParams, false);
                }
            }
        } else if (bl) {
            String string2 = null;
            if (this.cmdParams.get("jbo.internal.embedded") == null && (string2 = (String)this.origCmdParams.get("jbo.internal.embedded")) != null) {
                this.cmdParams.put("jbo.internal.embedded", string2);
            }
        }
        if (!this.getParamFromPanel(this.cmdParams, true)) {
            return;
        }
        Property[] propertyArray = this.getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (property != null && (property.isNew || property.isModified) && property.key != null && property.key.length() > 0) {
                if (property.value != null) {
                    this.cmdParams.put(property.key, property.value);
                    PropertyMetadata propertyMetadata = PropertyMetadata.findProperty((String)property.key);
                    if (propertyMetadata != null && (property.value.equalsIgnoreCase(propertyMetadata.getDefault()) || property.value.length() == 0)) {
                        this.cmdParams.remove(property.key);
                    }
                } else {
                    this.cmdParams.remove(property.key);
                }
            }
            ++n;
        }
        this.propConfPanel.removeDeletedParameters(this.cmdParams);
        if (this.isEditing()) {
            this.cmdParams.remove("EjbClientJars");
        } else {
            this.cmdParams.put(PropertyMetadata.INITIAL_CONTEXT_FACTORY.getName(), PropertyMetadata.INITIAL_CONTEXT_FACTORY.getDefault());
            this.configMgr.initializeFromConnectionName(this.cmdParams);
        }
        if (this.connectWhenDone) {
            boolean bl2 = false;
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                bl2 = ConnectionInfo.useApplicationModule(this, this.configMgr, string);
            }
            catch (Throwable throwable) {
                ErrorHandler.displayError(this.parent, throwable);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (!bl2) {
                return;
            }
        }
        this.close();
    }

    private final void connRequired_actionPerformed(ActionEvent actionEvent) {
        ButtonModel buttonModel = this.connRequiredCheck.getModel();
        this.setJdbcConnectionPanelEnabled(buttonModel.isSelected());
    }

    private final JPanel createAMConfPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Border border = BorderFactory.createEmptyBorder(5, 5, 0, 5);
        this.wlPanel = new WLPanel(this.parent);
        this.iasPanel = new IASPanel(this.parent);
        this.cardLayout = new CardLayout();
        this.appConTypePanel = new JPanel(this.cardLayout);
        this.appConTypePanel.add((Component)new PlatformPanel(), platforms[0]);
        this.appConTypePanel.add((Component)new VBPanel(this.parent), platforms[1]);
        this.appConTypePanel.add((Component)this.iasPanel, platforms[2]);
        this.appConTypePanel.add((Component)this.wlPanel, platforms[3]);
        String string = Res.getString(95);
        this.orbTypeCombo.setEnabled(this.isNewConfig());
        this.orbTypeCombo.setModel(this.createPlatformComboModel());
        this.orbTypeCombo.getAccessibleContext().setAccessibleName(string);
        this.orbTypeCombo.addActionListener(new 4());
        int n = Math.max(this.appTypeCombo.getMinimumSize().width, this.orbTypeCombo.getMinimumSize().width);
        n = Math.max(n, this.dbConnTypeCombo.getMinimumSize().width);
        Dimension dimension = new Dimension(n, this.appTypeCombo.getMinimumSize().height);
        this.appTypeCombo.setPreferredSize(dimension);
        this.orbTypeCombo.setPreferredSize(dimension);
        this.dbConnTypeCombo.setPreferredSize(dimension);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), border));
        this.addToPanel(jPanel2, this.orbTypeCombo, this.appConTypePanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.mainConnPanel.setBorder(BorderFactory.createCompoundBorder(this.connBorder, border));
        this.connTypeCombo.setEditable(false);
        this.connTypeCombo.addActionListener(new 3());
        string = Res.getString(103);
        this.connBorder.setTitle(string);
        this.dbConnTypeCombo.getAccessibleContext().setAccessibleName(string);
        this.initdbConnTypeCombo(0);
        this.buildJdbcConnectionPanel();
        gridBagLayout.setConstraints(this.mainConnPanel, gridBagConstraints);
        jPanel.add(this.mainConnPanel);
        JPanel jPanel3 = new JPanel();
        string = Res.getString(90);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), border));
        this.appTypeCombo.getAccessibleContext().setAccessibleName(string);
        if (this.isEditing()) {
            this.addToPanel(jPanel3, new JLabel(Res.getString(90)), this.buildAppTypePanel());
        } else {
            this.appTypeCombo.setEditable(false);
            this.addToPanel(jPanel3, this.appTypeCombo, this.buildAppTypePanel());
        }
        JboTesterUtil.removeKeyBindingCompatibility(this.packageField);
        if (this.isEditing()) {
            this.packageField.setEnabled(false);
        }
        this.appTypeCombo.setVisible(false);
        this.appTypeCombo.setEnabled(false);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private ComboBoxModel createPlatformComboModel() {
        if (this.mode != ConfigMode.NEW) {
            return new DefaultComboBoxModel<String>(new String[]{Res.getString(210), Res.getString(206), Res.getString(212), Res.getString(211)});
        }
        return new DefaultComboBoxModel<String>(new String[]{Res.getString(210)});
    }

    private final void dbConnType_actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        int n2 = this.dbConnTypeCombo.getSelectedIndex();
        if (n2 != -1) {
            n = n2;
        }
        this.showJdbcPanel(n);
    }

    private String getConfigName() {
        String string = null;
        string = !this.isEditing() ? (String)this.bc4jConNameCombo.getSelectedItem() : this.bc4jConNameField.getText();
        return string;
    }

    private final boolean getParamFromPanel(Hashtable hashtable, boolean bl) {
        String string;
        String string2 = this.packageField.getText();
        if (string2 == null || string2.length() <= 0) {
            if (bl) {
                ErrorHandler.displayError(this.parent, Res.getString(100));
                return false;
            }
        } else {
            hashtable.put("ApplicationName", string2);
        }
        if (this.isEditing()) {
            string = "APPMODULE";
            String string3 = this.bc4jConNameField.getText();
            boolean bl2 = true;
            String string4 = null;
            if (this.isConfigNameHasInvalidChars(string3)) {
                bl2 = false;
                string4 = Res.getString(245);
            }
            if (this.isConfigNameEmpty(string3)) {
                bl2 = false;
                string4 = Res.getString(247);
            }
            if (!this.isConfigNameUnique(string3)) {
                bl2 = false;
                string4 = Res.getString(246);
            }
            if (bl2) {
                hashtable.put("BC4JConfigName", string3);
            } else if (bl) {
                ErrorHandler.displayError(this.parent, string4);
                this.bc4jConNameField.selectAll();
                this.bc4jConNameField.requestFocus();
                return false;
            }
        } else {
            Object object;
            String string5 = string = this.appTypeCombo.getSelectedIndex() == 0 ? "PACKAGE" : "APPMODULE";
            if (this.showNamedConnections && (object = this.bc4jConNameCombo.getSelectedItem()) != null) {
                hashtable.put("BC4JConfigName", object);
            }
        }
        if (string == "PACKAGE") {
            hashtable.put("ApplicationType", string);
        } else {
            hashtable.remove("ApplicationType");
        }
        int n = this.orbTypeCombo.getSelectedIndex();
        hashtable.put(PropertyMetadata.DEPLOY_PLATFORM.getName(), platforms[n]);
        if (!this.validateAndUpdateConnectionParams(hashtable, bl)) {
            return false;
        }
        if (this.mPoolParameterPanel != null) {
            if (!this.mPoolParameterPanel.validateAndUpdateScalabilityParams(hashtable, bl)) {
                return false;
            }
            Property[] propertyArray = this.getProperties();
            HashMap hashMap = new HashMap(propertyArray.length);
            int n2 = 0;
            while (n2 < propertyArray.length) {
                Property property = propertyArray[n2];
                hashMap.put((Object)property.key, (Object)property);
                ++n2;
            }
            int n3 = 0;
            while (n3 < PoolParameterPanel.POOL_PARAMETER_METADATA.length) {
                String string6 = PoolParameterPanel.POOL_PARAMETER_METADATA[n3].getName();
                Property property = (Property)hashMap.get((Object)string6);
                String string7 = (String)this.cmdParams.get(string6);
                if (property != null && property.isModified && !property.value.equals(string7)) {
                    property.value = string7;
                }
                ++n3;
            }
        }
        if (!this.isEmbeddedConfig(this.getConfigName())) {
            hashtable.remove(PropertyMetadata.HOST_NAME.getName());
            hashtable.remove(PropertyMetadata.CONNECTION_PORT.getName());
        } else {
            String string8 = null;
            if (hashtable.get(PropertyMetadata.HOST_NAME.getName()) == null && (string8 = (String)this.origCmdParams.get(PropertyMetadata.HOST_NAME.getName())) != null) {
                hashtable.put(PropertyMetadata.HOST_NAME.getName(), string8);
            }
            String string9 = null;
            if (hashtable.get(PropertyMetadata.CONNECTION_PORT.getName()) == null && (string9 = (String)this.origCmdParams.get(PropertyMetadata.CONNECTION_PORT.getName())) != null) {
                hashtable.put(PropertyMetadata.CONNECTION_PORT.getName(), string9);
            }
        }
        hashtable.remove(PropertyMetadata.APPLICATION_PATH.getName());
        hashtable.remove("ORBgatekeeperIOR");
        hashtable.remove(PropertyMetadata.CONNECTION_MODE.getName());
        hashtable.remove("EjbClientJars");
        PlatformPanel platformPanel = (PlatformPanel)this.appConTypePanel.getComponent(n);
        return platformPanel.getParams(hashtable, bl);
    }

    private Property[] getProperties() {
        return this.propConfPanel.getProperties();
    }

    private final void initAppInfo(Hashtable hashtable) {
        String string;
        if (hashtable == null) {
            hashtable = defaultConParam;
        } else {
            if (hashtable.get(PropertyMetadata.DEPLOY_PLATFORM.getName()) == null) {
                hashtable.put(PropertyMetadata.DEPLOY_PLATFORM.getName(), defaultConParam.get(PropertyMetadata.DEPLOY_PLATFORM.getName()));
            }
            if (hashtable.get("ApplicationName") == null) {
                hashtable.put("ApplicationName", defaultConParam.get("ApplicationName"));
            }
        }
        this.currentParams = (Hashtable)hashtable.clone();
        if (this.isEditing()) {
            this.bc4jConNameField.setText((String)hashtable.get("BC4JConfigName"));
            if (this.isEmbeddedConfig(this.getConfigName())) {
                this.bc4jConNameField.setEditable(false);
            } else {
                this.bc4jConNameField.setEditable(true);
            }
        }
        String string2 = (String)hashtable.get(PropertyMetadata.DEPLOY_PLATFORM.getName());
        this.setDeployPlatform(string2);
        this.initJdbcPanel(string2, hashtable);
        if (this.mPoolParameterPanel != null) {
            this.mPoolParameterPanel.setPoolParameters(hashtable);
        }
        if (!this.isEditing() && ((string = (String)hashtable.get("ApplicationType")) == null || string.equals("APPMODULE"))) {
            this.appTypeCombo.setSelectedIndex(1);
        }
        String string3 = (String)hashtable.get("ApplicationName");
        this.packageField.setText(string3);
    }

    private final void initConfigName() {
        if (this.showNamedConnections && !this.isEditing()) {
            String[] stringArray = null;
            try {
                if (this.configMgr != null) {
                    stringArray = this.configMgr.getConfigurationNameList((String)this.cmdParams.get("ApplicationName"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = Res.getString(93);
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            this.bc4jConNameCombo.setModel(new DefaultComboBoxModel<String>(stringArray2));
        }
    }

    private final void initdbConnTypeCombo(int n) {
        this.updateConnectionCombo(n);
    }

    private final void initJdbcPanel(String string, Hashtable hashtable) {
        String string2 = null;
        String string3 = null;
        int n = 0;
        if (string.equals("VB") || string.equals("LOCAL") || string.equals("EjbWls") || string.equals("EjbIas")) {
            string2 = (String)hashtable.get("JDBCName");
            string3 = (String)hashtable.get("JDBCDataSource");
        }
        this.connRequiredCheck.addActionListener(new 2());
        if (string3 != null) {
            n = 1;
            this.connRequiredCheck.getModel().setSelected(true);
            this.setJdbcConnectionPanelEnabled(true);
            this.dsNameField.setText(string3);
        } else if (string2 != null) {
            this.connTypeCombo.setSelectedItem(string2);
            this.connRequiredCheck.getModel().setSelected(true);
            this.setJdbcConnectionPanelEnabled(true);
        } else {
            this.connRequiredCheck.getModel().setSelected(this.isEJBPackage ^ true);
            this.setJdbcConnectionPanelEnabled(this.isEJBPackage ^ true);
        }
        this.dbConnTypeCombo.setSelectedIndex(n);
    }

    private final boolean isConfigNameEmpty(String string) {
        return string.length() == 0;
    }

    private final boolean isConfigNameHasInvalidChars(String string) {
        return string.indexOf(46) != -1;
    }

    private final boolean isConfigNameUnique(String string) {
        if (this.uniqueNames != null && !string.equals(this.oldConName)) {
            int n = 0;
            while (n < this.uniqueNames.length) {
                if (this.uniqueNames[n].equalsIgnoreCase(string)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private final boolean isEditing() {
        return this.mode == ConfigMode.NEW || this.mode == ConfigMode.EDIT;
    }

    private final boolean isEmbeddedConfig(String string) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = string != null && string.length() > 0 && Res.getString(93).equals(string);
        if (!bl && this.configMgr != null) {
            bl2 = this.configMgr.isEmbeddedConfig(string);
        } else if (bl && Configuration.isEmbeddedConfig((Hashtable)this.origCmdParams)) {
            bl2 = true;
        }
        return bl2;
    }

    private final boolean isNewConfig() {
        return this.mode == ConfigMode.NEW;
    }

    private final void jbInit() {
        this.setHelpLocation("f1_bcbctconnect_html");
        JPanel jPanel = this.getMainPanel();
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        if (this.showNamedConnections) {
            JPanel jPanel2 = this.buildNamePanel();
            gridBagConstraints.insets = new Insets(5, 5, 0, 15);
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            if (!this.isEditing()) {
                this.bc4jConNameCombo.addActionListener(new 1());
            }
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addChangeListener(this);
        jTabbedPane.addTab(Res.getString(81), this.createAMConfPanel());
        if (this.isEditing()) {
            this.mPoolParameterPanel = new PoolParameterPanel(this.parent, this.cmdParams);
            jTabbedPane.addTab(Res.getString(83), this.mPoolParameterPanel);
        }
        jTabbedPane.addTab(Res.getString(82), this.propConfPanel);
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagLayout.setConstraints(jTabbedPane, gridBagConstraints);
        jPanel.add(jTabbedPane);
    }

    private final void orbTypeCombo_actionPerformed(ActionEvent actionEvent) {
        int n = this.orbTypeCombo.getSelectedIndex();
        this.cardLayout.show(this.appConTypePanel, platforms[n]);
        this.currentParams.put(PropertyMetadata.DEPLOY_PLATFORM.getName(), platforms[n]);
        PlatformPanel platformPanel = (PlatformPanel)this.appConTypePanel.getComponent(n);
        platformPanel.setParams(this.currentParams);
        this.initdbConnTypeCombo(n);
    }

    private final void populatePropertiesTable() {
        this.getParamFromPanel(this.currentParams, false);
        this.removeDeletedParameters();
        ArrayList arrayList = new ArrayList(50);
        HashMap hashMap = new HashMap(10);
        Property[] propertyArray = this.getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (property != null && (property.isNew || property.isModified) && property.key != null && property.key.length() > 0) {
                arrayList.add((Object)property);
                hashMap.put((Object)property.key, (Object)property.value);
            }
            ++n;
        }
        Enumeration enumeration = PropertyMetadata.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            PropertyMetadata propertyMetadata = (PropertyMetadata)enumeration.nextElement();
            String string = propertyMetadata.getName();
            if (hashMap.get((Object)string) != null) continue;
            if (propertyMetadata == PropertyMetadata.DEPLOY_PLATFORM || propertyMetadata == PropertyMetadata.CONNECTION_MODE || propertyMetadata == PropertyMetadata.HOST_NAME || propertyMetadata == PropertyMetadata.CONNECTION_PORT || propertyMetadata == PropertyMetadata.APPLICATION_PATH || propertyMetadata == PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE || propertyMetadata == PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE || propertyMetadata == PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD || propertyMetadata == PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE || propertyMetadata == PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE || propertyMetadata == PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE || propertyMetadata == PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL || propertyMetadata == PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE || propertyMetadata == PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE || propertyMetadata == PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE || propertyMetadata == PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE || propertyMetadata == PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE || propertyMetadata == PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL || propertyMetadata == PropertyMetadata.ENV_DO_FAILOVER || propertyMetadata == PropertyMetadata.ENV_DO_CONNECTION_POOLING || propertyMetadata == PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS || propertyMetadata == PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE || propertyMetadata == PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING) {
                bl = true;
            }
            String string2 = (String)this.currentParams.get(string);
            String string3 = propertyMetadata.getDescription();
            if (string2 == null) {
                string2 = propertyMetadata.getDefault();
            }
            Property property = new Property(string, string2, string3, bl, false, false, false);
            arrayList.add((Object)property);
        }
        int n2 = 0;
        Enumeration enumeration2 = this.currentParams.keys();
        while (enumeration2.hasMoreElements()) {
            PropertyMetadata propertyMetadata;
            String string = (String)enumeration2.nextElement();
            boolean bl = false;
            if (hashMap.get((Object)string) != null || string.compareTo("DBconnection") == 0 || string.compareTo("BC4JConfigName") == 0 || string.compareTo("jbo.internal.embedded") == 0 || string.compareTo("jbo.configname") == 0 || (propertyMetadata = PropertyMetadata.findProperty((String)string)) != null) continue;
            if (string.compareTo("ApplicationName") == 0 || string.compareTo("ApplicationType") == 0 || string.compareTo("EjbClientJars") == 0 || string.compareTo("JDBCName") == 0) {
                bl = true;
            }
            Property property = new Property(string, (String)this.currentParams.get(string), string, bl, false, false, true);
            arrayList.add(n2++, (Object)property);
        }
        propertyArray = (Property[])arrayList.toArray((Object[])new Property[arrayList.size()]);
        this.propConfPanel.setProperties(propertyArray);
        this.propConfPanel.sort();
        this.propConfPanel.refresh();
    }

    private void removeDeletedParameters() {
        this.propConfPanel.removeDeletedParameters(this.currentParams);
    }

    private final void setJdbcConnectionPanelEnabled(boolean bl) {
        this.dsNameField.setEnabled(bl);
        this.connTypeCombo.setEnabled(bl);
        this.dbConnTypeCombo.setEnabled(bl);
        this.userNameField.setEnabled(bl);
        this.urlField.setEnabled(bl);
    }

    private void setProperties(Property[] propertyArray) {
        this.propConfPanel.setProperties(propertyArray);
    }

    private final void showJdbcPanel(int n) {
        String string = jdbcPanelNames[n];
        CardLayout cardLayout = (CardLayout)this.jdbcConnPanel.getLayout();
        cardLayout.show(this.jdbcConnPanel, string);
    }

    private final boolean useDataSource() {
        return this.dbConnTypeCombo.getSelectedIndex() == 1;
    }

    private final boolean validateAndUpdateConnectionParams(Hashtable hashtable, boolean bl) {
        boolean bl2 = true;
        try {
            hashtable.remove("JDBCDataSource");
            hashtable.remove("JDBCName");
            hashtable.remove("IIOPName");
            hashtable.remove("HTTPName");
            boolean bl3 = this.connRequiredCheck.getModel().isSelected();
            if (this.useDataSource()) {
                String string = this.dsNameField.getText();
                if (string == null || string.length() <= 0) {
                    if (bl && bl3) {
                        ErrorHandler.displayError(this.parent, Res.getString(101));
                        boolean bl4 = false;
                        return bl4;
                    }
                } else if (bl3) {
                    hashtable.put("JDBCDataSource", string);
                }
            } else {
                String string = (String)this.connTypeCombo.getSelectedItem();
                if (string == null || string.length() <= 0) {
                    if (bl && bl3) {
                        ErrorHandler.displayError(this.parent, Res.getString(101));
                        boolean bl5 = false;
                        return bl5;
                    }
                } else if (bl3) {
                    this.updateConnectionParams(hashtable, string);
                }
                bl2 = true;
            }
        }
        catch (Exception exception) {
            if (bl) {
                ErrorHandler.displayError(this.parent, exception);
            }
            boolean bl6 = false;
            return bl6;
        }
        return bl2;
    }

    protected abstract void connTypeCombo_actionPerformed(ActionEvent var1);

    protected abstract void updateConnectionCombo(int var1);

    protected abstract void updateConnectionParams(Hashtable var1, String var2) throws IOException;

    public final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionDialogBase.this.dbConnType_actionPerformed(actionEvent);
        }
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionDialogBase.this.orbTypeCombo_actionPerformed(actionEvent);
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionDialogBase.this.connTypeCombo_actionPerformed(actionEvent);
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionDialogBase.this.connRequired_actionPerformed(actionEvent);
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionDialogBase.this.bc4jConNameCombo_actionPerformed(actionEvent);
        }
    }
}

