/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.io.FileDescriptor;
import java.net.InetAddress;

public class ChattySecurityManager
extends SecurityManager {
    private static final boolean ALLOW_ALL = false;
    private static String[] allowedProps = new String[]{"java.version", "java.class.version", "java.vendor", "java.vendor.url", "os.name", "os.version", "os.arch", "file.separator", "path.separator", "line.separator", "user.home", "user.language", "user.region", "user.timezone", "user.name", "file.encoding.pkg", "file.encoding", "impl.prefix", "socksProxyHost", "java.protocol.handler.pkgs", "jdbc.drivers", "fooeybarrrrrr"};

    public ChattySecurityManager() {
        System.out.println("Constructed Securitymanager " + System.getProperty("java.version"));
    }

    public void checkPropertyAccess(String string) {
        this.checkPropertyAccess(string, "");
    }

    public void checkPropertyAccess(String string, String string2) {
        if (string.startsWith("awt") || string.startsWith("sun") || string.startsWith("java")) {
            return;
        }
        int n = 0;
        while (n < allowedProps.length) {
            if (string.equals(allowedProps[n])) {
                return;
            }
            ++n;
        }
        ChattySecurityManager.t("denying PropertyAccess", string, string2);
        throw new SecurityException("propertyAccess '" + string + "' denied");
    }

    public void checkCreateClassLoader() {
        this.t("CreateClassLoader");
    }

    public void checkAccess(Thread thread) {
        ChattySecurityManager.t("Access", thread);
    }

    public void checkAccess(ThreadGroup threadGroup) {
        ChattySecurityManager.t("Access", threadGroup);
    }

    public void checkExit(int n) {
        this.t("Exit");
    }

    public void checkExec(String string) {
        ChattySecurityManager.t("Exec", string);
    }

    public void checkLink(String string) {
        ChattySecurityManager.t("Link", string);
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        ChattySecurityManager.t("Read", fileDescriptor);
    }

    public void checkRead(String string) {
        ChattySecurityManager.t("Read", string);
    }

    public void checkRead(String string, Object object) {
        ChattySecurityManager.t("Read", string);
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        ChattySecurityManager.t("Write", fileDescriptor);
    }

    public void checkWrite(String string) {
        ChattySecurityManager.t("Write", string);
    }

    public void checkDelete(String string) {
        ChattySecurityManager.t("Delete", string);
    }

    public void checkConnect(String string, int n) {
        ChattySecurityManager.t("Connect", string, new Integer(n));
    }

    public void checkConnect(String string, int n, Object object) {
        ChattySecurityManager.t("Connect", string, new Integer(n));
    }

    public void checkListen(int n) {
        ChattySecurityManager.t("Listen", new Integer(n));
    }

    public void checkAccept(String string, int n) {
        this.t("");
    }

    public void checkMulticast(InetAddress inetAddress) {
        ChattySecurityManager.t("Multicast", inetAddress);
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        ChattySecurityManager.t("Multicast", inetAddress, new Byte(by));
    }

    public void checkPropertiesAccess() {
        this.t("PropertiesAccess");
    }

    public boolean checkTopLevelWindow(Object object) {
        return true;
    }

    public void checkPrintJobAccess() {
        this.t("PrintJobAccess");
    }

    public void checkSystemClipboardAccess() {
        this.t("SystemClipboardAccess");
    }

    public void checkAwtEventQueueAccess() {
        this.t("AwtEventQueueAccess");
    }

    public void checkPackageAccess(String string) {
        ChattySecurityManager.t("PackageAccess", string);
    }

    public void checkPackageDefinition(String string) {
        ChattySecurityManager.t("PackageDefinition", string);
    }

    public void checkSetFactory() {
        this.t("SetFactory");
    }

    public void checkMemberAccess(Class clazz, int n) {
        ChattySecurityManager.t("MemberAccess", clazz, new Integer(n));
    }

    public void checkSecurityAccess(String string) {
        ChattySecurityManager.t("SecurityAccess", string);
    }

    private void t(String string) {
        ChattySecurityManager.t(string, "");
    }

    private static void t(String string, String string2) {
        System.out.println("check" + string + ": " + string2);
    }

    private static void t(String string, Object object) {
        ChattySecurityManager.t(string, object.toString());
    }

    private static void t(String string, Object object, Object object2) {
        ChattySecurityManager.t(string, object.toString() + "," + object2.toString());
    }
}

