/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.util.MenuUtils;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboExceptionHandler;
import oracle.jbo.JboWarning;
import oracle.jbo.ViewLink;
import oracle.jbo.ViewObject;
import oracle.jbo.jbotester.AMDialog;
import oracle.jbo.jbotester.AMTreeNode;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.ObjTreeNode;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.ResultWindow;
import oracle.jbo.jbotester.SimpleForm;
import oracle.jbo.jbotester.VLDialog;
import oracle.jbo.jbotester.VLTreeNode;
import oracle.jbo.jbotester.VODialog;
import oracle.jbo.jbotester.VOTreeNode;

public final class BaseTree
extends JScrollPane
implements JboExceptionHandler,
ChangeListener {
    private final TesterTreeCellRenderer cellRenderer;
    private final Action ctxMenuAction;
    private final Action keyEnterAction;
    private final JTree tree;

    private /* synthetic */ void $init$() {
        this.cellRenderer = new TesterTreeCellRenderer();
        this.ctxMenuAction = new ContextMenuAction();
        this.keyEnterAction = new KeyEnterAction();
    }

    public BaseTree() {
        this.$init$();
        this.tree = new JTree(new DefaultMutableTreeNode("AM"));
        this.tree.setEditable(false);
        this.tree.setAutoscrolls(true);
        this.tree.setToggleClickCount(5);
        this.tree.addMouseListener(new TreeMouseListener());
        this.tree.addTreeSelectionListener(new 1());
        ResultWindow.getResultWindow().addChangeListener(this);
        this.registerKeyboardAction(this.ctxMenuAction, KeyStroke.getKeyStroke(121, 1), 2);
        this.registerKeyboardAction(this.keyEnterAction, KeyStroke.getKeyStroke(10, 0), 2);
        this.setViewportView(this.tree);
    }

    public ObjTreeNode addChild(DefaultMutableTreeNode defaultMutableTreeNode, ObjTreeNode objTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        }
        defaultTreeModel.insertNodeInto(objTreeNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        return objTreeNode;
    }

    public void clearAll() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        if (defaultTreeModel != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot()) != null) {
            defaultMutableTreeNode.removeAllChildren();
            defaultTreeModel.reload();
        }
    }

    public void createDynViewObject() {
        ObjTreeNode objTreeNode = this.getSelection();
        if (objTreeNode == null) {
            return;
        }
        ObjTreeNode objTreeNode2 = objTreeNode.getParentOfType(0);
        if (objTreeNode2 == null) {
            return;
        }
        VODialog vODialog = new VODialog(MainFrame.getInstance(), (ApplicationModule)objTreeNode2.getData());
        vODialog.show();
        ViewObject viewObject = vODialog.getViewObject();
        if (viewObject == null) {
            return;
        }
        VOTreeNode vOTreeNode = new VOTreeNode(viewObject);
        this.addChild(objTreeNode2, vOTreeNode);
        this.tree.makeVisible(new TreePath(vOTreeNode.getPath()));
    }

    public void finishedProcessingPiggyback(Exception[] exceptionArray) {
    }

    public Object getSelectedObject() {
        ObjTreeNode objTreeNode = this.getSelection();
        if (objTreeNode == null) {
            return null;
        }
        return objTreeNode.getData();
    }

    public void handleException(Exception exception, boolean bl) {
        ErrorHandler.displayError((Frame)MainFrame.getInstance(), exception);
    }

    public void handleWarning(JboWarning jboWarning) {
        ErrorHandler.displayError((Frame)MainFrame.getInstance(), jboWarning.getMessage());
    }

    public ObjTreeNode insertChild(DefaultMutableTreeNode defaultMutableTreeNode, ObjTreeNode objTreeNode, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        }
        defaultTreeModel.insertNodeInto(objTreeNode, defaultMutableTreeNode, n);
        return objTreeNode;
    }

    public void nodeSelected(TreeSelectionEvent treeSelectionEvent) {
        ObjTreeNode objTreeNode = (ObjTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        MainFrame.getInstance().getStatusLine().setText(objTreeNode.getStatus());
    }

    public void reload(TreeNode treeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.reload(treeNode);
    }

    public void removeFromParent(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
    }

    public void setAppModule(ApplicationModule applicationModule) {
        this.tree.setCellRenderer(this.cellRenderer);
        applicationModule.setExceptionHandler((JboExceptionHandler)this);
        AMTreeNode aMTreeNode = new AMTreeNode(applicationModule);
        this.tree.setModel(new DefaultTreeModel(aMTreeNode));
        this.createAppModuleChildren(aMTreeNode);
        this.selectNode(aMTreeNode);
        this.requestFocus();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ResultWindow resultWindow;
        SimpleForm simpleForm;
        if (changeEvent.getSource() instanceof ResultWindow && (simpleForm = (SimpleForm)(resultWindow = (ResultWindow)changeEvent.getSource()).getSelectedTab()) != null) {
            this.selectNode(simpleForm.getTreeNode());
        }
    }

    private void createAppModuleChildren(AMTreeNode aMTreeNode) {
        ApplicationModule applicationModule = (ApplicationModule)aMTreeNode.getData();
        Object[] objectArray = applicationModule.getViewObjectNames(true, true);
        Arrays.sort(objectArray);
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < objectArray.length) {
            if (!hashMap.containsKey(objectArray[n])) {
                this.descendViewObject((String)objectArray[n], applicationModule, aMTreeNode, hashMap, arrayList);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.tree.makeVisible(new TreePath(((ObjTreeNode)arrayList.get(n2)).getPath()));
            ++n2;
        }
        String[] stringArray = applicationModule.getApplicationModuleNames(true, true);
        int n3 = 0;
        while (n3 < stringArray.length) {
            ApplicationModule applicationModule2 = applicationModule.findApplicationModule(stringArray[n3]);
            if (applicationModule2 != null) {
                AMTreeNode aMTreeNode2 = new AMTreeNode(applicationModule2);
                this.addChild(aMTreeNode, aMTreeNode2);
                this.createAppModuleChildren(aMTreeNode2);
            }
            ++n3;
        }
    }

    private VOTreeNode descendViewObject(String string, ApplicationModule applicationModule, ObjTreeNode objTreeNode, HashMap hashMap, ArrayList arrayList) {
        VOTreeNode vOTreeNode = new VOTreeNode(applicationModule, string);
        boolean bl = true;
        String[] stringArray = applicationModule.getViewLinkNames(true, true);
        int n = 0;
        while (n < stringArray.length) {
            ViewLink viewLink = applicationModule.findViewLink(stringArray[n]);
            if (string.equals(viewLink.getSource().getName())) {
                bl = false;
                VLTreeNode vLTreeNode = new VLTreeNode(applicationModule, viewLink);
                vOTreeNode.add(vLTreeNode);
                String string2 = viewLink.getDestination().getName();
                VOTreeNode vOTreeNode2 = (VOTreeNode)hashMap.get((Object)string2);
                if (vOTreeNode2 == null) {
                    vOTreeNode2 = this.descendViewObject(string2, applicationModule, vLTreeNode, hashMap, arrayList);
                } else {
                    if (((ObjTreeNode)vOTreeNode2.getParent()).getType() == 2) {
                        vOTreeNode2 = new VOTreeNode(applicationModule, viewLink.getDestination());
                    } else {
                        objTreeNode = (ObjTreeNode)vOTreeNode2.getParent();
                    }
                    vLTreeNode.add(vOTreeNode2);
                    arrayList.add((Object)vOTreeNode2);
                }
            }
            ++n;
        }
        objTreeNode.add(vOTreeNode);
        if (bl) {
            arrayList.add((Object)vOTreeNode);
        }
        hashMap.put((Object)string, (Object)vOTreeNode);
        return vOTreeNode;
    }

    private ObjTreeNode getSelection() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            return (ObjTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    private ObjTreeNode hitTest(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.tree.getRowForLocation(point.x, point.y);
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        if (n != -1) {
            return (ObjTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    private void processEnterKey() {
        ObjTreeNode objTreeNode = this.getSelection();
        if (objTreeNode != null) {
            objTreeNode.showForm();
        }
    }

    private void processTreeMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1) {
            return;
        }
        ObjTreeNode objTreeNode = this.hitTest(mouseEvent);
        if (objTreeNode == null) {
            return;
        }
        objTreeNode.showForm();
    }

    private void selectNode(ObjTreeNode objTreeNode) {
        this.tree.setSelectionPath(new TreePath(objTreeNode.getPath()));
    }

    void createApplicationModule() {
        ObjTreeNode objTreeNode = this.getSelection();
        if (objTreeNode == null) {
            return;
        }
        this.createApplicationModule(objTreeNode);
    }

    void createApplicationModule(ObjTreeNode objTreeNode) {
        ObjTreeNode objTreeNode2 = objTreeNode.getParentOfType(0);
        if (objTreeNode2 == null) {
            return;
        }
        AMDialog aMDialog = new AMDialog(MainFrame.getInstance(), (ApplicationModule)objTreeNode2.getData());
        aMDialog.show();
        ApplicationModule applicationModule = aMDialog.getApplicationModule();
        if (applicationModule == null) {
            return;
        }
        AMTreeNode aMTreeNode = new AMTreeNode(applicationModule);
        this.addChild(objTreeNode2, aMTreeNode);
        this.tree.makeVisible(new TreePath(aMTreeNode.getPath()));
        this.createAppModuleChildren(aMTreeNode);
    }

    void createDynViewLink() {
        ObjTreeNode objTreeNode = this.getSelection();
        if (objTreeNode == null) {
            return;
        }
        ObjTreeNode objTreeNode2 = objTreeNode.getParentOfType(0);
        if (objTreeNode2 == null) {
            return;
        }
        ApplicationModule applicationModule = (ApplicationModule)objTreeNode2.getData();
        if (applicationModule.getViewObjectNames().length <= 1) {
            ErrorHandler.displayError((Frame)MainFrame.getInstance(), Res.getString(192));
            return;
        }
        VLDialog vLDialog = new VLDialog(MainFrame.getInstance(), applicationModule);
        vLDialog.show();
        ViewLink viewLink = vLDialog.getViewLink();
        if (viewLink == null) {
            return;
        }
        VLTreeNode vLTreeNode = new VLTreeNode(viewLink);
        VOTreeNode vOTreeNode = (VOTreeNode)objTreeNode2.getChildOfName(viewLink.getDestination().getName());
        this.removeFromParent(vOTreeNode);
        vLTreeNode.add(vOTreeNode);
        VOTreeNode vOTreeNode2 = (VOTreeNode)objTreeNode2.getChildOfName(viewLink.getSource().getName());
        this.addChild(vOTreeNode2, vLTreeNode);
        this.tree.makeVisible(new TreePath(vOTreeNode2.getPath()));
        this.tree.makeVisible(new TreePath(vLTreeNode.getPath()));
        this.tree.makeVisible(new TreePath(vOTreeNode.getPath()));
    }

    private final class ContextMenuAction
    extends AbstractAction {
        public ContextMenuAction() {
            super("ctxMenu");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPopupMenu jPopupMenu;
            ObjTreeNode objTreeNode = BaseTree.this.getSelection();
            if (objTreeNode != null && (jPopupMenu = objTreeNode.getMenu()) != null) {
                MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)((Component)actionEvent.getSource()), (int)10, (int)10);
            }
        }
    }

    private final class KeyEnterAction
    extends AbstractAction {
        public KeyEnterAction() {
            super("keyEnterAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BaseTree.this.processEnterKey();
        }
    }

    private class TesterTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            try {
                ObjTreeNode objTreeNode = (ObjTreeNode)object;
                if (objTreeNode != null) {
                    ImageIcon imageIcon = objTreeNode.getIcon();
                    if (imageIcon != null) {
                        this.setIcon(imageIcon);
                    }
                } else if (bl3) {
                    this.setIcon(this.getDefaultOpenIcon());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
    }

    private final class TreeMouseListener
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            BaseTree.this.processTreeMouseClicked(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.checkIsPopupTrigger(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkIsPopupTrigger(mouseEvent);
        }

        private void checkIsPopupTrigger(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            ObjTreeNode objTreeNode;
            if (mouseEvent.isPopupTrigger() && (objTreeNode = BaseTree.this.hitTest(mouseEvent)) != null && (jPopupMenu = objTreeNode.getMenu()) != null) {
                Point point = mouseEvent.getPoint();
                TreePath treePath = BaseTree.this.tree.getPathForLocation(point.x, point.y);
                BaseTree.this.tree.setSelectionPath(treePath);
                MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)BaseTree.this.tree, (int)point.x, (int)point.y);
            }
        }

        private TreeMouseListener() {
        }
    }

    public final class 1
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            BaseTree.this.nodeSelected(treeSelectionEvent);
        }
    }
}

