/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Frame;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import oracle.jbo.ApplicationModule;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.ObjTreeNode;
import oracle.jbo.jbotester.Res;
import oracle.jbo.jbotester.properties.ApplicationModuleBean;

public final class AMTreeNode
extends ObjTreeNode {
    ApplicationModule am;
    static ImageIcon icon;

    public AMTreeNode(ApplicationModule applicationModule) {
        super(applicationModule.getName());
        this.am = applicationModule;
        if (icon == null) {
            icon = JboTesterUtil.getIcon("NodeAMU.gif");
        }
    }

    public String getName() {
        return this.am.getName();
    }

    public String getFullName() {
        return this.am.getFullName();
    }

    public int getType() {
        return 0;
    }

    public Object getData() {
        return this.am;
    }

    public void setData(Object object) {
        this.am = (ApplicationModule)object;
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public void remove() {
        if (this.isRoot()) {
            ErrorHandler.displayError((Frame)MainFrame.getInstance(), Res.getString(193));
            return;
        }
        super.remove();
        this.am.remove();
        this.am = null;
    }

    public JPopupMenu getMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenu jMenu = MainFrame.createMenu(11);
            jMenu.add(ObjTreeNode.createAMAction);
            jMenu.add(ObjTreeNode.createVOAction);
            jMenu.add(ObjTreeNode.createVLAction);
            this.popupMenu.add(jMenu);
            if (this.removeAction == null) {
                this.removeAction = new ObjTreeNode.RemoveAction(this);
            }
            this.popupMenu.add(this.removeAction);
            this.popupMenu.addSeparator();
            this.popupMenu.add(new ObjTreeNode.PropertiesAction(this));
        }
        this.removeAction.setEnabled(this.isRoot() ^ true);
        return this.popupMenu;
    }

    public String getStatus() {
        if (this.am == null) {
            return " ";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Res.getString(194));
        stringBuffer.append(this.am.getFullName());
        stringBuffer.append(Res.getString(195));
        stringBuffer.append(this.am.getDefFullName());
        return stringBuffer.toString();
    }

    public void showProperties() {
        ApplicationModuleBean applicationModuleBean = new ApplicationModuleBean(this.am);
        this.showPropertyDialog(applicationModuleBean, applicationModuleBean.getBeanInfo(), 189);
    }
}

