/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.uix;

import oracle.jbo.domain.Array;

public final class PrimitiveTypes {
    private static final Class _ARRAY_CLASS = PrimitiveTypes._loadClass("oracle.jbo.domain.Array");
    private static final Class _ROWID_CLASS = PrimitiveTypes._loadClass("oracle.jbo.domain.RowID");
    private static final Class _STRUCT_CLASS = PrimitiveTypes._loadClass("oracle.jbo.domain.Struct");
    private static final Class _CLOB_CLASS = PrimitiveTypes._loadClass("oracle.jbo.domain.ClobDomain");
    private static final Class _TIMESTAMP_CLASS = PrimitiveTypes._loadClass("oracle.jbo.domain.Timestamp");
    private static /* synthetic */ Class class$java$lang$String;
    private static /* synthetic */ Class class$oracle$ord$im$OrdDomainIOInterface;
    private static /* synthetic */ Class class$oracle$jbo$domain$Number;
    private static /* synthetic */ Class class$java$lang$Number;
    private static /* synthetic */ Class class$oracle$jbo$domain$Date;
    private static /* synthetic */ Class class$java$util$Date;
    private static /* synthetic */ Class class$java$lang$Boolean;

    public static boolean isBoolean(Class clazz) {
        Class clazz2 = class$java$lang$Boolean;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Boolean = PrimitiveTypes.class$("java.lang.Boolean");
        }
        return clazz2.equals(clazz) || Boolean.TYPE.equals(clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDate(Class clazz) {
        if (clazz == null) {
            return false;
        }
        Class clazz2 = class$oracle$jbo$domain$Date;
        if (clazz2 == null) {
            clazz2 = class$oracle$jbo$domain$Date = PrimitiveTypes.class$("oracle.jbo.domain.Date");
        }
        if (clazz2.isAssignableFrom(clazz)) return true;
        Class clazz3 = class$java$util$Date;
        if (clazz3 == null) {
            clazz3 = class$java$util$Date = PrimitiveTypes.class$("java.util.Date");
        }
        if (clazz3.isAssignableFrom(clazz)) return true;
        if (PrimitiveTypes.isTimestamp(clazz)) return true;
        return false;
    }

    public static boolean isTimestamp(Class clazz) {
        return PrimitiveTypes._instanceOf(clazz, _TIMESTAMP_CLASS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNumber(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            if (Integer.TYPE.equals(clazz)) return true;
            if (Double.TYPE.equals(clazz)) return true;
            if (Long.TYPE.equals(clazz)) return true;
            if (Float.TYPE.equals(clazz)) return true;
            if (Byte.TYPE.equals(clazz)) return true;
            if (Short.TYPE.equals(clazz)) return true;
            return false;
        }
        Class clazz2 = class$oracle$jbo$domain$Number;
        if (clazz2 == null) {
            clazz2 = class$oracle$jbo$domain$Number = PrimitiveTypes.class$("oracle.jbo.domain.Number");
        }
        if (clazz2.isAssignableFrom(clazz)) return true;
        Class clazz3 = class$java$lang$Number;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Number = PrimitiveTypes.class$("java.lang.Number");
        }
        if (clazz3.isAssignableFrom(clazz)) return true;
        return false;
    }

    public static boolean isMedia(Class clazz) {
        if (clazz == null) {
            return false;
        }
        Class clazz2 = class$oracle$ord$im$OrdDomainIOInterface;
        if (clazz2 == null) {
            clazz2 = class$oracle$ord$im$OrdDomainIOInterface = PrimitiveTypes.class$("oracle.ord.im.OrdDomainIOInterface");
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean isRowID(Class clazz) {
        return PrimitiveTypes._instanceOf(clazz, _ROWID_CLASS);
    }

    public static boolean isArray(Class clazz) {
        if (clazz == null || _ARRAY_CLASS == null) {
            return false;
        }
        return clazz.isArray() || _ARRAY_CLASS.isAssignableFrom(clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isString(Class clazz) {
        if (clazz == null) return true;
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = PrimitiveTypes.class$("java.lang.String");
        }
        if (clazz2.equals(clazz)) return true;
        return false;
    }

    public static boolean isPrimitive(Class clazz) {
        return PrimitiveTypes.isString(clazz) || clazz.isPrimitive() || PrimitiveTypes.isBoolean(clazz) || PrimitiveTypes.isDate(clazz) || PrimitiveTypes.isNumber(clazz) || PrimitiveTypes.isRowID(clazz) || PrimitiveTypes.isClob(clazz) || PrimitiveTypes.isMedia(clazz);
    }

    public static boolean isComposite(Class clazz) {
        return (PrimitiveTypes.isPrimitive(clazz) || PrimitiveTypes.isArray(clazz)) ^ true;
    }

    public static boolean isStruct(Class clazz) {
        return PrimitiveTypes._instanceOf(clazz, _STRUCT_CLASS);
    }

    public static boolean isClob(Class clazz) {
        return PrimitiveTypes._instanceOf(clazz, _CLOB_CLASS);
    }

    public static Object[] getArray(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return (Object[])object;
        }
        Array array = (Array)object;
        return array.getArray();
    }

    private static boolean _instanceOf(Class clazz, Class clazz2) {
        return clazz != null && clazz2 != null && clazz2.isAssignableFrom(clazz);
    }

    private static Class _loadClass(String string) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz = null;
            return clazz;
        }
    }

    private PrimitiveTypes() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

