/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j;

import java.util.HashMap;
import java.util.Map;
import org.krysalis.barcode4j.BarcodeClassResolver;

public class DefaultBarcodeClassResolver
implements BarcodeClassResolver {
    private Map classes;

    public DefaultBarcodeClassResolver() {
        this.registerBarcodeClass("codabar", "org.krysalis.barcode4j.impl.codabar.Codabar");
        this.registerBarcodeClass("code39", "org.krysalis.barcode4j.impl.code39.Code39");
        this.registerBarcodeClass("code128", "org.krysalis.barcode4j.impl.code128.Code128");
        this.registerBarcodeClass("2of5", "org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5");
        this.registerBarcodeClass("intl2of5", "org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5");
        this.registerBarcodeClass("interleaved2of5", "org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5");
        this.registerBarcodeClass("ean-13", "org.krysalis.barcode4j.impl.upcean.EAN13");
        this.registerBarcodeClass("ean13", "org.krysalis.barcode4j.impl.upcean.EAN13");
        this.registerBarcodeClass("ean-8", "org.krysalis.barcode4j.impl.upcean.EAN8");
        this.registerBarcodeClass("ean8", "org.krysalis.barcode4j.impl.upcean.EAN8");
        this.registerBarcodeClass("upc-a", "org.krysalis.barcode4j.impl.upcean.UPCA");
        this.registerBarcodeClass("upca", "org.krysalis.barcode4j.impl.upcean.UPCA");
        this.registerBarcodeClass("upc-e", "org.krysalis.barcode4j.impl.upcean.UPCE");
        this.registerBarcodeClass("upce", "org.krysalis.barcode4j.impl.upcean.UPCE");
        this.registerBarcodeClass("postnet", "org.krysalis.barcode4j.impl.postnet.POSTNET");
    }

    public void registerBarcodeClass(String name, String classname) {
        if (this.classes == null) {
            this.classes = new HashMap();
        }
        this.classes.put(name.toLowerCase(), classname);
    }

    public Class resolve(String name) throws ClassNotFoundException {
        String clazz = null;
        if (this.classes != null) {
            clazz = (String)this.classes.get(name.toLowerCase());
        }
        if (clazz == null) {
            clazz = name;
        }
        Class<?> cl = Class.forName(clazz);
        return cl;
    }

    public Class resolveBean(String name) throws ClassNotFoundException {
        String clazz = null;
        if (this.classes != null) {
            clazz = (String)this.classes.get(name.toLowerCase());
        }
        if (clazz == null) {
            clazz = name;
        }
        Class<?> cl = Class.forName(clazz + "Bean");
        return cl;
    }
}

