/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.providers.rad;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.CredentialNotFoundException;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.spi.CredentialProvisioning;
import oracle.adf.share.security.credentialstore.spi.GenericCredentialStore;
import oracle.adf.share.security.providers.rad.OracleDBCredential;
import oracle.adf.share.security.resource.ADFSecurityMessageBundle;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.User;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class RADCredentialStore
extends GenericCredentialStore
implements CredentialProvisioning {
    public static String CREDENTIAL_TYPE_ORACLEDB = "OracleDB";
    public static String CREDENTIAL_TYPE_USER = "UserProperties";
    private InitialDirContext dirContext;
    private static String PROP_LOCATION = "location";
    private static String PROP_LDAP_USER = "ldap.user";
    private static String PROP_LDAP_PASSWORD = "ldap.password";
    private static String PROP_LDAP_COMMON_NAME = "cn";
    private static String PROP_LDAP_DOMAIN_CONTROL = "dc";
    private static String PROP_LDAP_ORGANIZATIONAL_UNIT = "ou";
    private static String PROP_LDAP_ORGANIZATION = "o";
    private static final String INIT_CTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private String host;
    private String location;
    private String ldap_cn;
    private String ldap_user;
    private String ldap_password;
    private User _ldapUser;
    private String[] _extProperties;

    private /* synthetic */ void $init$() {
        this.dirContext = null;
        this._ldapUser = null;
        this._extProperties = new String[]{OracleDBCredential.USERID_ATTRIBUTE, OracleDBCredential.PASSWORD_ATTRIBUTE, OracleDBCredential.RESOURCE_NAME, OracleDBCredential.RESOURCETYPE_NAME, OracleDBCredential.FLEX_ATTRIBUTE1, OracleDBCredential.FLEX_ATTRIBUTE2, OracleDBCredential.FLEX_ATTRIBUTE3};
    }

    private void setInitialContext() throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", INIT_CTX);
        hashtable.put("java.naming.provider.url", this.host);
        hashtable.put("java.naming.security.principal", this.ldap_cn);
        hashtable.put("java.naming.security.credentials", this.ldap_password);
        this.dirContext = new InitialDirContext(hashtable);
    }

    public void initialize(Hashtable hashtable) {
        this.location = (String)hashtable.get("oracle.adf.security.credentialstore.location");
        this.host = "ldap://" + this.location;
        String string = "";
        int n = this.location.indexOf(":");
        if (n > 0) {
            string = this.location.substring(n + 1);
            this.location = this.location.substring(0, n);
        }
        this.ldap_cn = PROP_LDAP_COMMON_NAME + "=" + (String)hashtable.get(PROP_LDAP_COMMON_NAME);
        this.ldap_user = (String)hashtable.get(PROP_LDAP_USER);
        this.ldap_password = (String)hashtable.get(PROP_LDAP_PASSWORD);
        System.out.println("location = " + this.location);
        System.out.println("port = " + string);
        System.out.println(" cn = " + this.ldap_cn);
        System.out.println(" pwd = " + this.ldap_password);
        try {
            this.setInitialContext();
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80101"));
        }
        try {
            String string2 = PROP_LDAP_DOMAIN_CONTROL + "=" + this.location + "," + PROP_LDAP_DOMAIN_CONTROL + "=com";
            this._ldapUser = new User((DirContext)this.dirContext, Util.IDTYPE_SIMPLE, this.ldap_user, Util.IDTYPE_DN, string2, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80101"));
        }
    }

    public void storeCredential(Credential credential, String string) {
        this.storeCredentialForUser(credential, string, this._ldapUser);
    }

    void storeCredentialForUser(Credential credential, String string, User user) {
        Credential credential2 = this.fetchCredentialForUser(string, user);
        try {
            ModPropertySet modPropertySet = new ModPropertySet();
            Set set = credential.getPropertyNames();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = credential.getProperty(string2);
                modPropertySet.addProperty(5, string2, string3);
            }
            if (credential.getProperty(OracleDBCredential.RESOURCETYPE_NAME) == null) {
                modPropertySet.addProperty(this.getAttributeChangeType(credential2, OracleDBCredential.RESOURCETYPE_NAME), OracleDBCredential.RESOURCETYPE_NAME, CREDENTIAL_TYPE_USER);
            }
            if (credential.getProperty(OracleDBCredential.RESOURCE_NAME) == null) {
                modPropertySet.addProperty(this.getAttributeChangeType(credential2, OracleDBCredential.RESOURCE_NAME), OracleDBCredential.RESOURCE_NAME, string);
            }
            if (credential2 == null) {
                user.createExtendedProperties((DirContext)this.dirContext, User.EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR, modPropertySet);
            } else {
                user.setExtendedProperties((DirContext)this.dirContext, User.EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR, OracleDBCredential.RESOURCE_NAME + "=" + string, modPropertySet);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80102", new Object[]{string}));
        }
    }

    public void storeSerializableCredential(Serializable serializable, String string, Principal principal) {
        throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80108"));
    }

    public Credential fetchCredential(String string) {
        String string2;
        Credential credential = this.fetchCredentialForUser(string, this._ldapUser);
        if (credential == null && (string2 = this.getApplicationUserName()) != null) {
            try {
                User user = this.getLDAPUser(string2);
                credential = this.fetchCredentialForUser(string, user);
            }
            catch (ADFSecurityRuntimeException aDFSecurityRuntimeException) {
                // empty catch block
            }
        }
        if (credential == null) {
            throw new CredentialNotFoundException(ADFSecurityMessageBundle.getString("80106", new Object[]{string}));
        }
        return credential;
    }

    Credential fetchCredentialForUser(String string, User user) {
        String string2 = string != null ? string : null;
        try {
            PropertySetCollection propertySetCollection = user.getExtendedProperties((DirContext)this.dirContext, User.EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR, this._extProperties, OracleDBCredential.RESOURCE_NAME + "=" + string);
            int n = 0;
            if (n < propertySetCollection.size()) {
                Credential credential = this.credentialProperties(propertySetCollection.getPropertySet(n));
                return credential;
            }
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
        return null;
    }

    public Serializable fetchSerializableCredential(String string) {
        throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80108"));
    }

    ArrayList fetchCredentials() {
        ArrayList<Credential> arrayList = new ArrayList<Credential>();
        try {
            PropertySetCollection propertySetCollection = this._ldapUser.getExtendedProperties((DirContext)this.dirContext, User.EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR, this._extProperties, OracleDBCredential.RESOURCETYPE_NAME + "=*");
            int n = 0;
            while (n < propertySetCollection.size()) {
                arrayList.add(this.credentialProperties(propertySetCollection.getPropertySet(n)));
                ++n;
            }
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80104"));
        }
        return arrayList;
    }

    public void removeCredential(String string) {
        this.removeCredentialForUser(string, this._ldapUser);
    }

    void removeCredentialForUser(String string, User user) {
        String string2 = string;
        try {
            PropertySetCollection propertySetCollection = user.getExtendedProperties((DirContext)this.dirContext, User.EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR, this._extProperties, OracleDBCredential.RESOURCE_NAME + "=" + string);
            int n = 0;
            while (n < propertySetCollection.size()) {
                Util.ldapDelete((DirContext)this.dirContext, (String)propertySetCollection.getPropertySet(n).getDN());
                ++n;
            }
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80105", new Object[]{string}));
        }
    }

    public void storeCredential(Credential credential, String string, Principal principal) {
        block0: {
            User user = this.getLDAPUser(principal.getName());
            if (user == null) break block0;
            this.storeCredentialForUser(credential, string, user);
        }
    }

    public void removeCredential(String string, Principal principal) {
        User user = this.getLDAPUser(principal.getName());
        if (user == null) {
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80100"));
        }
        this.removeCredentialForUser(string, user);
    }

    User getLDAPUser(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            String string2 = PROP_LDAP_DOMAIN_CONTROL + "=" + this.location + "," + PROP_LDAP_DOMAIN_CONTROL + "=com";
            User user = new User((DirContext)this.dirContext, Util.IDTYPE_SIMPLE, string, Util.IDTYPE_DN, string2, true);
            return user;
        }
        catch (Exception exception) {
            throw new ADFSecurityRuntimeException(exception);
        }
    }

    Credential credentialProperties(PropertySet propertySet) {
        OracleDBCredential oracleDBCredential = new OracleDBCredential();
        String[] stringArray = propertySet.getAttributeNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            Property property = propertySet.getProperty(string);
            String string2 = property.getName();
            int n2 = 0;
            while (n2 < property.size()) {
                oracleDBCredential.put(string2, (String)property.getValue(n2));
                ++n2;
            }
            ++n;
        }
        return oracleDBCredential;
    }

    int getAttributeChangeType(Credential credential, String string) {
        if (credential != null && credential.getProperty(string) != null) {
            return 7;
        }
        return 5;
    }

    public RADCredentialStore() {
        this.$init$();
    }
}

