/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.providers.jazn;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.Hashtable;
import java.util.logging.Level;
import oracle.adf.share.ADFContext;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.providers.jazn.JAZNCredentialStore;
import oracle.adf.share.security.providers.jazn.JAZNIdentityManagementProvider;
import oracle.adf.share.security.providers.jazn.JAZNPolicyProvider;
import oracle.adf.share.security.resource.ADFSecurityMessageBundle;
import oracle.security.jazn.JAZNConfig;
import oracle.security.jazn.JAZNException;
import oracle.security.jazn.action.GetJAZNConfigPropertyAction;
import oracle.security.jazn.action.GetSystemPropertyAction;
import oracle.security.jazn.action.SetSystemPropertyAction;
import oracle.security.jazn.policy.PermissionClassManager;
import oracle.security.jazn.realm.Realm;
import oracle.security.jazn.realm.RealmManager;
import oracle.security.jazn.realm.RealmRole;
import oracle.security.jazn.realm.RoleManager;
import oracle.security.jazn.util.Env;

public class JAZNContextHelper {
    private static JAZNContextHelper _singleton;
    private static final Object __LOCK__;
    private static ADFLogger _adfSecLogger;
    private static JAZNConfig _config;
    private static RealmManager _realmMgr;
    private static PermissionClassManager _permClsMgr;
    private static JAZNPolicyProvider _policyMgr;
    private static JAZNIdentityManagementProvider _identityMgr;
    private static JAZNCredentialStore _credentialStore;
    static final String JAZN_CONFIG = "oracle.security.jazn.config";
    static final String OC4J_JAR = "oc4j.jar";
    static final String JAZN_JAR = "jazn.jar";
    static final String JAZN_XML = "jazn.xml";
    static final String ADFS_JAZN_JAR = "adfs-jazn.jar";
    static final String APPLICATION_JAZNCONFIG = "/META-INF/jazn.xml";
    static final String APPLICATION_CONFIG = "/META-INF/orion-application.xml";
    static final String OC4JCONFIG_CLASS = "oracle.jdeveloper.xml.oc4j.Oc4jConfigAdmin";
    private static String _configStr;
    private static String _embeddedConfigPath;
    private static ProtectionDomain _thisPD;
    private static boolean _setJAZNProps;
    private static boolean _jClient;
    private static boolean _dualUpdate;
    private static boolean _useHomeConfig;
    private static boolean _refreshConfig;
    static final String EMBEDDED_CONFIG_FILENAME = "/system-application.xml";
    private static final String FILE_SEPARATOR;

    public static JAZNContextHelper getInstance() {
        return JAZNContextHelper.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAZNContextHelper getInstance(Hashtable hashtable) {
        Object object = __LOCK__;
        synchronized (object) {
            if (_singleton == null) {
                JAZNContextHelper jAZNContextHelper = new JAZNContextHelper();
                jAZNContextHelper.refresh(hashtable);
                if (_config != null) {
                    _singleton = jAZNContextHelper;
                    JAZNContextHelper jAZNContextHelper2 = jAZNContextHelper;
                    return jAZNContextHelper2;
                }
                JAZNContextHelper jAZNContextHelper3 = null;
                return jAZNContextHelper3;
            }
            JAZNContextHelper.refreshJAZNContext();
        }
        return _singleton;
    }

    public void initialize(Hashtable hashtable) {
        this.refresh(hashtable);
    }

    public JAZNPolicyProvider getPolicyProvider() {
        if (_policyMgr == null) {
            _policyMgr = new JAZNPolicyProvider(this);
        }
        return _policyMgr;
    }

    public void setIdentityManagementProvider(JAZNIdentityManagementProvider jAZNIdentityManagementProvider) {
        _identityMgr = jAZNIdentityManagementProvider;
    }

    public JAZNIdentityManagementProvider getIdentityManagementProvider() {
        if (_identityMgr == null) {
            _identityMgr = new JAZNIdentityManagementProvider(this);
        }
        return _identityMgr;
    }

    public void setCredentialStore(JAZNCredentialStore jAZNCredentialStore) {
        _credentialStore = jAZNCredentialStore;
    }

    static void setLoginConfig(String string) {
        _configStr = string;
    }

    static void setLoginConfigSystemProperty() {
        if (_configStr != null) {
            return;
        }
        _adfSecLogger.log(Level.FINE, "Setting JAZN Config property ...");
        try {
            _configStr = System.getProperty(JAZN_CONFIG);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refresh(Hashtable hashtable) {
        JAZNContextHelper.refreshJAZNContext();
        JAZNContextHelper.setLoginConfigSystemProperty();
        if (_configStr != null) {
            try {
                _config = new JAZNConfig(_configStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_config == null) {
            try {
                _config = JAZNConfig.getOC4JInstanceConfig();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80109"));
            }
        }
        if (_config.getProviderType().equals(Env.PROVIDER_TYPE_LDAP)) {
            JAZNContextHelper.setSystemProperties();
        }
        try {
            _realmMgr = _config.getRealmManager();
            if (_realmMgr == null) {
                _adfSecLogger.log(Level.INFO, "RealmManager not found!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Security.setProperty("auth.policy.provider", "oracle.security.jazn.spi.PolicyProvider");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JAZNConfig getJAZNConfig() {
        return _config;
    }

    public JAZNConfig getEmbeddedJAZNConfig() {
        return this.getEmbeddedConfig();
    }

    static void validateJAZNConfig() {
        if (_config == null) {
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80109"));
        }
    }

    public String getDefaultRealmName() {
        JAZNContextHelper.validateJAZNConfig();
        return _config.getDefaultRealm();
    }

    public static PermissionClassManager getPermissionClassManager() {
        if (_permClsMgr == null) {
            _permClsMgr = _config.getPermissionClassManager();
        }
        return _permClsMgr;
    }

    public static RealmManager getRealmManager() {
        JAZNContextHelper.validateJAZNConfig();
        return _config.getRealmManager();
    }

    public Realm getDefaultRealm() {
        JAZNContextHelper.validateJAZNConfig();
        Realm realm = null;
        try {
            realm = _realmMgr.getRealm(this.getDefaultRealmName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return realm;
    }

    RealmRole getRealmRole(String string) {
        return this.getRealmRole(string, _config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RealmRole getRealmRole(String string, JAZNConfig jAZNConfig) {
        RealmRole realmRole = null;
        try {
            Realm realm = jAZNConfig.getRealmManager().getRealm(jAZNConfig.getDefaultRealm());
            RoleManager roleManager = realm.getRoleManager();
            realmRole = roleManager.getRole(string);
            if (realmRole != null) return realmRole;
        }
        catch (JAZNException jAZNException) {
            jAZNException.printStackTrace();
        }
        return realmRole;
    }

    void persistJAZNData() {
        this.persistJAZNData(null);
    }

    void persistJAZNData(JAZNConfig jAZNConfig) {
        try {
            if (_useHomeConfig) {
                _config.getJAZNProvider().persist();
            }
            if (jAZNConfig != null && jAZNConfig != _config) {
                jAZNConfig.getJAZNProvider().persist();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ADFLogger getADFSecurityLogger() {
        return _adfSecLogger;
    }

    String findJAZNConfig() {
        String string = APPLICATION_CONFIG;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            string = APPLICATION_JAZNCONFIG;
            uRL = classLoader.getResource(string);
        }
        if (uRL != null) {
            String string2 = uRL.getPath();
            int n = string2.indexOf("!/");
            if (n > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2.substring(0, n - 1));
                stringBuffer.append(string);
                string2 = stringBuffer.toString();
            }
            _adfSecLogger.log(Level.FINE, "JAZN Config path ..." + string2);
            return string2;
        }
        return null;
    }

    static void refreshJAZNContext() {
        _jClient = false;
        _refreshConfig = true;
    }

    static void setSystemProperties() {
        if (_setJAZNProps) {
            return;
        }
        if (JAZNContextHelper.getSystemJAZNProperty(Env.LDAP_CACHE_POLICY_ENABLE, null) == null) {
            JAZNContextHelper._setSystemProperty(Env.LDAP_CACHE_POLICY_ENABLE, "false");
        }
        if (JAZNContextHelper.getSystemJAZNProperty(Env.LDAP_CACHE_REALM_ENABLE, null) == null) {
            JAZNContextHelper._setSystemProperty(Env.LDAP_CACHE_REALM_ENABLE, "false");
        }
        if (JAZNContextHelper.getSystemJAZNProperty(Env.LDAP_CACHE_SESSION_ENABLE, null) == null) {
            JAZNContextHelper._setSystemProperty(Env.LDAP_CACHE_SESSION_ENABLE, "false");
        }
        String string = JAZNContextHelper.getSystemJAZNProperty(Env.LDAP_CACHE_POLICY_ENABLE, null);
        _setJAZNProps = true;
    }

    static String getSystemJAZNProperty(String string, String string2) {
        String string3 = JAZNContextHelper.getSystemProperty(string, null);
        if (string3 == null) {
            string3 = JAZNContextHelper.getJAZNProperty(string, string2);
        }
        return string3;
    }

    private static String getSystemProperty(String string, String string2) {
        return (String)AccessController.doPrivileged(new GetSystemPropertyAction(string, string2));
    }

    private static String _setSystemProperty(String string, String string2) {
        return (String)AccessController.doPrivileged(new SetSystemPropertyAction(string, string2));
    }

    private static String getJAZNProperty(String string, String string2) {
        return (String)AccessController.doPrivileged(new GetJAZNConfigPropertyAction(JAZNConfig.getJAZNConfig(), string, string2));
    }

    private String getEmbeddedConfigPath() {
        if (_refreshConfig || !_jClient && _embeddedConfigPath == null) {
            try {
                String string;
                Hashtable<?, ?> hashtable = ADFContext.getCurrent().getSecurityContext().getEnvironment();
                String string2 = (String)hashtable.get("oracle.adf.security.embedded.location");
                if (string2 != null) {
                    if (string2.length() == 0) {
                        _jClient = true;
                        _embeddedConfigPath = null;
                    }
                } else if (_embeddedConfigPath == null) {
                    string2 = this.findEmbeddedConfigPath();
                }
                if (string2 != null && !_jClient) {
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    stringBuffer.append(FILE_SEPARATOR);
                    stringBuffer.append(JAZN_XML);
                    _embeddedConfigPath = stringBuffer.toString();
                    _adfSecLogger.log(Level.FINE, "Setting Embedded JAZN Config property ..." + _embeddedConfigPath);
                }
                if ((string = System.getProperty("oracle.adf.security.authorization.dual")) != null && string.equals("true")) {
                    _dualUpdate = true;
                }
                _refreshConfig = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _embeddedConfigPath;
    }

    private String findEmbeddedConfigPath() {
        if (_embeddedConfigPath != null) {
            return _embeddedConfigPath;
        }
        try {
            Method method;
            Class<?> clazz = Class.forName(OC4JCONFIG_CLASS);
            if (clazz != null && (method = clazz.getMethod("getEmbeddedOc4jConfigDir", new Class[0])) != null) {
                _embeddedConfigPath = ((File)method.invoke(null, new Object[0])).getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _embeddedConfigPath;
    }

    private JAZNConfig getEmbeddedConfig() {
        JAZNConfig jAZNConfig = null;
        if (_config.getProviderType().equals(Env.PROVIDER_TYPE_LDAP)) {
            return null;
        }
        this.getEmbeddedConfigPath();
        if (_embeddedConfigPath != null) {
            try {
                jAZNConfig = new JAZNConfig(_embeddedConfigPath);
                _adfSecLogger.log(Level.FINE, "JAZN embedded onfig path ..." + _embeddedConfigPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_embeddedConfigPath == null || _dualUpdate) {
            _useHomeConfig = true;
        }
        return jAZNConfig;
    }

    public static String getRealmName(String string, JAZNConfig jAZNConfig) {
        int n = string.indexOf("/");
        if (n > 0) {
            return string.substring(0, n);
        }
        return jAZNConfig.getDefaultRealm();
    }

    public boolean isDualUpdate() {
        return _dualUpdate;
    }

    static {
        __LOCK__ = new Object();
        _adfSecLogger = ADFSecurityUtil.getADFLogger();
        _policyMgr = null;
        _identityMgr = null;
        _credentialStore = null;
        _configStr = null;
        _embeddedConfigPath = null;
        _thisPD = null;
        _setJAZNProps = false;
        _jClient = false;
        _dualUpdate = false;
        _useHomeConfig = false;
        _refreshConfig = true;
        FILE_SEPARATOR = System.getProperty("file.separator");
    }
}

