/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.util.logging.Level;
import oracle.adf.share.perf.ADFPerfLog;
import oracle.adf.share.perf.PerfLogRecord;
import oracle.adf.share.perf.PerfUtil;

protected class ADFPerfSensor {
    private static int sIndex = 0;
    protected String mSensorFullName;
    protected Level mLevel;
    protected int mIndex;
    protected boolean mEnablePerfLog;
    protected boolean mEnableDms;
    private boolean mIsTimerLogged;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private /* synthetic */ void $init$() {
        this.mLevel = null;
        this.mIndex = 0;
        this.mEnablePerfLog = false;
        this.mEnableDms = false;
        this.mIsTimerLogged = false;
    }

    protected ADFPerfSensor(Level level, String string) {
        this.$init$();
        this.mLevel = level;
        this.mSensorFullName = string;
        this.mIndex = ADFPerfSensor.getIndex();
        this.mEnablePerfLog = ADFPerfLog.getLevel().intValue() <= level.intValue();
        this.mEnableDms = PerfUtil.getDMSSensorLevel().intValue() <= level.intValue();
    }

    protected void log(long l, String string, String string2) {
        this.logIndex();
        PerfLogRecord perfLogRecord = new PerfLogRecord(this.mLevel, string);
        perfLogRecord.setMillis(l);
        perfLogRecord.setIndex(this.mIndex);
        ADFPerfLog.addLogRecord(perfLogRecord, string2);
    }

    public boolean isActive() {
        return this.mEnablePerfLog || this.mEnableDms;
    }

    private synchronized void logIndex() {
        if (!this.mIsTimerLogged) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("I ");
            stringBuffer.append(this.mIndex);
            stringBuffer.append(" ");
            stringBuffer.append(this.mSensorFullName);
            stringBuffer.append(LINE_SEPARATOR);
            ADFPerfLog.getIdxLogger().log(this.mLevel, stringBuffer.toString());
            this.mIsTimerLogged = true;
        }
    }

    private static synchronized int getIndex() {
        return ++sIndex;
    }
}

