/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ADFLogRecord
extends LogRecord {
    private transient boolean _needToInferCaller;
    private static final String _JDK_LOG_CLASS = "java.util.logging.Logger";
    private static final String _ADF_LOG_CLASS = "oracle.adf.share.logging.ADFLogger";

    public ADFLogRecord(Level level, String string) {
        super(level, string);
        this.$init$();
    }

    public String getSourceClassName() {
        if (this._needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceClassName();
    }

    public void setSourceClassName(String string) {
        this._needToInferCaller = false;
        super.setSourceClassName(string);
    }

    public String getSourceMethodName() {
        if (this._needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceMethodName();
    }

    public void setSourceMethodName(String string) {
        this._needToInferCaller = false;
        super.setSourceMethodName(string);
    }

    private void _inferCaller() {
        this._needToInferCaller = false;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n = 0;
        while (n < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string = stackTraceElement.getClassName();
            if (string.equals(_JDK_LOG_CLASS) || string.equals(_ADF_LOG_CLASS)) break;
            ++n;
        }
        while (n < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string = stackTraceElement.getClassName();
            if (string.equals(_JDK_LOG_CLASS) || string.equals(_ADF_LOG_CLASS)) {
                ++n;
                continue;
            }
            String string2 = stackTraceElement.getMethodName();
            if ("log".equals(string2) || "_log".equals(string2)) {
                ++n;
                continue;
            }
            this.setSourceClassName(string);
            this.setSourceMethodName(string2);
            return;
        }
        this.setSourceClassName(null);
        this.setSourceMethodName(null);
    }

    private /* synthetic */ void $init$() {
        this._needToInferCaller = true;
    }
}

