/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.security.Principal;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.CredentialProvisioner;
import oracle.adf.share.security.credentialstore.CredentialStore;
import oracle.adf.share.security.identitymanagement.UserManager;

public class CredentialStoreHelper {
    private static CredentialStoreHelper singleton = null;
    private static ThreadLocal initialized = new ThreadLocal();
    private static Object syncLock = new Object();
    private UserManager userMgr = new UserManager("oracle.adf.share.security.providers.jazn.JAZNIdentityManagementProvider");
    private CredentialProvisioner csp = new CredentialProvisioner("oracle.adf.share.security.providers.jazn.JAZNCredentialStore");
    private CredentialStore cs = new CredentialStore("oracle.adf.share.security.providers.jazn.JAZNCredentialStore");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialStoreHelper getInstance() throws Exception {
        if (initialized.get() == null) {
            Object object = syncLock;
            synchronized (object) {
                if (singleton == null) {
                    singleton = new CredentialStoreHelper();
                }
                initialized.set(Boolean.TRUE);
            }
        }
        return singleton;
    }

    public void removeCredential(String string, String string2) throws Exception {
        Principal principal = this.userMgr.getPrincipal(string);
        this.csp.removeCredential(string2, principal);
    }

    public void storeCredential(String string, String string2, Credential credential) throws Exception {
        Principal principal = this.userMgr.getPrincipal(string);
        this.csp.storeCredential(credential, string2, principal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Credential fetchCredential(String string, String string2) throws Exception {
        Credential credential;
        SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
        Principal principal = null;
        try {
            if (securityContext.getEnvironment().get("java.naming.security.principal") == null) {
                principal = this.userMgr.getPrincipal(string);
                securityContext.addToEnvironment("java.naming.security.principal", principal);
            }
            credential = this.cs.fetchCredential(string2);
            Object var7_6 = null;
            if (principal == null) return credential;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (principal == null) throw throwable;
            securityContext.removeFromEnvironment("java.naming.security.principal");
            throw throwable;
        }
        securityContext.removeFromEnvironment("java.naming.security.principal");
        return credential;
    }
}

