/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.util;

import java.text.ParsePosition;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import oracle.core.ojdl.util.TimestampFormat;

public class ISO8601TimestampFormat
extends TimestampFormat {
    private Calendar m_calendar = new GregorianCalendar();
    private int m_year = Integer.MIN_VALUE;
    private int m_month = Integer.MIN_VALUE;
    private int m_day = Integer.MIN_VALUE;
    private long m_baseTime = 0L;

    public ISO8601TimestampFormat() {
        this.m_calendar.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        this.m_calendar.setLenient(false);
    }

    public long parse(String string, ParsePosition parsePosition) {
        return this.parse(string.toCharArray(), parsePosition);
    }

    public long parse(String string) {
        return this.parse(string.toCharArray(), new ParsePosition(0));
    }

    public long parse(char[] cArray, ParsePosition parsePosition) {
        int n;
        int n2 = cArray.length;
        int n3 = parsePosition.getIndex();
        if (n2 - n3 < 20) {
            return Long.MIN_VALUE;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = Character.digit(cArray[n3++], 10);
        int n14 = Character.digit(cArray[n3++], 10);
        int n15 = Character.digit(cArray[n3++], 10);
        int n16 = Character.digit(cArray[n3++], 10);
        if (n13 < 0 || n14 < 0 || n15 < 0 || n16 < 0) {
            return Long.MIN_VALUE;
        }
        n4 = n13 * 1000 + n14 * 100 + n15 * 10 + n16;
        if (cArray[n3++] != '-') {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n3++], 10);
        n14 = Character.digit(cArray[n3++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n5 = n13 * 10 + n14;
        if (cArray[n3++] != '-') {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n3++], 10);
        n14 = Character.digit(cArray[n3++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n6 = n13 * 10 + n14;
        if (cArray[n3++] != 'T') {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n3++], 10);
        n14 = Character.digit(cArray[n3++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n7 = n13 * 10 + n14;
        if (cArray[n3++] != ':') {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n3++], 10);
        n14 = Character.digit(cArray[n3++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n8 = n13 * 10 + n14;
        if (cArray[n3++] != ':') {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n3++], 10);
        n14 = Character.digit(cArray[n3++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n9 = n13 * 10 + n14;
        if (n3 >= n2) {
            return Long.MIN_VALUE;
        }
        n10 = 0;
        if (cArray[n3] == '.') {
            n13 = 0;
            n14 = 0;
            n15 = 0;
            if (++n3 < n2 && (n13 = Character.digit(cArray[n3], 10)) >= 0) {
                if (++n3 < n2 && (n14 = Character.digit(cArray[n3], 10)) >= 0) {
                    if (++n3 < n2 && (n15 = Character.digit(cArray[n3], 10)) >= 0) {
                        ++n3;
                    } else {
                        n15 = 0;
                    }
                } else {
                    n14 = 0;
                }
            } else {
                n13 = 0;
            }
            n10 = n13 * 100 + n14 * 10 + n15;
            while (n3 < n2 && Character.isDigit(cArray[n3])) {
                ++n3;
            }
        }
        if (n3 >= n2) {
            return Long.MIN_VALUE;
        }
        if (cArray[n3] == 'Z' || cArray[n3] == 'z') {
            n = 0;
            ++n3;
        } else {
            if (n2 - n3 < 6) {
                return Long.MIN_VALUE;
            }
            int n17 = 0;
            if (cArray[n3] == '-') {
                n17 = -1;
            } else if (cArray[n3] == '+') {
                n17 = 1;
            } else {
                return Long.MIN_VALUE;
            }
            int n18 = ++n3;
            n13 = Character.digit(cArray[n18], 10);
            int n19 = ++n3;
            ++n3;
            n14 = Character.digit(cArray[n19], 10);
            if (n13 < 0 || n14 < 0) {
                return Long.MIN_VALUE;
            }
            n11 = n13 * 10 + n14;
            if (n11 > 23) {
                return Long.MIN_VALUE;
            }
            if (cArray[n3++] != ':') {
                return Long.MIN_VALUE;
            }
            n13 = Character.digit(cArray[n3++], 10);
            n14 = Character.digit(cArray[n3++], 10);
            if (n13 < 0 || n14 < 0) {
                return Long.MIN_VALUE;
            }
            n12 = n13 * 10 + n14;
            if (n12 > 59) {
                return Long.MIN_VALUE;
            }
            n = n17 * (n11 * 60 + n12) * 60000;
        }
        parsePosition.setIndex(n3);
        if (n7 > 24 || n8 > 59 || n9 > 59) {
            return Long.MIN_VALUE;
        }
        if (n4 != this.m_year || n5 != this.m_month || n6 != this.m_day) {
            this.m_calendar.clear();
            try {
                this.m_calendar.set(n4, n5 - 1, n6);
                this.m_baseTime = this.m_calendar.getTime().getTime();
            }
            catch (Exception exception) {
                return Long.MIN_VALUE;
            }
            this.m_year = n4;
            this.m_month = n5;
            this.m_day = n6;
        }
        return this.m_baseTime + (long)(((n7 * 60 + n8) * 60 + n9) * 1000) + (long)n10 - (long)n;
    }
}

