/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.util.logging.Level;
import oracle.core.ojdl.MessageType;

public class ODLLevel
extends Level {
    public static Level TRACE = Level.FINE;
    public static Level NOTIFICATION = Level.INFO;
    public static Level WARNING = Level.WARNING;
    public static Level ERROR = Level.SEVERE;
    public static Level INTERNAL_ERROR = new ODLLevel("INTERNAL_ERROR", Level.SEVERE.intValue() + 100);

    public static MessageType getMsgTypeAndLevel(Level level, int[] nArray) {
        int n = level.intValue();
        if (n <= Level.FINEST.intValue()) {
            nArray[0] = 32;
            return MessageType.TRACE;
        }
        if (n <= Level.FINER.intValue()) {
            nArray[0] = 16 + ODLLevel.getArbLevel(n, Level.FINER, Level.FINEST, 16);
            return MessageType.TRACE;
        }
        if (n <= Level.FINE.intValue()) {
            nArray[0] = 1 + ODLLevel.getArbLevel(n, Level.FINE, Level.FINER, 15);
            return MessageType.TRACE;
        }
        if (n <= Level.CONFIG.intValue()) {
            nArray[0] = 16 + ODLLevel.getArbLevel(n, Level.CONFIG, Level.FINE, 17);
            return MessageType.NOTIFICATION;
        }
        if (n <= Level.INFO.intValue()) {
            nArray[0] = 1 + ODLLevel.getArbLevel(n, Level.INFO, Level.CONFIG, 15);
            return MessageType.NOTIFICATION;
        }
        if (n <= Level.WARNING.intValue()) {
            nArray[0] = 1 + ODLLevel.getArbLevel(n, Level.WARNING, Level.INFO, 32);
            return MessageType.WARNING;
        }
        if (n <= Level.SEVERE.intValue()) {
            nArray[0] = 1 + ODLLevel.getArbLevel(n, Level.SEVERE, Level.WARNING, 32);
            return MessageType.ERROR;
        }
        if (n <= INTERNAL_ERROR.intValue()) {
            nArray[0] = 1 + ODLLevel.getArbLevel(n, INTERNAL_ERROR, Level.SEVERE, 32);
            return MessageType.INTERNAL_ERROR;
        }
        nArray[0] = 1;
        return MessageType.UNKNOWN;
    }

    public static Level getLevel(MessageType messageType, int n) {
        if (messageType == MessageType.TRACE) {
            if (n < 16) {
                return ODLLevel.getLevel(Level.FINE, Level.FINER, 15, n);
            }
            if (n < 32) {
                return ODLLevel.getLevel(Level.FINER, Level.FINEST, 16, n - 15);
            }
            return Level.FINEST;
        }
        if (messageType == MessageType.NOTIFICATION) {
            if (n < 16) {
                return ODLLevel.getLevel(Level.INFO, Level.CONFIG, 15, n);
            }
            return ODLLevel.getLevel(Level.CONFIG, Level.FINE, 17, n - 15);
        }
        if (messageType == MessageType.WARNING) {
            return ODLLevel.getLevel(Level.WARNING, Level.INFO, 32, n);
        }
        if (messageType == MessageType.ERROR) {
            return ODLLevel.getLevel(Level.SEVERE, Level.WARNING, 32, n);
        }
        return ODLLevel.getLevel(INTERNAL_ERROR, Level.SEVERE, 32, n);
    }

    public static Level parse(String string) {
        int n;
        String string2;
        String string3;
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        } else {
            string3 = string;
            string2 = "1";
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid argument: " + string);
        }
        if (n <= 0 || n > 32) {
            throw new IllegalArgumentException("Invalid argument: " + string);
        }
        MessageType messageType = MessageType.getMessageType(string3);
        if (messageType == MessageType.UNKNOWN) {
            return Level.parse(string);
        }
        return ODLLevel.getLevel(MessageType.getMessageType(string3), n);
    }

    private static Level getLevel(Level level, Level level2, int n, int n2) {
        int n3 = level.intValue() + (level2.intValue() - level.intValue()) / n * (n2 - 1);
        return Level.parse(Integer.toString(n3));
    }

    private static final int getArbLevel(int n, Level level, Level level2, int n2) {
        int n3 = (n - level.intValue()) / ((level2.intValue() - level.intValue()) / n2);
        return n3 < n2 ? n3 : n2 - 1;
    }

    protected ODLLevel(String string, int n) {
        super(string, n, null);
    }
}

