/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BLOB;

public class OrdMediaUtil {
    public static final int READ_MAX_CHUNKSIZE = 32768;
    public static final int LOAD_MAX_CHUNKSIZE = 0x100000;
    public static final int DEFAULT_LOAD_MAX_CHUNKSIZE = 32768;

    public static byte[] getDataInByteArray(BLOB bLOB) throws SQLException, IOException, OutOfMemoryError {
        int n = 0;
        int n2 = 0;
        n = 32768;
        byte[] byArray = null;
        if ((int)bLOB.length() == 0) {
            return null;
        }
        byArray = new byte[(int)bLOB.length()];
        InputStream inputStream = null;
        try {
            inputStream = bLOB.getBinaryStream();
            while ((n = inputStream.read(byArray, n2, n)) != -1) {
                n2 += n;
            }
        }
        finally {
            Object var6_6 = null;
            inputStream.close();
        }
        return byArray;
    }

    public static boolean getDataInFile(String string, BLOB bLOB) throws SQLException, IOException {
        int n = 0;
        boolean bl = false;
        byte[] byArray = new byte[32768];
        n = 32768;
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            inputStream = bLOB.getBinaryStream();
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            Object var9_8 = null;
            fileOutputStream.close();
            inputStream.close();
        }
        return true;
    }

    public static void imCompatibilityInit(OracleConnection oracleConnection) throws Exception {
        int n = -1;
        String string = "";
        String string2 = " DECLARE  version VARCHAR2(40);  begin    version := '9.0.0' ;  ? := ORDSYS.IM.compatibilityInit(version,?);  end;";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall(string2);
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.execute();
            n = oracleCallableStatement.getInt(1);
            string = oracleCallableStatement.getString(2);
        }
        finally {
            Object var6_5 = null;
            oracleCallableStatement.close();
        }
        if (n != 0) {
            throw new Exception(string);
        }
    }

    public static boolean loadData(String string, BLOB bLOB) throws SQLException, IOException {
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        int n3 = 0;
        File file = null;
        try {
            file = new File(string);
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
            n2 = (int)file.length();
            n3 = n2 < 0x100000 ? n2 : 0x100000;
            byArray = new byte[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            n3 = 32768;
            byArray = new byte[n3];
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bLOB.trim(0L);
            int n4 = 1;
            while ((n = fileInputStream.read(byArray)) != -1) {
                if (n < n3) {
                    byte[] byArray2 = new byte[n];
                    int n5 = 0;
                    while (n5 < n) {
                        byArray2[n5] = byArray[n5];
                        ++n5;
                    }
                    bLOB.putBytes((long)n4, byArray2);
                } else {
                    bLOB.putBytes((long)n4, byArray);
                }
                n4 += n;
            }
        }
        finally {
            Object var9_12 = null;
            fileInputStream.close();
        }
        return true;
    }

    public static boolean loadDataFromByteArray(byte[] byArray, BLOB bLOB) throws SQLException, IOException {
        bLOB.trim(0L);
        bLOB.putBytes(1L, byArray);
        return true;
    }

    public static boolean loadDataFromInputStream(InputStream inputStream, BLOB bLOB) throws SQLException, IOException, OutOfMemoryError {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray = null;
        int n2 = 0;
        try {
            n2 = 262144;
            byArray = new byte[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            n2 = 32768;
            byArray = new byte[n2];
        }
        try {
            bLOB.trim(0L);
            int n3 = 1;
            while ((n = inputStream.read(byArray)) != -1) {
                if (n < n2) {
                    byte[] byArray2 = new byte[n];
                    int n4 = 0;
                    while (n4 < n) {
                        byArray2[n4] = byArray[n4];
                        ++n4;
                    }
                    bLOB.putBytes((long)n3, byArray2);
                } else {
                    bLOB.putBytes((long)n3, byArray);
                }
                n3 += n;
            }
        }
        finally {
            Object var8_12 = null;
            inputStream.close();
        }
        return true;
    }

    public static void virCompatibilityInit(OracleConnection oracleConnection) throws Exception {
        int n = -1;
        String string = "";
        String string2 = " DECLARE  version VARCHAR2(40);  begin    version := '9.0.0';  ? := ORDSYS.VIR.compatibilityInit(version,?);  end;";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall(string2);
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.execute();
            n = oracleCallableStatement.getInt(1);
            string = oracleCallableStatement.getString(2);
        }
        finally {
            Object var6_5 = null;
            oracleCallableStatement.close();
        }
        if (n != 0) {
            throw new Exception(string);
        }
    }
}

