/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.DCTransactionStateListener;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.common.StringManager;
import oracle.jbo.format.DefaultNumberFormatter;
import oracle.jbo.format.Formatter;
import oracle.jbo.uicli.UIMessageBundle;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.binding.JUStatusBarInterface;
import oracle.jbo.uicli.binding.JUTransactionStateListener;
import oracle.jbo.uicli.jui.JUIUtil;
import oracle.jbo.uicli.jui.JUPanelBinding;

public class JUStatusBar
extends JPanel
implements JUTransactionStateListener,
JUStatusBarInterface,
RowSetListener {
    private static final int DEFAULT_PROGRESS_HEIGHT = 21;
    private static final int DEFAULT_PROGRESS_WIDTH = 100;
    private static final String BLANK = " ";
    private Color _foreGround;
    private Color _backGround;
    private Font _font;
    private Dimension _progressBarSize;
    private boolean _hasModeIcon;
    private boolean _hasMessageArea;
    private boolean _hasCurrentRow;
    private boolean _hasRowCount;
    private boolean _hasModifiedFlag;
    private boolean _hasPercentDone;
    private boolean _modeIconShown;
    private boolean _messageAreaShown;
    private boolean _currentRowShown;
    private boolean _rowCountShown;
    private boolean _modifiedFlagShown;
    private boolean _percentDoneShown;
    private JLabel _modeIcon;
    private StatusBarLabelControl _currentRow;
    private StatusBarLabelControl _rowCount;
    private StatusBarLabelControl _modifiedFlag;
    private StatusBarLabelControl _messageArea;
    private StatusBarProgressControl _percentDone;
    private String _currentRowFormatString;
    private String _rowCountFormatString;
    private String _modifiedFlagFormatString;
    private String _messageAreaFormatString;
    private String _percentDoneFormatString;
    private Formatter _currentRowFormatter;
    private Formatter _rowCountFormatter;
    private Formatter _modifiedFlagFormatter;
    private Formatter _messageAreaFormatter;
    private Formatter _percentDoneFormatter;
    private Border _labelBorder;
    private Border _barBorder;
    private GridBagLayout _barLayout;
    private int _preferredHeight;
    private String mMsgStr;
    NavigatableRowIterator mCurrentRSI;
    DCIteratorBinding mIterBinding;
    private boolean mDirty;
    private static final String MSG_BUNDLE = "oracle.jbo.uicli.UIMessageBundle";
    private String _dirtyStr;
    private String _cleanStr;
    private Icon _imgData;
    private Icon _imgFind;
    private boolean mNotInited;
    private JUPanelBinding mFormBinding;
    private Runnable mUpdateIndicatorsRunnable;
    private Runnable mUpdateIndicatorValuesRunnable;
    private static /* synthetic */ Class class$oracle$jbo$uicli$controls$JUStatusBar;

    private /* synthetic */ void $init$() {
        this._foreGround = null;
        this._backGround = null;
        this._font = null;
        this._progressBarSize = new Dimension(100, 21);
        this._hasModeIcon = true;
        this._hasMessageArea = true;
        this._hasCurrentRow = true;
        this._hasRowCount = false;
        this._hasModifiedFlag = true;
        this._hasPercentDone = false;
        this._modeIconShown = false;
        this._messageAreaShown = false;
        this._currentRowShown = false;
        this._rowCountShown = false;
        this._modifiedFlagShown = false;
        this._percentDoneShown = false;
        this._preferredHeight = 21;
        this.mMsgStr = BLANK;
        this.mDirty = false;
        this.mNotInited = true;
        this.mUpdateIndicatorsRunnable = null;
        this.mUpdateIndicatorValuesRunnable = null;
    }

    public JUStatusBar() {
        this.$init$();
        this._barBorder = BorderFactory.createEmptyBorder();
        this._labelBorder = BorderFactory.createLoweredBevelBorder();
        this._barLayout = new GridBagLayout();
        this.setBorder(this._barBorder);
        super.setLayout(this._barLayout);
        this._currentRowFormatString = UIMessageBundle.getResString((String)"02672");
        this._rowCountFormatString = UIMessageBundle.getResString((String)"02673");
        this._modifiedFlagFormatString = UIMessageBundle.getResString((String)"02669");
        this._dirtyStr = UIMessageBundle.getResString((String)"02671");
        this._cleanStr = UIMessageBundle.getResString((String)"02670");
        this._rowCountFormatter = this._currentRowFormatter = new DefaultNumberFormatter();
        this._updateIndicatorsLater();
        JLabel jLabel = new JLabel("test");
        if (jLabel != null) {
            super.setForeground(jLabel.getForeground());
            super.setBackground(jLabel.getBackground());
        }
    }

    public static JUIteratorBinding createViewBinding(JUPanelBinding jUPanelBinding, String string, String string2, String string3) {
        if (!JUIUtil.inDesignTime()) {
            return jUPanelBinding.getRowIterBinding(string, string2, string3);
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTIteratorBinding");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                int n2 = constructorArray[n].getParameterTypes().length;
                if (n2 == 1) {
                    Object[] objectArray = new Object[]{string};
                    Object obj = constructorArray[n].newInstance(objectArray);
                    JUIteratorBinding jUIteratorBinding = (JUIteratorBinding)obj;
                    return jUIteratorBinding;
                }
                ++n;
            }
            JUIteratorBinding jUIteratorBinding = null;
            return jUIteratorBinding;
        }
        catch (Exception exception) {
            JUIteratorBinding jUIteratorBinding = null;
            return jUIteratorBinding;
        }
    }

    public static JUIteratorBinding getModelInstance(JUPanelBinding jUPanelBinding, String string, String string2, String string3) {
        return JUStatusBar.createViewBinding(jUPanelBinding, string, string2, string3);
    }

    public static JUIteratorBinding createPanelBinding(JUPanelBinding jUPanelBinding, JUStatusBar jUStatusBar) {
        if (!JUIUtil.inDesignTime()) {
            jUStatusBar.mNotInited = true;
            jUStatusBar.mFormBinding = jUPanelBinding;
            jUPanelBinding.addStatusBarInterface(jUStatusBar);
            ArrayList arrayList = jUPanelBinding.getAllIterBindingList();
            if (arrayList.size() > 0) {
                return (JUIteratorBinding)arrayList.get(0);
            }
            return null;
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTIteratorPanelBinding");
            Object obj = clazz.newInstance();
            JUIteratorBinding jUIteratorBinding = (JUIteratorBinding)obj;
            return jUIteratorBinding;
        }
        catch (Exception exception) {
            JUIteratorBinding jUIteratorBinding = null;
            return jUIteratorBinding;
        }
    }

    public static JUIteratorBinding getModelInstance(JUPanelBinding jUPanelBinding, JUStatusBar jUStatusBar) {
        return JUStatusBar.createPanelBinding(jUPanelBinding, jUStatusBar);
    }

    public DCIteratorBinding getModel() {
        return this.mIterBinding;
    }

    public void setModel(JUIteratorBinding jUIteratorBinding) {
        this.setModel((DCIteratorBinding)jUIteratorBinding);
    }

    public void setModel(DCIteratorBinding dCIteratorBinding) {
        if (dCIteratorBinding == null || JUIUtil.inDesignTime()) {
            this.displayStatus(this.mIterBinding, "02675", new Object[0]);
            this.mIterBinding = dCIteratorBinding;
            if (this.mCurrentRSI != null) {
                this.mCurrentRSI.removeListener((Object)this);
            }
            this.mCurrentRSI = null;
        } else {
            if (dCIteratorBinding.isIteratorMadeVisible()) {
                this.mIterBinding = dCIteratorBinding;
                NavigatableRowIterator navigatableRowIterator = dCIteratorBinding.getNavigatableRowIterator();
                if (this.mCurrentRSI != navigatableRowIterator) {
                    if (this.mCurrentRSI != null) {
                        this.mCurrentRSI.removeListener((Object)this);
                    }
                    this.mCurrentRSI = navigatableRowIterator;
                    if (navigatableRowIterator != null) {
                        navigatableRowIterator.addListener((Object)this);
                    }
                }
            }
            this.displayStatus(dCIteratorBinding, "02666", new Object[]{dCIteratorBinding.getDisplayName()});
        }
    }

    public LayoutManager getLayout() {
        return this._barLayout;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void setProgressBarSize(Dimension dimension) {
        this._progressBarSize = dimension;
        if (this._percentDone != null) {
            this._progressBarSize.height = this._percentDone.getMinimumSize().height;
            this._percentDone.setPreferredSize(this._progressBarSize);
            this._percentDone.setMinimumSize(this._progressBarSize);
            this._percentDone.setMaximumSize(this._progressBarSize);
        }
    }

    public Dimension getProgressBarSize() {
        return this._progressBarSize;
    }

    public void setIndicatorBorderStyle(Border border) {
        this._labelBorder = border;
        if (this._currentRow != null) {
            this._currentRow.setBorder(this._labelBorder);
        }
        if (this._rowCount != null) {
            this._rowCount.setBorder(this._labelBorder);
        }
        if (this._modifiedFlag != null) {
            this._modifiedFlag.setBorder(this._labelBorder);
        }
        if (this._messageArea != null) {
            this._messageArea.setBorder(this._labelBorder);
        }
        if (this._percentDone != null) {
            this._percentDone.setBorder(this._labelBorder);
        }
        if (this._modeIcon != null) {
            this._modeIcon.setBorder(this._labelBorder);
        }
    }

    public Border getIndicatorBorderStyle() {
        return this._labelBorder;
    }

    public void setFont(Font font) {
        this._font = font;
        super.setFont(this._font);
        if (this._currentRow != null) {
            this._currentRow.setFont(this._font);
        }
        if (this._rowCount != null) {
            this._rowCount.setFont(this._font);
        }
        if (this._modifiedFlag != null) {
            this._modifiedFlag.setFont(this._font);
        }
        if (this._messageArea != null) {
            this._messageArea.setFont(this._font);
        }
        if (this._modeIcon != null) {
            this._modeIcon.setFont(this._font);
        }
    }

    public Font getFont() {
        return this._font;
    }

    public void setDataModeIcon(Icon icon) {
        this._imgData = icon;
    }

    public void setFindModeIcon(Icon icon) {
        this._imgFind = icon;
    }

    public void setForeground(Color color) {
        this._foreGround = color;
        super.setForeground(color);
        if (this._currentRow != null) {
            this._currentRow.setForeground(color);
        }
        if (this._rowCount != null) {
            this._rowCount.setForeground(color);
        }
        if (this._modifiedFlag != null) {
            this._modifiedFlag.setForeground(color);
        }
        if (this._messageArea != null) {
            this._messageArea.setForeground(color);
        }
        if (this._modeIcon != null) {
            this._modeIcon.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        this._backGround = color;
        super.setBackground(color);
        if (this._currentRow != null) {
            this._currentRow.setBackground(color);
        }
        if (this._rowCount != null) {
            this._rowCount.setBackground(color);
        }
        if (this._modifiedFlag != null) {
            this._modifiedFlag.setBackground(color);
        }
        if (this._messageArea != null) {
            this._messageArea.setBackground(color);
        }
        if (this._modeIcon != null) {
            this._modeIcon.setBackground(color);
        }
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setMaximumSize(Dimension dimension) {
        dimension.height = this._preferredHeight;
        super.setMaximumSize(dimension);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setMinimumSize(Dimension dimension) {
        dimension.height = this._preferredHeight;
        super.setMinimumSize(dimension);
    }

    public Dimension getPreferredSize() {
        try {
            Dimension dimension = new Dimension(this.getParent().getSize().width, this._preferredHeight);
            return dimension;
        }
        catch (Exception exception) {
            Dimension dimension = new Dimension(50, 350);
            return dimension;
        }
    }

    public void setPreferredSize(Dimension dimension) {
        dimension.height = this._preferredHeight;
        super.setPreferredSize(dimension);
    }

    public void setCurrentRowFormatter(Formatter formatter) {
        this._currentRowFormatter = formatter;
        this._updateStatusBarControl((StatusBarControl)this._currentRow, this._currentRowFormatter);
        this._updateIndicatorsLater();
    }

    public Formatter getCurrentRowFormatter() {
        return this._currentRowFormatter;
    }

    public void setRowCountFormatter(Formatter formatter) {
        this._rowCountFormatter = formatter;
        this._updateStatusBarControl((StatusBarControl)this._rowCount, this._rowCountFormatter);
        this._updateIndicatorsLater();
    }

    public Formatter getRowCountFormatter() {
        return this._rowCountFormatter;
    }

    public void setModifiedFlagFormatter(Formatter formatter) {
        this._modifiedFlagFormatter = formatter;
        this._updateStatusBarControl((StatusBarControl)this._modifiedFlag, this._modifiedFlagFormatter);
        this._updateIndicatorsLater();
    }

    public Formatter getModifiedFlagFormatter() {
        return this._modifiedFlagFormatter;
    }

    public void setMessageAreaFormatter(Formatter formatter) {
        this._messageAreaFormatter = formatter;
        this._updateStatusBarControl((StatusBarControl)this._messageArea, this._messageAreaFormatter);
        this._updateIndicatorsLater();
    }

    public Formatter getMessageAreaFormatter() {
        return this._messageAreaFormatter;
    }

    public void setPercentDoneFormatter(Formatter formatter) {
        this._percentDoneFormatter = formatter;
        this._updateStatusBarControl((StatusBarControl)this._percentDone, this._percentDoneFormatter);
        this._updateIndicatorsLater();
    }

    public Formatter getPercentDoneFormatter() {
        return this._percentDoneFormatter;
    }

    public void setCurrentRowFormatString(String string) {
        this._currentRowFormatString = string;
        this._updateStatusBarControl((StatusBarControl)this._currentRow, this._currentRowFormatString);
        this._updateIndicatorsLater();
    }

    public String getCurrentRowFormatString() {
        return this._currentRowFormatString;
    }

    public void setRowCountFormatString(String string) {
        this._rowCountFormatString = string;
        this._updateStatusBarControl((StatusBarControl)this._rowCount, this._rowCountFormatString);
        this._updateIndicatorsLater();
    }

    public String getRowCountFormatString() {
        return this._rowCountFormatString;
    }

    public void setModifiedFlagFormatString(String string) {
        this._modifiedFlagFormatString = string;
        this._updateStatusBarControl((StatusBarControl)this._modifiedFlag, this._modifiedFlagFormatString);
        this._updateIndicatorsLater();
    }

    public String getModifiedFlagFormatString() {
        return this._modifiedFlagFormatString;
    }

    public void setMessageAreaFormatString(String string) {
        this._messageAreaFormatString = string;
        this._updateStatusBarControl((StatusBarControl)this._messageArea, this._messageAreaFormatString);
        this._updateIndicatorsLater();
    }

    public String getMessageAreaFormatString() {
        return this._messageAreaFormatString;
    }

    public void setPercentDoneFormatString(String string) {
        this._percentDoneFormatString = string;
        this._updateStatusBarControl((StatusBarControl)this._percentDone, this._percentDoneFormatString);
        this._updateIndicatorsLater();
    }

    public String getPercentDoneFormatString() {
        return this._percentDoneFormatString;
    }

    public boolean getHasModifiedFlag() {
        return this._hasModifiedFlag;
    }

    public void setHasModifiedFlag(boolean bl) {
        if (this._hasModifiedFlag != bl) {
            this._hasModifiedFlag = bl;
            this._updateIndicatorsLater();
        }
    }

    public boolean getHasMessageArea() {
        return this._hasMessageArea;
    }

    public void setHasMessageArea(boolean bl) {
        if (this._hasMessageArea != bl) {
            this._hasMessageArea = bl;
            this._updateIndicatorsLater();
        }
    }

    public boolean getHasCurrentRow() {
        return this._hasCurrentRow;
    }

    public void setHasCurrentRow(boolean bl) {
        if (this._hasCurrentRow != bl) {
            this._hasCurrentRow = bl;
            this._updateIndicatorsLater();
        }
    }

    public boolean getHasRowCount() {
        return this._hasRowCount;
    }

    public void setHasRowCount(boolean bl) {
        if (this._hasRowCount != bl) {
            this._hasRowCount = bl;
            this._updateIndicatorsLater();
        }
    }

    public boolean getHasPercentDone() {
        return this._hasPercentDone;
    }

    public void setHasPercentDone(boolean bl) {
        if (this._hasPercentDone != bl) {
            this._hasPercentDone = bl;
            this._updateIndicatorsLater();
        }
    }

    public boolean getHasModeIcon() {
        return this._hasModeIcon;
    }

    public void setHasModeIcon(boolean bl) {
        if (this._hasModeIcon != bl) {
            this._hasModeIcon = bl;
            this._updateIndicatorsLater();
        }
    }

    public void transactionStateChanged(boolean bl) {
        this.mDirty = bl;
        this._updateIndicatorsLater();
    }

    public void focusGained(DCIteratorBinding dCIteratorBinding, DCControlBinding dCControlBinding, int n) {
        if (dCControlBinding != null) {
            DCIteratorBinding dCIteratorBinding2 = dCControlBinding.getDCIteratorBinding();
            if (dCIteratorBinding2 != null) {
                if (n > -1) {
                    this.displayStatus(dCIteratorBinding, "02667", new Object[]{dCIteratorBinding2.getDisplayName(), ((JUCtrlValueBinding)dCControlBinding).getAttributeDef(n).getName()});
                } else {
                    this.displayStatus(dCIteratorBinding, "02666", new Object[]{dCIteratorBinding2.getDisplayName()});
                }
            } else {
                this.mMsgStr = null;
            }
        }
        if (dCIteratorBinding == null) {
            return;
        }
        NavigatableRowIterator navigatableRowIterator = dCIteratorBinding.getNavigatableRowIterator();
        if (this.mCurrentRSI != navigatableRowIterator) {
            this.setModel(dCIteratorBinding);
            this._updateIndicatorValuesLater();
        } else if (this._messageArea != null) {
            this._messageArea._updateValueLater(this.mMsgStr);
        }
    }

    public String getStatusMessageText() {
        return this.mMsgStr;
    }

    public void displayStatus(DCIteratorBinding dCIteratorBinding, String string, Object[] objectArray) {
        if (dCIteratorBinding != null && dCIteratorBinding.isIteratorMadeVisible() && (dCIteratorBinding.hasRSI() || dCIteratorBinding.isFindMode()) && dCIteratorBinding.getNavigatableRowIterator() != this.mCurrentRSI) {
            this.setModel(dCIteratorBinding);
        }
        if (this._messageArea != null) {
            this.mMsgStr = StringManager.getString((String)MSG_BUNDLE, (String)string, (String)BLANK, (Object[])objectArray);
            this._updateIndicatorValuesLater();
        }
    }

    public void displayStatus(String string) {
        if (this._messageArea != null) {
            this.mMsgStr = string;
            this._updateIndicatorValuesLater();
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this._updateIndicatorValuesLater();
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        if (rangeRefreshEvent.getRowCountInRange() <= 0) {
            this._updateIndicatorValuesLater();
        }
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
        this._updateIndicatorValuesLater();
    }

    public void rowInserted(InsertEvent insertEvent) {
        this._updateIndicatorValuesLater();
    }

    public void rowUpdated(UpdateEvent updateEvent) {
        this._updateIndicatorValuesLater();
    }

    private StatusBarLabelControl _createStatusLabel(String string, Formatter formatter, Border border) {
        StatusBarLabelControl statusBarLabelControl = new StatusBarLabelControl(string, formatter);
        statusBarLabelControl.setBorder(border);
        if (this._font != null) {
            statusBarLabelControl.setFont(this._font);
        }
        if (this._foreGround != null) {
            statusBarLabelControl.setForeground(this._foreGround);
        }
        if (this._backGround != null) {
            statusBarLabelControl.setBackground(this._backGround);
        }
        return statusBarLabelControl;
    }

    private JLabel _createModeIcon(Border border) {
        JLabel jLabel = new JLabel();
        jLabel.setBorder(border);
        if (this._font != null) {
            jLabel.setFont(this._font);
        }
        if (this._foreGround != null) {
            jLabel.setForeground(this._foreGround);
        }
        if (this._backGround != null) {
            jLabel.setBackground(this._backGround);
        }
        return jLabel;
    }

    private StatusBarProgressControl _createProgressBar(String string, Formatter formatter, Border border) {
        StatusBarProgressControl statusBarProgressControl = new StatusBarProgressControl(string, formatter);
        statusBarProgressControl.setBorder(border);
        if (this._font != null) {
            statusBarProgressControl.setFont(this._font);
        }
        if (this._foreGround != null) {
            statusBarProgressControl.setForeground(this._foreGround);
        }
        if (this._backGround != null) {
            statusBarProgressControl.setBackground(this._backGround);
        }
        return statusBarProgressControl;
    }

    private void _updateIndicatorsLater() {
        if (this.mUpdateIndicatorsRunnable == null) {
            this.mUpdateIndicatorsRunnable = new 2();
            SwingUtilities.invokeLater(this.mUpdateIndicatorsRunnable);
        }
    }

    protected synchronized void _updateIndicators() {
        int n = 0;
        boolean bl = false;
        if (this._hasPercentDone) {
            if (this._percentDone == null) {
                this._percentDone = this._createProgressBar(this._percentDoneFormatString, this._percentDoneFormatter, this._labelBorder);
            }
            if (!this._percentDoneShown) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = -1;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                this.add(this._percentDone, gridBagConstraints, n);
                bl = true;
                this._percentDoneShown = true;
            }
            ++n;
        } else {
            bl = true;
            if (this._percentDone != null) {
                this.remove(this._percentDone);
            }
            this._percentDoneShown = false;
        }
        if (this._hasCurrentRow) {
            if (this._currentRow == null) {
                this._currentRow = this._createStatusLabel(this._currentRowFormatString, this._currentRowFormatter, this._labelBorder);
            }
            if (!this._currentRowShown) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = -1;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                this.add(this._currentRow, gridBagConstraints, n);
                bl = true;
                this._currentRowShown = true;
            }
            ++n;
        } else if (this._currentRow != null) {
            bl = true;
            this.remove(this._currentRow);
            this._currentRowShown = false;
        }
        if (this._hasRowCount) {
            if (this._rowCount == null) {
                this._rowCount = this._createStatusLabel(this._rowCountFormatString, this._rowCountFormatter, this._labelBorder);
            }
            if (!this._rowCountShown) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = -1;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                this.add(this._rowCount, gridBagConstraints, n);
                bl = true;
                this._rowCountShown = true;
            }
            ++n;
        } else if (this._rowCount != null) {
            bl = true;
            this.remove(this._rowCount);
            this._rowCountShown = false;
        }
        if (this._hasModifiedFlag) {
            if (this._modifiedFlag == null) {
                this._modifiedFlag = this._createStatusLabel(this._modifiedFlagFormatString, this._modifiedFlagFormatter, this._labelBorder);
            }
            if (!this._modifiedFlagShown) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = -1;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                this.add(this._modifiedFlag, gridBagConstraints, n);
                bl = true;
                this._modifiedFlagShown = true;
            }
            ++n;
        } else if (this._modifiedFlag != null) {
            bl = true;
            this.remove(this._modifiedFlag);
            this._modifiedFlagShown = false;
        }
        if (this._hasMessageArea) {
            if (this._messageArea == null) {
                this._messageArea = this._createStatusLabel(this._messageAreaFormatString, this._messageAreaFormatter, this._labelBorder);
            }
            if (!this._messageAreaShown) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = -1;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                this.add(this._messageArea, gridBagConstraints, n);
                bl = true;
                this._messageAreaShown = true;
            }
            ++n;
        } else if (this._messageArea != null) {
            bl = true;
            this.remove(this._messageArea);
            this._messageAreaShown = false;
        }
        if (this._hasModeIcon) {
            if (this._modeIcon == null) {
                this._modeIcon = this._createModeIcon(this._labelBorder);
            }
            if (!this._modeIconShown) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = -1;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 13;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                this.add(this._modeIcon, gridBagConstraints, n);
                bl = true;
                this._modeIconShown = true;
            }
            ++n;
        } else if (this._modeIcon != null) {
            bl = true;
            this.remove(this._modeIcon);
            this._modeIconShown = false;
        }
        if (bl) {
            this._updateIndicatorValuesLater();
        }
    }

    private void _updateIndicatorValuesLater() {
        if (this.mUpdateIndicatorValuesRunnable == null) {
            this.mUpdateIndicatorValuesRunnable = new 1();
            SwingUtilities.invokeLater(this.mUpdateIndicatorValuesRunnable);
        }
    }

    protected void _updateIndicatorValues() {
        if (this.mNotInited && !JUIUtil.inDesignTime()) {
            if (this.mIterBinding != null) {
                this.mNotInited = false;
                this.mIterBinding.getDataControl().addTransactionStateListener((DCTransactionStateListener)this);
            } else if (this.mFormBinding != null) {
                try {
                    if (this.mFormBinding != null && this.mFormBinding.getDataControl() != null) {
                        this.mNotInited = false;
                        this.mFormBinding.getDataControl().addTransactionStateListener((DCTransactionStateListener)this);
                    }
                }
                catch (InvalidObjNameException invalidObjNameException) {
                    // empty catch block
                }
            }
        }
        if (this.mCurrentRSI != null) {
            int n = -1;
            if (this._currentRow != null) {
                n = this.mCurrentRSI.getCurrentRowIndex() + 1;
                this._currentRow._updateValueLater(Integer.toString(n));
            }
            if (this._rowCount != null || this._percentDone != null) {
                long l;
                long l2 = l = this.mCurrentRSI instanceof RowSetIterator ? ((RowSetIterator)this.mCurrentRSI).getRowSet().getEstimatedRowCount() : (long)this.mCurrentRSI.getRowCount();
                if (this._rowCount != null) {
                    this._rowCount._updateValueLater(Long.toString(l));
                }
                if (this._percentDone != null) {
                    if (n < 0) {
                        n = this.mCurrentRSI.getCurrentRowIndex() + 1;
                    }
                    this._percentDone.setValue((int)((double)n / (double)l * 100.0));
                }
            }
            if (this._modifiedFlag != null) {
                if (this.mCurrentRSI instanceof RowSetIterator) {
                    this._modifiedFlag.setText(this._modifiedFlagFormatString + (this.mDirty ? this._dirtyStr : this._cleanStr));
                } else {
                    this._modifiedFlag.setText(this._modifiedFlagFormatString + this._cleanStr);
                }
            }
            if (this._modeIcon != null) {
                if (this._imgData == null) {
                    Class clazz = class$oracle$jbo$uicli$controls$JUStatusBar;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$uicli$controls$JUStatusBar = JUStatusBar.class$("oracle.jbo.uicli.controls.JUStatusBar");
                    }
                    Class clazz2 = clazz;
                    this._imgData = new ImageIcon(clazz2.getResource("images/data.gif"));
                    this._imgFind = new ImageIcon(clazz2.getResource("images/find.gif"));
                }
                this._modeIcon.setIcon(this.mIterBinding == null || !this.mIterBinding.isFindMode() ? this._imgData : this._imgFind);
            }
        } else if (this._modifiedFlag != null) {
            this._modifiedFlag.setText(this._modifiedFlagFormatString + this._cleanStr);
        }
        if (this._messageArea != null) {
            this._messageArea._updateValue(this.mMsgStr);
        }
    }

    private void _updateStatusBarControl(StatusBarControl statusBarControl, String string) {
        if (statusBarControl != null) {
            statusBarControl.setFormatString(string);
        }
    }

    private void _updateStatusBarControl(StatusBarControl statusBarControl, Formatter formatter) {
        if (statusBarControl != null) {
            statusBarControl.setFormatter(formatter);
        }
    }

    public void release() {
        if (this.mFormBinding != null) {
            this.mFormBinding.removeStatusBarInterface(this);
        }
        if (this.mIterBinding != null) {
            this.mIterBinding.getDataControl().removeTransactionStateListener((DCTransactionStateListener)this);
        } else if (this.mFormBinding != null) {
            try {
                if (this.mFormBinding != null && this.mFormBinding.getDataControl() != null) {
                    this.mFormBinding.getDataControl().removeTransactionStateListener((DCTransactionStateListener)this);
                }
            }
            catch (InvalidObjNameException invalidObjNameException) {
                // empty catch block
            }
        }
        this.mNotInited = true;
        this.mFormBinding = null;
        this.setModel((JUIteratorBinding)null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 2
    implements Runnable {
        public void run() {
            JUStatusBar.this._updateIndicators();
            JUStatusBar.this.mUpdateIndicatorsRunnable = null;
            JUStatusBar.this._updateIndicatorValuesLater();
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            JUStatusBar.this._updateIndicatorValues();
            JUStatusBar.this.mUpdateIndicatorValuesRunnable = null;
        }
    }

    public interface StatusBarControl {
        public void setFormatString(String var1);

        public void setFormatter(Formatter var1);
    }

    public class StatusBarLabelControl
    extends JLabel
    implements StatusBarControl {
        String _formatString;
        Formatter _formatter;
        private String mUpdateValueRunnableStringVal;
        private Runnable mUpdateValueRunnable;

        public StatusBarLabelControl() {
            this(null, 2, null, null);
        }

        public StatusBarLabelControl(Icon icon) {
            this(icon, 0, null, null);
        }

        public StatusBarLabelControl(String string, Formatter formatter) {
            this(null, 2, string, formatter);
        }

        public StatusBarLabelControl(Icon icon, int n, String string, Formatter formatter) {
            super("", icon, n);
            this._formatString = string;
            this._formatter = formatter;
            this._updateValueLater(null);
        }

        public void setFormatString(String string) {
            this._formatString = string;
            this._updateValueLater(null);
        }

        public String getFormatString() {
            return this._formatString;
        }

        public void setFormatter(Formatter formatter) {
            this._formatter = formatter;
            this._updateValueLater(null);
        }

        public Formatter getFormatter() {
            return this._formatter;
        }

        private void _updateValueLater(String string) {
            this.mUpdateValueRunnableStringVal = string;
            if (this.mUpdateValueRunnable == null) {
                this.mUpdateValueRunnable = new 1();
                SwingUtilities.invokeLater(this.mUpdateValueRunnable);
            }
        }

        private void _updateValue(String string) {
            String string2 = JUStatusBar.BLANK;
            if (this._formatString != null) {
                if (this._formatter != null) {
                    try {
                        string2 = this._formatter.format(this._formatString, (Object)string);
                    }
                    catch (Exception exception) {
                        string2 = this._formatString.replace('#', ' ') + (string != null ? string.toString() : JUStatusBar.BLANK);
                    }
                } else {
                    string2 = this._formatString.replace('#', ' ') + (string != null ? string.toString() : JUStatusBar.BLANK);
                }
            } else if (string != null) {
                string2 = string;
            }
            this.setText(string2);
        }

        public final class 1
        implements Runnable {
            public void run() {
                StatusBarLabelControl.this._updateValue(StatusBarLabelControl.this.mUpdateValueRunnableStringVal);
                StatusBarLabelControl.this.mUpdateValueRunnable = null;
                StatusBarLabelControl.this.mUpdateValueRunnableStringVal = null;
            }
        }
    }

    public class StatusBarProgressControl
    extends JProgressBar
    implements StatusBarControl {
        String _formatString;
        Formatter _formatter;
        private Runnable mUpdateAllValuesRunnable;

        public StatusBarProgressControl() {
            this(0, 0, 100, null, null);
        }

        public StatusBarProgressControl(int n) {
            this(n, 0, 100, null, null);
        }

        public StatusBarProgressControl(int n, int n2) {
            this(0, n, n2, null, null);
        }

        public StatusBarProgressControl(String string, Formatter formatter) {
            this(0, 0, 100, string, formatter);
        }

        public StatusBarProgressControl(int n, int n2, int n3, String string, Formatter formatter) {
            super(n, n2, n3);
            this._formatString = string;
            this._formatter = formatter;
            this.setBorderPainted(true);
            this.setStringPainted(true);
            this._updateAllValuesLater();
        }

        public Dimension getMaximumSize() {
            return JUStatusBar.this._progressBarSize;
        }

        public void setMaximumSize(Dimension dimension) {
            dimension.height = ((JUStatusBar)JUStatusBar.this)._progressBarSize.height;
            super.setMaximumSize(dimension);
        }

        public Dimension getMinimumSize() {
            return JUStatusBar.this._progressBarSize;
        }

        public void setMinimumSize(Dimension dimension) {
            dimension.height = ((JUStatusBar)JUStatusBar.this)._progressBarSize.height;
            super.setMinimumSize(dimension);
        }

        public Dimension getPreferredSize() {
            return JUStatusBar.this._progressBarSize;
        }

        public void setPreferredSize(Dimension dimension) {
            dimension.height = ((JUStatusBar)JUStatusBar.this)._progressBarSize.height;
            super.setPreferredSize(dimension);
        }

        public void setSize(Dimension dimension) {
            dimension.height = ((JUStatusBar)JUStatusBar.this)._progressBarSize.height;
            super.setSize(dimension);
        }

        public void setSize(int n, int n2) {
            n2 = ((JUStatusBar)JUStatusBar.this)._progressBarSize.height;
            super.setSize(n, n2);
        }

        public void setFormatString(String string) {
            this._formatString = string;
            this._updateAllValuesLater();
        }

        public String getFormatString() {
            return this._formatString;
        }

        public void setFormatter(Formatter formatter) {
            this._formatter = formatter;
            this._updateAllValues();
        }

        public Formatter getFormatter() {
            return this._formatter;
        }

        private void _updateAllValuesLater() {
            if (this.mUpdateAllValuesRunnable == null) {
                this.mUpdateAllValuesRunnable = new 1();
                SwingUtilities.invokeLater(this.mUpdateAllValuesRunnable);
            }
        }

        private void _updateAllValues() {
            Object var4_1 = null;
            double d = this.getPercentComplete();
            if (this._formatString != null) {
                String string;
                if (this._formatter != null) {
                    try {
                        string = this._formatter.format(this._formatString, (Object)new Double(d * 100.0));
                    }
                    catch (Exception exception) {
                        string = d * 100.0 + "%";
                    }
                } else {
                    string = d * 100.0 + "%";
                }
                if (string != null && !string.equals("")) {
                    this.setString(string);
                }
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                StatusBarProgressControl.this._updateAllValues();
                StatusBarProgressControl.this.mUpdateAllValuesRunnable = null;
            }
        }
    }
}

