/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.scrolling.ScrollableComponent;

public class PivotScrollPaneView
extends LWComponent
implements Accessible {
    private static final int _RESIZE_FEEDBACK_SIZE = 3;
    private int _orientation;
    private PivotTable _table;
    private PivotHeader _resizeHeader;

    public PivotScrollPaneView(PivotTable pivotTable) {
        this(pivotTable, 0);
    }

    public PivotScrollPaneView(PivotTable pivotTable, int n) {
        this._table = pivotTable;
        this._orientation = n;
        this.setLayout(null);
        this.setOpaque(true);
    }

    public void dispose() {
        if (this._table == null) {
            return;
        }
        this.removeAll();
        this._table = null;
        this._resizeHeader = null;
    }

    public void updateLayout() {
        this.removeAll();
        if (this.getOrientation() == 0) {
            ScrollableComponent scrollableComponent = this._table.getColumnPivotHeader();
            if (this._table.isColumnPivotHeaderVisible()) {
                this.add(scrollableComponent);
            } else {
                this.remove(scrollableComponent);
            }
            scrollableComponent = this._table.getPivotGrid().getColumnHeader();
            this.add(scrollableComponent);
        } else {
            ScrollableComponent scrollableComponent = this._table.getRowPivotHeader();
            if (this._table.isRowPivotHeaderVisible()) {
                this.add(scrollableComponent);
            } else {
                this.remove(scrollableComponent);
            }
            scrollableComponent = this._table.getPivotGrid().getRowHeader();
            this.add(scrollableComponent);
        }
        this.revalidate();
    }

    public int getOrientation() {
        return this._orientation;
    }

    public PivotTable getPivotTable() {
        return this._table;
    }

    public Dimension getPreferredSize() {
        if (this._orientation == 0) {
            Dimension dimension = this._table.getPivotGrid().getColumnHeader().getPreferredSize();
            if (this._table.isColumnPivotHeaderVisible()) {
                Dimension dimension2 = this._table.getColumnPivotHeader().getPreferredSize();
                dimension.height += dimension2.height;
                if (dimension2.width != 0) {
                    dimension.width = dimension2.width;
                }
            }
            return dimension;
        }
        Dimension dimension = this._table.getPivotGrid().getRowHeader().getPreferredSize();
        if (this._table.isRowPivotHeaderVisible()) {
            Dimension dimension3 = this._table.getRowPivotHeader().getPreferredSize();
            dimension.width += dimension3.width;
            if (dimension3.height != 0) {
                dimension.height = dimension3.height;
            }
        }
        return dimension;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        if (this.getOrientation() == 0) {
            boolean bl = this._table.getPivotGrid().isColumnHeaderVisible();
            Header header = this._table.getPivotGrid().getColumnHeader();
            header.setVisible(bl);
            Dimension dimension = header.getPreferredSize();
            if (this._table.isColumnPivotHeaderVisible()) {
                this._table.getColumnPivotHeader().setBounds(0, 0, this.getWidth(), this.getHeight() - dimension.height);
            }
            header.setBounds(0, this.getHeight() - dimension.height, this.getWidth(), dimension.height);
        } else {
            boolean bl = this._table.getPivotGrid().isRowHeaderVisible();
            Header header = this._table.getPivotGrid().getRowHeader();
            header.setVisible(bl);
            Dimension dimension = header.getPreferredSize();
            if (this._table.isRowPivotHeaderVisible()) {
                this._table.getRowPivotHeader().setBounds(0, 0, this.getWidth() - dimension.width, this.getHeight());
            }
            header.setBounds(this.getWidth() - dimension.width, 0, dimension.width, this.getHeight());
        }
    }

    public void paintOverChildren(Graphics graphics) {
        if (this._resizeHeader != null) {
            Color color = graphics.getColor();
            PivotHeader pivotHeader = this._resizeHeader;
            int n = pivotHeader.getHeaderResizeItem();
            Header header = pivotHeader.getHeader();
            UIDefaults uIDefaults = this.getUIDefaults();
            graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_TEXT));
            if (this.getOrientation() == 0) {
                if (pivotHeader.getOrientation() == 0) {
                    int n2 = header.getItemPosition(n) + header.getItemSize(n);
                    graphics.fillRect(0, n2, this.getWidth(), 3);
                }
            } else if (pivotHeader.getOrientation() == 1) {
                int n3 = header.getItemPosition(n) + header.getItemSize(n);
                graphics.fillRect(n3, 0, 3, this.getHeight());
            }
            graphics.setColor(color);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.updateLayout();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePivotScrollPaneView();
        }
        return this.accessibleContext;
    }

    final void setResizeHeader(PivotHeader pivotHeader) {
        this._resizeHeader = pivotHeader;
        this.repaint();
    }

    protected class AccessiblePivotScrollPaneView
    extends JComponent.AccessibleJComponent {
        public AccessiblePivotScrollPaneView() {
            super(PivotScrollPaneView.this);
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }
    }
}

