/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.pivot.PivotValidateEvent;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableResizeListener;

final class PivotGridTabAdapt
implements TableEditListener,
TableResizeListener {
    private PivotTable _pivot;

    public PivotGridTabAdapt(PivotTable pivotTable) {
        this._pivot = pivotTable;
    }

    public void dispose() {
        this._pivot = null;
    }

    public void cellEditing(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2005, tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    public void cellEdited(TableEvent tableEvent) {
        this._pivot.postEvent(new TableEvent(this._pivot, 2006, tableEvent.getColumn(), tableEvent.getRow()));
    }

    public void columnResizing(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2001, tableEvent.getColumn(), -1);
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        } else {
            this._pivot.getPivotGrid().setCurrentlyResizing(true);
        }
    }

    public void columnResized(TableEvent tableEvent) {
        this._pivot.getPivotGrid().setCurrentlyResizing(false);
        SpreadTable spreadTable = (SpreadTable)tableEvent.getSource();
        int n = tableEvent.getColumn();
        int n2 = spreadTable.getColumnWidth(n);
        if (this._pivot.getEqualSizedColumns()) {
            this._pivot.tryDefaultColumns();
            spreadTable.setColumnWidth(n, -1);
            PivotHeader pivotHeader = this._pivot.getColumnPivotHeader();
            pivotHeader.setColumnWidth(n, -1);
            this._pivot.setDefaultColumnWidth(n2);
        } else {
            this._pivot.setColumnWidth(n, n2);
        }
        this._pivot.postEvent(new TableEvent(this._pivot, 2002, n, -1));
    }

    public void rowResizing(TableEvent tableEvent) {
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(this._pivot, 2003, -1, tableEvent.getRow());
        this._pivot.postEvent(pivotValidateEvent);
        if (pivotValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        } else {
            this._pivot.getPivotGrid().setCurrentlyResizing(true);
        }
    }

    public void rowResized(TableEvent tableEvent) {
        this._pivot.getPivotGrid().setCurrentlyResizing(false);
        SpreadTable spreadTable = (SpreadTable)tableEvent.getSource();
        int n = tableEvent.getRow();
        int n2 = spreadTable.getRowHeight(n);
        if (this._pivot.getEqualSizedRows()) {
            this._pivot.tryDefaultRows();
            spreadTable.setRowHeight(n, -1);
            PivotHeader pivotHeader = this._pivot.getRowPivotHeader();
            pivotHeader.setRowHeight(n, -1);
            this._pivot.setDefaultRowHeight(n2);
        } else {
            this._pivot.setRowHeight(n, n2);
        }
        this._pivot.postEvent(new TableEvent(this._pivot, 2004, -1, n));
    }
}

