/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import oracle.bali.ewt.layout.DelegatingLayout;

public class HidingLayout
extends DelegatingLayout {
    private LayoutManager _containedLayout = null;

    public HidingLayout(LayoutManager layoutManager) {
        if (layoutManager == null) {
            throw new IllegalArgumentException();
        }
        this._containedLayout = layoutManager;
    }

    public LayoutManager getContainedLayout() {
        return this._containedLayout;
    }

    public void layoutContainer(Container container) {
        super.layoutContainer(container);
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (this.shrinkComponent(container, component)) {
                component.setSize(0, 0);
            }
            ++n2;
        }
    }

    protected boolean shrinkComponent(Container container, Component component) {
        if (component.isVisible()) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            dimension.width -= insets.right;
            dimension.height -= insets.bottom;
            Rectangle rectangle = component.getBounds();
            if (rectangle.x + rectangle.width > dimension.width || rectangle.y + rectangle.height > dimension.height) {
                return true;
            }
        }
        return false;
    }
}

