/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.hGrid;

import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.grid.hGrid.HTwoDModel;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;

public class HArrayTwoDModel
extends AbstractTwoDModel
implements HTwoDModel {
    public static final int ROW_NOT_VISIBLE = -1;
    public static final int ROOT_PARENT_INDEX = -1;
    private int[] _visibleToStoreTable;
    private ArrayTwoDModel _store;

    public HArrayTwoDModel(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Must have at least one column");
        }
        this._store = new ArrayTwoDModel(n, 0);
        this.addRowsAtDepth(0, n2, 0, -1);
    }

    public int getColumnCount() {
        return this._store.getColumnCount();
    }

    public final int getRowCount() {
        if (this._visibleToStoreTable == null) {
            return 0;
        }
        return this._visibleToStoreTable.length;
    }

    public final Object getData(int n, int n2) {
        return this.getExpandedData(n, this._visibleToStoreTable[n2]);
    }

    public final void setData(int n, int n2, Object object) {
        this.setExpandedData(n, this._visibleToStoreTable[n2], object);
    }

    public final void expandRow(int n, int n2) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        this.expandExpandedRow(this._visibleToStoreTable[n2]);
    }

    public final void collapseRow(int n, int n2) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        this.collapseExpandedRow(this._visibleToStoreTable[n2]);
    }

    public int getExpandedRowCount() {
        return this._store.getRowCount();
    }

    public Object getExpandedData(int n, int n2) {
        return this._store.getData(n, n2);
    }

    public void setExpandedData(int n, int n2, Object object) {
        if (n == 0) {
            Data data = this._getRowHData(n2);
            data._data = object;
            object = data;
        }
        this.setStoreData(n, n2, object);
    }

    public boolean isRowExpanded(int n, int n2) {
        return this._getRowHData(this._visibleToStoreTable[n2]).isExpanded();
    }

    public void expandExpandedRow(int n) {
        Data data = this._getRowHData(n);
        if (data.isExpanded()) {
            return;
        }
        data._expanded = true;
        this.sendCellInvalidateEvent(0, n);
        if (!this.isRowVisible(n)) {
            return;
        }
        if (data._hasChildren) {
            int n2 = this._getVisibleDescendantCount(n);
            int n3 = this.getVisibleIndex(n) + 1;
            this._expandTable(n3, n2);
            int[] nArray = this._visibleToStoreTable;
            int n4 = data.getDepth();
            int n5 = this.getExpandedRowCount();
            int n6 = n3;
            while (++n < n5) {
                data = this._getRowHData(n);
                if (data.getDepth() <= n4) break;
                nArray[n6++] = n;
                if (!data.hasChildren() || data.isExpanded()) continue;
                n += this.getDescendantCount(n);
            }
            this.fireModelEvent(2004, n3, n2);
        }
    }

    public void collapseExpandedRow(int n) {
        Data data = this._getRowHData(n);
        if (!data.isExpanded()) {
            return;
        }
        if (!this.isRowVisible(n)) {
            data._expanded = false;
            return;
        }
        int n2 = -1;
        int n3 = -1;
        if (data._hasChildren) {
            n2 = this._getVisibleDescendantCount(n);
            n3 = this.getVisibleIndex(n) + 1;
            this._shrinkTable(n3, n2);
        }
        data._expanded = false;
        if (n2 != -1) {
            this.fireModelEvent(2005, n3, n2);
        }
        this.sendCellInvalidateEvent(0, n);
    }

    public int getVisibleIndex(int n) {
        if (!this.isRowVisible(n)) {
            return -1;
        }
        int n2 = this._findNewVisibleIndex(n);
        return n2;
    }

    public int getExpandedIndex(int n) {
        if (this._visibleToStoreTable != null) {
            return this._visibleToStoreTable[n];
        }
        return -1;
    }

    public void addChildrenRows(int n, int n2) {
        this.addRowsAtDepth(n + 1, n2, this._getRowDepth(n) + 1, n);
    }

    public void addRootRows(int n, int n2) {
        if (n < this.getExpandedRowCount() && this._getRowDepth(n) > 0) {
            throw new IllegalArgumentException("Can't insert root item here");
        }
        this.addRowsAtDepth(n, n2, 0, -1);
    }

    public int addSiblingRows(int n, int n2) {
        int n3 = this._getRowDepth(n);
        int n4 = this.getParentRow(n);
        n += this.getDescendantCount(n) + 1;
        this.addRowsAtDepth(n, n2, n3, n4);
        return n;
    }

    public int removeRows(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = this._getRowDepth(n);
        int n7 = n;
        int n8 = this.getVisibleIndex(n);
        int n9 = this.getParentRow(n);
        int n10 = this.getExpandedRowCount();
        int n11 = 0;
        while (n11 < n2) {
            if (this._getRowDepth(n7) != n6) {
                throw new IllegalArgumentException("Illegal numberOfRows");
            }
            n4 = this.getDescendantCount(n7) + 1;
            n5 += n4;
            if ((n7 += n4) == n10) break;
            ++n11;
        }
        n4 = 0;
        if (n8 != -1) {
            int n12 = n + n5 - 1;
            n4 = this._findNewVisibleIndex(n12) - n8 + 1;
            if (!this.isRowVisible(n12)) {
                --n4;
            }
            this._shrinkTable(n8, n4);
        }
        int[] nArray = this._visibleToStoreTable;
        int n13 = 0;
        while (n13 < nArray.length) {
            n3 = nArray[n13];
            if (n3 >= n) {
                nArray[n13] = n3 - n5;
            }
            ++n13;
        }
        this._store.removeRows(n, n5);
        n3 = this._store.getRowCount();
        int n14 = n;
        while (n14 < n3) {
            Data data = this._getRowHData(n14);
            int n15 = data.getParentRow();
            if (n15 >= n) {
                data._parentRow = n15 - n2;
            }
            ++n14;
        }
        if (n4 > 0) {
            this.fireModelEvent(2005, n8, n4);
        }
        if (n9 != -1) {
            boolean bl;
            if (this.getExpandedRowCount() - 1 == n9) {
                bl = true;
            } else {
                boolean bl2 = bl = this._getRowDepth(n9 + 1) != n6;
            }
            if (bl) {
                Data data = this._getRowHData(n9);
                data._hasChildren = false;
                if (!data._claimHasChildren) {
                    this.sendCellInvalidateEvent(0, n9);
                }
            }
        }
        return n5;
    }

    public void claimRowHasChildren(int n, boolean bl) {
        Data data = this._getRowHData(n);
        boolean bl2 = data.hasChildren();
        data._claimHasChildren = bl;
        if (bl2 != data.hasChildren()) {
            this.sendCellInvalidateEvent(0, n);
        }
    }

    public int getParentRow(int n) {
        return this._getRowHData(n).getParentRow();
    }

    public boolean isRowVisible(int n) {
        while (n >= 0) {
            if ((n = this.getParentRow(n)) == -1 || this._getRowHData(n).isExpanded()) continue;
            return false;
        }
        return true;
    }

    public int getDescendantCount(int n) {
        int n2 = this._getRowDepth(n);
        int n3 = this.getExpandedRowCount();
        int n4 = 0;
        while (++n < n3) {
            if (this._getRowDepth(n) <= n2) break;
            ++n4;
        }
        return n4;
    }

    protected void addRowsAtDepth(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (n2 == 0) {
            return;
        }
        if (n < this.getExpandedRowCount() && this._getRowDepth(n) > n3) {
            throw new IllegalArgumentException();
        }
        if (n4 == -1) {
            if (n3 != 0) {
                throw new IllegalArgumentException();
            }
        } else {
            Data data = this._getRowHData(n4);
            int n8 = data.getDepth();
            if (n8 != n3 - 1) {
                throw new IllegalArgumentException();
            }
            if (!data._hasChildren) {
                data._hasChildren = true;
                if (!data._claimHasChildren) {
                    this.sendCellInvalidateEvent(0, n4);
                }
            }
        }
        this._store.addRows(n, n2);
        int n9 = 0;
        while (n9 < n2) {
            Data data = new Data(n3, n4);
            this._store.setData(0, n + n9, data);
            ++n9;
        }
        int[] nArray = this._visibleToStoreTable;
        if (nArray != null) {
            n7 = 0;
            while (n7 < nArray.length) {
                n6 = nArray[n7];
                if (n6 >= n) {
                    nArray[n7] = n6 + n2;
                }
                ++n7;
            }
        }
        n7 = this._store.getRowCount();
        n6 = n + n2;
        while (n6 < n7) {
            Data data = this._getRowHData(n6);
            n5 = data.getParentRow();
            if (n5 >= n) {
                data._parentRow = n5 + n2;
            }
            ++n6;
        }
        if (this.isRowVisible(n)) {
            int n10 = n > 0 ? this._findNewVisibleIndex(n) : 0;
            this._expandTable(n10, n2);
            nArray = this._visibleToStoreTable;
            n5 = 0;
            while (n5 < n2) {
                nArray[n10 + n5] = n + n5;
                ++n5;
            }
            this.fireModelEvent(2004, n10, n2);
        }
    }

    protected void setStoreData(int n, int n2, Object object) {
        this._store.setData(n, n2, object);
        this.sendCellInvalidateEvent(n, n2);
    }

    protected void sendCellInvalidateEvent(int n, int n2) {
        int n3 = this.getVisibleIndex(n2);
        if (n3 != -1) {
            this.fireModelEvent(2007, n, 1, n3, 1);
        }
    }

    private Data _getRowHData(int n) {
        return (Data)this.getExpandedData(0, n);
    }

    private int _getRowDepth(int n) {
        return ((HDataObject)this.getExpandedData(0, n)).getDepth();
    }

    private void _shrinkTable(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int[] nArray = this._visibleToStoreTable;
        int n3 = nArray == null ? 0 : nArray.length;
        int[] nArray2 = new int[n3 - n2];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        System.arraycopy(nArray, n + n2, nArray2, n, n3 - n2 - n);
        this._visibleToStoreTable = nArray2;
    }

    private void _expandTable(int n, int n2) {
        int[] nArray = this._visibleToStoreTable;
        int n3 = nArray == null ? 0 : nArray.length;
        int[] nArray2 = new int[n3 + n2];
        if (n > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n3 > n) {
            System.arraycopy(nArray, n, nArray2, n + n2, n3 - n);
        }
        this._visibleToStoreTable = nArray2;
    }

    private int _findNewVisibleIndex(int n) {
        int[] nArray = this._visibleToStoreTable;
        if (nArray == null) {
            return 0;
        }
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n <= nArray[n3]) {
                return n3;
            }
            ++n3;
        }
        return n2;
    }

    private int _getVisibleDescendantCount(int n) {
        if (!this._getRowHData(n).isExpanded()) {
            return 0;
        }
        int n2 = this._getRowDepth(n);
        int n3 = this.getExpandedRowCount();
        int n4 = 0;
        while (++n < n3) {
            Data data = this._getRowHData(n);
            if (data.getDepth() <= n2) break;
            ++n4;
            if (!data._hasChildren || data.isExpanded()) continue;
            n += this.getDescendantCount(n);
        }
        return n4;
    }

    private final class Data
    implements HDataObject {
        Object _data;
        boolean _expanded;
        boolean _hasChildren;
        boolean _claimHasChildren;
        int _parentRow;
        private int _depth;

        public Data(int n, int n2) {
            this._depth = n;
            this._parentRow = n2;
        }

        public Object getData() {
            return this._data;
        }

        public int getDepth() {
            return this._depth;
        }

        public boolean isExpanded() {
            return this._expanded;
        }

        public boolean hasChildren() {
            return this._hasChildren || this._claimHasChildren;
        }

        public int getParentRow() {
            return this._parentRow;
        }
    }
}

