/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.print.PrinterGraphics;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.elaf.EWTPivotGridUI;
import oracle.bali.ewt.elaf.EWTTableUI;
import oracle.bali.ewt.elaf.basic.BasicTableGeometryHelper;
import oracle.bali.ewt.elaf.oracle.OracleEWTTableUI;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.table.SpreadTable;

public class OracleEWTPivotGridUI
extends EWTPivotGridUI {
    private static OracleEWTPivotGridUI _sInstance;
    private static OracleEWTTableUI _sTableUI;
    private static Painter[] _sCornerPainters;

    private OracleEWTPivotGridUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (_sInstance == null) {
            _sInstance = new OracleEWTPivotGridUI();
            _sTableUI = (OracleEWTTableUI)OracleEWTTableUI.createUI(jComponent);
        }
        return _sInstance;
    }

    public void installUI(JComponent jComponent) {
        LookAndFeel.installColors(jComponent, "EWTPivotGrid.background", "EWTPivotGrid.foreground");
        _sTableUI.installUI(jComponent);
        jComponent.setBorder(null);
        jComponent.setOpaque(true);
    }

    public Painter getCornerPainter(JComponent jComponent, int n) {
        Painter painter = null;
        if (n >= 0 && n <= 3) {
            painter = _sCornerPainters[n];
            if (painter == null) {
                painter = new _CornerP(n);
            }
            OracleEWTPivotGridUI._sCornerPainters[n] = painter;
        }
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        return painter;
    }

    public void updateGeometry(JComponent jComponent) {
        BasicTableGeometryHelper.updateGeometry((SpreadTable)jComponent);
    }

    static {
        _sCornerPainters = new Painter[4];
    }

    private class _CornerP
    extends AbstractPainter {
        private int _corner;

        public _CornerP(int n) {
            this._corner = n;
        }

        public Dimension getMinimumSize(PaintContext paintContext) {
            return new Dimension(0, 0);
        }

        public int getRepaintFlags(PaintContext paintContext) {
            return 128;
        }

        public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl;
            Object object;
            Color color = graphics.getColor();
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            int n5 = n2 + n4 - 1;
            int n6 = n + n3 - 1;
            Color color2 = uIDefaults.getColor("control");
            Color color3 = uIDefaults.getColor("normalIntensity");
            Color color4 = uIDefaults.getColor("EWTPivot.darkShadow");
            graphics.setColor(color2);
            graphics.fillRect(n, n2, n3, n4);
            int n7 = paintContext.getPaintState();
            Color color5 = null;
            if (this._corner == 3 && (n7 & 1) == 0 && (object = paintContext.getPaintData("table.cornerBorderColor")) instanceof Color) {
                color5 = (Color)object;
            }
            if (color5 == null) {
                if ((n7 & 4) == 0) {
                    graphics.setColor(color4);
                } else {
                    graphics.setColor(color3);
                }
            } else {
                graphics.setColor(color5);
            }
            graphics.drawLine(n, n5, n6, n5);
            graphics.drawLine(n6, n2, n6, n5);
            object = paintContext.getPaintData(EWTTableUI.KEY_DRAW_RAISED);
            boolean bl2 = bl = object instanceof Boolean ? (Boolean)object : true;
            if (bl && (n7 & 4) == 0) {
                graphics.setColor(Color.white);
                graphics.drawLine(n, n2, n, n5 - 1);
                graphics.drawLine(n + 1, n2, n + 1, n5 - 2);
                graphics.drawLine(n, n2, n6 - 1, n2);
                graphics.drawLine(n, n2 + 1, n6 - 2, n2 + 1);
                graphics.drawLine(n, n5 - 2, n6 - 1, n5 - 2);
                graphics.drawLine(n6 - 2, n2, n6 - 2, n5 - 2);
                graphics.setColor(color3);
                graphics.drawLine(n + 1, n5 - 1, n6 - 1, n5 - 1);
                graphics.drawLine(n6 - 1, n2 + 1, n6 - 1, n5 - 1);
            } else {
                graphics.setColor(color2);
                graphics.drawLine(n, n2, n, n5 - 1);
                graphics.drawLine(n, n2, n6 - 1, n2);
                if (color5 == null) {
                    if (graphics instanceof PrintGraphics || graphics instanceof PrinterGraphics) {
                        graphics.setColor(color4);
                    } else {
                        graphics.setColor(color3);
                    }
                } else {
                    graphics.setColor(color5);
                }
                graphics.drawLine(n6, n2, n6, n2);
                graphics.drawLine(n, n5, n, n5);
            }
        }
    }
}

