/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeChildManager;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.OneDSparseArray;

public class DTreeSparseChildManager
implements DTreeChildManager {
    private OneDSparseArray _children;
    private DTreeItem[] _expandedchildren;
    private int _nexpanded;
    private int _subht;
    private int _parentht;

    public void childExpansionChanged(DTreeDeferringParent dTreeDeferringParent, DTreeItem dTreeItem) {
        if (dTreeItem.isExpanded()) {
            this._addExpandedChild(dTreeDeferringParent, dTreeItem);
        } else {
            this._removeExpandedChild(dTreeDeferringParent, dTreeItem);
        }
    }

    public int getChildX(DTreeDeferringParent dTreeDeferringParent, int n) {
        DTree dTree = dTreeDeferringParent.getTree();
        int n2 = dTreeDeferringParent.getX();
        if (dTreeDeferringParent == dTree.getRoot()) {
            return n2;
        }
        return n2 + this.getChildrenXOffset(dTreeDeferringParent, dTree.getIndentWidth());
    }

    public int getChildY(DTreeDeferringParent dTreeDeferringParent, int n) {
        int n2 = dTreeDeferringParent.getY();
        int n3 = this._getParentHeight();
        int n4 = dTreeDeferringParent.getChildHeight();
        int n5 = 0;
        int n6 = n2 + this.getChildrenYOffset(dTreeDeferringParent, n3);
        if (dTreeDeferringParent.isExpanded() && this._nexpanded != 0) {
            int n7 = 0;
            while (n7 < this._nexpanded) {
                DTreeItem dTreeItem = this._expandedchildren[n7];
                int n8 = dTreeItem.getIndex();
                if (n <= n8) break;
                n6 += (n8 - n5) * n4 + dTreeItem.getSubTreeHeight();
                n5 = n8 + 1;
                ++n7;
            }
        }
        return n6 + (n - n5) * n4;
    }

    public DTreeItem getItem(DTreeDeferringParent dTreeDeferringParent, int n) {
        DTreeItemFactory dTreeItemFactory;
        DTreeItem dTreeItem;
        if (this._children == null) {
            this._children = new OneDSparseArray();
        }
        if ((dTreeItem = (DTreeItem)this._children.getElement(n)) == null && (dTreeItem = (dTreeItemFactory = dTreeDeferringParent.getItemFactory()).createItem(dTreeDeferringParent, n)) != null) {
            this._children.setElement(dTreeItem, n);
            dTreeItem.itemAdded(dTreeDeferringParent, n);
        }
        return dTreeItem;
    }

    public DTreeItem getItemAt(DTreeDeferringParent dTreeDeferringParent, int n, int n2) {
        int n3 = dTreeDeferringParent.getSubTreeHeight();
        if (n2 >= n3) {
            return null;
        }
        int n4 = this._getParentHeight();
        if (n2 < n4) {
            return dTreeDeferringParent;
        }
        int n5 = dTreeDeferringParent.getChildHeight();
        int n6 = 0;
        int n7 = this.getChildrenYOffset(dTreeDeferringParent, n4);
        if (dTreeDeferringParent.isExpanded() && this._nexpanded != 0) {
            int n8 = dTreeDeferringParent.getY();
            int n9 = 0;
            while (n9 < this._nexpanded) {
                DTreeItem dTreeItem = this._expandedchildren[n9];
                int n10 = dTreeItem.getIndex();
                int n11 = n7 + (n10 - n6) * n5;
                n3 = dTreeItem.getSubTreeHeight();
                if (n2 < n11) break;
                if (n2 < n11 + n3) {
                    return dTreeItem.getItemAt(n, n2 - n11);
                }
                n7 = n11 + n3;
                n6 = n10 + 1;
                ++n9;
            }
        }
        return dTreeDeferringParent.getItem(n6 + (n2 - n7) / n5);
    }

    public DTreeItem getNextExpandedChild(DTreeDeferringParent dTreeDeferringParent, DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = null;
        if (dTreeItem == null) {
            if (this._nexpanded > 0) {
                dTreeItem2 = this._expandedchildren[0];
            }
        } else {
            int n = 0;
            while (n < this._nexpanded) {
                if (this._expandedchildren[n] == dTreeItem) break;
                ++n;
            }
            if (n < this._nexpanded - 1) {
                dTreeItem2 = this._expandedchildren[n + 1];
            }
        }
        return dTreeItem2;
    }

    public DTreeItem getNextInstantiatedChild(DTreeDeferringParent dTreeDeferringParent, DTreeItem dTreeItem) {
        if (this._children == null) {
            return null;
        }
        int n = 0;
        n = dTreeItem == null ? this._children.getFirstIndex() : this._children.getNextIndex(dTreeItem.getIndex());
        if (n == -1) {
            return null;
        }
        return (DTreeItem)this._children.getElement(n);
    }

    public int getSubTreeHeight(DTreeDeferringParent dTreeDeferringParent) {
        return this._subht;
    }

    public void itemsAdded(DTreeDeferringParent dTreeDeferringParent, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (this._children != null) {
            this._children.insertElements(n3, n4);
            int n5 = this._children.getNextIndex(n3);
            while (n5 != -1) {
                DTreeItem dTreeItem = (DTreeItem)this._children.getElement(n5);
                if (dTreeItem != null) {
                    dTreeItem.setIndex(n5);
                }
                n5 = this._children.getNextIndex(n5);
            }
        }
    }

    public void itemsRemoved(DTreeDeferringParent dTreeDeferringParent, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (this._children != null) {
            DTreeItem dTreeItem;
            int n5 = n3;
            while (n5 != -1 && n5 < n3 + n4) {
                dTreeItem = (DTreeItem)this._children.getElement(n5);
                if (dTreeItem != null) {
                    if (dTreeItem.isExpanded()) {
                        this._removeExpandedChild(dTreeDeferringParent, dTreeItem);
                    }
                    dTreeItem.itemRemoved();
                }
                n5 = this._children.getNextIndex(n5);
            }
            this._children.removeElements(n3, n4);
            n5 = n3;
            while (n5 != -1) {
                dTreeItem = (DTreeItem)this._children.getElement(n5);
                if (dTreeItem != null) {
                    dTreeItem.setIndex(n5);
                }
                n5 = this._children.getNextIndex(n5);
            }
        }
    }

    public void layout(DTreeDeferringParent dTreeDeferringParent, int n, int n2) {
        int n3 = this._parentht = dTreeDeferringParent.getSize().height;
        if (dTreeDeferringParent.isExpanded() && dTreeDeferringParent.getItemCount() != 0) {
            DTree dTree = dTreeDeferringParent.getTree();
            int n4 = this.getChildrenYOffset(dTreeDeferringParent, n3);
            int n5 = 0;
            if (dTreeDeferringParent != dTree.getRoot()) {
                n5 = this.getChildrenXOffset(dTreeDeferringParent, dTree.getIndentWidth());
            }
            int n6 = this._layoutChildren(dTreeDeferringParent, n + n5, n2 + n4);
            this._subht = Math.max(n3, n4 + n6);
        } else {
            this._subht = n3;
        }
    }

    protected int getChildrenXOffset(DTreeDeferringParent dTreeDeferringParent, int n) {
        return n;
    }

    protected int getChildrenYOffset(DTreeDeferringParent dTreeDeferringParent, int n) {
        return n;
    }

    private void _addExpandedChild(DTreeDeferringParent dTreeDeferringParent, DTreeItem dTreeItem) {
        if (this._expandedchildren == null) {
            this._expandedchildren = new DTreeItem[1];
        }
        if (this._nexpanded == this._expandedchildren.length) {
            DTreeItem[] dTreeItemArray = new DTreeItem[this._expandedchildren.length * 2];
            System.arraycopy(this._expandedchildren, 0, dTreeItemArray, 0, this._nexpanded);
            this._expandedchildren = dTreeItemArray;
        }
        int n = dTreeItem.getIndex();
        int n2 = 0;
        while (n2 < this._nexpanded) {
            if (n < this._expandedchildren[n2].getIndex()) {
                System.arraycopy(this._expandedchildren, n2, this._expandedchildren, n2 + 1, this._nexpanded - n2);
                break;
            }
            ++n2;
        }
        this._expandedchildren[n2] = dTreeItem;
        ++this._nexpanded;
    }

    private int _layoutChildren(DTreeDeferringParent dTreeDeferringParent, int n, int n2) {
        int n3 = 0;
        int n4 = dTreeDeferringParent.getChildHeight();
        if (dTreeDeferringParent.isExpanded() && this._nexpanded != 0) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < this._nexpanded) {
                DTreeItem dTreeItem = this._expandedchildren[n6];
                n5 = (dTreeItem.getIndex() - n6) * n4 + n3;
                dTreeItem.layout(n, n2 + n5);
                n3 += dTreeItem.getSubTreeHeight();
                ++n6;
            }
        }
        return n3 + (dTreeDeferringParent.getItemCount() - this._nexpanded) * n4;
    }

    private void _removeExpandedChild(DTreeDeferringParent dTreeDeferringParent, DTreeItem dTreeItem) {
        int n = 0;
        while (n < this._nexpanded) {
            if (this._expandedchildren[n] == dTreeItem) {
                if (n != this._nexpanded - 1) {
                    System.arraycopy(this._expandedchildren, n + 1, this._expandedchildren, n, this._nexpanded - n - 1);
                }
                --this._nexpanded;
                this._expandedchildren[this._nexpanded] = null;
                return;
            }
            ++n;
        }
    }

    private int _getParentHeight() {
        return this._parentht;
    }
}

