/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeRange;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.event.Cancelable;

public class DTreeMultipleSelectionManager
implements DTreeSelectionManager {
    private DTree _tree;
    private DTreeSelection _ranges;
    private DTreeItem _anchor;
    private PropertyChangeSupport _propSupport;
    private VetoableChangeSupport _vetoSupport;

    public DTreeMultipleSelectionManager() {
        this._setSelection(new DTreeSelection());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport == null) {
            this._propSupport = new PropertyChangeSupport(this);
        }
        this._propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoSupport == null) {
            this._vetoSupport = new VetoableChangeSupport(this);
        }
        this._vetoSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport != null) {
            this._propSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoSupport != null) {
            this._vetoSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setTree(DTree dTree) {
        if (dTree != this._tree) {
            this._setSelection(null);
            this._tree = dTree;
            this._setSelection(new DTreeSelection());
            this._anchor = null;
        }
    }

    public void extendSelection(DTreeItem dTreeItem) throws PropertyVetoException {
        DTreeRange[] dTreeRangeArray = new DTreeRange[1];
        int n = 0;
        DTreeItem dTreeItem2 = this._getAnchor();
        DTreeItem dTreeItem3 = null;
        DTreeItem dTreeItem4 = null;
        if (DTree.isItemBefore(dTreeItem2, dTreeItem)) {
            dTreeItem3 = dTreeItem2;
            dTreeItem4 = dTreeItem;
        } else {
            dTreeItem3 = dTreeItem;
            dTreeItem4 = dTreeItem2;
        }
        Enumeration enumeration = this._tree.getExpandedEnumeration();
        while (enumeration.hasMoreElements()) {
            Object object;
            DTreeItem dTreeItem5 = (DTreeItem)enumeration.nextElement();
            if (dTreeItem4 == dTreeItem5 || DTree.isItemBefore(dTreeItem4, dTreeItem5) || DTree.isItemBefore(dTreeItem5, dTreeItem3) && !DTree.isItemDescendent(dTreeItem3, dTreeItem5)) continue;
            int n2 = 0;
            int n3 = 0;
            if (dTreeItem3 == dTreeItem5 || DTree.isItemBefore(dTreeItem3, dTreeItem5)) {
                n2 = 0;
            } else if (dTreeItem3.getParent() == dTreeItem5) {
                n2 = dTreeItem3.getIndex();
            } else {
                object = dTreeItem3.getParent();
                while (object.getParent() != dTreeItem5) {
                    object = object.getParent();
                }
                n2 = object.getIndex() + 1;
            }
            if (!DTree.isItemDescendent(dTreeItem4, dTreeItem5)) {
                n3 = dTreeItem5.getItemCount() - n2;
            } else {
                object = dTreeItem4;
                while (object.getParent() != dTreeItem5) {
                    object = object.getParent();
                }
                n3 = object.getIndex() - n2 + 1;
            }
            object = new DTreeRange(dTreeItem5, n2, n3);
            if (n == dTreeRangeArray.length) {
                DTreeRange[] dTreeRangeArray2 = new DTreeRange[n * 2];
                System.arraycopy(dTreeRangeArray, 0, dTreeRangeArray2, 0, n);
                dTreeRangeArray = dTreeRangeArray2;
            }
            dTreeRangeArray[n] = object;
            ++n;
        }
        if (dTreeRangeArray.length != n) {
            DTreeRange[] dTreeRangeArray3 = new DTreeRange[n];
            System.arraycopy(dTreeRangeArray, 0, dTreeRangeArray3, 0, n);
            dTreeRangeArray = dTreeRangeArray3;
        }
        DTreeSelection dTreeSelection = new DTreeSelection();
        dTreeSelection.addRanges(dTreeRangeArray);
        this._setSelection(dTreeSelection, dTreeItem);
    }

    public boolean isSomethingSelected() {
        return this._ranges.getCount() > 0;
    }

    public DTreeSelection getSelection() {
        return (DTreeSelection)this._ranges.clone();
    }

    public DTree getTree() {
        return this._tree;
    }

    public boolean isSelected(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem.getParent();
        int n = dTreeItem.getIndex();
        int n2 = 0;
        while (n2 < this._ranges.getCount()) {
            DTreeRange dTreeRange = this._ranges.getRange(n2);
            if (dTreeRange.contains(dTreeItem2, n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void itemCollapsing(DTreeItemEvent dTreeItemEvent) {
        DTreeItem dTreeItem = dTreeItemEvent.getItem();
        DTreeSelection dTreeSelection = this.getSelection();
        DTreeSelection dTreeSelection2 = new DTreeSelection();
        int n = 0;
        while (n < dTreeSelection.getCount()) {
            DTreeRange dTreeRange = dTreeSelection.getRange(n);
            if (!DTree.isItemDescendent(dTreeRange.getParent(), dTreeItem)) {
                dTreeSelection2.addRange(dTreeRange);
            }
            ++n;
        }
        try {
            this.setSelection(dTreeSelection2);
        }
        catch (PropertyVetoException propertyVetoException) {
            ((Cancelable)((Object)dTreeItemEvent)).cancel();
        }
    }

    public void itemsAdded(DTreeItem dTreeItem, int n, int n2) {
    }

    public void itemsRemoved(DTreeItem dTreeItem, int n, int n2) {
    }

    public void selectItem(DTreeItem dTreeItem) throws PropertyVetoException {
        DTreeSelection dTreeSelection = new DTreeSelection();
        if (dTreeItem != null) {
            dTreeSelection.addRange(new DTreeRange(dTreeItem.getParent(), dTreeItem.getIndex(), 1));
        }
        this._setSelection(dTreeSelection, dTreeItem);
        this._setAnchor(dTreeItem);
    }

    public void setSelection(DTreeSelection dTreeSelection) throws PropertyVetoException {
        this._setSelection(dTreeSelection, null);
    }

    public void toggleItem(DTreeItem dTreeItem) throws PropertyVetoException {
        DTreeSelection dTreeSelection = this.getSelection();
        DTreeSelection dTreeSelection2 = null;
        if (!this.isSelected(dTreeItem)) {
            dTreeSelection2 = this.getSelection();
            dTreeSelection2.addRange(new DTreeRange(dTreeItem.getParent(), dTreeItem.getIndex(), 1));
        } else {
            DTreeItem dTreeItem2 = dTreeItem.getParent();
            int n = dTreeItem.getIndex();
            dTreeSelection2 = new DTreeSelection();
            int n2 = 0;
            while (n2 < dTreeSelection.getCount()) {
                DTreeRange dTreeRange = dTreeSelection.getRange(n2);
                if (!dTreeRange.contains(dTreeItem2, n)) {
                    dTreeSelection2.addRange(dTreeRange);
                } else {
                    int n3 = dTreeRange.getStartIndex();
                    int n4 = dTreeRange.getCount();
                    if (n > n3) {
                        dTreeSelection2.addRange(new DTreeRange(dTreeItem2, n3, n - n3));
                    }
                    if (n < n3 + n4 - 1) {
                        dTreeSelection2.addRange(new DTreeRange(dTreeItem2, n + 1, n3 + n4 - (n + 1)));
                    }
                }
                ++n2;
            }
        }
        this._setSelection(dTreeSelection2, dTreeItem);
        this._setAnchor(dTreeItem);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propSupport != null) {
            this._propSupport.firePropertyChange(string, object, object2);
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this._vetoSupport != null) {
            this._vetoSupport.fireVetoableChange(string, object, object2);
        }
    }

    protected DTreeSelection filterSelection(DTreeSelection dTreeSelection) {
        return dTreeSelection;
    }

    private DTreeItem _getAnchor() {
        if (this._anchor == null) {
            this._anchor = this._tree.getRoot();
        }
        return this._anchor;
    }

    private void _setAnchor(DTreeItem dTreeItem) {
        this._anchor = dTreeItem;
    }

    private void _setFocusedItem(DTreeItem dTreeItem) {
        if (dTreeItem != null) {
            DTree dTree = this.getTree();
            dTree.setFocusedItem(dTreeItem);
        }
    }

    private void _setSelection(DTreeSelection dTreeSelection, DTreeItem dTreeItem) throws PropertyVetoException {
        DTreeSelection dTreeSelection2 = this.getSelection();
        boolean bl = dTreeSelection == null;
        DTreeSelection dTreeSelection3 = bl ? new DTreeSelection() : this.filterSelection((DTreeSelection)dTreeSelection.clone());
        if (dTreeSelection2.equals(dTreeSelection)) {
            return;
        }
        this.fireVetoableChange("selection", dTreeSelection2, dTreeSelection3);
        this._setSelection(dTreeSelection3);
        this._setFocusedItem(dTreeItem);
        if (bl) {
            this._setAnchor(null);
        } else if (this._anchor == null) {
            this._setAnchor(dTreeSelection3.getFirstItem());
        }
        this.firePropertyChange("selection", dTreeSelection2, dTreeSelection3);
    }

    private void _setSelection(DTreeSelection dTreeSelection) {
        DTree dTree;
        if (dTreeSelection != this._ranges && (dTree = this.getTree()) != null) {
            if (this._ranges != null) {
                dTree.__removeSelection(this._ranges);
            }
            this._ranges = dTreeSelection;
            if (this._ranges != null) {
                dTree.__addSelection(this._ranges);
            }
        }
    }
}

