/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.chooser.color.CustomColorPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class ColorPickerPane
extends LWComponent
implements Accessible {
    public static final int RGB_TOOLTIP = 0;
    public static final int RGB_HEX_TOOLTIP = 1;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    public static final String PROPERTY_COLOR_PALETTE = "customColorPalette";
    public static final String PROPERTY_CUSTOM_COLOR_NAMES = "customColorNames";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_DEFAULT_SELECTED = "defaultSelected";
    public static final String PROPERTY_AUTOMATIC_SELECTED = "automaticSelected";
    private static final String _RESOURCE_FILE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_TITLE = "COLORPICKERPANE.TITLE";
    private static final String _KEY_COLOR_LABEL = "COLORPICKERPANE.COLOR_LABEL";
    private static final String _KEY_DEFAULT = "COLORCHOICE.DEFAULT";
    private static final String _KEY_AUTOMATIC = "COLORCHOICE.AUTOMATIC";
    private static final String _KEY_TRANSPARENT = "COLORCHOICE.NO_COLOR";
    private static final String _KEY_NONE = "COLORCHOICE.NONE";
    private static final String _KEY_CUSTOM_COLOR = "COLORCHOICE.EDIT_COLOR";
    private static final String _KEY_NO_COLOR_TIP = "COLORPALETTE.NO_COLOR";
    private static final String _KEY_DEFAULT_TIP = "COLORCHOICE.DEFAULT_TOOLTIP";
    private static final String _KEY_CUSTOM_TIP = "COLORCHOICE.CUSTOM_TOOLTIP";
    private static final String _ICON_NO_COLOR = "images/trans_icon.gif";
    private static final String _ICON_AUTO = "images/auto_icon.gif";
    private static final String _ICON_DEFAULT = "images/default_icon.gif";
    private static final Color _DEFAULT_COLOR_TO_CHANGE = Color.white;
    private static final int _MIN_COL_COUNT = 5;
    private static final int _MIN_ROW_COUNT = 3;
    private static final int _CUSTOM_ROW_COUNT = 2;
    private static final int _COLOR_LABEL = 1;
    private static final int _DEFAULT_BUTTON = 2;
    private static final int _TRANSPARENT_BUTTON = 3;
    private static final int _PALETTE = 4;
    private static final int _CUSTOM_BUTTON = 5;
    private static final Dimension _EMPTY_SIZE = new Dimension();
    private static final String _TRANSPARENT_NAME = "Transparent_Button";
    private static final String _DEFAULT_NAME = "Default_Button";
    private static final String _AUTOMATIC_NAME = "Automatic_Button";
    private static final String _CUSTOM_NAME = "Custom_Button";
    private static final String _GRID_NAME = "ColorPalette_Grid";
    private static final String _CUSTOM_GRID_NAME = "CustomColorPalette_Grid";
    private static Image _sDefaultButtonImage;
    private static ImageIcon _sAutomaticIcon;
    private static ImageIcon _sTransparentIcon;
    private boolean _initialized;
    private boolean _ignoreEvents;
    private EventHandler _eventHandler = new EventHandler();
    private JLabel _colorLabel;
    private JToggleButton _defaultButton;
    private boolean _defaultSelected;
    private Color _defaultColor;
    private ImageFilter _defaultImageFilter;
    private Color _firstPaletteColor;
    private JToggleButton _automaticButton;
    private boolean _automaticSelected;
    private JToggleButton _transparentButton;
    private boolean _isTransparentLabel = true;
    private ColorGrid _colorGrid;
    private ColorGrid _customGrid;
    private JScrollPane _scrollPane;
    private JButton _customButton;
    private Icon _customIcon;
    private Color _customColor;
    private CustomColorPane _customColorPane;
    private boolean _customPaletteDirty;
    private boolean _customNamesDirty;
    private boolean _updateCustomPalette = true;
    private boolean _updateCustomNames = true;
    private boolean _focusCycleDirty = true;
    private List _focusCycle;
    private Color _selectedColor;
    static /* synthetic */ Class class$oracle$bali$ewt$chooser$color$ColorPickerPane;

    public ColorPickerPane() {
        this(null, null, null);
    }

    public ColorPickerPane(Color color) {
        this(null, null, color);
    }

    public ColorPickerPane(TwoDModel twoDModel, Color color) {
        this(twoDModel, null, color);
    }

    public ColorPickerPane(TwoDModel twoDModel, TwoDModel twoDModel2, Color color) {
        this._createAndLayoutUI();
        this.setToolTipMode(0);
        this.setColorPalette(twoDModel);
        this.setCustomColorPalette(twoDModel2);
        this.setSelectedColor(color);
        this._initialized = true;
    }

    public static int showDialog(Component component, ColorPickerPane colorPickerPane) {
        return ColorPickerPane.showDialog(component, colorPickerPane, null, false);
    }

    public static int showDialog(Component component, ColorPickerPane colorPickerPane, String string, boolean bl) {
        Object object;
        if (colorPickerPane == null) {
            throw new IllegalArgumentException("ColorPickerPane must be non-null");
        }
        Locale locale = LocaleUtils.getDefaultableLocale((Component)colorPickerPane);
        if (string == null) {
            object = colorPickerPane._getResourceBundle(locale);
            string = ((ResourceBundle)object).getString(_KEY_TITLE);
        }
        object = JEWTDialog.createDialog(component, string, 7);
        ((Component)object).setLocale(locale);
        ((JEWTDialog)object).setContent(colorPickerPane);
        ((JEWTDialog)object).setCenterOver(component);
        ((Dialog)object).setResizable(bl);
        ((JEWTDialog)object).setInitialFocus(colorPickerPane._getInitialFocus());
        int n = ((JEWTDialog)object).runDialog() ? 1 : 2;
        ((JEWTDialog)object).dispose();
        return n;
    }

    public void setDefaultAllowed(boolean bl) {
        if (bl != this.isDefaultAllowed()) {
            if (bl) {
                this.setAutomaticAllowed(false);
            }
            if (this._defaultButton == null) {
                this._createAndLayoutDefaultButton();
                this.revalidate();
                this.repaint();
            }
            this._defaultButton.setVisible(bl);
            this._updateColorLabelFor();
            this._focusCycleDirty = true;
        }
    }

    public boolean isDefaultAllowed() {
        return this._defaultButton != null && this._defaultButton.isVisible();
    }

    public void setDefaultColor(Color color) {
        Color color2 = this.getDefaultColor();
        this._defaultColor = color;
        if (color2 == null || !color2.equals(color)) {
            if (this._defaultButton != null) {
                this._updateDefaultButtonIcon();
                this._updateButtonTips(2);
            }
            if (this.isDefaultSelected()) {
                this.firePropertyChange(PROPERTY_SELECTED_COLOR, color2, this._defaultColor);
            }
        }
    }

    public Color getDefaultColor() {
        if (this._defaultColor == null) {
            TwoDModel twoDModel;
            if (this._firstPaletteColor == null && (twoDModel = this.getColorPalette()) != null && twoDModel.getColumnCount() > 0 && twoDModel.getRowCount() > 0) {
                this._firstPaletteColor = (Color)twoDModel.getData(0, 0);
            }
            return this._firstPaletteColor;
        }
        return this._defaultColor;
    }

    public void setDefaultSelected(boolean bl) {
        if (bl != this.isDefaultSelected()) {
            this._ignoreEvents = true;
            this._setDefaultSelected(bl);
            if (bl) {
                this._setAutomaticSelected(false);
                this._setTransparentSelected(false);
                this._setSelectedColorInPalette(null);
            } else if (this._selectedColor == null) {
                this._setTransparentSelected(true);
            } else {
                this._setSelectedColorInPalette(this._selectedColor);
            }
            this._ignoreEvents = false;
            Color color = this.getDefaultColor();
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, bl ? this._selectedColor : color, bl ? color : this._selectedColor);
        }
    }

    public boolean isDefaultSelected() {
        return this._defaultSelected;
    }

    public void setAutomaticAllowed(boolean bl) {
        if (bl != this.isAutomaticAllowed()) {
            if (bl) {
                this.setDefaultAllowed(false);
            }
            if (this._automaticButton == null) {
                this._createAndLayoutAutomaticButton();
                this.revalidate();
                this.repaint();
            }
            this._automaticButton.setVisible(bl);
            this._updateColorLabelFor();
            this._focusCycleDirty = true;
        }
    }

    public boolean isAutomaticAllowed() {
        return this._automaticButton != null && this._automaticButton.isVisible();
    }

    public void setAutomaticSelected(boolean bl) {
        if (bl != this.isAutomaticSelected()) {
            this._ignoreEvents = true;
            Color color = this._selectedColor;
            this._selectedColor = null;
            this._setAutomaticSelected(bl);
            if (bl) {
                this._setDefaultSelected(false);
                this._setTransparentSelected(false);
                this._setSelectedColorInPalette(null);
            } else {
                this._setTransparentSelected(true);
            }
            this._ignoreEvents = false;
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, color, this._selectedColor);
        }
    }

    public boolean isAutomaticSelected() {
        return this._automaticSelected;
    }

    public void setTransparentAllowed(boolean bl) {
        if (bl != this.isTransparentAllowed()) {
            if (this._transparentButton == null) {
                this._createAndLayoutTransparentButton();
                this.revalidate();
                this.repaint();
            }
            this._transparentButton.setVisible(bl);
            this._updateColorLabelFor();
            this._focusCycleDirty = true;
        }
    }

    public boolean isTransparentAllowed() {
        return this._transparentButton != null && this._transparentButton.isVisible();
    }

    public void setTransparentLabelUsed(boolean bl) {
        if (bl != this.isTransparentLabelUsed()) {
            this._isTransparentLabel = bl;
            if (this._transparentButton != null) {
                this._updateTransparentText(this._getResourceBundle(null));
            }
        }
    }

    public boolean isTransparentLabelUsed() {
        return this._isTransparentLabel;
    }

    public void setCustomizationAllowed(boolean bl) {
        if (bl != this.isCustomizationAllowed()) {
            if (this._customButton == null) {
                this._createAndLayoutCustomButton();
                this.revalidate();
                this.repaint();
            }
            this._customButton.setVisible(bl);
            if (bl) {
                this._updateCustomButtonIcon();
                this._updateButtonTips(5);
            }
            this._focusCycleDirty = true;
        }
    }

    public boolean isCustomizationAllowed() {
        return this._customButton != null && this._customButton.isVisible();
    }

    public void setColorPalette(TwoDModel twoDModel) {
        this._colorGrid.setColorPalette(twoDModel);
    }

    public TwoDModel getColorPalette() {
        return this._colorGrid.getColorPalette();
    }

    public void setCustomColorPalette(TwoDModel twoDModel) {
        boolean bl;
        boolean bl2 = bl = twoDModel != null && twoDModel.getColumnCount() > 0 && twoDModel.getRowCount() > 0;
        if (bl != this._customGrid.isVisible()) {
            this._customGrid.setVisible(bl);
            this._focusCycleDirty = true;
        }
        this._customGrid.setColorPalette(twoDModel);
    }

    public TwoDModel getCustomColorPalette() {
        return this._customGrid.getColorPalette();
    }

    public void setCustomColorNames(TwoDModel twoDModel) {
        TwoDModel twoDModel2 = this._customGrid.__getColorNames();
        if (twoDModel2 != twoDModel) {
            this._customGrid.__setColorNames(twoDModel);
            this._updateCustomNames = true;
            this.firePropertyChange(PROPERTY_CUSTOM_COLOR_NAMES, twoDModel2, twoDModel);
        }
    }

    public TwoDModel getCustomColorNames() {
        return this._customGrid.__getColorNames();
    }

    public String getCustomColorName() {
        if (!this._customGrid.isVisible()) {
            return null;
        }
        TwoDModel twoDModel = this.getCustomColorNames();
        if (twoDModel != null) {
            Object object;
            int n = this._customGrid.__getSelectedColumn();
            int n2 = this._customGrid.__getSelectedRow();
            if (n != -1 && n2 != -1 && n < twoDModel.getColumnCount() && n2 < twoDModel.getRowCount() && (object = twoDModel.getData(n, n2)) instanceof String) {
                return (String)object;
            }
        }
        return null;
    }

    public void setSelectedColor(Color color) {
        this._ignoreEvents = true;
        Color color2 = this._selectedColor;
        this._selectedColor = color;
        this._setDefaultSelected(false);
        if (this._selectedColor != null) {
            this._setAutomaticSelected(false);
            this._setTransparentSelected(false);
        } else if (!this.isAutomaticSelected()) {
            this._setTransparentSelected(true);
        }
        this._setSelectedColorInPalette(this._selectedColor);
        this._ignoreEvents = false;
        this.firePropertyChange(PROPERTY_SELECTED_COLOR, color2, this._selectedColor);
    }

    public Color getSelectedColor() {
        if (this.isDefaultSelected()) {
            return this.getDefaultColor();
        }
        return this._selectedColor;
    }

    public void setToolTipMode(int n) {
        if (n != this.getToolTipMode()) {
            this._colorGrid.setToolTipMode(n);
            this._customGrid.setToolTipMode(n);
            if (this._defaultButton != null) {
                this._updateButtonTips(2);
            }
            if (this.isCustomizationAllowed()) {
                this._updateButtonTips(5);
            }
        }
    }

    public int getToolTipMode() {
        return this._colorGrid.getToolTipMode();
    }

    public CustomColorPane getCustomColorPane() {
        if (this._customColorPane == null) {
            this._customColorPane = new CustomColorPane();
        }
        this._configureCustomColorPane(this._customColorPane);
        return this._customColorPane;
    }

    public void dispose() {
        if (this._eventHandler == null) {
            return;
        }
        this._colorLabel = null;
        if (this._defaultButton != null) {
            this.__unregisterButtonActions(this._defaultButton);
            this._defaultButton = null;
        }
        if (this._automaticButton != null) {
            this.__unregisterButtonActions(this._automaticButton);
            this._automaticButton = null;
        }
        if (this._transparentButton != null) {
            this.__unregisterButtonActions(this._transparentButton);
            this._transparentButton = null;
        }
        if (this._customButton != null) {
            this.__unregisterCustomButtonActions(this._customButton);
            this._customButton = null;
        }
        this._colorGrid.removePropertyChangeListener(this._eventHandler);
        this._colorGrid.dispose();
        this._colorGrid = null;
        this._customGrid.removePropertyChangeListener(this._eventHandler);
        this._customGrid.dispose();
        this._customGrid = null;
        this._scrollPane = null;
        if (this._customColorPane != null) {
            this._customColorPane.dispose();
            this._customColorPane = null;
        }
        if (this._focusCycle != null) {
            this._focusCycle.clear();
            this._focusCycle = null;
        }
        this._eventHandler = null;
    }

    public void updateUI() {
        super.updateUI();
        if (this._customColorPane != null) {
            SwingUtilities.updateComponentTreeUI(this._customColorPane);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        throw new IllegalArgumentException("setLayout() not supported");
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this._colorLabel != null) {
            this._colorLabel.setEnabled(bl);
        }
        if (this._defaultButton != null) {
            this._defaultButton.setEnabled(bl);
        }
        if (this._automaticButton != null) {
            this._automaticButton.setEnabled(bl);
        }
        if (this._transparentButton != null) {
            this._transparentButton.setEnabled(bl);
        }
        this._colorGrid.setEnabled(bl);
        this._customGrid.setEnabled(bl);
        if (this._customButton != null) {
            this._customButton.setEnabled(bl);
        }
    }

    public void addNotify() {
        super.addNotify();
        this._updateLabels(this.getLocale());
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._initialized) {
            this._updateLabels(locale);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleColorPickerPane();
        }
        return this.accessibleContext;
    }

    JLabel __createColorLabel() {
        return new JLabel();
    }

    void __registerButtonActions(JToggleButton jToggleButton) {
        jToggleButton.addItemListener(this._eventHandler);
    }

    void __unregisterButtonActions(JToggleButton jToggleButton) {
        jToggleButton.removeItemListener(this._eventHandler);
    }

    void __registerCustomButtonActions(JButton jButton) {
        jButton.addActionListener(this._eventHandler);
    }

    void __unregisterCustomButtonActions(JButton jButton) {
        jButton.removeActionListener(this._eventHandler);
    }

    JButton __getCustomButton() {
        return this._customButton;
    }

    ColorGrid __getStandardGrid() {
        return this._colorGrid;
    }

    ColorGrid __getCustomGrid() {
        return this._customGrid;
    }

    CustomColorPane __getCustomColorPane() {
        return this.getCustomColorPane();
    }

    void __launchCustomColorPane() {
        CustomColorPane customColorPane = this.__getCustomColorPane();
        if (customColorPane == null) {
            return;
        }
        this._configureCustomColorPane(customColorPane);
        customColorPane.addPropertyChangeListener(this._eventHandler);
        this._customPaletteDirty = false;
        this._customNamesDirty = false;
        if (this.__showPaneInDialog(customColorPane)) {
            TwoDModel twoDModel;
            if (this._customPaletteDirty && (twoDModel = this.getCustomColorPalette()) != null) {
                ColorPickerUtils.copyModel(customColorPane.getCustomColorPalette(), twoDModel);
                this.firePropertyChange(PROPERTY_COLOR_PALETTE, null, twoDModel);
            }
            if (this._customNamesDirty) {
                TwoDModel twoDModel2;
                twoDModel = customColorPane.getCustomColorNames();
                TwoDModel twoDModel3 = twoDModel2 = this.getCustomColorNames();
                if (twoDModel != null) {
                    int n = twoDModel.getColumnCount();
                    int n2 = twoDModel.getRowCount();
                    if (twoDModel2 == null) {
                        twoDModel3 = new ArrayTwoDModel(n, n2);
                    } else {
                        int n3 = twoDModel2.getColumnCount();
                        int n4 = twoDModel2.getRowCount();
                        if (n > n3 || n2 > n4) {
                            n3 = Math.max(n3, n);
                            n4 = Math.max(n4, n2);
                            twoDModel3 = new ArrayTwoDModel(n3, n4);
                            ColorPickerUtils.copyModel(twoDModel2, twoDModel3);
                        }
                    }
                    ColorPickerUtils.copyModel(twoDModel, twoDModel3);
                }
                if (twoDModel3 != twoDModel2) {
                    this.setCustomColorNames(twoDModel3);
                } else {
                    this.firePropertyChange(PROPERTY_CUSTOM_COLOR_NAMES, null, twoDModel3);
                }
            }
            this.setSelectedColor(customColorPane.getSelectedColor());
        }
        customColorPane.removePropertyChangeListener(this._eventHandler);
        this._updateCustomPalette = this._customPaletteDirty;
        this._updateCustomNames = this._customNamesDirty;
    }

    boolean __showPaneInDialog(CustomColorPane customColorPane) {
        return CustomColorPane.showDialog(this, customColorPane) == 1;
    }

    List __getFocusCycle() {
        if (!this._focusCycleDirty && this._focusCycle != null) {
            return this._focusCycle;
        }
        this._focusCycle = new ArrayList(1);
        if (this.isDefaultAllowed()) {
            this._focusCycle.add(this._defaultButton);
        } else if (this.isAutomaticAllowed()) {
            this._focusCycle.add(this._automaticButton);
        }
        if (this.isTransparentAllowed()) {
            this._focusCycle.add(this._transparentButton);
        }
        this._focusCycle.add(this._colorGrid);
        if (this._customGrid.isVisible()) {
            this._focusCycle.add(this._customGrid);
        }
        if (this.isCustomizationAllowed()) {
            this._focusCycle.add(this._customButton);
        }
        this._focusCycleDirty = false;
        return this._focusCycle;
    }

    private void _createAndLayoutUI() {
        super.setLayout(new PaneLayout(5));
        this._createAndLayoutColorLabel();
        this._createAndLayoutGridPanel();
        this._updateColorLabelFor();
    }

    private void _createAndLayoutColorLabel() {
        this._colorLabel = this.__createColorLabel();
        if (this._colorLabel != null) {
            this.add(this._colorLabel);
        }
    }

    private void _updateColorLabelText(ResourceBundle resourceBundle) {
        String string = resourceBundle.getString(_KEY_COLOR_LABEL);
        this._colorLabel.setText(StringUtils.stripMnemonic((String)string));
        this._colorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
    }

    private void _updateColorLabelFor() {
        if (this._colorLabel != null) {
            JComponent jComponent = this._colorGrid;
            if (this.isDefaultAllowed()) {
                jComponent = this._defaultButton;
            } else if (this.isAutomaticAllowed()) {
                jComponent = this._automaticButton;
            } else if (this.isTransparentAllowed()) {
                jComponent = this._transparentButton;
            }
            this._colorLabel.setLabelFor(jComponent);
        }
    }

    private void _createAndLayoutDefaultButton() {
        this._defaultButton = new ColorToggleButton();
        this._defaultButton.setSelected(this.isDefaultSelected());
        this._defaultButton.setName(_DEFAULT_NAME);
        this._defaultButton.setHorizontalAlignment(10);
        this._updateDefaultText(this._getResourceBundle(null));
        this._updateDefaultButtonIcon();
        this._updateButtonTips(2);
        this.__registerButtonActions(this._defaultButton);
        this.add(this._defaultButton);
    }

    private void _updateDefaultText(ResourceBundle resourceBundle) {
        String string = resourceBundle.getString(_KEY_DEFAULT);
        this._defaultButton.setText(StringUtils.stripMnemonic((String)string));
        if (this._colorLabel == null) {
            this._defaultButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
    }

    private void _updateDefaultButtonIcon() {
        Icon icon = this._defaultButton.getIcon();
        if (!(icon instanceof ImageIcon)) {
            icon = new ImageIcon();
            this._defaultButton.setIcon(icon);
        }
        if (_sDefaultButtonImage == null) {
            _sDefaultButtonImage = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorPickerPane == null ? (class$oracle$bali$ewt$chooser$color$ColorPickerPane = ColorPickerPane.class$("oracle.bali.ewt.chooser.color.ColorPickerPane")) : class$oracle$bali$ewt$chooser$color$ColorPickerPane, _ICON_DEFAULT);
        }
        if (this._defaultImageFilter == null) {
            this._defaultImageFilter = ColorPickerUtils.createColorFilter(_DEFAULT_COLOR_TO_CHANGE);
        }
        ImageIcon imageIcon = (ImageIcon)icon;
        Image image = _sDefaultButtonImage;
        Color color = this.getDefaultColor();
        Image image2 = ColorPickerUtils.createFilteredImage(image, this._defaultImageFilter, color);
        imageIcon.setImage(image2);
        Icon icon2 = this._defaultButton.getDisabledIcon();
        if (!(icon2 instanceof ImageIcon)) {
            icon2 = new ImageIcon();
            this._defaultButton.setDisabledIcon(icon2);
        }
        ImageIcon imageIcon2 = (ImageIcon)icon2;
        imageIcon2.setImage(ImageUtils.createDisabledImage(image2));
        this._defaultButton.repaint();
    }

    private void _createAndLayoutAutomaticButton() {
        this._automaticButton = new ColorToggleButton();
        this._automaticButton.setSelected(this.isAutomaticSelected());
        this._automaticButton.setName(_AUTOMATIC_NAME);
        this._automaticButton.setHorizontalAlignment(10);
        this._updateAutomaticText(this._getResourceBundle(null));
        if (_sAutomaticIcon == null) {
            _sAutomaticIcon = new ImageIcon(ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorPickerPane == null ? (class$oracle$bali$ewt$chooser$color$ColorPickerPane = ColorPickerPane.class$("oracle.bali.ewt.chooser.color.ColorPickerPane")) : class$oracle$bali$ewt$chooser$color$ColorPickerPane, _ICON_AUTO));
        }
        this._automaticButton.setIcon(_sAutomaticIcon);
        this.__registerButtonActions(this._automaticButton);
        this.add(this._automaticButton);
    }

    private void _updateAutomaticText(ResourceBundle resourceBundle) {
        String string = resourceBundle.getString(_KEY_AUTOMATIC);
        this._automaticButton.setText(StringUtils.stripMnemonic((String)string));
        if (this._colorLabel == null) {
            this._automaticButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
    }

    private void _createAndLayoutTransparentButton() {
        this._transparentButton = new ColorToggleButton();
        this._transparentButton.setSelected(this.getSelectedColor() == null && !this.isAutomaticSelected());
        this._transparentButton.setName(_TRANSPARENT_NAME);
        this._transparentButton.setHorizontalAlignment(10);
        this._updateTransparentText(this._getResourceBundle(null));
        if (_sTransparentIcon == null) {
            _sTransparentIcon = new ImageIcon(ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorPickerPane == null ? (class$oracle$bali$ewt$chooser$color$ColorPickerPane = ColorPickerPane.class$("oracle.bali.ewt.chooser.color.ColorPickerPane")) : class$oracle$bali$ewt$chooser$color$ColorPickerPane, _ICON_NO_COLOR));
        }
        this._transparentButton.setIcon(_sTransparentIcon);
        this.__registerButtonActions(this._transparentButton);
        this.add(this._transparentButton);
    }

    private void _updateTransparentText(ResourceBundle resourceBundle) {
        String string = this.isTransparentLabelUsed() ? resourceBundle.getString(_KEY_TRANSPARENT) : resourceBundle.getString(_KEY_NONE);
        this._transparentButton.setText(StringUtils.stripMnemonic((String)string));
        if (this._colorLabel == null) {
            this._transparentButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
    }

    private void _createAndLayoutGridPanel() {
        this._colorGrid = new ColorGrid();
        this._colorGrid.setName(_GRID_NAME);
        this._colorGrid.setOpaque(false);
        this._colorGrid.addPropertyChangeListener(this._eventHandler);
        this._customGrid = new ColorGrid(true);
        this._customGrid.setName(_CUSTOM_GRID_NAME);
        this._customGrid.setOpaque(false);
        this._customGrid.addPropertyChangeListener(this._eventHandler);
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        jPanel.add((Component)this._colorGrid, "West");
        jPanel.add((Component)this._customGrid, "South");
        jPanel.setOpaque(false);
        this._scrollPane = new JScrollPane(jPanel);
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this._scrollPane.setOpaque(false);
        this._scrollPane.getViewport().setOpaque(false);
        FocusUtils.setFocusable(this._scrollPane.getHorizontalScrollBar(), false);
        FocusUtils.setFocusable(this._scrollPane.getVerticalScrollBar(), false);
        FocusUtils.setFocusable(this._scrollPane, false);
        int n = this._colorGrid.getDefaultColumnWidth();
        int n2 = this._colorGrid.getDefaultRowHeight();
        Dimension dimension = this._colorGrid.convertInnerToOuterSize(n * 5, n2 * 3);
        this._scrollPane.getViewport().setMinimumSize(dimension);
        this.add(this._scrollPane);
    }

    private void _createAndLayoutCustomButton() {
        this._customButton = new CustomButton();
        this._customButton.setName(_CUSTOM_NAME);
        this._updateCustomText(this._getResourceBundle(null));
        this.__registerCustomButtonActions(this._customButton);
        this.add(this._customButton);
    }

    private void _updateCustomText(ResourceBundle resourceBundle) {
        String string = resourceBundle.getString(_KEY_CUSTOM_COLOR);
        this._customButton.setText(StringUtils.stripMnemonic((String)string));
        this._customButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
    }

    private void _updateCustomButtonIcon() {
        Color color = this._getCustomColor();
        if (color == null) {
            this._customButton.setIcon(null);
        } else {
            if (this._customIcon == null) {
                this._customIcon = new PainterIcon(this._customButton, ColorPickerUtils.getSelectedColorPainter());
            }
            this._customButton.setIcon(this._customIcon);
        }
    }

    private void _updateButtonTips(int n) {
        if (n != 2 && n != 5) {
            return;
        }
        boolean bl = n == 2;
        Color color = bl ? this.getDefaultColor() : this._getCustomColor();
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        String string = null;
        int n2 = this.getToolTipMode();
        if (color != null && n2 == 1) {
            string = ColorUtils.colorToHTML(color).toUpperCase(locale);
        } else {
            ResourceBundle resourceBundle = this._getResourceBundle(locale);
            if (color == null && bl) {
                string = resourceBundle.getString(_KEY_NO_COLOR_TIP);
            } else if (color != null) {
                String string2 = bl ? _KEY_DEFAULT_TIP : _KEY_CUSTOM_TIP;
                String string3 = resourceBundle.getString(string2);
                Object[] objectArray = new Object[]{IntegerUtils.getInteger((int)color.getRed()), IntegerUtils.getInteger((int)color.getGreen()), IntegerUtils.getInteger((int)color.getBlue())};
                string = MessageFormat.format(string3, objectArray);
            }
        }
        if (bl) {
            this._defaultButton.setToolTipText(string);
            this._defaultButton.getAccessibleContext().setAccessibleName(string);
        } else {
            this._customButton.setToolTipText(string);
            this._customButton.getAccessibleContext().setAccessibleName(string);
        }
    }

    private void _updateLabels(Locale locale) {
        if (locale == null) {
            Locale.getDefault();
        }
        ResourceBundle resourceBundle = this._getResourceBundle(locale);
        if (this._colorLabel != null) {
            this._updateColorLabelText(resourceBundle);
        }
        if (this._defaultButton != null) {
            this._updateDefaultText(resourceBundle);
            this._updateButtonTips(2);
        }
        if (this._automaticButton != null) {
            this._updateAutomaticText(resourceBundle);
        }
        if (this._transparentButton != null) {
            this._updateTransparentText(resourceBundle);
        }
        if (this._customButton != null) {
            this._updateCustomText(resourceBundle);
            this._updateButtonTips(5);
        }
        this._colorGrid.setLocale(locale);
        this._customGrid.setLocale(locale);
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = LocaleUtils.getDefaultableLocale((Component)this);
        }
        return ResourceBundle.getBundle(_RESOURCE_FILE, locale);
    }

    private Component _getInitialFocus() {
        if (this.isDefaultAllowed() && this.isDefaultSelected()) {
            return this._defaultButton;
        }
        if (this.isAutomaticAllowed() && this.isAutomaticSelected()) {
            return this._automaticButton;
        }
        if (this._selectedColor == null && this.isTransparentAllowed()) {
            return this._transparentButton;
        }
        if (this.isCustomizationAllowed() && this._getCustomColor() != null) {
            return this._customButton;
        }
        if (this._customGrid.isVisible() && this._customGrid.__getSelectedColumn() != -1 && this._customGrid.__getSelectedRow() != -1) {
            return this._customGrid;
        }
        return this._colorGrid;
    }

    private void _setDefaultSelected(boolean bl) {
        if (bl != this.isDefaultSelected()) {
            this._defaultSelected = bl;
            if (this._defaultButton != null) {
                this._defaultButton.setSelected(bl);
            }
            this.firePropertyChange(PROPERTY_DEFAULT_SELECTED, !bl, bl);
        }
    }

    private void _setAutomaticSelected(boolean bl) {
        if (bl != this.isAutomaticSelected()) {
            this._automaticSelected = bl;
            if (this._automaticButton != null) {
                this._automaticButton.setSelected(bl);
            }
            this.firePropertyChange(PROPERTY_AUTOMATIC_SELECTED, !bl, bl);
        }
    }

    private void _setTransparentSelected(boolean bl) {
        if (this._transparentButton != null) {
            this._transparentButton.setSelected(bl);
        }
    }

    private void _setSelectedColorInPalette(Color color) {
        try {
            this._colorGrid.setSelectedColor(color);
            this._customGrid.setSelectedColor(null);
            this._setCustomColor(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._colorGrid.setSelectedColor(null);
            if (this._customGrid.isVisible()) {
                try {
                    this._customGrid.setSelectedColor(color);
                    this._setCustomColor(null);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    this._customGrid.setSelectedColor(null);
                    this._setCustomColor(color);
                }
            }
            this._setCustomColor(color);
        }
    }

    private void _setCustomColor(Color color) {
        Color color2 = this._getCustomColor();
        if (color2 != color) {
            this._customColor = color;
            if (this.isCustomizationAllowed()) {
                this._updateCustomButtonIcon();
                this._updateButtonTips(5);
            }
        }
    }

    private Color _getCustomColor() {
        return this._customColor;
    }

    private void _selectedColorChanged(Object object, boolean bl, Color color) {
        if (!this._ignoreEvents) {
            this._ignoreEvents = true;
            Color color2 = this.getSelectedColor();
            if (bl) {
                if (object == this._defaultButton) {
                    this._setDefaultSelected(true);
                } else {
                    this._setDefaultSelected(false);
                }
                if (object == this._automaticButton) {
                    this._selectedColor = null;
                    this._setAutomaticSelected(true);
                } else {
                    this._setAutomaticSelected(false);
                }
                if (object == this._transparentButton) {
                    this._selectedColor = null;
                    this._setTransparentSelected(true);
                } else {
                    this._setTransparentSelected(false);
                }
                if (object == this._colorGrid) {
                    this._selectedColor = color;
                } else {
                    this._colorGrid.setSelectedColor(null);
                }
                if (object == this._customGrid) {
                    this._selectedColor = color;
                } else {
                    this._customGrid.setSelectedColor(null);
                }
                this._setCustomColor(null);
                this.firePropertyChange(PROPERTY_SELECTED_COLOR, color2, this.getSelectedColor());
            } else if (object instanceof JToggleButton) {
                ((JToggleButton)object).setSelected(true);
            }
            this._ignoreEvents = false;
        }
    }

    private void _configureCustomColorPane(CustomColorPane customColorPane) {
        int n;
        customColorPane.setLocale(LocaleUtils.getDefaultableLocale((Component)this));
        customColorPane.setToolTipMode(this.getToolTipMode());
        customColorPane.setColorPalette(this.getColorPalette());
        TwoDModel twoDModel = this.getCustomColorPalette();
        if (this._updateCustomPalette) {
            if (twoDModel != null) {
                int n2 = twoDModel.getColumnCount();
                n = twoDModel.getRowCount();
                ArrayTwoDModel arrayTwoDModel = new ArrayTwoDModel(n2, n);
                ColorPickerUtils.copyModel(twoDModel, arrayTwoDModel);
                twoDModel = arrayTwoDModel;
            }
            customColorPane.setCustomColorPalette(twoDModel);
            this._updateCustomPalette = false;
        }
        if (this._updateCustomNames) {
            TwoDModel twoDModel2 = this.getCustomColorNames();
            if (twoDModel2 != null) {
                n = twoDModel2.getColumnCount();
                int n3 = twoDModel2.getRowCount();
                ArrayTwoDModel arrayTwoDModel = new ArrayTwoDModel(n, n3);
                ColorPickerUtils.copyModel(twoDModel2, arrayTwoDModel);
                twoDModel2 = arrayTwoDModel;
            }
            customColorPane.setCustomColorNames(twoDModel2);
            this._updateCustomNames = false;
        }
        Color color = this.getSelectedColor();
        customColorPane.setCurrentColor(color);
        customColorPane.setSelectedColor(color);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EventHandler
    implements ItemListener,
    ActionListener,
    PropertyChangeListener {
        private EventHandler() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            boolean bl = itemEvent.getStateChange() == 1;
            ColorPickerPane.this._selectedColorChanged(object, bl, null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ColorPickerPane.this._customButton) {
                ColorPickerPane.this.__launchCustomColorPane();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if (object instanceof ColorGrid) {
                Color color;
                if ("model".equals(string)) {
                    if (object == ColorPickerPane.this._colorGrid) {
                        ColorPickerPane.this._firstPaletteColor = null;
                        if (ColorPickerPane.this._defaultColor == null && ColorPickerPane.this._defaultButton != null) {
                            ColorPickerPane.this._updateDefaultButtonIcon();
                            ColorPickerPane.this._updateButtonTips(2);
                        }
                    } else {
                        ColorPickerPane.this._updateCustomPalette = true;
                        ColorPickerPane.super.firePropertyChange(ColorPickerPane.PROPERTY_COLOR_PALETTE, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    }
                    ColorPickerPane.this.revalidate();
                    ColorPickerPane.this.repaint();
                } else if (ColorPickerPane.PROPERTY_SELECTED_COLOR.equals(string) && (color = (Color)propertyChangeEvent.getNewValue()) != null) {
                    ColorPickerPane.this._selectedColorChanged(object, true, color);
                }
            } else if (object == ColorPickerPane.this._customColorPane) {
                if (ColorPickerPane.PROPERTY_COLOR_PALETTE.equals(string)) {
                    ColorPickerPane.this._customPaletteDirty = true;
                } else if (ColorPickerPane.PROPERTY_CUSTOM_COLOR_NAMES.equals(string)) {
                    ColorPickerPane.this._customNamesDirty = true;
                }
            }
        }
    }

    private class AccessibleColorPickerPane
    extends JComponent.AccessibleJComponent {
        private AccessibleColorPickerPane() {
            super(ColorPickerPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COLOR_CHOOSER;
        }
    }

    private class PaneLayout
    implements LayoutManager {
        private int _vGap;

        public PaneLayout(int n) {
            this._vGap = n;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this._getSize(container, true);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this._getSize(container, false);
        }

        public void layoutContainer(Container container) {
            Component component;
            Serializable serializable;
            Serializable serializable2;
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = container.getWidth() - (insets.left + insets.right);
            int n4 = container.getHeight() - (insets.top + insets.bottom);
            Component component2 = this._getComponent(1);
            if (component2 != null) {
                serializable2 = component2.getPreferredSize();
                component2.setBounds(n, n2, n3, ((Dimension)serializable2).height);
                n2 += ((Dimension)serializable2).height + this._vGap;
            }
            Dimension dimension = (serializable2 = this._getComponent(2)) != null ? ((Component)serializable2).getPreferredSize() : _EMPTY_SIZE;
            Component component3 = this._getComponent(3);
            Dimension dimension2 = component3 != null ? component3.getPreferredSize() : _EMPTY_SIZE;
            Component component4 = this._getComponent(4);
            if (component4 instanceof JScrollPane) {
                serializable = (JScrollPane)component4;
                ((JScrollPane)serializable).setHorizontalScrollBarPolicy(31);
                ((JScrollPane)serializable).setVerticalScrollBarPolicy(21);
            }
            Serializable serializable3 = serializable = component4 != null ? component4.getPreferredSize() : _EMPTY_SIZE;
            if (component4 instanceof JScrollPane) {
                component = (JScrollPane)component4;
                ((JScrollPane)component).setHorizontalScrollBarPolicy(30);
                ((JScrollPane)component).setVerticalScrollBarPolicy(20);
            }
            Dimension dimension3 = (component = this._getComponent(5)) != null ? component.getPreferredSize() : _EMPTY_SIZE;
            int n5 = Math.max(dimension2.width, dimension.width);
            n5 = Math.max(n5, ((Dimension)serializable).width);
            n5 = Math.min(n5, n3);
            if (serializable2 != null) {
                ((Component)serializable2).setBounds(n, n2, n5, dimension.height);
                n2 += dimension.height;
            }
            if (component3 != null) {
                component3.setBounds(n, n2, n5, dimension2.height);
                n2 += dimension2.height;
            }
            if (component4 != null) {
                if (serializable2 != null || component3 != null) {
                    n2 += this._vGap;
                }
                int n6 = component == null ? n2 : n2 + this._vGap + dimension3.height;
                int n7 = n4 - n6;
                n7 = Math.min(n7, ((Dimension)serializable).height);
                component4.setBounds(n, n2, n5, n7);
                n2 += n7;
            }
            if (component != null) {
                n = Math.max(n, n + n5 - dimension3.width);
                component.setBounds(n, n2 += this._vGap, dimension3.width, dimension3.height);
            }
        }

        private Dimension _getSize(Container container, boolean bl) {
            Serializable serializable;
            Serializable serializable2;
            Serializable serializable3;
            Serializable serializable4;
            Serializable serializable5;
            Dimension dimension = new Dimension();
            Component component = this._getComponent(1);
            if (component != null) {
                serializable5 = component.getPreferredSize();
                dimension.width = Math.max(dimension.width, ((Dimension)serializable5).width);
                dimension.height += ((Dimension)serializable5).height + this._vGap;
            }
            if ((serializable5 = this._getComponent(2)) != null) {
                serializable4 = ((Component)serializable5).getPreferredSize();
                dimension.width = Math.max(dimension.width, ((Dimension)serializable4).width);
                dimension.height += ((Dimension)serializable4).height;
            }
            if ((serializable4 = this._getComponent(3)) != null) {
                serializable3 = ((Component)serializable4).getPreferredSize();
                dimension.width = Math.max(dimension.width, ((Dimension)serializable3).width);
                dimension.height += ((Dimension)serializable3).height;
            }
            if ((serializable3 = this._getComponent(4)) != null) {
                if (serializable5 != null || serializable4 != null) {
                    dimension.height += this._vGap;
                }
                if (serializable3 instanceof JScrollPane) {
                    serializable2 = (JScrollPane)serializable3;
                    ((JScrollPane)serializable2).setHorizontalScrollBarPolicy(31);
                    ((JScrollPane)serializable2).setVerticalScrollBarPolicy(21);
                }
                serializable2 = ((Component)serializable3).getPreferredSize();
                if (serializable3 instanceof JScrollPane) {
                    serializable = (JScrollPane)serializable3;
                    ((JScrollPane)serializable).setHorizontalScrollBarPolicy(30);
                    ((JScrollPane)serializable).setVerticalScrollBarPolicy(20);
                }
                if (bl) {
                    serializable = ((Component)serializable3).getMinimumSize();
                    ((Dimension)serializable2).width = Math.min(((Dimension)serializable2).width, ((Dimension)serializable).width);
                    ((Dimension)serializable2).height = Math.min(((Dimension)serializable2).width, ((Dimension)serializable).width);
                }
                dimension.width = Math.max(dimension.width, ((Dimension)serializable2).width);
                dimension.height += ((Dimension)serializable2).height;
            }
            if ((serializable2 = this._getComponent(5)) != null) {
                dimension.height += this._vGap;
                serializable = ((Component)serializable2).getPreferredSize();
                dimension.width = Math.max(dimension.width, ((Dimension)serializable).width);
                dimension.height += ((Dimension)serializable).height;
            }
            serializable = container.getInsets();
            dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
            dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
            return dimension;
        }

        private Component _getComponent(int n) {
            JComponent jComponent = null;
            switch (n) {
                case 1: {
                    jComponent = ColorPickerPane.this._colorLabel;
                    break;
                }
                case 2: {
                    jComponent = ColorPickerPane.this.isDefaultAllowed() ? ColorPickerPane.this._defaultButton : (ColorPickerPane.this.isAutomaticAllowed() ? ColorPickerPane.this._automaticButton : null);
                    break;
                }
                case 3: {
                    jComponent = ColorPickerPane.this._transparentButton;
                    break;
                }
                case 4: {
                    jComponent = ColorPickerPane.this._scrollPane;
                    break;
                }
                case 5: {
                    jComponent = ColorPickerPane.this._customButton;
                }
            }
            if (jComponent != null && jComponent.isVisible()) {
                return jComponent;
            }
            return null;
        }
    }

    private class PainterIcon
    implements Icon {
        private Painter _iconPainter;
        private PaintContext _paintContext;

        public PainterIcon(JComponent jComponent, Painter painter) {
            this._paintContext = new PaintCtxt(jComponent);
            this._iconPainter = painter;
        }

        public int getIconWidth() {
            return this._iconPainter.getPreferredSize((PaintContext)this._paintContext).width;
        }

        public int getIconHeight() {
            return this._iconPainter.getPreferredSize((PaintContext)this._paintContext).height;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Dimension dimension = this._iconPainter.getPreferredSize(this._paintContext);
            this._iconPainter.paint(this._paintContext, graphics, n, n2, dimension.width, dimension.height);
        }

        private class PaintCtxt
        extends JPaintContext {
            public PaintCtxt(JComponent jComponent) {
                super(jComponent);
            }

            public Color getPaintForeground() {
                return ColorPickerPane.this._getCustomColor();
            }
        }
    }

    private class CustomButton
    extends JButton {
        private CustomButton() {
        }

        public void updateUI() {
            super.updateUI();
            this.setMargin(ColorPickerUtils.getDefaultButtonMargin());
        }
    }

    private class ColorToggleButton
    extends JToggleButton {
        private ColorToggleButton() {
        }

        public void updateUI() {
            super.updateUI();
            this.setMargin(ColorPickerUtils.getDefaultButtonMargin());
        }
    }
}

