/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import oracle.ojc.storage.AbstractStorage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.JarStorage;

final class JarFileStorage
extends AbstractStorage {
    JarStorage jarStorage;
    DirectoryStorage dir;
    String name;
    int offset;
    int size;
    int csize;

    JarFileStorage(JarStorage jarStorage, DirectoryStorage directoryStorage, String string, int n, int n2, int n3) {
        super(null, string);
        this.jarStorage = jarStorage;
        this.dir = directoryStorage;
        this.name = string;
        this.offset = n;
        this.size = n2;
        this.csize = n3;
    }

    private byte[] header() throws IOException {
        this.jarStorage.r.seek(this.offset);
        byte[] byArray = new byte[30];
        this.jarStorage.r.readFully(byArray);
        if (JarStorage.get4LE(byArray, 0) != 67324752) {
            throw new IOException("zip file is corrupted");
        }
        if ((JarStorage.get2LE(byArray, 6) & 1) != 0) {
            throw new IOException("zip file is encrypted");
        }
        return byArray;
    }

    private boolean inflateFully(byte[] byArray, byte[] byArray2) {
        try {
            ZippedFileInputStream zippedFileInputStream = new ZippedFileInputStream(byArray2);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(zippedFileInputStream, new Inflater(true), byArray2.length);
            int n = inflaterInputStream.read(byArray, 0, byArray.length);
            return n == byArray.length;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public byte[] read() throws IOException {
        byte[] byArray = this.header();
        byte[] byArray2 = new byte[this.csize];
        this.jarStorage.r.skipBytes(JarStorage.get2LE(byArray, 26) + JarStorage.get2LE(byArray, 28));
        this.jarStorage.r.readFully(byArray2, 0, this.csize);
        if (JarStorage.get2LE(byArray, 8) == 0) {
            return byArray2;
        }
        byte[] byArray3 = new byte[this.size];
        if (!this.inflateFully(byArray3, byArray2)) {
            throw new IOException("zip file is corrupted");
        }
        return byArray3;
    }

    public int read(byte[] byArray) throws IOException {
        byte[] byArray2 = this.header();
        boolean bl = JarStorage.get2LE(byArray2, 8) != 0;
        this.jarStorage.r.skipBytes(JarStorage.get2LE(byArray2, 26) + JarStorage.get2LE(byArray2, 28));
        if (!bl) {
            int n = this.csize < byArray.length ? this.csize : byArray.length;
            this.jarStorage.r.readFully(byArray, 0, n);
            return this.csize;
        }
        if (this.size > byArray.length) {
            return this.size;
        }
        byte[] byArray3 = new byte[this.csize];
        this.jarStorage.r.readFully(byArray3, 0, this.csize);
        byte[] byArray4 = new byte[this.size];
        if (!this.inflateFully(byArray4, byArray3)) {
            throw new IOException("zip file is corrupted");
        }
        System.arraycopy(byArray4, 0, byArray, 0, this.size);
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.dir.getPath() + File.separatorChar + this.name;
    }

    public String getCanonicalPath() {
        return this.dir.getCanonicalPath() + File.separatorChar + this.name;
    }

    public boolean isInJar() {
        return true;
    }

    private class ZippedFileInputStream
    extends InputStream {
        private byte[] cbuf;
        private int bytesRead;
        private int bytesLeft;

        ZippedFileInputStream(byte[] byArray) throws IOException {
            this.cbuf = byArray;
            this.bytesRead = 0;
            this.bytesLeft = byArray.length;
        }

        public int available() {
            return this.bytesLeft;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.bytesLeft <= 0) {
                return -1;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > this.bytesLeft) {
                n2 = this.bytesLeft;
            }
            System.arraycopy(this.cbuf, this.bytesRead, byArray, n, n2);
            this.bytesRead += n2;
            this.bytesLeft -= n2;
            return n2;
        }

        public int read() throws IOException {
            if (this.bytesLeft <= 0) {
                return -1;
            }
            byte by = this.cbuf[this.bytesRead];
            ++this.bytesRead;
            --this.bytesLeft;
            return by;
        }

        public long skip(long l) {
            if (l < 0L) {
                l = 0L;
            }
            if (l > (long)this.bytesLeft) {
                l = this.bytesLeft;
            }
            this.bytesRead = (int)((long)this.bytesRead + l);
            this.bytesLeft = (int)((long)this.bytesLeft - l);
            return l;
        }
    }
}

