/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.AbstractStorage;
import oracle.ojc.storage.FileStorage;

public class DirectoryStorage
extends AbstractStorage {
    HashMap entries = new HashMap();

    public DirectoryStorage(AbstractStorage abstractStorage, String string) {
        super(abstractStorage, string);
    }

    public DirectoryStorage(File file) {
        super(file);
    }

    Storage find(String string) {
        return (Storage)this.entries.get(string);
    }

    private void readDirectory() {
        String[] stringArray = this.file.list();
        if (stringArray != null) {
            int n = stringArray.length;
            while (--n >= 0) {
                String string = stringArray[n];
                Storage storage = this.find(string);
                if (storage != null) continue;
                File file = new File(this.file, string);
                storage = file.isDirectory() ? new DirectoryStorage(file) : new FileStorage(file);
                this.entries.put(string, storage);
            }
        }
    }

    public boolean isDirectory() {
        return true;
    }

    public Storage create(String string) throws IOException {
        FileStorage fileStorage = new FileStorage(this, string);
        fileStorage.out = new FileOutputStream(fileStorage.file);
        this.entries.put(string, fileStorage);
        return fileStorage;
    }

    public Storage createDir(String string) throws IOException {
        DirectoryStorage directoryStorage = new DirectoryStorage(this, string);
        if (!directoryStorage.file.exists()) {
            directoryStorage.file.mkdir();
        }
        this.entries.put(string, directoryStorage);
        return directoryStorage;
    }

    public Storage open(String string) {
        File file;
        Storage storage;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((storage = this.find(string)) != null) {
            return storage;
        }
        try {
            file = new File(this.file, string);
            if (!file.exists()) {
                return null;
            }
            if (File.separatorChar == '\\' && !string.equals(file.getCanonicalFile().getName())) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        storage = file.isDirectory() ? new DirectoryStorage(file) : new FileStorage(file);
        this.entries.put(string, storage);
        return storage;
    }

    public ArrayList listStorage() {
        if (this.file != null) {
            this.readDirectory();
        }
        return new ArrayList(this.entries.values());
    }
}

