/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.Message;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.Storage;

public final class Warning
extends Message {
    static final int MAX_WARNING_INDEX = 1000;
    static BitSet defaults;
    static BitSet warnings;

    Warning(Storage storage, ErrorInfo errorInfo, int n) {
        super(storage, errorInfo, n);
    }

    Warning(Storage storage, ErrorInfo errorInfo, int n, String string) {
        super(storage, errorInfo, n, string);
    }

    Warning(Storage storage, ErrorInfo errorInfo, int n, String string, String string2) {
        super(storage, errorInfo, n, string, string2);
    }

    Warning(Storage storage, ErrorInfo errorInfo, int n, String string, String string2, String string3) {
        super(storage, errorInfo, n, string, string2, string3);
    }

    public static void defaultWarning(int n) {
        warnings.set(n, defaults.get(n));
    }

    public static void enableWarning(int n) {
        if (n < 1000) {
            warnings.set(n);
        }
    }

    public static void disableWarning(int n) {
        if (n < 1000) {
            warnings.clear(n);
        }
    }

    public static void defaultAllWarnings() {
        warnings = (BitSet)defaults.clone();
    }

    public static void enableAllWarnings() {
        warnings.set(0, 1000);
    }

    public static void disableAllWarnings() {
        warnings.clear();
    }

    public static boolean isEmpty() {
        return warnings.isEmpty();
    }

    public static boolean isEnabled(int n) {
        return warnings.get(n);
    }

    static {
        warnings = new BitSet(1000);
        Warning.enableAllWarnings();
        Warning.disableWarning(Message.warningStaticAccessWithObject.getNumber());
        Warning.disableWarning(Message.warningUnusedImport.getNumber());
        Warning.disableWarning(Message.warningPartialUsedStarImport.getNumber());
        Warning.disableWarning(Message.warningParameterNeverUsed.getNumber());
        Warning.disableWarning(Message.warningIsDeprecated.getNumber());
        Warning.disableWarning(Message.warningEmptyStatement.getNumber());
        Warning.disableWarning(Message.warningFallThrough.getNumber());
        Warning.disableWarning(Message.warningCatchVarNeverUsed.getNumber());
        Warning.disableWarning(Message.warningEmptyCatchStatement.getNumber());
        Warning.disableWarning(Message.warningNoSerialVersionUID.getNumber());
        defaults = (BitSet)warnings.clone();
    }
}

