/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

final class UnaryPlusExpression
extends UnaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    UnaryPlusExpression(int n, Expression expression) {
        super((byte)38, n, expression);
    }

    Expression foldExpression() {
        if (this.operand.kind == 2) {
            return this.operand;
        }
        return this;
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        Expression expression = this.operand.resolveAndCheck(parser);
        TypeSymbol typeSymbol2 = expression.getType();
        if (!(typeSymbol2.isNumericType() || parser.options.sourceJDKVersion >= 150 && typeSymbol2.isReferenceType() && (typeSymbol = BoxingExpression.getPrimitiveType(parser, typeSymbol2)) != null && typeSymbol.isNumericType())) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol2.isErroneous(), this.toString(), typeSymbol2.errorName());
            return new ErrorExpression(error);
        }
        return expression.promoteType(parser, TypeSymbol.unaryNumericPromotion(parser, typeSymbol2));
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "+";
    }

    static {
        $assertionsDisabled = !UnaryPlusExpression.class.desiredAssertionStatus();
    }
}

