/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;

final class TypeVariableSymbol
extends ClassSymbol {
    static final byte TVK_ANY = 0;
    static final byte TVK_VARIABLE = 1;
    static final byte TVK_UPPERBOUND = 2;
    static final byte TVK_LOWERBOUND = 3;
    private static final char[] wildcardSignature;
    byte typeVariableKind;
    TypeSymbol refSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    TypeVariableSymbol(int n, byte by, ReferenceTypeSymbol referenceTypeSymbol) {
        super(n, null, (byte)10, (short)0, null);
        this.typeVariableKind = by;
        this.refSymbol = referenceTypeSymbol;
    }

    String errorName() {
        if (this.refSymbol.isErroneous()) {
            return "";
        }
        return this.toString();
    }

    char[] getSignature() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    protected void toString(StringBuffer stringBuffer) {
        switch (this.typeVariableKind) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 0: {
                stringBuffer.append('?');
                break;
            }
            case 2: {
                stringBuffer.append("? extends ");
                this.refSymbol.toString(stringBuffer);
                break;
            }
            case 3: {
                stringBuffer.append("? super ");
                this.refSymbol.toString(stringBuffer);
                break;
            }
            case 1: {
                this.refSymbol.toString(stringBuffer);
            }
        }
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol typeSymbol2) {
        if (typeSymbol instanceof TypeVariableSymbol) {
            ReferenceTypeSymbol referenceTypeSymbol;
            ReferenceTypeSymbol referenceTypeSymbol2;
            TypeVariableSymbol typeVariableSymbol = (TypeVariableSymbol)typeSymbol;
            if (typeVariableSymbol.typeVariableKind == 0) {
                return true;
            }
            if (this.typeVariableKind == 0) {
                if (typeVariableSymbol.refSymbol.isTypeParameter()) {
                    TypeParameterSymbol typeParameterSymbol = (TypeParameterSymbol)typeVariableSymbol.refSymbol;
                    return this.isJavaLangObject(typeParameterSymbol.bound);
                }
                if (typeVariableSymbol.refSymbol.isClass()) {
                    return this.isJavaLangObject((ClassSymbol)typeVariableSymbol.refSymbol);
                }
                return false;
            }
            if (this.refSymbol.isParameterizedClass() && typeVariableSymbol.refSymbol.isParameterizedClass()) {
                referenceTypeSymbol2 = (ParameterizedClassSymbol)this.refSymbol;
                referenceTypeSymbol = (ParameterizedClassSymbol)typeVariableSymbol.refSymbol;
                if (referenceTypeSymbol2.genericClassSymbol == referenceTypeSymbol.genericClassSymbol && (referenceTypeSymbol2.typeVariableList == null || referenceTypeSymbol.typeVariableList == null) && referenceTypeSymbol2.typeVariableList != referenceTypeSymbol.typeVariableList) {
                    return false;
                }
            }
            if (this.refSymbol.equalTo(typeVariableSymbol.refSymbol, typeSymbol2)) {
                return true;
            }
            if (this.refSymbol.isArrayType()) {
                if (typeVariableSymbol.refSymbol.isArrayType()) {
                    referenceTypeSymbol2 = (ArraySymbol)this.refSymbol;
                    referenceTypeSymbol = (ArraySymbol)typeVariableSymbol.refSymbol;
                    TypeSymbol typeSymbol3 = ArraySymbol.getArrayType(((ArraySymbol)referenceTypeSymbol2).baseType, ((ArraySymbol)referenceTypeSymbol2).dimension - 1);
                    TypeSymbol typeSymbol4 = ArraySymbol.getArrayType(((ArraySymbol)referenceTypeSymbol).baseType, ((ArraySymbol)referenceTypeSymbol).dimension - 1);
                    return typeSymbol3.equalTo(typeSymbol4, typeSymbol2);
                }
                if (typeVariableSymbol.refSymbol.isTypeParameter()) {
                    return this.isJavaLangObject(((TypeParameterSymbol)typeVariableSymbol.refSymbol).bound);
                }
                return false;
            }
            if (typeVariableSymbol.refSymbol.isArrayType()) {
                return false;
            }
            if (!this.refSymbol.isClass() || !typeVariableSymbol.refSymbol.isClass()) {
                return false;
            }
            switch (this.typeVariableKind << 8 | typeVariableSymbol.typeVariableKind) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 256: 
                case 512: 
                case 768: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 257: 
                case 515: 
                case 770: {
                    return false;
                }
                case 258: 
                case 514: 
                case 769: {
                    ClassSymbol classSymbol = (ClassSymbol)this.refSymbol;
                    ClassSymbol classSymbol2 = (ClassSymbol)typeVariableSymbol.refSymbol;
                    return classSymbol2.isSuperclass(classSymbol, typeSymbol2) || classSymbol.implementsInterface(classSymbol2, typeSymbol2);
                }
                case 259: 
                case 513: 
                case 771: 
            }
            ClassSymbol classSymbol = (ClassSymbol)this.refSymbol;
            ClassSymbol classSymbol3 = (ClassSymbol)typeVariableSymbol.refSymbol;
            return classSymbol.isSuperclass(classSymbol3, typeSymbol2) || classSymbol3.implementsInterface(classSymbol, typeSymbol2);
        }
        return false;
    }

    TypeSymbol resolveType(Parser parser, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.refSymbol != null) {
            this.refSymbol = this.refSymbol.resolveType(parser, n, bl, bl2, false);
            if (this.refSymbol.isErroneous()) {
                this.refSymbol = parser.javaLangObjectPcs;
            }
        }
        return this;
    }

    boolean isTypeVariable() {
        return true;
    }

    boolean involvesGenerics() {
        return true;
    }

    char[] getGenericSignature() {
        StringBuffer stringBuffer;
        switch (this.typeVariableKind) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 0: {
                return wildcardSignature;
            }
            case 2: {
                stringBuffer = new StringBuffer("+");
                break;
            }
            case 3: {
                stringBuffer = new StringBuffer("-");
                break;
            }
            case 1: {
                stringBuffer = new StringBuffer();
            }
        }
        stringBuffer.append(this.refSymbol.getGenericSignature());
        return stringBuffer.toString().toCharArray();
    }

    boolean involvesTypeParameter() {
        if (this.refSymbol != null) {
            return this.refSymbol.involvesTypeParameter();
        }
        return false;
    }

    boolean containsTypeParameterDefinedBy(Symbol symbol) {
        if (this.refSymbol != null) {
            return this.refSymbol.containsTypeParameterDefinedBy(symbol);
        }
        return false;
    }

    boolean containsTypeParameter(TypeParameterSymbol typeParameterSymbol) {
        if (this.refSymbol != null) {
            return this.refSymbol.containsTypeParameter(typeParameterSymbol);
        }
        return false;
    }

    void getTypeParameterSymbol(ArrayList arrayList) {
        if (this.refSymbol != null) {
            this.refSymbol.getTypeParameterSymbol(arrayList);
        }
    }

    void changeScope(Scope scope) {
        if (this.refSymbol != null) {
            this.refSymbol.changeScope(scope);
        }
    }

    TypeSymbol replaceUnresolvedTypeParameters(TypeParameterList typeParameterList) {
        if (this.refSymbol != null) {
            this.refSymbol = this.refSymbol.replaceUnresolvedTypeParameters(typeParameterList);
        }
        return this;
    }

    TypeSymbol replaceTypeParameters(TypeParameterList typeParameterList) {
        TypeSymbol typeSymbol;
        if (this.refSymbol != null && (typeSymbol = this.refSymbol.replaceTypeParameters(typeParameterList)) != this.refSymbol) {
            return new TypeVariableSymbol(this.pos, this.typeVariableKind, (ReferenceTypeSymbol)typeSymbol);
        }
        return this;
    }

    TypeSymbol applyTypeVariables(TypeParameterList typeParameterList, TypeVariableList typeVariableList, boolean bl) {
        TypeSymbol typeSymbol;
        if (this.refSymbol != null && (typeSymbol = this.refSymbol.applyTypeVariables(typeParameterList, typeVariableList, false)) != this.refSymbol) {
            if (typeSymbol == null) {
                return new TypeVariableSymbol(this.pos, 0, null);
            }
            return new TypeVariableSymbol(this.pos, this.typeVariableKind, (ReferenceTypeSymbol)typeSymbol);
        }
        return this;
    }

    RawClassSymbol getClassSymbol() {
        if (this.refSymbol.isArrayType()) {
            return null;
        }
        return ((ClassSymbol)this.refSymbol).getClassSymbol();
    }

    ClassSymbol getSuperClassSymbol() {
        if (this.refSymbol.isArrayType()) {
            return null;
        }
        return ((ClassSymbol)this.refSymbol).getSuperClassSymbol();
    }

    ClassSymbol getInterface(RawClassSymbol rawClassSymbol) {
        if (this.refSymbol.isArrayType()) {
            return null;
        }
        return ((ClassSymbol)this.refSymbol).getInterface(rawClassSymbol);
    }

    ImplementationList getImplementationList() {
        if (this.refSymbol.isArrayType()) {
            return null;
        }
        return ((ClassSymbol)this.refSymbol).getImplementationList();
    }

    boolean isSuperclass(ClassSymbol classSymbol) {
        return this.isSuperclass(classSymbol, null);
    }

    boolean isSuperclass(ClassSymbol classSymbol, TypeSymbol typeSymbol) {
        if (this.refSymbol.isArrayType()) {
            return false;
        }
        return ((ClassSymbol)this.refSymbol).isSuperclass(classSymbol, typeSymbol);
    }

    void checkForOutOfPackageInnerClasses(ConstantPool constantPool, RawClassSymbol rawClassSymbol) {
        if (this.refSymbol != null) {
            ClassSymbol classSymbol;
            if (this.refSymbol.isArrayType()) {
                ArraySymbol arraySymbol = (ArraySymbol)this.refSymbol;
                if (!arraySymbol.baseType.isClass()) {
                    return;
                }
                classSymbol = (ClassSymbol)arraySymbol.baseType;
            } else {
                classSymbol = (ClassSymbol)this.refSymbol;
            }
            constantPool.checkForOutOfPackageInnerClass(rawClassSymbol, classSymbol.getClassSymbol());
            classSymbol.checkForOutOfPackageInnerClasses(constantPool, rawClassSymbol);
        }
    }

    private boolean isJavaLangObject(ClassSymbol classSymbol) {
        return classSymbol.getClassSymbol().errorName().equals("class java.lang.Object");
    }

    static {
        $assertionsDisabled = !TypeVariableSymbol.class.desiredAssertionStatus();
        wildcardSignature = new char[]{'*'};
    }
}

