/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSuperClassException;

final class TypeParameterSymbol
extends ClassSymbol {
    Symbol definingSymbol;
    boolean methodTypeParameter;
    boolean emptyBound;
    ClassSymbol bound;
    int boundPos;
    ClassSymbolList interfaceBounds;
    MethodSymbol[] methodTable;

    TypeParameterSymbol(int n, Identifier identifier, ClassSymbol classSymbol, int n2, ClassSymbolList classSymbolList) {
        super(n, identifier, (byte)10, (short)0, null);
        this.bound = classSymbol;
        this.boundPos = n2;
        this.interfaceBounds = classSymbolList;
    }

    TypeParameterSymbol(int n, Identifier identifier) {
        super(n, identifier, (byte)10, (short)0, null);
    }

    boolean isErroneous() {
        if (this.bound.isErroneous()) {
            return true;
        }
        ClassSymbolList classSymbolList = this.interfaceBounds;
        while (classSymbolList != null) {
            if (classSymbolList.classSymbol.isErroneous()) {
                return true;
            }
            classSymbolList = classSymbolList.next;
        }
        return false;
    }

    String kindName() {
        return Message.classString;
    }

    char[] getSignature() {
        if (this.emptyBound) {
            return this.interfaceBounds.classSymbol.getSignature();
        }
        return this.bound.getSignature();
    }

    char[] getInternalName() {
        if (this.emptyBound) {
            return this.interfaceBounds.classSymbol.getInternalName();
        }
        return this.bound.getInternalName();
    }

    protected void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.identifier.toString());
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol typeSymbol2) {
        if (this == typeSymbol) {
            return true;
        }
        if (typeSymbol.isTypeParameter()) {
            return this.bound.equalTo(((TypeParameterSymbol)typeSymbol).bound, typeSymbol2);
        }
        if (this.bound.equalTo(typeSymbol, typeSymbol2)) {
            return true;
        }
        if (!typeSymbol.isClass()) {
            return false;
        }
        ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
        if (classSymbol.containsTypeParameter(this)) {
            return false;
        }
        if (classSymbol.isInterface()) {
            return this.bound.implementsInterface(classSymbol, typeSymbol2);
        }
        return classSymbol.isSuperclass(this.bound, typeSymbol2);
    }

    TypeSymbol resolveType(Parser parser, int n, boolean bl, boolean bl2, boolean bl3) {
        TypeSymbol typeSymbol = this.bound.resolveType(parser, n, bl, bl2, false);
        if (!typeSymbol.isClass()) {
            typeSymbol = parser.javaLangObjectPcs;
        }
        this.bound = (ClassSymbol)typeSymbol;
        ClassSymbolList classSymbolList = this.interfaceBounds;
        while (classSymbolList != null) {
            typeSymbol = classSymbolList.classSymbol.resolveType(parser, n, bl, bl2, false);
            if (!typeSymbol.isClass()) {
                typeSymbol = parser.javaLangObjectPcs;
            }
            classSymbolList.classSymbol = (ClassSymbol)typeSymbol;
            classSymbolList = classSymbolList.next;
        }
        return this;
    }

    boolean isTypeParameter() {
        return true;
    }

    boolean isMethodTypeParameter() {
        return this.definingSymbol instanceof MethodSymbol;
    }

    boolean involvesGenerics() {
        return true;
    }

    boolean involvesTypeParameter() {
        return true;
    }

    boolean containsTypeParameterDefinedBy(Symbol symbol) {
        return symbol == null || symbol == this.definingSymbol;
    }

    boolean containsTypeParameter(TypeParameterSymbol typeParameterSymbol) {
        return typeParameterSymbol == this;
    }

    void getTypeParameterSymbol(ArrayList arrayList) {
        arrayList.add(this);
    }

    void changeScope(Scope scope) {
        this.bound.changeScope(scope);
        ClassSymbolList classSymbolList = this.interfaceBounds;
        while (classSymbolList != null) {
            classSymbolList.classSymbol.changeScope(scope);
            classSymbolList = classSymbolList.next;
        }
    }

    TypeSymbol replaceUnresolvedTypeParameters(TypeParameterList typeParameterList) {
        this.bound = (ClassSymbol)this.bound.replaceUnresolvedTypeParameters(typeParameterList);
        ClassSymbolList classSymbolList = this.interfaceBounds;
        while (classSymbolList != null) {
            classSymbolList.classSymbol = (ClassSymbol)classSymbolList.classSymbol.replaceUnresolvedTypeParameters(typeParameterList);
            classSymbolList = classSymbolList.next;
        }
        return this;
    }

    TypeSymbol replaceTypeParameters(TypeParameterList typeParameterList) {
        while (typeParameterList != null) {
            if (this.identifier == typeParameterList.typeParameter.identifier) {
                return typeParameterList.typeParameter;
            }
            typeParameterList = typeParameterList.next;
        }
        return this;
    }

    TypeSymbol applyTypeVariables(TypeParameterList typeParameterList, TypeVariableList typeVariableList, boolean bl) {
        while (typeParameterList != null && typeVariableList != null) {
            if (typeParameterList.typeParameter == this) {
                if (!bl || typeVariableList.typeVariable.refSymbol != null) {
                    return typeVariableList.typeVariable.refSymbol;
                }
                return typeParameterList.typeParameter.bound;
            }
            typeParameterList = typeParameterList.next;
            typeVariableList = typeVariableList.next;
        }
        return this;
    }

    char[] getGenericSignature() {
        StringBuffer stringBuffer = new StringBuffer("T");
        stringBuffer.append(this.identifier.name);
        stringBuffer.append(';');
        return stringBuffer.toString().toCharArray();
    }

    RawClassSymbol getClassSymbol() {
        return this.bound.getClassSymbol();
    }

    ClassSymbol getSuperClassSymbol() {
        return this.bound;
    }

    ClassSymbol getInterface(RawClassSymbol rawClassSymbol) {
        return this.bound.getInterface(rawClassSymbol);
    }

    ImplementationList getImplementationList() {
        return this.bound.getImplementationList();
    }

    boolean isSuperclass(ClassSymbol classSymbol) {
        return this.isSuperclass(classSymbol, null);
    }

    boolean isSuperclass(ClassSymbol classSymbol, TypeSymbol typeSymbol) {
        return this.bound.isSuperclass(classSymbol, typeSymbol);
    }

    boolean implementsInterface(ClassSymbol classSymbol) {
        return this.implementsInterface(classSymbol, null);
    }

    boolean implementsInterface(ClassSymbol classSymbol, TypeSymbol typeSymbol) {
        ClassSymbolList classSymbolList = this.interfaceBounds;
        while (classSymbolList != null) {
            ClassSymbol classSymbol2 = classSymbolList.classSymbol;
            if (classSymbol2.equalTo(classSymbol, typeSymbol) || classSymbol2.implementsInterface(classSymbol, typeSymbol)) {
                return true;
            }
            classSymbolList = classSymbolList.next;
        }
        return false;
    }

    void checkForOutOfPackageInnerClasses(ConstantPool constantPool, RawClassSymbol rawClassSymbol) {
        constantPool.checkForOutOfPackageInnerClass(rawClassSymbol, this.bound.getClassSymbol());
        this.bound.checkForOutOfPackageInnerClasses(constantPool, rawClassSymbol);
        ClassSymbolList classSymbolList = this.interfaceBounds;
        while (classSymbolList != null) {
            ClassSymbol classSymbol = classSymbolList.classSymbol;
            constantPool.checkForOutOfPackageInnerClass(rawClassSymbol, classSymbol.getClassSymbol());
            classSymbol.checkForOutOfPackageInnerClasses(constantPool, rawClassSymbol);
            classSymbolList = classSymbolList.next;
        }
    }

    MethodSymbol[] getMethodTable(Parser parser) {
        if (this.methodTable == null) {
            this.buildMethodTable(parser);
        }
        return this.methodTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean buildMethodTable(Parser parser) {
        try {
            parser.currentClassesBeingResolved.add(this);
            ArrayList arrayList = new ArrayList();
            if (this.bound.isParameterizedClass()) {
                this.mergeIntoMethodTable(parser, arrayList, (ParameterizedClassSymbol)this.bound);
            }
            ClassSymbolList classSymbolList = this.interfaceBounds;
            while (classSymbolList != null) {
                if (classSymbolList.classSymbol.isParameterizedClass()) {
                    this.mergeIntoMethodTable(parser, arrayList, (ParameterizedClassSymbol)classSymbolList.classSymbol);
                }
                classSymbolList = classSymbolList.next;
            }
            this.methodTable = arrayList.toArray(new MethodSymbol[arrayList.size()]);
            Object var5_4 = null;
            int n = parser.currentClassesBeingResolved.size();
            parser.currentClassesBeingResolved.remove(n - 1);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            int n = parser.currentClassesBeingResolved.size();
            parser.currentClassesBeingResolved.remove(n - 1);
            throw throwable;
        }
        return false;
    }

    void checkBounds(Parser parser, int n, TypeSymbol typeSymbol, TypeParameterList typeParameterList, TypeVariableList typeVariableList) {
        if (parser.resolutionFailures > 0) {
            return;
        }
        if (!typeSymbol.isErroneous() && typeSymbol.isClass()) {
            RawClassSymbol rawClassSymbol;
            ParameterizedClassSymbol parameterizedClassSymbol;
            ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
            ParameterizedClassSymbol parameterizedClassSymbol2 = classSymbol.isParameterizedClass() ? (ParameterizedClassSymbol)classSymbol : null;
            RawClassSymbol rawClassSymbol2 = classSymbol.getClassSymbol();
            if (this.bound instanceof UnresolvedClassSymbol) {
                throw new UnresolvedSuperClassException(this.bound);
            }
            ClassSymbol classSymbol2 = (ClassSymbol)this.bound.applyTypeVariables(typeParameterList, typeVariableList);
            if (!(classSymbol.equalTo(classSymbol2) || classSymbol2.isSuperclass(classSymbol) || classSymbol.implementsInterface(classSymbol2))) {
                if (!classSymbol2.isParameterizedClass() || parameterizedClassSymbol2 == null) {
                    parser.error(Message.errorTypeParameterOutOfBounds, n, false, typeSymbol.errorName());
                } else {
                    parameterizedClassSymbol = (ParameterizedClassSymbol)classSymbol2;
                    rawClassSymbol = parameterizedClassSymbol.getClassSymbol();
                    if (!(rawClassSymbol2.equalTo(rawClassSymbol) || rawClassSymbol.isSuperclass(rawClassSymbol2) || rawClassSymbol2.implementsInterface(rawClassSymbol))) {
                        parser.error(Message.errorTypeParameterOutOfBounds, n, false, typeSymbol.errorName());
                    } else {
                        parameterizedClassSymbol.checkBounds(parser, n, parameterizedClassSymbol2);
                    }
                }
            }
            ClassSymbolList classSymbolList = this.interfaceBounds;
            while (classSymbolList != null) {
                classSymbol2 = classSymbolList.classSymbol;
                if (classSymbol2 instanceof UnresolvedClassSymbol) {
                    throw new UnresolvedSuperClassException(classSymbol2);
                }
                if (!classSymbol.equalTo(classSymbol2 = (ClassSymbol)classSymbol2.applyTypeVariables(typeParameterList, typeVariableList)) && !classSymbol.implementsInterface(classSymbol2)) {
                    if (!classSymbol2.isParameterizedClass() || parameterizedClassSymbol2 == null) {
                        parser.error(Message.errorTypeParameterOutOfBounds, n, false, typeSymbol.errorName());
                    } else {
                        parameterizedClassSymbol = (ParameterizedClassSymbol)classSymbol2;
                        rawClassSymbol = parameterizedClassSymbol.getClassSymbol();
                        if (!rawClassSymbol2.equalTo(rawClassSymbol) && !rawClassSymbol2.implementsInterface(rawClassSymbol)) {
                            parser.error(Message.errorTypeParameterOutOfBounds, n, false, typeSymbol.errorName());
                        } else {
                            parameterizedClassSymbol.checkBounds(parser, n, parameterizedClassSymbol2);
                        }
                    }
                }
                classSymbolList = classSymbolList.next;
            }
        }
    }
}

