/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CatchDescriptor;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.EndOfScopeStatement;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.LocalVariableSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TrySyncList;
import oracle.ojc.compiler.TypeSymbol;

final class TryStatement
extends Statement {
    StatementList tryBody;
    CatchDescriptor catchDesc;
    StatementList finallyBody;
    int finallyStartPos;
    int finallyEndPos;
    int finalliesNeeded;
    boolean generating;
    Label finallyLabel;
    BitSet exitPosSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    TryStatement(StatementList statementList, int n, StatementList statementList2, CatchDescriptor catchDescriptor, StatementList statementList3, int n2, int n3) {
        super(statementList, n, (byte)17);
        this.tryBody = statementList2;
        this.catchDesc = catchDescriptor;
        this.finallyBody = statementList3;
        this.finallyStartPos = n2;
        this.finallyEndPos = n3;
        this.finalliesNeeded = 1;
        statementList2.parent = this;
        if (statementList3 != null) {
            statementList3.parent = this;
        }
        CatchDescriptor catchDescriptor2 = catchDescriptor;
        while (catchDescriptor2 != null) {
            catchDescriptor2.catchBody.parent = this;
            catchDescriptor2 = catchDescriptor2.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveAndCheck(Parser parser) {
        BitSet bitSet;
        boolean bl;
        TrySyncList trySyncList;
        TrySyncList trySyncList2 = parser.innerTrySync;
        parser.innerTrySync = trySyncList = new TrySyncList(trySyncList2, this, null);
        this.exitPosSet = null;
        BitSet bitSet2 = (BitSet)parser.defSet.clone();
        try {
            this.tryBody.resolveAndCheck(parser);
            bl = this.tryBody.canReachNextStatement(false);
            bitSet = parser.defSet;
            if (!bl) {
                bitSet = null;
            }
            if (this.exitPosSet != null) {
                parser.posSet.or(this.exitPosSet);
            }
            ClassSymbol classSymbol = null;
            CatchDescriptor catchDescriptor = this.catchDesc;
            while (catchDescriptor != null) {
                ++parser.estimatedLineCount;
                parser.defSet = (BitSet)bitSet2.clone();
                int n = parser.currentClassSymbol.cd.fieldCount + catchDescriptor.catchVariable.varStackIndex;
                parser.defSet.set(n);
                parser.posSet.set(n);
                TypeSymbol typeSymbol = catchDescriptor.catchVariable.type;
                byte by = typeSymbol.typeKind;
                if (by != 10) {
                    parser.error(Message.errorIncompatibleTypes, catchDescriptor.pos, typeSymbol.isErroneous(), typeSymbol.errorName(), parser.javaLangThrowableSymbol.errorName());
                    catchDescriptor.catchVariable.type = parser.javaLangThrowableSymbol;
                } else {
                    ClassSymbol classSymbol2 = (ClassSymbol)typeSymbol.resolveType(parser, catchDescriptor.pos, false, false, false);
                    if (!classSymbol2.equalTo(parser.javaLangThrowableSymbol) && !parser.javaLangThrowableSymbol.isSuperclass(classSymbol2) || classSymbol2.isTypeParameter()) {
                        parser.error(Message.errorIncompatibleTypes, catchDescriptor.pos, classSymbol2.isErroneous(), classSymbol2.errorName(), parser.javaLangThrowableSymbol.errorName());
                    }
                    if (!catchDescriptor.checked && parser.javaLangExceptionSymbol.isSuperclass(classSymbol2) && !parser.javaLangRuntimeExceptionSymbol.equalTo(classSymbol2) && !parser.javaLangRuntimeExceptionSymbol.isSuperclass(classSymbol2)) {
                        parser.error(Message.errorExceptionNeverThrown, catchDescriptor.pos, classSymbol2.isErroneous(), classSymbol2.identifier.toString());
                    } else if (classSymbol != null && (classSymbol == classSymbol2 || classSymbol.isSuperclass(classSymbol2))) {
                        parser.error(Message.errorUnreachableCatch, catchDescriptor.pos, false);
                    } else {
                        classSymbol = classSymbol2;
                        catchDescriptor.catchVariable.type = classSymbol2;
                    }
                }
                StatementList statementList = catchDescriptor.catchBody;
                statementList.resolveAndCheck(parser);
                if (statementList.first == null || parser.options.localVariables && statementList.first == statementList.last && statementList.first instanceof EndOfScopeStatement) {
                    parser.warning(null, Message.warningEmptyCatchStatement, catchDescriptor.pos);
                }
                if (statementList.canReachNextStatement(true)) {
                    bl = true;
                    if (bitSet == null) {
                        bitSet = parser.defSet;
                    } else {
                        bitSet.and(parser.defSet);
                    }
                }
                catchDescriptor = catchDescriptor.next;
            }
        }
        finally {
            parser.innerTrySync = trySyncList2;
        }
        StatementList statementList = this.finallyBody;
        if (statementList != null) {
            parser.defSet = (BitSet)bitSet2.clone();
            parser.estimatedLineCount += 2;
            int n = parser.estimatedLineCount;
            statementList.resolveAndCheck(parser);
            if (parser.options.targetJDKVersion >= 150) {
                n = parser.estimatedLineCount - n;
                parser.estimatedLineCount += (n *= this.finalliesNeeded);
            }
            if (bl && !(bl = statementList.canReachNextStatement(false))) {
                parser.warning(null, Message.warningUnterminatedFinally, statementList.first.pos);
            }
            if (bitSet != null) {
                if (!bl) {
                    parser.defSet = (BitSet)bitSet2.clone();
                } else {
                    parser.defSet.or(bitSet);
                }
            }
        } else {
            parser.defSet = bitSet == null ? bitSet2 : bitSet;
        }
        if (this.catchDesc == null && statementList == null) {
            parser.error(Message.errorTryWithoutCatch, this.pos, false);
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
        if (this.next != null && this.next.isCodeStatement() && !this.canReachNextStatement(false)) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    private boolean catches(Parser parser, ClassSymbol classSymbol) {
        CatchDescriptor catchDescriptor = this.catchDesc;
        while (catchDescriptor != null) {
            TypeSymbol typeSymbol = catchDescriptor.catchVariable.type;
            if (typeSymbol.isErroneous() || classSymbol.isAssignmentCompatible(parser, (ClassSymbol)typeSymbol)) {
                return true;
            }
            catchDescriptor = catchDescriptor.next;
        }
        return false;
    }

    void updateDefUseSetsAfterReturn(Parser parser) {
        if (this.exitPosSet == null) {
            this.exitPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.exitPosSet.or(parser.posSet);
        }
        this.parent.updateDefUseSetsAfterReturn(parser);
    }

    void updateDefUseSetsAfterThrow(Parser parser, ClassSymbol classSymbol) {
        if (this.exitPosSet == null) {
            this.exitPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.exitPosSet.or(parser.posSet);
        }
        if (!this.catches(parser, classSymbol)) {
            this.parent.updateDefUseSetsAfterThrow(parser, classSymbol);
        }
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        if (this.exitPosSet == null) {
            this.exitPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.exitPosSet.or(parser.posSet);
        }
        this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
    }

    void updateDefUseSetsAfterContinue(Parser parser, LabelSymbol labelSymbol) {
        if (this.exitPosSet == null) {
            this.exitPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.exitPosSet.or(parser.posSet);
        }
        this.parent.updateDefUseSetsAfterContinue(parser, labelSymbol);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        TrySyncList trySyncList;
        TrySyncList trySyncList2 = byteCodeGenerator.parser.innerTrySync;
        byteCodeGenerator.parser.innerTrySync = trySyncList = new TrySyncList(trySyncList2, this, null);
        short s = byteCodeGenerator.generateGetPC();
        this.tryBody.generateByteCode(byteCodeGenerator);
        short s2 = byteCodeGenerator.generateGetPC();
        boolean bl = true;
        StatementList statementList = this.finallyBody;
        if (statementList != null) {
            bl = statementList.canReachNextStatement(false);
        }
        if (s == s2) {
            byteCodeGenerator.parser.innerTrySync = trySyncList2;
            if (statementList != null) {
                statementList.generateByteCode(byteCodeGenerator);
            }
        } else if (byteCodeGenerator.parser.options.targetJDKVersion < 150) {
            short s3;
            boolean bl2;
            Label label = new Label();
            if (statementList != null && this.finallyLabel == null) {
                this.finallyLabel = new Label();
            }
            if (bl2 = this.tryBody.canReachNextStatement(false)) {
                if (statementList != null) {
                    byteCodeGenerator.generateBranch_jsr(this.finallyLabel);
                    if (bl) {
                        byteCodeGenerator.generateBranch_goto(label);
                    }
                } else {
                    byteCodeGenerator.generateBranch_goto(label);
                }
            }
            CatchDescriptor catchDescriptor = this.catchDesc;
            while (catchDescriptor != null) {
                s3 = byteCodeGenerator.generateGetPC();
                TypeSymbol typeSymbol = null;
                StatementList statementList2 = catchDescriptor.catchBody;
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(catchDescriptor.pos));
                byteCodeGenerator.setOpStackHeight(1);
                if (statementList2 == null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                } else {
                    LocalVariableSymbol localVariableSymbol = catchDescriptor.catchVariable;
                    typeSymbol = localVariableSymbol.type;
                    byteCodeGenerator.storeLocalVariable(typeSymbol, localVariableSymbol.varStackIndex);
                    localVariableSymbol.startPC = localVariableSymbol.endPC = byteCodeGenerator.generateGetPC();
                    statementList2.generateByteCode(byteCodeGenerator);
                }
                short s4 = 0;
                if (typeSymbol != null) {
                    s4 = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
                }
                byteCodeGenerator.generateExceptionHandler(s, s2, s3, s4);
                if (statementList2 == null || statementList2.canReachNextStatement(false)) {
                    if (this.finallyLabel != null) {
                        byteCodeGenerator.generateBranch_jsr(this.finallyLabel);
                    }
                    if (catchDescriptor.next == null && this.finallyLabel == null) break;
                    if (bl) {
                        byteCodeGenerator.generateBranch_goto(label);
                    }
                }
                catchDescriptor = catchDescriptor.next;
            }
            byteCodeGenerator.parser.innerTrySync = trySyncList2;
            if (this.finallyLabel != null) {
                s2 = s3 = byteCodeGenerator.generateGetPC();
                byteCodeGenerator.setOpStackHeight(1);
                byteCodeGenerator.generateExceptionHandler(s, s2, s3, (short)0);
                short s5 = byteCodeGenerator.methodSymbol.localVarCount;
                byteCodeGenerator.methodSymbol.localVarCount = (short)(s5 + 1);
                short s6 = s5;
                byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
                byteCodeGenerator.storeLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, s6);
                byteCodeGenerator.generateBranch_jsr(this.finallyLabel);
                byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, s6);
                byteCodeGenerator.generate_8((byte)-65);
                byteCodeGenerator.setOpStackHeight(1);
                byteCodeGenerator.setLabel(this.finallyLabel);
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyStartPos));
                short s7 = byteCodeGenerator.methodSymbol.localVarCount;
                byteCodeGenerator.methodSymbol.localVarCount = (short)(s7 + 1);
                s6 = s7;
                byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
                byteCodeGenerator.storeLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, s6);
                statementList.generateByteCode(byteCodeGenerator);
                if (bl) {
                    byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyEndPos));
                    if (s6 > 255) {
                        byteCodeGenerator.generate_8_8_16((byte)-60, (byte)-87, s6);
                    } else {
                        byteCodeGenerator.generate_8_8((byte)-87, (byte)s6);
                    }
                }
            }
            byteCodeGenerator.setLabel(label);
        } else {
            short s8;
            Label label = new Label();
            boolean bl3 = this.tryBody.canReachNextStatement(false);
            if (bl3) {
                if (statementList != null) {
                    byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyEndPos));
                }
                byteCodeGenerator.generateBranch_goto(label);
            }
            CatchDescriptor catchDescriptor = this.catchDesc;
            while (catchDescriptor != null) {
                s8 = byteCodeGenerator.generateGetPC();
                TypeSymbol typeSymbol = null;
                StatementList statementList3 = catchDescriptor.catchBody;
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(catchDescriptor.pos));
                byteCodeGenerator.setOpStackHeight(1);
                if (statementList3 == null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                } else {
                    LocalVariableSymbol localVariableSymbol = catchDescriptor.catchVariable;
                    typeSymbol = localVariableSymbol.type;
                    byteCodeGenerator.storeLocalVariable(typeSymbol, localVariableSymbol.varStackIndex);
                    localVariableSymbol.startPC = localVariableSymbol.endPC = byteCodeGenerator.generateGetPC();
                    statementList3.generateByteCode(byteCodeGenerator);
                }
                if (s != s2) {
                    short s9 = 0;
                    if (typeSymbol != null) {
                        s9 = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
                    }
                    byteCodeGenerator.generateExceptionHandler(s, s2, s8, s9);
                }
                if (!(statementList3 != null && !statementList3.canReachNextStatement(false) || catchDescriptor.next == null && statementList == null)) {
                    bl3 = true;
                    byteCodeGenerator.generateBranch_goto(label);
                }
                catchDescriptor = catchDescriptor.next;
            }
            byteCodeGenerator.parser.innerTrySync = trySyncList2;
            if (statementList != null) {
                s2 = s8 = byteCodeGenerator.generateGetPC();
                byteCodeGenerator.setOpStackHeight(1);
                byteCodeGenerator.generateExceptionHandler(s, s2, s8, (short)0);
                short s10 = byteCodeGenerator.methodSymbol.localVarCount;
                byteCodeGenerator.methodSymbol.localVarCount = (short)(s10 + 1);
                short s11 = s10;
                byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyStartPos));
                byteCodeGenerator.storeLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, s11);
                statementList.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyEndPos));
                byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, s11);
                byteCodeGenerator.generate_8((byte)-65);
                byteCodeGenerator.decOpStackHeight(1);
            }
            byteCodeGenerator.setLabel(label);
            if (statementList != null && bl3) {
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyStartPos));
                statementList.generateByteCode(byteCodeGenerator);
                if (statementList.canReachNextStatement(true)) {
                    byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyEndPos));
                }
            }
        }
    }

    boolean canReachNextStatement(boolean bl) {
        if (this.finallyBody != null && !this.finallyBody.canReachNextStatement(bl)) {
            return false;
        }
        boolean bl2 = this.tryBody.canReachNextStatement(bl);
        CatchDescriptor catchDescriptor = this.catchDesc;
        while (catchDescriptor != null) {
            if (catchDescriptor.catchBody != null) {
                bl2 |= catchDescriptor.catchBody.canReachNextStatement(bl);
            }
            catchDescriptor = catchDescriptor.next;
        }
        return bl2;
    }

    static boolean checkCatches(Parser parser, ClassSymbol classSymbol) {
        boolean bl = false;
        TrySyncList trySyncList = parser.innerTrySync;
        while (trySyncList != null) {
            if (trySyncList.syncStmt == null) {
                TryStatement tryStatement = trySyncList.tryStmt;
                if (!$assertionsDisabled && tryStatement == null) {
                    throw new AssertionError();
                }
                CatchDescriptor catchDescriptor = tryStatement.catchDesc;
                while (catchDescriptor != null) {
                    TypeSymbol typeSymbol = catchDescriptor.catchVariable.type.resolveType(parser, catchDescriptor.pos, false, false, false);
                    if (typeSymbol.isErroneous()) {
                        catchDescriptor.checked = true;
                        bl = true;
                    } else {
                        ClassSymbol classSymbol2 = (ClassSymbol)typeSymbol;
                        if (classSymbol.isAssignmentCompatible(parser, classSymbol2)) {
                            catchDescriptor.checked = true;
                            bl = true;
                        }
                        if (classSymbol2.isAssignmentCompatible(parser, classSymbol)) {
                            catchDescriptor.checked = true;
                        }
                    }
                    catchDescriptor = catchDescriptor.next;
                }
            }
            trySyncList = trySyncList.outerTrySync;
        }
        return bl;
    }

    static {
        $assertionsDisabled = !TryStatement.class.desiredAssertionStatus();
    }
}

